/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.mouse;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.treetablechart.JTimeScaleArea;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.mouse.GeneralTimeScalePopupMenu;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteraction;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteractionListener;
import com.sbs.jpm.ui.treetablechart.mouse.MouseSensitiveComponent;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import javax.swing.ImageIcon;

public class TimeScaleArea
extends MouseSensitiveComponent {
    private final Cursor RESIZE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/resize.png")).getImage(), new Point(14, 16), "Resize");
    private final Cursor MOVE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/cross.png")).getImage(), new Point(14, 16), "Move");
    private final JTimeScaleArea area;
    protected GeneralTimeScalePopupMenu generalPopupMenu;

    public TimeScaleArea(JTimeScaleArea jTimeScaleArea, MouseInteractionListener mouseInteractionListener) {
        super(mouseInteractionListener);
        this.area = jTimeScaleArea;
    }

    protected void createPopups() {
        this.generalPopupMenu = new GeneralTimeScalePopupMenu(this.area.getArea().getChartArea());
        this.area.getTimeScaleManager().addTimeScaleListener(this.generalPopupMenu);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.area.getArea().isSplit() || this.area.getArea().isInsertTask()) {
            this.area.setCursor(Common.getApplication().getCursor());
        } else {
            int n = 2;
            int n2 = 2;
            GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.area.getTimeScaleManager().getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.FOCUS_DATE);
            if (graphicPrimitive != null) {
                this.area.setCursor(this.MOVE_CURSOR);
            } else {
                this.area.setCursor(this.RESIZE_CURSOR);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = 2;
        int n2 = 2;
        if (this.generalPopupMenu == null) {
            this.createPopups();
        }
        if (this.area.getArea().isSplit() || this.area.getArea().isInsertTask()) {
            Common.getApplication().setCursor(Cursor.getDefaultCursor());
            this.area.getArea().setSplit(false);
            this.area.getArea().setInsertTask(false);
        } else {
            GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.area.getTimeScaleManager().getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.FOCUS_DATE);
            if (mouseEvent.getButton() == 1) {
                this.mouseInteraction = graphicPrimitive != null ? new MouseMoveFocusInteraction(mouseEvent.getX(), mouseEvent.getY()) : new MouseZoomInteraction(mouseEvent.getX(), mouseEvent.getY());
            }
            if (mouseEvent.isPopupTrigger()) {
                this.generalPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            this.startMouseInteraction(this.mouseInteraction);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.generalPopupMenu == null) {
            this.createPopups();
        }
        if (mouseEvent.isPopupTrigger()) {
            this.generalPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class MouseMoveFocusInteraction
    extends MouseInteraction {
        private Rectangle2D rectangle;
        int initialY;
        int initialX;
        int currentY;
        int currentX;

        public MouseMoveFocusInteraction(int n, int n2) {
            this.rectangle = TimeScaleArea.this.area.getTimeScaleManager().getFocusRectangle();
            this.initialX = this.currentX = n;
            this.initialY = this.currentY = (int)this.rectangle.getY();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            if (n < ((TimeScaleArea)TimeScaleArea.this).area.getVisibleRect().x + 10) {
                n = ((TimeScaleArea)TimeScaleArea.this).area.getVisibleRect().x + 10;
            }
            if (n > ((TimeScaleArea)TimeScaleArea.this).area.getVisibleRect().x + ((TimeScaleArea)TimeScaleArea.this).area.getVisibleRect().width - 10) {
                n = ((TimeScaleArea)TimeScaleArea.this).area.getVisibleRect().x + ((TimeScaleArea)TimeScaleArea.this).area.getVisibleRect().width - 10;
            }
            this.currentX = n;
            TimeScaleArea.this.area.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            double d = (double)(this.currentX - this.initialX) * 100.0 / (double)((TimeScaleArea)TimeScaleArea.this).area.getVisibleRect().width;
            double d2 = TimeScaleArea.this.area.getTimeScaleManager().getFocusPointPercent() + d;
            TimeScaleArea.this.area.getTimeScaleManager().setFocusPointPercent(d2);
            TimeFrame timeFrame = TimeScaleArea.this.area.getArea().getVisibleTimeFrame();
            double d3 = timeFrame.getStartDate().getTime();
            double d4 = timeFrame.getEndDate().getTime();
            double d5 = d3 + d2 / 100.0 * (d4 - d3);
            TimeScaleArea.this.area.getTimeScaleManager().setFocusDate(new Date((long)d5));
            TimeScaleArea.this.endMouseInteraction(TimeScaleArea.this.mouseInteraction);
            TimeScaleArea.this.mouseInteraction = null;
        }

        public void paint(Graphics graphics) {
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            nArray[0] = this.currentX;
            nArray2[0] = this.currentY;
            nArray[1] = this.currentX + (int)this.rectangle.getWidth();
            nArray2[1] = this.currentY;
            nArray[2] = this.currentX + (int)(this.rectangle.getWidth() / 2.0);
            nArray2[2] = this.currentY + (int)this.rectangle.getHeight();
            graphics.drawPolygon(nArray, nArray2, 3);
        }
    }

    class MouseZoomInteraction
    extends MouseInteraction {
        int currentX;
        int currentY;

        public MouseZoomInteraction(int n, int n2) {
            this.currentX = n;
            this.currentY = n2;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - this.currentX;
            this.currentX = TimeScaleArea.this.area.getTimeScaleManager().zoom(n, mouseEvent.getX());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                TimeScaleArea.this.endMouseInteraction(TimeScaleArea.this.mouseInteraction);
                TimeScaleArea.this.mouseInteraction = null;
            }
        }
    }
}

