/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.mouse;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.component.view.JProjectViewTaskSheet;
import com.sbs.jpm.ui.treetablechart.JTaskChartArea;
import com.sbs.jpm.ui.treetablechart.mouse.ChartArea;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteractionListener;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class TaskSheetArea
extends ChartArea {
    private JMenuItem infoItem;

    public TaskSheetArea(JTaskChartArea jTaskChartArea, TimeScaleManager timeScaleManager, MouseInteractionListener mouseInteractionListener) {
        super(jTaskChartArea, mouseInteractionListener);
    }

    protected void createPopups() {
        super.createPopups();
        final JProjectViewTaskSheet jProjectViewTaskSheet = (JProjectViewTaskSheet)this.area.getTreeTable().getProjectView();
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.tooltip"));
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jProjectViewTaskSheet.getInfoButton().doClick();
            }
        });
        this.generalPopupMenu.add(this.infoItem);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.area.setCursor(this.HAND_CURSOR);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JProjectViewTaskSheet jProjectViewTaskSheet = (JProjectViewTaskSheet)this.area.getTreeTable().getProjectView();
        if (mouseEvent.getButton() == 1) {
            this.mouseInteraction = new ChartArea.MouseScrollInteraction(mouseEvent.getX(), mouseEvent.getY());
        }
        if (mouseEvent.isPopupTrigger()) {
            if (this.generalPopupMenu == null) {
                this.createPopups();
            }
            this.infoItem.setSelected(jProjectViewTaskSheet.getTaskView().isVisible());
            this.generalPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        this.startMouseInteraction(this.mouseInteraction);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JProjectViewTaskSheet jProjectViewTaskSheet = (JProjectViewTaskSheet)this.area.getTreeTable().getProjectView();
        if (mouseEvent.isPopupTrigger()) {
            if (this.generalPopupMenu == null) {
                this.createPopups();
            }
            this.infoItem.setSelected(jProjectViewTaskSheet.getTaskView().isVisible());
            this.generalPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

