/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.mouse;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.MouseHoover;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskDeadlineHoover;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.action.ActionSettingsOptions;
import com.sbs.jpm.ui.component.JDependencyDetails;
import com.sbs.jpm.ui.component.JOptionsDialog;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.treetablechart.JChartArea;
import com.sbs.jpm.ui.treetablechart.JGanttChartArea;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.ui.treetablechart.mouse.ChartArea;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteraction;
import com.sbs.jpm.ui.treetablechart.mouse.MouseInteractionListener;
import com.sbs.jpm.ui.treetablechart.mouse.ValidMouseLandDestination;
import com.sbs.jpm.ui.treetablechart.mouse.ValidSuccessorChecker;
import com.sbs.jpm.ui.treetablechart.time.GanttTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskAddDependencyEdit;
import com.sbs.jpm.undo.TaskCompletionEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskDeadlineEdit;
import com.sbs.jpm.undo.TaskDurationEdit;
import com.sbs.jpm.undo.TaskInsertEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.TaskNonEmptyEdit;
import com.sbs.jpm.undo.TaskRemoveDependencyEdit;
import com.sbs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class GanttArea
extends ChartArea {
    private GanttTreeTableManager taskManager;
    private TaskPopupMenu taskPopupMenu;
    private JDependencyDetails dependencyDetails;
    private Action taskInsertAction;
    private Action taskBreakAction;
    private DependencyPopupMenu dependencyPopupMenu;
    private DeadlinePopupMenu deadlinePopupMenu;
    private JProjectViewGantt ganttView;
    private JMenuItem generalInfoItem;
    private MouseHoover mouseHooverElement;
    private static ValidSuccessorChecker validTaskSuccesorChecker = new ValidSuccessorChecker();
    private ValidMouseLandDestination noValidLandDestination = new ValidMouseLandDestination(){

        public boolean validMouseLandDestination(MouseHoover mouseHoover) {
            return false;
        }
    };

    public GanttArea(JGanttChartArea jGanttChartArea, GanttTreeTableManager ganttTreeTableManager, MouseInteractionListener mouseInteractionListener) {
        super(jGanttChartArea, mouseInteractionListener);
        this.taskManager = ganttTreeTableManager;
        this.dependencyDetails = new JDependencyDetails(Common.getApplication());
        this.taskInsertAction = new AbstractAction(Common.I18N_ACTIONS.getString("task.insert") + (SystemUtilities.isOSMac() ? "(Command-click)" : "(Ctrl-click)"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertTask.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)GanttArea.this.area.getTreeTable().getProjectView();
                JButton jButton = ((JProjectViewGantt)GanttArea.this.area.getTreeTable().getProjectView()).getInsertTaskButton();
                GanttArea.this.area.setCursor(jProjectViewGantt.INSERT_TASK_CURSOR);
                jButton.grabFocus();
                jButton.doClick();
            }
        };
        this.taskInsertAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.insertAtLocation") + (SystemUtilities.isOSMac() ? "(Command-click)" : "(Ctrl-click)"));
        this.taskBreakAction = new AbstractAction(Common.I18N_ACTIONS.getString("task.break") + "(Shift-click)", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/break_task.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)GanttArea.this.area.getTreeTable().getProjectView();
                JButton jButton = ((JProjectViewGantt)GanttArea.this.area.getTreeTable().getProjectView()).getBreakButton();
                GanttArea.this.area.setCursor(jProjectViewGantt.BREAK_TASK_CURSOR);
                jButton.grabFocus();
                jButton.doClick();
            }
        };
        this.taskBreakAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.break.tooltip"));
    }

    private void mouseHoovering(GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive, ValidMouseLandDestination validMouseLandDestination) {
        if (graphicPrimitive != null) {
            MouseHoover mouseHoover;
            Object object = graphicPrimitive.getModelObject();
            if (object instanceof MouseHoover && this.mouseHooverElement != (mouseHoover = (MouseHoover)object)) {
                if (this.mouseHooverElement != null) {
                    this.mouseHooverElement.setMouseHoover(false);
                }
                if (validMouseLandDestination == null) {
                    this.mouseHooverElement = mouseHoover;
                    this.mouseHooverElement.setMouseHoover(true);
                } else if (validMouseLandDestination.validMouseLandDestination(mouseHoover)) {
                    this.mouseHooverElement = mouseHoover;
                    this.mouseHooverElement.setMouseHoover(true);
                }
                this.area.repaint();
            }
        } else if (this.mouseHooverElement != null) {
            this.mouseHooverElement.setMouseHoover(false);
            this.mouseHooverElement = null;
            this.area.repaint();
        }
    }

    private boolean changeCompletionAllowed(Task task) {
        Task task2 = task.getParent();
        if (task2 != null && !task2.isSplitted()) {
            return true;
        }
        int n = task2.getChildIndex(task);
        boolean bl = true;
        if (n + 1 < task2.getChildNumber() && task2.getChildAt(n + 1).getCompletion() > 0.0) {
            bl = false;
        }
        if (n > 0 && task2.getChildAt(n - 1).getCompletion() < 100.0) {
            bl = false;
        }
        return bl;
    }

    Cursor ganntMouseMoved(MouseEvent mouseEvent, ValidMouseLandDestination validMouseLandDestination) {
        int n = 2;
        int n2 = 0;
        Cursor cursor = this.DEFAULT_CURSOR;
        GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.DEADLINE);
        if (graphicPrimitive != null) {
            this.mouseHoovering(graphicPrimitive, validMouseLandDestination);
            cursor = this.MOVE_CURSOR;
        } else {
            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.MILESTONE);
            if (graphicPrimitive != null) {
                this.mouseHoovering(graphicPrimitive, validMouseLandDestination);
                Task task = (Task)((GraphicPrimitiveContainer.Rectangle)graphicPrimitive).getModelObject();
                cursor = task.isLeaf() ? this.MOVE_CURSOR : this.DEFAULT_CURSOR;
            } else {
                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK_COMPLETION);
                if (graphicPrimitive != null) {
                    GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                    Task task = (Task)rectangle.getModelObject();
                    double d = rectangle.getTopY();
                    double d2 = rectangle.getBottomY();
                    double d3 = rectangle.getRightX();
                    cursor = (double)mouseEvent.getX() >= d3 - (double)n && (double)mouseEvent.getX() <= d3 + (double)n && (double)mouseEvent.getY() <= d2 + (double)n2 && (double)mouseEvent.getY() >= d - (double)n2 ? (this.changeCompletionAllowed(task) ? this.PERCENT_CURSOR : (task.getCompletion() == 100.0 ? this.RESIZE_CURSOR : this.MOVE_CURSOR)) : this.MOVE_CURSOR;
                } else {
                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART_COMPLETION);
                    if (graphicPrimitive != null) {
                        Task task;
                        GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                        double d = rectangle.getTopY();
                        double d4 = rectangle.getBottomY();
                        double d5 = rectangle.getRightX();
                        cursor = (double)mouseEvent.getX() >= d5 - (double)n && (double)mouseEvent.getX() <= d5 + (double)n && (double)mouseEvent.getY() <= d4 + (double)n2 && (double)mouseEvent.getY() >= d - (double)n2 ? (this.changeCompletionAllowed(task = (Task)rectangle.getModelObject()) ? this.PERCENT_CURSOR : this.RESIZE_CURSOR) : this.MOVE_CURSOR;
                    } else {
                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK);
                        if (graphicPrimitive != null) {
                            this.mouseHoovering(graphicPrimitive, validMouseLandDestination);
                            GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                            double d = rectangle.getRightX();
                            cursor = (double)mouseEvent.getX() >= d - (double)n && (double)mouseEvent.getX() <= d + (double)n && (double)mouseEvent.getY() >= rectangle.getTopY() - (double)n2 && (double)mouseEvent.getY() <= rectangle.getBottomY() + (double)n2 ? this.RESIZE_CURSOR : this.MOVE_CURSOR;
                        } else {
                            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART);
                            if (graphicPrimitive != null) {
                                this.mouseHoovering(graphicPrimitive, validMouseLandDestination);
                                GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                                double d = rectangle.getRightX();
                                cursor = (double)mouseEvent.getX() >= d - (double)n && (double)mouseEvent.getX() <= d + (double)n && (double)mouseEvent.getY() >= rectangle.getTopY() - (double)n2 && (double)mouseEvent.getY() <= rectangle.getBottomY() + (double)n2 ? this.RESIZE_CURSOR : this.MOVE_CURSOR;
                            } else {
                                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SUPERTASK);
                                if (graphicPrimitive != null) {
                                    this.mouseHoovering(graphicPrimitive, validMouseLandDestination);
                                    cursor = this.PARENT_CURSOR;
                                } else {
                                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.PROJECT);
                                    if (graphicPrimitive != null) {
                                        this.mouseHoovering(graphicPrimitive, validMouseLandDestination);
                                        cursor = this.PARENT_CURSOR;
                                    } else {
                                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.DEPENDENCY);
                                        if (graphicPrimitive != null) {
                                            this.mouseHoovering(graphicPrimitive, validMouseLandDestination);
                                            cursor = this.LINK_POINT_CURSOR;
                                        } else {
                                            this.mouseHoovering(null, validMouseLandDestination);
                                            cursor = this.HAND_CURSOR;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return cursor;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.area.getTreeTableChart().getArea().isSplit() || this.area.getTreeTableChart().getArea().isInsertTask()) {
            this.ganntMouseMoved(mouseEvent, null);
            this.area.setCursor(Common.getApplication().getCursor());
        } else {
            JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)this.area.getTreeTable().getProjectView();
            Cursor cursor = this.ganntMouseMoved(mouseEvent, null);
            if (mouseEvent.isShiftDown()) {
                this.area.setCursor(jProjectViewGantt.BREAK_TASK_CURSOR);
            } else if (mouseEvent.isMetaDown() && SystemUtilities.isOSMac() || mouseEvent.isControlDown() && !SystemUtilities.isOSMac()) {
                this.area.setCursor(jProjectViewGantt.INSERT_TASK_CURSOR);
            } else {
                this.area.setCursor(cursor);
            }
        }
    }

    private void showDependencyInfo(Dependency dependency, MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            this.dependencyDetails.setDependency(dependency);
            this.dependencyDetails.pack();
            this.dependencyDetails.setLocationRelativeTo(Common.getApplication());
            this.dependencyDetails.setVisible(true);
        }
    }

    private void customizeBar(Task task, MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            this.customizeBar(task);
        }
    }

    public void customizeBar(Task task) {
        this.ganttView.getInfoButton().doClick();
        this.ganttView.getTaskView().setSelectedIndex(5);
    }

    private void insertTask(Point point) {
        Serializable serializable;
        Task task;
        Serializable serializable2;
        final JChartArea jChartArea = this.area;
        TreePath treePath = jChartArea.getTreeTable().getPathForLocation(10, point.y);
        Task task2 = (Task)treePath.getLastPathComponent();
        ChartTreeTableModel chartTreeTableModel = (ChartTreeTableModel)jChartArea.getTreeTable().getTreeTableModel();
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(chartTreeTableModel.getRootTask());
        if (task2.getParent() != null) {
            serializable2 = task2.getParent();
            int n = ((Task)serializable2).getChildIndex(task2);
            final int n2 = jChartArea.getTreeTable().getRowForPath(treePath);
            task = new Task(((Task)serializable2).getCompany().getIdGenerator().getNewId());
            ((Task)serializable2).addChild(n, task);
            task.setName(Common.I18N_RP.getString("newTask"));
            serializable = new TaskInsertEdit((Task)serializable2, task, n, "02-10-2009 12:44:00");
            TaskNameEdit taskNameEdit = new TaskNameEdit(task, "", task.getName(), "02-10-2009 12:41:02");
            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
            extendedCompoundEdit.addEdit(taskNameEdit);
            TaskPlanner.rescheduleTree((Task)serializable2);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jChartArea.getTreeTable().setRowSelectionInterval(n2, n2);
                }
            });
        } else {
            task = ((ChartTreeTableModel)jChartArea.getTreeTable().getTreeTableModel()).insertEmptyTasks(task2, extendedCompoundEdit, true);
            serializable2 = new TaskNameEdit(task, task.getName(), Common.I18N_RP.getString("newTask"), "02-10-2009 12:41:03");
            task.setName(Common.I18N_RP.getString("newTask"));
            TaskNonEmptyEdit taskNonEmptyEdit = new TaskNonEmptyEdit(task, "02-10-2009 : 12:40:02");
            extendedCompoundEdit.addEdit(taskNonEmptyEdit);
            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable2));
        }
        serializable2 = Calendar.getInstance();
        ((Calendar)serializable2).setTimeInMillis(jChartArea.getTimeScaleManager().getMilis(point.getX()));
        ((Calendar)serializable2).setTimeInMillis(CalendarManager.getDayStartTime((Calendar)serializable2));
        CalendarManager.STANDARD_CALENDAR.getFirstTime((Calendar)serializable2, true, Long.MAX_VALUE);
        Constraint constraint = task.getConstraint();
        task.setConstraint(new SNET(((Calendar)serializable2).getTime()));
        TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(task, constraint, task.getConstraint(), "09/11/09 12:37:00");
        extendedCompoundEdit.addEdit(taskConstraintEdit);
        task.setDirty(true, true);
        extendedCompoundEdit.end();
        serializable = new UndoableEditEvent(this, extendedCompoundEdit);
        this.fireUndoableEditHappened((UndoableEditEvent)serializable);
        TaskPlanner.rescheduleTree(task);
    }

    private void splitTaskBar(Task task, int n) {
        Date date = new Date(this.taskManager.getTimeScaleManager().getMilis(n));
        AbstractUndoableEdit abstractUndoableEdit = task.getParent() != null && task.getParent().isSplitted() ? task.splitPart(date, null) : task.split(date, null);
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createReschedulSingleEdit(task, abstractUndoableEdit);
        TaskPlanner.rescheduleTree(task);
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
        this.fireUndoableEditHappened(undoableEditEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = 2;
        int n2 = 0;
        GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.MILESTONE);
        if (graphicPrimitive != null) {
            this.customizeBar((Task)graphicPrimitive.getModelObject(), mouseEvent);
        } else {
            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK_COMPLETION);
            if (graphicPrimitive != null) {
                this.customizeBar((Task)graphicPrimitive.getModelObject(), mouseEvent);
            } else {
                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK);
                if (graphicPrimitive != null) {
                    this.customizeBar((Task)graphicPrimitive.getModelObject(), mouseEvent);
                } else {
                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART);
                    if (graphicPrimitive != null) {
                        this.customizeBar((Task)graphicPrimitive.getModelObject(), mouseEvent);
                    } else {
                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SUPERTASK);
                        if (graphicPrimitive != null) {
                            this.customizeBar((Task)graphicPrimitive.getModelObject(), mouseEvent);
                        } else {
                            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.PROJECT);
                            if (graphicPrimitive != null) {
                                this.customizeBar((Task)graphicPrimitive.getModelObject(), mouseEvent);
                            } else {
                                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), 2, PrimitiveStyle.DEPENDENCY);
                                if (graphicPrimitive != null) {
                                    this.showDependencyInfo((Dependency)graphicPrimitive.getModelObject(), mouseEvent);
                                } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                                    this.switchCalendaristicView();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void selectRow(Task task) {
        JTreeTable jTreeTable = this.area.getTreeTable();
        int n = jTreeTable.getRowForPath(new TreePath(task.getPath((Task)jTreeTable.getTreeTableModel().getRoot()).toArray()));
        jTreeTable.setRowSelectionInterval(n, n);
    }

    protected void createPopups() {
        super.createPopups();
        this.ganttView = (JProjectViewGantt)this.area.getTreeTable().getProjectView();
        this.generalInfoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.task") + (SystemUtilities.isOSMac() ? "(Command-D)" : "(Ctrl-D)"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.generalInfoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.task.tooltip"));
        this.generalInfoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GanttArea.this.ganttView.getInfoButton().doClick();
            }
        });
        this.taskPopupMenu = new TaskPopupMenu();
        this.dependencyPopupMenu = new DependencyPopupMenu();
        this.deadlinePopupMenu = new DeadlinePopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Common.I18N_ACTIONS.getString("settings.options") + "...");
        jMenuItem.setToolTipText(Common.I18N_ACTIONS.getString("settings.options.tooltip"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager actionManager = ActionManager.getActionManager();
                ActionSettingsOptions actionSettingsOptions = (ActionSettingsOptions)actionManager.getAction(ActionID.SETTINGS_OPTIONS);
                JOptionsDialog jOptionsDialog = actionSettingsOptions.getOptionsDialog();
                jOptionsDialog.selectPanel(1);
                jOptionsDialog.setVisible(true);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(Common.I18N_ACTIONS.getString("barColors") + "...", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/colors.png")));
        jMenuItem2.setToolTipText(Common.I18N_ACTIONS.getString("barColors.tooltip"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionManager actionManager = ActionManager.getActionManager();
                ActionSettingsOptions actionSettingsOptions = (ActionSettingsOptions)actionManager.getAction(ActionID.SETTINGS_OPTIONS);
                JOptionsDialog jOptionsDialog = actionSettingsOptions.getOptionsDialog();
                jOptionsDialog.selectPanel(2);
                jOptionsDialog.setVisible(true);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(this.ganttView.getCatchUpAction());
        jMenuItem3.setText(Common.I18N_ACTIONS.getString("updateCompletion"));
        this.generalPopupMenu.insert(this.generalInfoItem, 0);
        this.generalPopupMenu.insert(jMenuItem3, 0);
        this.generalPopupMenu.insert(this.taskBreakAction, 0);
        this.generalPopupMenu.insert(this.taskInsertAction, 0);
        this.generalPopupMenu.add(jMenuItem2);
        this.generalPopupMenu.add(jMenuItem);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = 2;
        int n2 = 0;
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)this.area.getTreeTable().getProjectView();
        if (this.taskPopupMenu == null) {
            this.createPopups();
        }
        if (this.area.getTreeTableChart().getArea().isSplit()) {
            Common.getApplication().setCursor(Cursor.getDefaultCursor());
            this.area.getTreeTableChart().getArea().setSplit(false);
            this.area.getTreeTableChart().getArea().setInsertTask(false);
            GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK_COMPLETION);
            if (graphicPrimitive != null) {
                GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                Task task = (Task)rectangle.getModelObject();
                this.selectRow(task);
                if (task.isLeaf() && mouseEvent.getButton() == 1) {
                    this.splitTaskBar(task, mouseEvent.getX());
                }
            } else {
                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART_COMPLETION);
                if (graphicPrimitive != null) {
                    GraphicPrimitiveContainer.RectangleArrayPart rectangleArrayPart = (GraphicPrimitiveContainer.RectangleArrayPart)graphicPrimitive;
                    Task task = (Task)rectangleArrayPart.getModelObject();
                    Task task2 = task.getParent();
                    this.selectRow(task2);
                    if (mouseEvent.getButton() == 1) {
                        this.splitTaskBar(task, mouseEvent.getX());
                    }
                } else {
                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK);
                    if (graphicPrimitive != null) {
                        GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                        Task task = (Task)rectangle.getModelObject();
                        this.selectRow(task);
                        if (mouseEvent.getButton() == 1) {
                            this.splitTaskBar(task, mouseEvent.getX());
                        }
                    } else {
                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART);
                        if (graphicPrimitive != null) {
                            GraphicPrimitiveContainer.RectangleArrayPart rectangleArrayPart = (GraphicPrimitiveContainer.RectangleArrayPart)graphicPrimitive;
                            Task task = (Task)rectangleArrayPart.getModelObject();
                            Task task3 = task.getParent();
                            this.selectRow(task3);
                            if (mouseEvent.getButton() == 1) {
                                this.splitTaskBar(task, mouseEvent.getX());
                            }
                        }
                    }
                }
            }
        } else if (this.area.getTreeTableChart().getArea().isInsertTask()) {
            Common.getApplication().setCursor(Cursor.getDefaultCursor());
            this.area.getTreeTableChart().getArea().setSplit(false);
            this.area.getTreeTableChart().getArea().setInsertTask(false);
            this.insertTask(mouseEvent.getPoint());
        } else {
            if (mouseEvent.isShiftDown()) {
                GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK_COMPLETION);
                if (graphicPrimitive != null) {
                    GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                    Task task = (Task)rectangle.getModelObject();
                    this.selectRow(task);
                    if (task.isLeaf() && mouseEvent.getButton() == 1) {
                        this.splitTaskBar(task, mouseEvent.getX());
                    }
                } else {
                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART_COMPLETION);
                    if (graphicPrimitive != null) {
                        GraphicPrimitiveContainer.RectangleArrayPart rectangleArrayPart = (GraphicPrimitiveContainer.RectangleArrayPart)graphicPrimitive;
                        Task task = (Task)rectangleArrayPart.getModelObject();
                        Task task4 = task.getParent();
                        this.selectRow(task4);
                        if (mouseEvent.getButton() == 1) {
                            this.splitTaskBar(task, mouseEvent.getX());
                        }
                    } else {
                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK);
                        if (graphicPrimitive != null) {
                            GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                            Task task = (Task)rectangle.getModelObject();
                            this.selectRow(task);
                            if (mouseEvent.getButton() == 1) {
                                this.splitTaskBar(task, mouseEvent.getX());
                            }
                        } else {
                            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART);
                            if (graphicPrimitive != null) {
                                GraphicPrimitiveContainer.RectangleArrayPart rectangleArrayPart = (GraphicPrimitiveContainer.RectangleArrayPart)graphicPrimitive;
                                Task task = (Task)rectangleArrayPart.getModelObject();
                                Task task5 = task.getParent();
                                this.selectRow(task5);
                                if (mouseEvent.getButton() == 1) {
                                    this.splitTaskBar(task, mouseEvent.getX());
                                }
                            }
                        }
                    }
                }
            } else if (!mouseEvent.isPopupTrigger() && mouseEvent.isMetaDown() && SystemUtilities.isOSMac() || mouseEvent.isControlDown() && !SystemUtilities.isOSMac()) {
                if (!mouseEvent.isPopupTrigger()) {
                    this.insertTask(mouseEvent.getPoint());
                }
            } else {
                GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.DEADLINE);
                if (graphicPrimitive != null) {
                    GraphicPrimitiveContainer.Image image = (GraphicPrimitiveContainer.Image)graphicPrimitive;
                    TaskDeadlineHoover taskDeadlineHoover = (TaskDeadlineHoover)image.getModelObject();
                    this.selectRow(taskDeadlineHoover.task);
                    if (mouseEvent.getButton() == 1) {
                        this.mouseInteraction = new DeadlineMoveInteraction(taskDeadlineHoover, image, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if (mouseEvent.isPopupTrigger()) {
                        TaskDeadlineHoover taskDeadlineHoover2 = (TaskDeadlineHoover)graphicPrimitive.getModelObject();
                        this.deadlinePopupMenu.show(taskDeadlineHoover2.task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.MILESTONE);
                    if (graphicPrimitive != null) {
                        GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                        Task task = (Task)rectangle.getModelObject();
                        this.selectRow(task);
                        if (mouseEvent.getButton() == 1) {
                            this.mouseInteraction = task.isLeaf() ? new TaskMoveLinkInteraction(task, mouseEvent.getX(), mouseEvent.getY(), false, false) : new TaskMoveLinkInteraction(task, mouseEvent.getX(), mouseEvent.getY(), false, true);
                        }
                        if (mouseEvent.isPopupTrigger()) {
                            this.taskPopupMenu.show(task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else {
                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK_COMPLETION);
                        if (graphicPrimitive != null) {
                            GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                            Task task = (Task)rectangle.getModelObject();
                            this.selectRow(task);
                            if (task.isLeaf() && mouseEvent.getButton() == 1) {
                                double d = rectangle.getTopY();
                                double d2 = rectangle.getBottomY();
                                double d3 = rectangle.getRightX();
                                if ((double)mouseEvent.getX() >= d3 - (double)n && (double)mouseEvent.getX() <= d3 + (double)n && (double)mouseEvent.getY() <= d2 + (double)n2 && (double)mouseEvent.getY() >= d - (double)n2) {
                                    if (this.changeCompletionAllowed(task)) {
                                        this.mouseInteraction = new TaskCompletionInteraction(task, mouseEvent.getX(), mouseEvent.getY());
                                    } else if (task.getCompletion() == 100.0) {
                                        Task task6 = task.getParent();
                                        int n3 = task6.getChildIndex(task);
                                        this.mouseInteraction = new TaskPartResizeInteraction(task6, n3, mouseEvent.getX(), mouseEvent.getY());
                                    } else {
                                        this.mouseInteraction = new TaskMoveLinkInteraction(task, mouseEvent.getX(), mouseEvent.getY(), false, false);
                                    }
                                } else {
                                    this.mouseInteraction = new TaskMoveLinkInteraction(task, mouseEvent.getX(), mouseEvent.getY(), false, false);
                                }
                            }
                            if (mouseEvent.isPopupTrigger()) {
                                this.taskPopupMenu.show(task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        } else {
                            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART_COMPLETION);
                            if (graphicPrimitive != null) {
                                GraphicPrimitiveContainer.RectangleArrayPart rectangleArrayPart = (GraphicPrimitiveContainer.RectangleArrayPart)graphicPrimitive;
                                Task task = (Task)rectangleArrayPart.getModelObject();
                                Task task7 = task.getParent();
                                this.selectRow(task7);
                                if (mouseEvent.getButton() == 1) {
                                    double d = rectangleArrayPart.getRightX();
                                    int n4 = task7.getChildIndex(task);
                                    this.mouseInteraction = (double)mouseEvent.getX() >= d - (double)n && (double)mouseEvent.getX() <= d + (double)n && (double)mouseEvent.getY() >= rectangleArrayPart.getTopY() - (double)n2 && (double)mouseEvent.getY() <= rectangleArrayPart.getBottomY() + (double)n2 ? (this.changeCompletionAllowed(task) ? new TaskPartCompletionInteraction(task7, n4, mouseEvent.getX(), mouseEvent.getY()) : new TaskPartResizeInteraction(task7, n4, mouseEvent.getX(), mouseEvent.getY())) : new TaskPartMoveLinkInteraction(task7, n4, mouseEvent.getX(), mouseEvent.getY(), false, false);
                                }
                                if (mouseEvent.isPopupTrigger()) {
                                    this.taskPopupMenu.show(task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                }
                            } else {
                                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK);
                                if (graphicPrimitive != null) {
                                    GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                                    Task task = (Task)rectangle.getModelObject();
                                    this.selectRow(task);
                                    if (mouseEvent.getButton() == 1) {
                                        double d = rectangle.getRightX();
                                        this.mouseInteraction = (double)mouseEvent.getX() >= d - (double)n && (double)mouseEvent.getX() <= d + (double)n && (double)mouseEvent.getY() >= rectangle.getTopY() - (double)n2 && (double)mouseEvent.getY() <= rectangle.getBottomY() + (double)n2 ? new TaskResizeInteraction(task, mouseEvent.getX(), mouseEvent.getY()) : new TaskMoveLinkInteraction(task, mouseEvent.getX(), mouseEvent.getY(), false, false);
                                    }
                                    if (mouseEvent.isPopupTrigger()) {
                                        this.taskPopupMenu.show(task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                    }
                                } else {
                                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART);
                                    if (graphicPrimitive != null) {
                                        GraphicPrimitiveContainer.RectangleArrayPart rectangleArrayPart = (GraphicPrimitiveContainer.RectangleArrayPart)graphicPrimitive;
                                        Task task = (Task)rectangleArrayPart.getModelObject();
                                        Task task8 = task.getParent();
                                        this.selectRow(task8);
                                        if (mouseEvent.getButton() == 1) {
                                            double d = rectangleArrayPart.getRightX();
                                            int n5 = task8.getChildIndex(task);
                                            this.mouseInteraction = (double)mouseEvent.getX() >= d - (double)n && (double)mouseEvent.getX() <= d + (double)n && (double)mouseEvent.getY() >= rectangleArrayPart.getTopY() - (double)n2 && (double)mouseEvent.getY() <= rectangleArrayPart.getBottomY() + (double)n2 ? new TaskPartResizeInteraction(task8, n5, mouseEvent.getX(), mouseEvent.getY()) : new TaskPartMoveLinkInteraction(task8, n5, mouseEvent.getX(), mouseEvent.getY(), false, false);
                                        }
                                        if (mouseEvent.isPopupTrigger()) {
                                            this.taskPopupMenu.show(task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                        }
                                    } else {
                                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SUPERTASK);
                                        if (graphicPrimitive != null) {
                                            GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                                            Task task = (Task)rectangle.getModelObject();
                                            this.selectRow(task);
                                            if (mouseEvent.getButton() == 1 && (double)mouseEvent.getX() >= rectangle.getLeftX() - (double)n && (double)mouseEvent.getX() <= rectangle.getRightX() + (double)n && (double)mouseEvent.getY() >= rectangle.getTopY() - (double)n2 && (double)mouseEvent.getY() <= rectangle.getBottomY() + (double)n2) {
                                                this.mouseInteraction = new TaskMoveLinkInteraction(task, mouseEvent.getX(), mouseEvent.getY(), false, true);
                                            }
                                            if (mouseEvent.isPopupTrigger()) {
                                                this.taskPopupMenu.show(task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                            }
                                        } else {
                                            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.PROJECT);
                                            if (graphicPrimitive != null) {
                                                GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                                                Task task = (Task)rectangle.getModelObject();
                                                this.selectRow(task);
                                                if (mouseEvent.getButton() == 1 && (double)mouseEvent.getX() >= rectangle.getLeftX() - (double)n && (double)mouseEvent.getX() <= rectangle.getRightX() + (double)n && (double)mouseEvent.getY() >= rectangle.getTopY() - (double)n2 && (double)mouseEvent.getY() <= rectangle.getBottomY() + (double)n2) {
                                                    this.mouseInteraction = new TaskMoveLinkInteraction(task, mouseEvent.getX(), mouseEvent.getY(), false, true);
                                                }
                                                if (mouseEvent.isPopupTrigger()) {
                                                    this.taskPopupMenu.show(task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                                }
                                            } else {
                                                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), 2, PrimitiveStyle.DEPENDENCY);
                                                if (graphicPrimitive != null) {
                                                    Dependency dependency = (Dependency)graphicPrimitive.getModelObject();
                                                    if (mouseEvent.isPopupTrigger()) {
                                                        this.dependencyPopupMenu.show(dependency, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                                    }
                                                } else {
                                                    if (mouseEvent.getButton() == 1) {
                                                        this.mouseInteraction = new ChartArea.MouseScrollInteraction(mouseEvent.getX(), mouseEvent.getY());
                                                    }
                                                    if (mouseEvent.isPopupTrigger()) {
                                                        this.generalInfoItem.setSelected(jProjectViewGantt.getTaskView().isVisible());
                                                        this.generalPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.startMouseInteraction(this.mouseInteraction);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = 2;
        int n2 = 0;
        JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)this.area.getTreeTable().getProjectView();
        if (this.taskPopupMenu == null) {
            this.createPopups();
        }
        Cursor cursor = this.ganntMouseMoved(mouseEvent, null);
        this.area.setCursor(cursor);
        GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.DEADLINE);
        if (graphicPrimitive != null) {
            if (mouseEvent.isPopupTrigger()) {
                TaskDeadlineHoover taskDeadlineHoover = (TaskDeadlineHoover)graphicPrimitive.getModelObject();
                this.deadlinePopupMenu.show(taskDeadlineHoover.task, mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.MILESTONE);
            if (graphicPrimitive != null) {
                if (mouseEvent.isPopupTrigger()) {
                    this.taskPopupMenu.show((Task)graphicPrimitive.getModelObject(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK_COMPLETION);
                if (graphicPrimitive != null) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.taskPopupMenu.show((Task)graphicPrimitive.getModelObject(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK);
                    if (graphicPrimitive != null) {
                        if (mouseEvent.isPopupTrigger()) {
                            this.taskPopupMenu.show((Task)graphicPrimitive.getModelObject(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else {
                        graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART);
                        if (graphicPrimitive != null) {
                            if (mouseEvent.isPopupTrigger()) {
                                this.taskPopupMenu.show((Task)graphicPrimitive.getModelObject(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        } else {
                            graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SUPERTASK);
                            if (graphicPrimitive != null) {
                                if (mouseEvent.isPopupTrigger()) {
                                    this.taskPopupMenu.show((Task)graphicPrimitive.getModelObject(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                }
                            } else {
                                graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.PROJECT);
                                if (graphicPrimitive != null) {
                                    if (mouseEvent.isPopupTrigger()) {
                                        this.taskPopupMenu.show((Task)graphicPrimitive.getModelObject(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                    }
                                } else {
                                    graphicPrimitive = this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), 2, PrimitiveStyle.DEPENDENCY);
                                    if (graphicPrimitive != null) {
                                        if (mouseEvent.isPopupTrigger()) {
                                            this.dependencyPopupMenu.show((Dependency)graphicPrimitive.getModelObject(), mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                        }
                                    } else if (mouseEvent.isPopupTrigger()) {
                                        this.generalInfoItem.setSelected(jProjectViewGantt.getTaskView().isVisible());
                                        this.generalPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    class DeadlinePopupMenu
    extends JPopupMenu {
        private Task task;
        private JMenuItem removeDeadlineItem = new JMenuItem(Common.I18N_ACTIONS.getString("deadline.delete"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png")));

        public void show(Component component, int n, int n2) {
            throw new RuntimeException("Internal error: DependencyPopupMenu needs a dependency, doesn't make sense without it! call show(Dependency dependency, Component component, int x, int y)");
        }

        public void show(Task task, Component component, int n, int n2) {
            this.task = task;
            this.removeDeadlineItem.setText(Common.I18N_ACTIONS.getString("deadline.delete") + " (" + task.getName() + ")");
            this.removeDeadlineItem.setToolTipText(Common.I18N_ACTIONS.getString("deadline.delete.tooltip") + ": " + task.getName());
            super.show(component, n, n2);
        }

        public DeadlinePopupMenu() {
            this.removeDeadlineItem.setToolTipText(Common.I18N_ACTIONS.getString("deadline.delete.tooltip"));
            this.removeDeadlineItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    TaskDeadlineEdit taskDeadlineEdit = new TaskDeadlineEdit(DeadlinePopupMenu.this.task, DeadlinePopupMenu.this.task.getDeadlineDate(), null, "09/11/09 12:35:00");
                    extendedCompoundEdit.addEdit(taskDeadlineEdit);
                    extendedCompoundEdit.end();
                    DeadlinePopupMenu.this.task.setDeadlineDate(null);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    GanttArea.this.fireUndoableEditHappened(undoableEditEvent);
                }
            });
            this.add(this.removeDeadlineItem);
        }
    }

    class DependencyPopupMenu
    extends JPopupMenu {
        private Dependency dependency;
        private JMenuItem dependencyInfoItem;
        private JMenuItem dependencySuccItem;
        private JMenuItem dependencyPredItem;
        private JMenuItem unlinkItem = new JMenuItem(Common.I18N_ACTIONS.getString("unlinkTasks"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/unlink.png")));

        public void show(Component component, int n, int n2) {
            throw new RuntimeException("Internal error: DependencyPopupMenu needs a dependency, doesn't make sense without it! call show(Dependency dependency, Component component, int x, int y)");
        }

        public void show(Dependency dependency, Component component, int n, int n2) {
            this.dependency = dependency;
            GanttArea.this.dependencyDetails.setDependency(dependency);
            this.unlinkItem.setEnabled(!dependency.getPredecessor().isParentSplitted());
            this.dependencyInfoItem.setSelected(GanttArea.this.ganttView.getTaskView().isVisible());
            this.dependencySuccItem.setText(Common.I18N_ACTIONS.getString("goTo.successor") + " (" + dependency.getSuccessor().getName() + ")");
            this.dependencySuccItem.setToolTipText(Common.I18N_ACTIONS.getString("goTo.successor.tooltip") + ": " + dependency.getSuccessor().getName());
            this.dependencyPredItem.setText(Common.I18N_ACTIONS.getString("goTo.predecessor") + " (" + dependency.getPredecessor().getName() + ")");
            this.dependencyPredItem.setToolTipText(Common.I18N_ACTIONS.getString("goTo.predecessor.tooltip") + ": " + dependency.getPredecessor().getName());
            super.show(component, n, n2);
        }

        public DependencyPopupMenu() {
            this.unlinkItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Task.removeDependency(DependencyPopupMenu.this.dependency);
                    TaskPlanner.rescheduleTree(DependencyPopupMenu.this.dependency.getPredecessor());
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, TaskRemoveDependencyEdit.createRescheduleEdit(DependencyPopupMenu.this.dependency));
                    GanttArea.this.fireUndoableEditHappened(undoableEditEvent);
                }
            });
            this.add(this.unlinkItem);
            this.dependencyInfoItem = new JMenuItem(Common.I18N_ACTIONS.getString("details.dependency"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
            this.dependencyInfoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.dependency"));
            this.dependencyInfoItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttArea.this.dependencyDetails.pack();
                    GanttArea.this.dependencyDetails.setLocationRelativeTo(Common.getApplication());
                    GanttArea.this.dependencyDetails.setVisible(true);
                }
            });
            this.add(this.dependencyInfoItem);
            this.dependencySuccItem = new JMenuItem(Common.I18N_ACTIONS.getString("goTo.successor"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/go_to.png")));
            this.dependencySuccItem.setToolTipText(Common.I18N_ACTIONS.getString("goTo.successor.tooltip"));
            this.dependencySuccItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttArea.this.ganttView.gotoTask(DependencyPopupMenu.this.dependency.getSuccessor());
                    Task task = DependencyPopupMenu.this.dependency.getSuccessor();
                    JTreeTable jTreeTable = GanttArea.this.ganttView.getGantt().getTreeTable();
                    int n = jTreeTable.getRowForPath(new TreePath(task.getPath((Task)jTreeTable.getTreeTableModel().getRoot()).toArray()));
                    jTreeTable.setRowSelectionInterval(n, n);
                    jTreeTable.scrollRowToVisible(n);
                }
            });
            this.add(this.dependencySuccItem);
            this.dependencyPredItem = new JMenuItem(Common.I18N_ACTIONS.getString("goTo.predecessor"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/go_to.png")));
            this.dependencyPredItem.setToolTipText(Common.I18N_ACTIONS.getString("goTo.predecessor.tooltip"));
            this.dependencyPredItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttArea.this.ganttView.gotoTask(DependencyPopupMenu.this.dependency.getPredecessor());
                    Task task = DependencyPopupMenu.this.dependency.getPredecessor();
                    JTreeTable jTreeTable = GanttArea.this.ganttView.getGantt().getTreeTable();
                    int n = jTreeTable.getRowForPath(new TreePath(task.getPath((Task)jTreeTable.getTreeTableModel().getRoot()).toArray()));
                    jTreeTable.setRowSelectionInterval(n, n);
                    jTreeTable.scrollRowToVisible(n);
                }
            });
            this.add(this.dependencyPredItem);
        }
    }

    class TaskPopupMenu
    extends JPopupMenu {
        private JCheckBoxMenuItem taskInfoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.task"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));

        public void show(Component component, int n, int n2) {
            throw new RuntimeException("Internal error: call show(Task task, Component component, int x, int y)");
        }

        public void show(Task task, Component component, int n, int n2) {
            this.taskInfoItem.setSelected(GanttArea.this.ganttView.getTaskView().isVisible());
            super.show(component, n, n2);
        }

        public TaskPopupMenu() {
            this.taskInfoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.tooltip"));
            this.taskInfoItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GanttArea.this.ganttView.getInfoButton().doClick();
                }
            });
            this.add(this.taskInfoItem);
            this.add(GanttArea.this.taskInsertAction);
            this.add(GanttArea.this.taskBreakAction);
        }
    }

    class DeadlineMoveInteraction
    extends AutomaticMouseScroll {
        Rectangle2D rectangle;
        TaskDeadlineHoover taskDeadlineHoover;
        int initialY;
        int initialX;

        public DeadlineMoveInteraction(TaskDeadlineHoover taskDeadlineHoover, GraphicPrimitiveContainer.Image image, int n, int n2) {
            this.taskDeadlineHoover = taskDeadlineHoover;
            this.rectangle = new Rectangle((int)image.getLeftX(), (int)image.getTopY(), image.getIcon().getIconWidth(), image.getIcon().getIconHeight());
            this.initialX = this.currentX = n;
            this.initialY = this.currentY = n2;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDraggedTimeShift(mouseEvent);
            GanttArea.this.ganntMouseMoved(mouseEvent, GanttArea.this.noValidLandDestination);
            GanttArea.this.area.repaint();
        }

        public void paint(Graphics graphics) {
            GanttArea.this.area.setCursor(GanttArea.this.MOVE_CURSOR);
            int n = this.currentX - this.initialX;
            double d = this.rectangle.getX() + (double)n;
            double d2 = this.rectangle.getY();
            double d3 = this.rectangle.getHeight();
            double d4 = this.rectangle.getWidth();
            ((Graphics2D)graphics).draw(new Rectangle2D.Double(d, d2, d4, d3));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(this.taskDeadlineHoover.task, mouseEvent);
        }

        public void mouseReleased(Task task, MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && (this.currentX != this.initialX || this.currentY != this.initialY)) {
                int n;
                Date date = new Date(GanttArea.this.area.getTimeScaleManager().getMilis(mouseEvent.getX()));
                TimeFrame timeFrame = GanttArea.this.area.getTreeTableChart().getArea().getVisibleTimeFrame();
                if (timeFrame.getStartDate().after(date)) {
                    timeFrame.setStartDate(date);
                }
                if (timeFrame.getEndDate().before(date)) {
                    timeFrame.setEndDate(date);
                }
                Date[] dateArray = GanttArea.this.area.getTimeScaleManager().getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
                Date date2 = new Date(date.getTime());
                for (n = 0; n < dateArray.length && !date2.before(dateArray[n]); ++n) {
                }
                date2 = dateArray[n];
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date2);
                CalendarManager calendarManager = task.getUsedCalendar();
                calendarManager.getFirstTime(calendar, true, false, 0L);
                Date date3 = calendar.getTime();
                TaskDeadlineEdit taskDeadlineEdit = new TaskDeadlineEdit(task, task.getDeadlineDate(), date3, "09/11/09 12:36:00");
                task.setDeadlineDate(date3);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, taskDeadlineEdit);
                GanttArea.this.fireUndoableEditHappened(undoableEditEvent);
            }
            GanttArea.this.endMouseInteraction(GanttArea.this.mouseInteraction);
            GanttArea.this.mouseInteraction = null;
            GanttArea.this.area.repaint();
        }
    }

    class TaskMoveLinkInteraction
    extends AutomaticMouseScroll {
        private Rectangle2D rectangle;
        Task task;
        int initialY;
        int initialX;
        boolean forceMove;
        boolean forceLink;

        public TaskMoveLinkInteraction(Task task, int n, int n2, boolean bl, boolean bl2) {
            this.task = task;
            this.rectangle = GanttArea.this.taskManager.getRectangle(task);
            this.initialX = this.currentX = n;
            this.initialY = this.currentY = n2;
            this.forceMove = bl;
            this.forceLink = bl2;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDraggedTimeShift(mouseEvent);
            GanttArea.this.ganntMouseMoved(mouseEvent, validTaskSuccesorChecker);
            GanttArea.this.area.repaint();
        }

        public void paint(Graphics graphics) {
            if (!this.forceMove && (this.forceLink || (double)this.currentY > this.rectangle.getMaxY() || (double)this.currentY < this.rectangle.getMinY())) {
                GanttArea.this.area.setCursor(GanttArea.this.NEW_LINK_CURSOR);
                graphics.setColor(Color.black);
                graphics.drawLine(this.initialX, this.initialY, this.currentX, this.currentY);
                int[] nArray = new int[3];
                int[] nArray2 = new int[3];
                int n = this.currentX - this.initialX;
                int n2 = this.currentY - this.initialY;
                int n3 = (int)((double)0.08f * (double)n);
                int n4 = (int)((double)0.08f * (double)n2);
                int n5 = (n3 < 0 ? -n3 : n3) + (n4 < 0 ? -n4 : n4);
                n3 = (int)((double)n3 * 10.0 / (double)n5);
                n4 = (int)((double)n4 * 10.0 / (double)n5);
                nArray[0] = this.currentX;
                nArray2[0] = this.currentY;
                nArray[1] = this.currentX - n3 + n4 / 2;
                nArray2[1] = this.currentY - n4 - n3 / 2;
                nArray[2] = this.currentX - n3 - n4 / 2;
                nArray2[2] = this.currentY - n4 + n3 / 2;
                graphics.fillPolygon(nArray, nArray2, 3);
            } else {
                GanttArea.this.area.setCursor(GanttArea.this.MOVE_CURSOR);
                int n = this.currentX - this.initialX;
                double d = this.rectangle.getX() + (double)n;
                double d2 = this.rectangle.getY();
                double d3 = this.rectangle.getHeight();
                double d4 = this.rectangle.getWidth();
                ((Graphics2D)graphics).draw(new Rectangle2D.Double(d, d2, d4, d3));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(this.task, mouseEvent);
        }

        public void mouseReleased(Task task, MouseEvent mouseEvent) {
            if (!this.forceMove && (this.forceLink || (double)this.currentY > this.rectangle.getMaxY() || (double)this.currentY < this.rectangle.getMinY())) {
                if (mouseEvent.getButton() == 1) {
                    int n = 2;
                    int n2 = 2;
                    GraphicPrimitiveContainer.GraphicPrimitive graphicPrimitive = GanttArea.this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.MILESTONE);
                    if (graphicPrimitive == null && (graphicPrimitive = GanttArea.this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.TASK)) == null && (graphicPrimitive = GanttArea.this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SPLITTED_TASK_PART)) == null && (graphicPrimitive = GanttArea.this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.SUPERTASK)) == null) {
                        graphicPrimitive = GanttArea.this.taskManager.getSelectablePrimitive(mouseEvent.getX(), n, mouseEvent.getY(), n2, PrimitiveStyle.PROJECT);
                    }
                    if (graphicPrimitive != null) {
                        GraphicPrimitiveContainer.Rectangle rectangle = (GraphicPrimitiveContainer.Rectangle)graphicPrimitive;
                        Task task2 = (Task)rectangle.getModelObject();
                        if ((double)mouseEvent.getX() >= rectangle.getLeftX() - (double)n && (double)mouseEvent.getX() <= rectangle.getRightX() + (double)n && (double)mouseEvent.getY() >= rectangle.getTopY() && (double)mouseEvent.getY() <= rectangle.getBottomY()) {
                            Dependency dependency = new Dependency(this.task.getCompany().getIdGenerator().getNewId());
                            dependency.setPredecessor(this.task);
                            dependency.setSuccessor(task2);
                            dependency.adjustDependencyForSplit();
                            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.task);
                            try {
                                Task.addDependency(dependency, true);
                            }
                            catch (CircularRelationshipException circularRelationshipException) {
                                Common.logException("Error:", circularRelationshipException);
                                JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                                GanttArea.this.endMouseInteraction(GanttArea.this.mouseInteraction);
                                GanttArea.this.mouseInteraction = null;
                                GanttArea.this.area.repaint();
                                return;
                            }
                            TaskAddDependencyEdit taskAddDependencyEdit = new TaskAddDependencyEdit(dependency, "09/11/09 13:02:01");
                            extendedCompoundEdit.addEdit(taskAddDependencyEdit);
                            extendedCompoundEdit.end();
                            TaskPlanner.rescheduleTree(dependency.getSuccessor());
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            GanttArea.this.fireUndoableEditHappened(undoableEditEvent);
                        }
                    }
                }
            } else if (mouseEvent.getButton() == 1 && (this.currentX != this.initialX || this.currentY != this.initialY)) {
                int n;
                int n3;
                int n4 = this.currentX - this.initialX;
                long l = GanttArea.this.area.getTimeScaleManager().convertPixelsToMilis(n4);
                CalendarManager calendarManager = task.getUsedCalendar();
                Date date = new Date(task.getStartDate().getTime() + l);
                TimeFrame timeFrame = GanttArea.this.area.getTreeTableChart().getArea().getVisibleTimeFrame();
                if (timeFrame.getStartDate().after(date)) {
                    timeFrame.setStartDate(date);
                }
                if (timeFrame.getEndDate().before(date)) {
                    timeFrame.setEndDate(date);
                }
                Date[] dateArray = GanttArea.this.area.getTimeScaleManager().getCurrentScaleCombination().getBottomRenderer().getExtendedTimeUnits(timeFrame);
                Date date2 = new Date(date.getTime());
                for (n3 = 0; n3 < dateArray.length && !date2.before(dateArray[n3]); ++n3) {
                }
                date2 = n3 == 0 ? dateArray[0] : dateArray[n3 - 1];
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date2);
                calendarManager.getFirstTime(calendar, true, Long.MAX_VALUE);
                Constraint constraint = new SNET(calendar.getTime());
                Task task3 = task.getParent();
                if (task3 != null && task3.isSplitted() && (n = task3.getChildIndex(task)) > 0 && calendar.getTime().before(task3.getChildAt(n - 1).getEndDate())) {
                    constraint = new ASAP();
                }
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(task, task.getConstraint(), constraint, true, "09/11/09 12:37:01");
                task.setForce(true);
                task.setConstraint(constraint);
                extendedCompoundEdit.addEdit(taskConstraintEdit);
                extendedCompoundEdit.end();
                TaskPlanner.rescheduleTree(task);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                GanttArea.this.fireUndoableEditHappened(undoableEditEvent);
            }
            GanttArea.this.endMouseInteraction(GanttArea.this.mouseInteraction);
            GanttArea.this.mouseInteraction = null;
            GanttArea.this.area.repaint();
        }
    }

    class AutomaticMouseScroll
    extends MouseInteraction {
        int currentY;
        int currentX;
        double oldScreenX;
        long oldWhen;
        double accelerate = 0.0;

        AutomaticMouseScroll() {
        }

        public void mouseDraggedTimeShift(MouseEvent mouseEvent) {
            int n = 10;
            double d = 5.0;
            if (GanttArea.this.area.getVisibleRect().getMaxX() <= (double)mouseEvent.getX()) {
                int n2;
                double d2 = n;
                this.currentX = (int)GanttArea.this.area.getVisibleRect().getMaxX();
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (this.oldWhen != mouseEvent.getWhen()) {
                    if (this.oldScreenX != 0.0) {
                        this.accelerate = pointerInfo.getLocation().getX() >= this.oldScreenX ? (this.accelerate += 1.0) : (this.accelerate -= 1.0);
                    }
                    this.oldScreenX = pointerInfo.getLocation().getX();
                    this.oldWhen = mouseEvent.getWhen();
                }
                if ((n2 = (int)(d2 + this.accelerate * d)) < n) {
                    n2 = n;
                    this.accelerate = 0.0;
                    this.currentX = mouseEvent.getX();
                    this.oldScreenX = pointerInfo.getLocation().getX();
                    this.oldWhen = mouseEvent.getWhen();
                }
                GanttArea.this.area.getTimeScaleManager().shift(n2);
            } else if (GanttArea.this.area.getVisibleRect().getX() >= (double)mouseEvent.getX()) {
                int n3;
                double d3 = -n;
                this.currentX = (int)GanttArea.this.area.getVisibleRect().getX();
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (this.oldWhen != mouseEvent.getWhen()) {
                    if (this.oldScreenX != 0.0) {
                        this.accelerate = pointerInfo.getLocation().getX() >= this.oldScreenX ? (this.accelerate += 1.0) : (this.accelerate -= 1.0);
                    }
                    this.oldScreenX = pointerInfo.getLocation().getX();
                    this.oldWhen = mouseEvent.getWhen();
                }
                if ((n3 = (int)(d3 + this.accelerate * d)) > -n) {
                    n3 = -n;
                    this.accelerate = 0.0;
                    this.currentX = mouseEvent.getX();
                    this.oldScreenX = pointerInfo.getLocation().getX();
                    this.oldWhen = mouseEvent.getWhen();
                }
                GanttArea.this.area.getTimeScaleManager().shift(n3);
            } else {
                this.accelerate = -1.0;
                this.currentX = mouseEvent.getX();
            }
            this.currentY = mouseEvent.getY();
        }
    }

    class TaskPartMoveLinkInteraction
    extends TaskMoveLinkInteraction {
        Task taskPart;
        int partNo;
        Rectangle2D parentRectangle;
        Rectangle2D childPartRectangle;
        Rectangle2D parentPartRectangle;

        public TaskPartMoveLinkInteraction(Task task, int n, int n2, int n3, boolean bl, boolean bl2) {
            super(task, n2, n3, bl, bl2);
            this.taskPart = task.getChildAt(n);
            this.partNo = n;
            this.parentRectangle = GanttArea.this.taskManager.getRectangle(task);
            this.childPartRectangle = GanttArea.this.taskManager.getRectangle(this.taskPart);
            this.parentPartRectangle = new Rectangle2D.Double(this.childPartRectangle.getX(), this.parentRectangle.getY(), this.childPartRectangle.getWidth(), this.parentRectangle.getHeight());
            ((TaskMoveLinkInteraction)this).rectangle = this.parentPartRectangle;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(this.taskPart, mouseEvent);
        }
    }

    class TaskResizeInteraction
    extends AutomaticMouseScroll {
        Rectangle2D rectangle;
        Task task;
        int initialY;
        int initialX;

        public TaskResizeInteraction(Task task, int n, int n2) {
            this.task = task;
            this.initialX = this.currentX = n;
            this.initialY = this.currentY = n2;
            this.rectangle = GanttArea.this.taskManager.getRectangle(task);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDraggedTimeShift(mouseEvent);
            GanttArea.this.area.repaint();
        }

        public void paint(Graphics graphics) {
            int n = (int)this.rectangle.getX();
            int n2 = (int)this.rectangle.getY();
            int n3 = (int)this.rectangle.getHeight();
            graphics.drawRect(n, n2, this.currentX - n, n3);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(this.task, mouseEvent);
        }

        public void mouseReleased(Task task, MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (this.currentX != this.initialX || this.currentY != this.initialY) {
                    CalendarManager calendarManager = task.getUsedCalendar();
                    Date date = new Date(GanttArea.this.area.getTimeScaleManager().getMilis(mouseEvent.getX()));
                    Date[] dateArray = GanttArea.this.area.getTimeScaleManager().getCurrentScaleCombination().getBottomRenderer().getTimeUnits(GanttArea.this.area.getTreeTableChart().getArea().getVisibleTimeFrame());
                    Date date2 = new Date(date.getTime());
                    for (int i = 0; i < dateArray.length; ++i) {
                        if (!date2.before(dateArray[i])) continue;
                        date2 = dateArray[i];
                        break;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    while (true) {
                        calendarManager.getFirstTime(calendar, false, date2.getTime());
                        if (!calendar.getTime().before(date2)) break;
                        calendarManager.getFirstTime(calendar, true, Long.MAX_VALUE);
                    }
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(date2);
                    if (calendar.after(calendar2)) {
                        calendar = calendar2;
                    }
                    long l = calendarManager.getDuration(task.getStartDate(), calendar.getTime(), true);
                    TaskDurationEdit taskDurationEdit = new TaskDurationEdit(task, task.getDuration(), l, "02-10-2009 13:00:02");
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createReschedulSingleEdit(task, taskDurationEdit);
                    task.changeDuration(l);
                    TaskPlanner.rescheduleTree(task);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    GanttArea.this.fireUndoableEditHappened(undoableEditEvent);
                }
                GanttArea.this.endMouseInteraction(GanttArea.this.mouseInteraction);
                GanttArea.this.mouseInteraction = null;
                GanttArea.this.area.repaint();
            }
        }
    }

    class TaskPartResizeInteraction
    extends TaskResizeInteraction {
        Task taskPart;
        int partNo;

        public TaskPartResizeInteraction(Task task, int n, int n2, int n3) {
            super(task, n2, n3);
            this.taskPart = task.getChildAt(n);
            this.partNo = n;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(this.taskPart, mouseEvent);
        }
    }

    class TaskCompletionInteraction
    extends AutomaticMouseScroll {
        Task task;
        int initialY;
        int initialX;
        private Rectangle2D rectangle;

        public TaskCompletionInteraction(Task task, int n, int n2) {
            this.task = task;
            this.initialX = this.currentX = n;
            this.initialY = this.currentY = n2;
            this.rectangle = GanttArea.this.taskManager.getCompletionRectangle(task);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDraggedTimeShift(mouseEvent);
            GanttArea.this.area.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(this.task, mouseEvent);
        }

        public void mouseReleased(Task task, MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (this.currentX != this.initialX || this.currentY != this.initialY) {
                    Serializable serializable;
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    Date date = new Date(GanttArea.this.area.getTimeScaleManager().getMilis(mouseEvent.getX()));
                    Task task2 = task.getParent();
                    if (task2 != null && task2.isSplitted()) {
                        int n = 0;
                        for (Task serializable22 : task2.getChildList()) {
                            if (serializable22.getEndDate().before(date)) {
                                serializable = new TaskCompletionEdit(serializable22, serializable22.getCompletion(), 100.0, "09/11/09 12:40:00");
                                serializable22.setCompletion(100.0);
                                extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                                ++n;
                                continue;
                            }
                            if (!serializable22.getStartDate().after(date)) continue;
                            serializable = new TaskCompletionEdit(serializable22, serializable22.getCompletion(), 0.0, "09/11/09 12:40:11");
                            serializable22.setCompletion(0.0);
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                        }
                        task = task2.getChildAt(n);
                    }
                    double d = task.getCompletionForCompletionDate(date);
                    TaskCompletionEdit taskCompletionEdit = new TaskCompletionEdit(task, task.getCompletion(), d, "09/11/09 12:40:01");
                    task.setCompletion(d);
                    extendedCompoundEdit.addEdit(taskCompletionEdit);
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree(task);
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    GanttArea.this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                }
                GanttArea.this.endMouseInteraction(GanttArea.this.mouseInteraction);
                GanttArea.this.mouseInteraction = null;
            }
        }

        public void paint(Graphics graphics) {
            double d = this.rectangle.getX();
            double d2 = this.rectangle.getY();
            double d3 = this.rectangle.getHeight();
            ((Graphics2D)graphics).draw(new Rectangle2D.Double(d, d2, (double)this.currentX - d, d3));
        }
    }

    class TaskPartCompletionInteraction
    extends TaskCompletionInteraction {
        Task taskPart;
        int partNo;

        public TaskPartCompletionInteraction(Task task, int n, int n2, int n3) {
            super(task, n2, n3);
            this.taskPart = task.getChildAt(n);
            this.partNo = n;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseReleased(this.taskPart, mouseEvent);
        }
    }
}

