/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.treetablechart.JEPSTable;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskCalendarEdit;
import com.sbs.jpm.undo.TaskCompletionEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskDurationEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.TaskNonEmptyEdit;
import com.sbs.jpm.undo.TaskStatusEdit;
import com.sbs.jpm.undo.TaskWorkCompletionEdit;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;

public class EPSTableModel
extends AbstractTableModel {
    public static final String NAME = Common.I18N_RP.getString("column.projectName");
    public static final String PROJECT_MANAGER = Common.I18N_RP.getString("column.projectManager");
    public static final String DURATION = Common.I18N_RP.getString("column.duration");
    public static final String ACTUAL_DURATION = Common.I18N_RP.getString("column.actualDuration");
    public static final String REMAINING_DURATION = Common.I18N_RP.getString("column.remainingDuration");
    public static final String START = Common.I18N_RP.getString("column.start");
    public static final String END = Common.I18N_RP.getString("column.end");
    public static final String CALENDAR = Common.I18N_RP.getString("column.calendar");
    public static final String PERCENT_COMPLETE = Common.I18N_RP.getString("column.percentComplete");
    public static final String PERCENT_WORK_COMPLETE = Common.I18N_RP.getString("column.percentWorkComplete");
    public static final String ACTUAL_START = Common.I18N_RP.getString("column.actualStart");
    public static final String ACTUAL_END = Common.I18N_RP.getString("column.actualEnd");
    public static final String STATUS = Common.I18N_RP.getString("column.status");
    public static final String WORK = Common.I18N_RP.getString("column.work");
    public static final String ACTUAL_WORK = Common.I18N_RP.getString("column.actualWork");
    public static final String REMAINING_WORK = Common.I18N_RP.getString("column.remainingWork");
    public static final String COST = Common.I18N_RP.getString("column.cost");
    public static final String ACTUAL_COST = Common.I18N_RP.getString("column.actualCost");
    public static final String REMAINING_COST = Common.I18N_RP.getString("column.remainingCost");
    public static final String ESTIMATED_START = Common.I18N_RP.getString("column.estimatedStart");
    public static final String CODE = Common.I18N_RP.getString("column.code");
    public static final String CLIENT = Common.I18N_RP.getString("column.client");
    protected List titles;
    protected List columnsType;
    protected List emptyResources;
    private Company data;
    private EventListenerList listeners;
    protected TaskListener taskHandler;
    private JEPSTable table;

    public EPSTableModel() {
        this(null, new Company());
    }

    public EPSTableModel(JEPSTable jEPSTable, Company company) {
        this.data = company;
        this.table = jEPSTable;
        this.listeners = new EventListenerList();
        this.titles = new LinkedList();
        this.columnsType = new LinkedList();
        this.titles.add(NAME);
        this.titles.add(PROJECT_MANAGER);
        this.titles.add(DURATION);
        this.titles.add(START);
        this.titles.add(END);
        this.titles.add(COST);
        this.titles.add(WORK);
        this.titles.add(PERCENT_COMPLETE);
        this.titles.add(PERCENT_WORK_COMPLETE);
        this.titles.add(ACTUAL_DURATION);
        this.titles.add(REMAINING_DURATION);
        this.titles.add(ACTUAL_START);
        this.titles.add(ACTUAL_END);
        this.titles.add(ACTUAL_COST);
        this.titles.add(REMAINING_COST);
        this.titles.add(ACTUAL_WORK);
        this.titles.add(REMAINING_WORK);
        this.titles.add(STATUS);
        this.titles.add(CALENDAR);
        this.titles.add(ESTIMATED_START);
        this.titles.add(CODE);
        this.titles.add(CLIENT);
        this.columnsType.add(Task.class);
        this.columnsType.add(String.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(String.class);
        this.columnsType.add(CalendarManager.class);
        this.columnsType.add(Date.class);
        this.columnsType.add(String.class);
        this.columnsType.add(Client.class);
        this.taskHandler = new TaskHandler();
        this.addTasksListeners(company.getRootTask());
    }

    private void addTasksListeners(Task task) {
        if (task.isProject()) {
            task.addTaskListener(this.taskHandler);
        }
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            this.addTasksListeners(task.getProjectChildAt(i));
        }
    }

    private void removeTasksListeners(Task task) {
        task.removeTaskListener(this.taskHandler);
        for (int i = 0; i < task.getProjectChildNumber(); ++i) {
            this.removeTasksListeners(task.getProjectChildAt(i));
        }
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getRootTask().getProjectChildNumber();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 || n2 == 17;
    }

    public Object getValueAt(int n, int n2) {
        Task task = this.data.getRootTask().getProjectChildAt(n);
        switch (n2) {
            case 0: {
                return task;
            }
            case 1: {
                return task.getManager();
            }
            case 3: {
                return task.getStartDate();
            }
            case 4: {
                return task.getEndDate();
            }
            case 2: {
                if (task.isLeaf() || task.isSplitted()) {
                    return task.getDuration();
                }
                return task.getWorkingDuration();
            }
            case 5: {
                return task.getCost();
            }
            case 6: {
                return task.getWork();
            }
            case 7: {
                return task.getCompletion();
            }
            case 8: {
                return task.getWorkCompletion();
            }
            case 9: {
                if (task.isLeaf() || task.isSplitted()) {
                    return task.getActualDuration();
                }
                return task.getActualWorkingDuration();
            }
            case 10: {
                if (task.isLeaf() || task.isSplitted()) {
                    return new Long(task.getRemainingDuration());
                }
                return task.getRemainingWorkingDuration();
            }
            case 11: {
                return task.getActualStartDate();
            }
            case 12: {
                return task.getActualEndDate();
            }
            case 13: {
                return task.getActualCost();
            }
            case 14: {
                return task.getRemainingCost();
            }
            case 15: {
                return task.getActualWork();
            }
            case 16: {
                return task.getRemainingWork();
            }
            case 17: {
                return task.getStatus();
            }
            case 18: {
                return task.getCalendar();
            }
            case 19: {
                return task.getConstraint().getDate();
            }
            case 20: {
                return task.getCode();
            }
            case 21: {
                return task.getClient();
            }
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        Task task = this.data.getRootTask().getProjectChildAt(n);
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.data.getRootTask());
        boolean bl = task.isEmpty();
        AbstractUndoableEdit abstractUndoableEdit = null;
        boolean bl2 = true;
        switch (n2) {
            case 0: {
                abstractUndoableEdit = new TaskNameEdit(task, task.getName(), object.toString(), "02-10-2009 12:41:00");
                task.setName(object.toString());
                bl2 = false;
                break;
            }
            case 3: {
                SNET sNET = new SNET((Date)object);
                abstractUndoableEdit = new TaskConstraintEdit(task, task.getConstraint(), sNET, true, "09/11/09 12:37:05");
                task.setForce(true);
                task.setConstraint(sNET);
                bl2 = true;
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                long l = (Long)object;
                abstractUndoableEdit = new TaskDurationEdit(task, task.getDuration(), l, "02-10-2009 13:00:00");
                task.changeDuration(l);
                bl2 = true;
                break;
            }
            case 18: {
                CalendarManager calendarManager = object instanceof CalendarManager ? (CalendarManager)object : null;
                abstractUndoableEdit = new TaskCalendarEdit(task, task.getCalendar(), calendarManager, "09/11/09 12:53:06");
                task.setCalendar(calendarManager);
                bl2 = true;
                break;
            }
            case 7: {
                int n3 = (Integer)object;
                abstractUndoableEdit = new TaskCompletionEdit(task, task.getCompletion(), n3, "09/11/09 12:40:10");
                task.setCompletion(n3);
                bl2 = true;
                break;
            }
            case 8: {
                int n4 = (Integer)object;
                abstractUndoableEdit = new TaskWorkCompletionEdit(task, task.getWorkCompletion(), n4, "01-10-2009 17:20:03");
                task.setWorkCompletion(n4, true);
                bl2 = true;
                break;
            }
            case 17: {
                String string = object.toString();
                abstractUndoableEdit = new TaskStatusEdit(task, task.getStatus(), string, "01-10-2009 17:31:00");
                task.setStatus(string);
                bl2 = false;
                break;
            }
        }
        if (bl) {
            TaskNonEmptyEdit taskNonEmptyEdit = new TaskNonEmptyEdit(task, "02-10-2009 : 12:40:00");
            extendedCompoundEdit.addEdit(taskNonEmptyEdit);
        }
        if (abstractUndoableEdit != null) {
            extendedCompoundEdit.addEdit(abstractUndoableEdit);
        }
        if (bl2) {
            TaskPlanner.rescheduleTree(task);
        } else {
            extendedCompoundEdit.discardReschedule();
        }
        extendedCompoundEdit.end();
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
        this.fireUndoableEditHappened(undoableEditEvent);
    }

    public Class getColumnClass(int n) {
        return (Class)this.columnsType.get(n);
    }

    public String getColumnName(int n) {
        return (String)this.titles.get(n);
    }

    public void setColumnName(int n, String string) {
        this.titles.set(n, string);
    }

    public int getColumnCount() {
        return this.titles.size();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    protected void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task != EPSTableModel.this.data.getRootTask()) {
                int n = EPSTableModel.this.data.getRootTask().getProjectChildIndex(task);
                EPSTableModel.this.fireTableRowsUpdated(n, n);
            }
        }

        public void projectChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task != EPSTableModel.this.data.getRootTask()) {
                int n = EPSTableModel.this.data.getRootTask().getProjectChildIndex(task);
                EPSTableModel.this.fireTableRowsUpdated(n, n);
            }
        }

        public void dataChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            if (task != EPSTableModel.this.data.getRootTask()) {
                int n = EPSTableModel.this.data.getRootTask().getProjectChildIndex(task);
                EPSTableModel.this.fireTableRowsUpdated(n, n);
            }
        }

        public void childAdded(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            if (task2.isProject()) {
                task2.addTaskListener(EPSTableModel.this.taskHandler);
                int n = task.getProjectChildIndex(task2);
                EPSTableModel.this.fireTableRowsInserted(n, n);
            }
        }

        public void childWillRemove(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Task task2 = taskEvent.getTask();
            if (task2.isProject()) {
                task2.removeTaskListener(EPSTableModel.this.taskHandler);
                int n = task.getProjectChildIndex(task2);
                EPSTableModel.this.fireTableRowsDeleted(n, n);
            }
        }
    }
}

