/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart.chart;

import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskDeadlineHoover;
import com.sbs.jpm.ui.treetablechart.chart.ChartUIConfiguration;
import com.sbs.jpm.ui.treetablechart.chart.GraphicPrimitiveContainer;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.PrimitiveStyle;
import com.sbs.jpm.ui.treetablechart.util.TextLengthCalculatorImpl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Map;

public class StyledPainterImpl
implements Painter {
    private Graphics graphics;
    private final Map stylePainter = new HashMap();
    private final TextLengthCalculatorImpl textLengthCalculator;
    private ChartUIConfiguration config;
    private static final Color hooverDependencyColor = Color.GRAY.brighter();
    private static final int hooverBorderThickness = 2;
    private static final Stroke hooverStroke = new BasicStroke(2.0f);
    private RectanglePainter focusPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            int n = (int)rectangle.getRightX();
            int n2 = (int)rectangle.getTopY();
            int n3 = (int)rectangle.getBottomY();
            Polygon polygon = new Polygon();
            polygon.addPoint((int)rectangle.getLeftX(), n2);
            polygon.addPoint(n, n2);
            polygon.addPoint((int)rectangle.getMiddleX(), n3);
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(StyledPainterImpl.this.config.getTimescaleFocusPointColor());
            StyledPainterImpl.this.graphics.fillPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    static final Stroke dashStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
    private static final Color gridColor = new Color(230, 230, 230);
    private LinePainter delimiterPainter = new LinePainter(){

        public void paint(GraphicPrimitiveContainer.Line line) {
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(gridColor);
            StyledPainterImpl.this.graphics.drawLine((int)line.getStartX(), (int)line.getStartY(), (int)line.getFinishX(), (int)line.getFinishY());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private LinePainter gridDelimiterPainter = new LinePainter(){

        public void paint(GraphicPrimitiveContainer.Line line) {
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(Color.GRAY.brighter());
            StyledPainterImpl.this.graphics.drawLine((int)line.getStartX(), (int)line.getStartY(), (int)line.getFinishX(), (int)line.getFinishY());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private LinePainter timescaleDelimiterPainter = new LinePainter(){

        public void paint(GraphicPrimitiveContainer.Line line) {
            Rectangle rectangle = StyledPainterImpl.this.graphics.getClipBounds();
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(new Color(130, 130, 130));
            StyledPainterImpl.this.graphics.drawLine(rectangle.x + (int)line.getStartX(), (int)line.getStartY(), rectangle.x + (int)line.getFinishX(), (int)line.getFinishY());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private LinePainter projectStartDatePainter = new LinePainter(){

        public void paint(GraphicPrimitiveContainer.Line line) {
            Graphics2D graphics2D = (Graphics2D)StyledPainterImpl.this.graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.setColor(StyledPainterImpl.this.config.getProjectStartDatePointColor());
            graphics2D.draw(new Line2D.Double((double)rectangle.x + line.getStartX(), line.getStartY(), (double)rectangle.x + line.getFinishX(), line.getFinishY()));
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    };
    private LinePainter projectEstimatedStartDatePainter = new LinePainter(){

        public void paint(GraphicPrimitiveContainer.Line line) {
            Graphics2D graphics2D = (Graphics2D)StyledPainterImpl.this.graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.setColor(StyledPainterImpl.this.config.getProjectEstimatedStartDatePointColor());
            graphics2D.draw(new Line2D.Double((double)rectangle.x + line.getStartX(), line.getStartY(), (double)rectangle.x + line.getFinishX(), line.getFinishY()));
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    };
    private LinePainter projectEndDatePainter = new LinePainter(){

        public void paint(GraphicPrimitiveContainer.Line line) {
            Graphics2D graphics2D = (Graphics2D)StyledPainterImpl.this.graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.setColor(StyledPainterImpl.this.config.getProjectEndDatePointColor());
            graphics2D.draw(new Line2D.Double((double)rectangle.x + line.getStartX(), line.getStartY(), (double)rectangle.x + line.getFinishX(), line.getFinishY()));
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    };
    private LinePainter currentDatePainter = new LinePainter(){

        public void paint(GraphicPrimitiveContainer.Line line) {
            Graphics2D graphics2D = (Graphics2D)StyledPainterImpl.this.graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashStroke);
            graphics2D.setColor(StyledPainterImpl.this.config.getCurrentDatePointColor());
            graphics2D.draw(new Line2D.Double((double)rectangle.x + line.getStartX(), line.getStartY(), (double)rectangle.x + line.getFinishX(), line.getFinishY()));
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    };
    private LinePainter dependencyPainter = new LinePainter(){
        private static final int PIN_SIZE = 4;
        private static final int LEFT_OFFSET = 3;

        public void paint(GraphicPrimitiveContainer.Line line) {
            int n;
            int n2;
            Dependency dependency = (Dependency)line.getModelObject();
            Task task = dependency.getPredecessor();
            Task task2 = dependency.getSuccessor();
            Color color = StyledPainterImpl.this.graphics.getColor();
            if (dependency.getMouseHoover()) {
                StyledPainterImpl.this.graphics.setColor(hooverDependencyColor);
            } else {
                StyledPainterImpl.this.graphics.setColor(Color.BLACK);
            }
            int n3 = (int)line.getFinishX();
            if (line.getFinishX() - line.getStartX() < 3.0) {
                n3 = (int)line.getFinishX() + 3;
            }
            StyledPainterImpl.this.graphics.drawLine((int)line.getStartX(), (int)line.getStartY(), n3, (int)line.getStartY());
            StyledPainterImpl.this.graphics.drawLine(n3, (int)line.getStartY(), n3, (int)line.getFinishY());
            if (task.getId() < task2.getId()) {
                n2 = (int)line.getFinishY() - 4;
                n = (int)line.getFinishY();
            } else {
                n2 = (int)line.getFinishY() + 4;
                n = (int)line.getFinishY() - 1;
            }
            Polygon polygon = new Polygon();
            polygon.addPoint(n3, n);
            polygon.addPoint(n3 - 4, n2);
            polygon.addPoint((int)line.getFinishX() + 3 + 4, n2);
            polygon.addPoint(n3 + 4, n2);
            StyledPainterImpl.this.graphics.fillPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter periodPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(StyledPainterImpl.this.config.getDayOffColor());
            StyledPainterImpl.this.graphics.fillRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter supertaskPainter = new RectanglePainter(){
        private static final int PIN_SIZE = 3;

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            int n = 6;
            int n2 = (int)rectangle.getRightX();
            int n3 = (int)rectangle.getTopY();
            int n4 = (int)rectangle.getBottomY();
            int n5 = n4 - n;
            Polygon polygon = new Polygon();
            polygon.addPoint((int)rectangle.getLeftX(), n3);
            polygon.addPoint(n2, n3);
            polygon.addPoint(n2, n4);
            polygon.addPoint(n2 - n >= (int)rectangle.getLeftX() ? n2 - n : (int)rectangle.getLeftX(), n5);
            polygon.addPoint((int)rectangle.getLeftX() + n <= n2 ? (int)rectangle.getLeftX() + n : n2, n5);
            polygon.addPoint((int)rectangle.getLeftX(), n4);
            Task task = (Task)rectangle.getModelObject();
            Color color = StyledPainterImpl.this.graphics.getColor();
            Color color2 = task.getBarColor();
            if (color2 == null) {
                color2 = StyledPainterImpl.this.config.getPhaseTaskColor();
            }
            if (task.getMouseHoover()) {
                StyledPainterImpl.this.graphics.setColor(Color.WHITE);
            } else {
                StyledPainterImpl.this.graphics.setColor(color2.darker());
            }
            StyledPainterImpl.this.graphics.drawPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color2);
            StyledPainterImpl.this.graphics.fillPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter projectPainter = new RectanglePainter(){
        private static final int PIN_SIZE = 3;

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            int n = 6;
            int n2 = (int)rectangle.getRightX();
            int n3 = (int)rectangle.getTopY();
            int n4 = (int)rectangle.getBottomY();
            int n5 = n4 - n;
            Polygon polygon = new Polygon();
            polygon.addPoint((int)rectangle.getLeftX(), n3);
            polygon.addPoint(n2, n3);
            polygon.addPoint(n2, n4);
            polygon.addPoint(n2 - n >= (int)rectangle.getLeftX() ? n2 - n : (int)rectangle.getLeftX(), n5);
            polygon.addPoint((int)rectangle.getLeftX() + n <= n2 ? (int)rectangle.getLeftX() + n : n2, n5);
            polygon.addPoint((int)rectangle.getLeftX(), n4);
            Task task = (Task)rectangle.getModelObject();
            Color color = StyledPainterImpl.this.graphics.getColor();
            Color color2 = task.getBarColor();
            if (color2 == null) {
                color2 = StyledPainterImpl.this.config.getProjectTaskColor();
            }
            if (task.getMouseHoover()) {
                StyledPainterImpl.this.graphics.setColor(Color.WHITE);
            } else {
                StyledPainterImpl.this.graphics.setColor(color2.darker());
            }
            StyledPainterImpl.this.graphics.drawPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color2);
            StyledPainterImpl.this.graphics.fillPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private IconPainter deadlinePainter = new IconPainter(){

        public void paint(GraphicPrimitiveContainer.Image image) {
            Graphics graphics = StyledPainterImpl.this.graphics;
            TaskDeadlineHoover taskDeadlineHoover = (TaskDeadlineHoover)image.getModelObject();
            if (taskDeadlineHoover.getMouseHoover()) {
                if (image.getHighlightedIcon() != null) {
                    image.getHighlightedIcon().paintIcon(null, graphics, (int)image.getLeftX(), (int)image.getTopY());
                } else {
                    image.getIcon().paintIcon(null, graphics, (int)image.getLeftX(), (int)image.getTopY());
                }
            } else {
                image.getIcon().paintIcon(null, graphics, (int)image.getLeftX(), (int)image.getTopY());
            }
        }
    };
    private TextPainter assignedResourcesPainter = new TextPainter(){
        private static final int TOP_OFFSET = 2;

        public void paint(GraphicPrimitiveContainer.Text text) {
            Graphics graphics = StyledPainterImpl.this.graphics;
            Font font = graphics.getFont();
            Color color = text.getForegroundColor();
            if (color == null) {
                color = Color.BLACK;
            }
            graphics.setColor(color);
            if (text.getFont() != null) {
                graphics.setFont(text.getFont());
            } else {
                graphics.setFont(StyledPainterImpl.this.config.getChartFont());
            }
            graphics.drawString(text.getText(), (int)text.getLeftX(), (int)text.getBottomY() - 4);
            graphics.setFont(font);
        }
    };
    private TextPainter treeTableTextPainter = new TextPainter(){

        public void paint(GraphicPrimitiveContainer.Text text) {
            Font font = StyledPainterImpl.this.graphics.getFont();
            Color color = text.getForegroundColor();
            if (color == null) {
                color = Color.BLACK;
            }
            StyledPainterImpl.this.graphics.setColor(color);
            if (text.getFont() != null) {
                StyledPainterImpl.this.graphics.setFont(text.getFont());
            } else {
                StyledPainterImpl.this.graphics.setFont(StyledPainterImpl.this.config.getChartFont());
            }
            StyledPainterImpl.this.graphics.drawString(text.getText(), (int)text.getLeftX(), (int)text.getBottomY());
            StyledPainterImpl.this.graphics.setFont(font);
        }
    };
    private RectanglePainter taskCompletionPainter;
    private RectanglePainter splittedTaskPartCompletionPainter = this.taskCompletionPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            Color color = StyledPainterImpl.this.graphics.getColor();
            Task task = (Task)rectangle.getModelObject();
            Color color2 = task.getCompany().isShowCriticalPath() ? (task.isCritical() ? StyledPainterImpl.this.config.getTaskCompletionCriticalColor() : StyledPainterImpl.this.config.getTaskCompletionColor()) : StyledPainterImpl.this.config.getTaskCompletionColor();
            StyledPainterImpl.this.graphics.setColor(color2);
            StyledPainterImpl.this.graphics.fillRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter baselineCompletionPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            Color color = StyledPainterImpl.this.graphics.getColor();
            Color color2 = StyledPainterImpl.this.config.getTaskCompletionColor();
            StyledPainterImpl.this.graphics.setColor(color2);
            StyledPainterImpl.this.graphics.fillRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter taskPainter;
    private RectanglePainter splittedTaskPartPainter = this.taskPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            Color color = StyledPainterImpl.this.graphics.getColor();
            Task task = (Task)rectangle.getModelObject();
            Color color2 = task.getBarColor();
            if (color2 == null) {
                color2 = StyledPainterImpl.this.config.getTaskColor();
            }
            if (task.getCompany().isShowCriticalPath() && task.isCritical()) {
                color2 = StyledPainterImpl.this.config.getTaskCriticalColor();
            }
            Color color3 = task.getMouseHoover() ? Color.WHITE : color2.darker();
            StyledPainterImpl.this.graphics.setColor(color2);
            StyledPainterImpl.this.graphics.fillRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color3);
            StyledPainterImpl.this.graphics.drawRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter splittedTaskPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
        }
    };
    private RectanglePainter baselinePainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            Color color = StyledPainterImpl.this.graphics.getColor();
            Color color2 = StyledPainterImpl.this.config.getBaselineColor();
            Color color3 = color2.darker();
            StyledPainterImpl.this.graphics.setColor(color2);
            StyledPainterImpl.this.graphics.fillRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color3);
            StyledPainterImpl.this.graphics.drawRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter selectionPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            Rectangle rectangle2 = StyledPainterImpl.this.graphics.getClipBounds();
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(StyledPainterImpl.this.config.getDayOffColor());
            StyledPainterImpl.this.graphics.fillRect(rectangle2.x + (int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter milestonePainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            int n = (int)rectangle.getRightX();
            int n2 = (int)rectangle.getTopY();
            int n3 = (int)rectangle.getBottomY();
            Polygon polygon = new Polygon();
            polygon.addPoint((int)rectangle.getMiddleX(), n2);
            polygon.addPoint((int)rectangle.getLeftX() - 4, (int)rectangle.getMiddleY());
            polygon.addPoint((int)rectangle.getMiddleX(), n3);
            polygon.addPoint(n + 4, (int)rectangle.getMiddleY());
            Task task = (Task)rectangle.getModelObject();
            Color color = StyledPainterImpl.this.graphics.getColor();
            Color color2 = task.getBarColor();
            if (color2 == null) {
                color2 = StyledPainterImpl.this.config.getMilestoneColor();
            }
            if (task.getMouseHoover()) {
                StyledPainterImpl.this.graphics.setColor(Color.WHITE);
            } else {
                StyledPainterImpl.this.graphics.setColor(color2.darker());
            }
            StyledPainterImpl.this.graphics.drawPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color2);
            StyledPainterImpl.this.graphics.fillPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter supertaskCompletionPainter = new RectanglePainter(){
        private static final int PIN_SIZE = 3;

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            int n = 6;
            int n2 = (int)rectangle.getRightX();
            int n3 = (int)rectangle.getTopY();
            int n4 = (int)rectangle.getBottomY();
            int n5 = n4 - n;
            Polygon polygon = new Polygon();
            polygon.addPoint((int)rectangle.getLeftX(), n3);
            polygon.addPoint(n2, n3);
            polygon.addPoint(n2, n4 - n);
            polygon.addPoint(n2 - n >= (int)rectangle.getLeftX() ? n2 - n : (int)rectangle.getLeftX(), n5);
            polygon.addPoint((int)rectangle.getLeftX() + n <= n2 ? (int)rectangle.getLeftX() + n : n2, n5);
            polygon.addPoint((int)rectangle.getLeftX(), n4);
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(StyledPainterImpl.this.config.getPhaseTaskCompletionColor());
            StyledPainterImpl.this.graphics.fillPolygon(polygon);
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };
    private RectanglePainter timescaleBackgroundPainter = new RectanglePainter(){

        public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
            Rectangle rectangle2 = StyledPainterImpl.this.graphics.getClipBounds();
            Color color = StyledPainterImpl.this.graphics.getColor();
            StyledPainterImpl.this.graphics.setColor(StyledPainterImpl.this.config.getTimescaleBackgroundColor());
            StyledPainterImpl.this.graphics.fillRect(rectangle2.x + (int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            StyledPainterImpl.this.graphics.setColor(color);
        }
    };

    public StyledPainterImpl(ChartUIConfiguration chartUIConfiguration) {
        this.config = chartUIConfiguration;
        this.stylePainter.put(PrimitiveStyle.SUPERTASK, this.supertaskPainter);
        this.stylePainter.put(PrimitiveStyle.PROJECT, this.projectPainter);
        this.stylePainter.put(PrimitiveStyle.TASK, this.taskPainter);
        this.stylePainter.put(PrimitiveStyle.SPLITTED_TASK, this.splittedTaskPainter);
        this.stylePainter.put(PrimitiveStyle.SPLITTED_TASK_PART, this.splittedTaskPartPainter);
        this.stylePainter.put(PrimitiveStyle.SPLITTED_TASK_PART_COMPLETION, this.splittedTaskPartCompletionPainter);
        this.stylePainter.put(PrimitiveStyle.BASELINE, this.baselinePainter);
        this.stylePainter.put(PrimitiveStyle.MILESTONE, this.milestonePainter);
        this.stylePainter.put(PrimitiveStyle.DEADLINE, this.deadlinePainter);
        this.stylePainter.put(PrimitiveStyle.ASSIGNED_RESOURCES, this.assignedResourcesPainter);
        this.stylePainter.put(PrimitiveStyle.TREETABLE_TEXT, this.treeTableTextPainter);
        this.stylePainter.put(PrimitiveStyle.TASK_COMPLETION, this.taskCompletionPainter);
        this.stylePainter.put(PrimitiveStyle.BASELINE_COMPLETION, this.baselineCompletionPainter);
        this.stylePainter.put(PrimitiveStyle.SUPERTASK_COMPLETION, this.supertaskCompletionPainter);
        this.stylePainter.put(PrimitiveStyle.DEPENDENCY, this.dependencyPainter);
        this.stylePainter.put(PrimitiveStyle.PERIOD, this.periodPainter);
        this.stylePainter.put(PrimitiveStyle.TIMESCALE_BACKGROUND, this.timescaleBackgroundPainter);
        this.stylePainter.put(PrimitiveStyle.UNIT_DELIMITER, this.delimiterPainter);
        this.stylePainter.put(PrimitiveStyle.GRID_UNIT_DELIMITER, this.gridDelimiterPainter);
        this.stylePainter.put(PrimitiveStyle.TIMESCALE_UNIT_DELIMITER, this.timescaleDelimiterPainter);
        this.stylePainter.put(PrimitiveStyle.FOCUS_DATE, this.focusPainter);
        this.stylePainter.put(PrimitiveStyle.PROJECT_START_DATE, this.projectStartDatePainter);
        this.stylePainter.put(PrimitiveStyle.PROJECT_ESTIMATED_START_DATE, this.projectEstimatedStartDatePainter);
        this.stylePainter.put(PrimitiveStyle.PROJECT_END_DATE, this.projectEndDatePainter);
        this.stylePainter.put(PrimitiveStyle.CURRENT_DATE, this.currentDatePainter);
        this.stylePainter.put(PrimitiveStyle.SELECTION, this.selectionPainter);
        this.textLengthCalculator = new TextLengthCalculatorImpl(this.graphics);
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
        this.textLengthCalculator.setGraphics(graphics);
    }

    public void paint(GraphicPrimitiveContainer.Line line) {
        if (this.graphics == null) {
            throw new RuntimeException("Graphics is null");
        }
        LinePainter linePainter = null;
        if (this.stylePainter.containsKey(line.getStyle())) {
            linePainter = (LinePainter)this.stylePainter.get(line.getStyle());
        }
        if (linePainter != null) {
            linePainter.paint(line);
        } else {
            Rectangle rectangle = this.graphics.getClipBounds();
            Color color = line.getForegroundColor();
            if (color == null) {
                color = Color.BLACK;
            }
            this.graphics.setColor(color);
            this.graphics.drawLine(rectangle.x + (int)line.getStartX(), (int)line.getStartY(), rectangle.x + (int)line.getFinishX(), (int)line.getFinishY());
        }
    }

    public void paint(GraphicPrimitiveContainer.Rectangle rectangle) {
        if (this.graphics == null) {
            throw new RuntimeException("Graphics is null");
        }
        RectanglePainter rectanglePainter = null;
        if (this.stylePainter.containsKey(rectangle.getStyle())) {
            rectanglePainter = (RectanglePainter)this.stylePainter.get(rectangle.getStyle());
        }
        if (rectanglePainter != null) {
            rectanglePainter.paint(rectangle);
        } else {
            Rectangle rectangle2 = this.graphics.getClipBounds();
            if (rectangle.getBackgroundColor() == null) {
                Color color = rectangle.getForegroundColor();
                if (color == null) {
                    color = Color.BLACK;
                }
                this.graphics.setColor(color);
                this.graphics.drawRect(rectangle2.x + (int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            } else {
                this.graphics.setColor(rectangle.getBackgroundColor());
                this.graphics.fillRect((int)rectangle.getLeftX(), (int)rectangle.getTopY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            }
        }
    }

    public void paint(GraphicPrimitiveContainer.Image image) {
        if (this.graphics == null) {
            throw new RuntimeException("Graphics is null");
        }
        IconPainter iconPainter = null;
        if (this.stylePainter.containsKey(image.getStyle())) {
            iconPainter = (IconPainter)this.stylePainter.get(image.getStyle());
        }
        if (iconPainter != null) {
            iconPainter.paint(image);
        } else {
            Rectangle rectangle = this.graphics.getClipBounds();
            image.getIcon().paintIcon(null, this.graphics, (int)image.getLeftX(), (int)image.getTopY());
        }
    }

    public void paint(GraphicPrimitiveContainer.Text text) {
        if (this.graphics == null) {
            throw new RuntimeException("Graphics is null");
        }
        TextPainter textPainter = null;
        if (this.stylePainter.containsKey(text.getStyle())) {
            textPainter = (TextPainter)this.stylePainter.get(text.getStyle());
        }
        if (textPainter != null) {
            textPainter.paint(text);
        } else {
            Rectangle rectangle = this.graphics.getClipBounds();
            Font font = this.graphics.getFont();
            Color color = text.getForegroundColor();
            if (color == null) {
                color = Color.BLACK;
            }
            this.graphics.setColor(color);
            if (text.getFont() != null) {
                this.graphics.setFont(text.getFont());
            } else {
                this.graphics.setFont(this.config.getChartFont());
            }
            this.graphics.drawString(text.getText(), rectangle.x + (int)text.getLeftX(), (int)text.getBottomY());
            this.graphics.setFont(font);
        }
    }

    private static interface IconPainter {
        public void paint(GraphicPrimitiveContainer.Image var1);
    }

    private static interface TextPainter {
        public void paint(GraphicPrimitiveContainer.Text var1);
    }

    private static interface LinePainter {
        public void paint(GraphicPrimitiveContainer.Line var1);
    }

    private static interface RectanglePainter {
        public void paint(GraphicPrimitiveContainer.Rectangle var1);
    }
}

