/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.core.Task;
import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class TaskHighlighter
extends AbstractHighlighter {
    public static final Color PROJECT_COLOR = Color.GRAY;
    public static final Color TASK_COLOR = Color.BLACK;
    private int column;

    public TaskHighlighter(int n) {
        this.column = n;
        this.setHighlightPredicate(new TaskPredicate(n));
    }

    protected Color computeSelectedForeground(Component component, ComponentAdapter componentAdapter) {
        Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.column);
        if (object != null && object instanceof Task) {
            Task task = (Task)object;
            if (task.isProject()) {
                return PROJECT_COLOR;
            }
            return TASK_COLOR;
        }
        return Color.BLACK;
    }

    protected Color computeUnselectedForeground(Component component, ComponentAdapter componentAdapter) {
        Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.column);
        if (object != null && object instanceof Task) {
            Task task = (Task)object;
            if (task.isProject()) {
                return PROJECT_COLOR;
            }
            return TASK_COLOR;
        }
        return Color.BLACK;
    }

    protected void applyForeground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = color = componentAdapter.isSelected() ? this.computeSelectedForeground(component, componentAdapter) : this.computeUnselectedForeground(component, componentAdapter);
        if (color != null) {
            component.setForeground(color);
        }
    }

    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        this.applyForeground(component, componentAdapter);
        Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.column);
        if (object != null && object instanceof Task) {
            Task task = (Task)object;
            if (!(task.isSplitted() || !task.isProject() && task.isLeaf())) {
                component.setFont(component.getFont().deriveFont(1));
            } else {
                component.setFont(component.getFont().deriveFont(0));
            }
        }
        return component;
    }

    public class TaskPredicate
    implements HighlightPredicate {
        private int testColumn;

        public TaskPredicate(int n) {
            this.testColumn = n;
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.testColumn);
            if (object != null && object instanceof Task) {
                Task task = (Task)object;
                return !task.isEmpty();
            }
            return false;
        }
    }
}

