/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Resource;
import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class ResourceSheetHighlighter
extends AbstractHighlighter {
    public static final Color OVERALOCATED_COLOR = Color.RED;
    public static final Color OVERTIME_COLOR = Color.ORANGE;
    private int column;

    public ResourceSheetHighlighter(int n) {
        this.column = n;
        this.setHighlightPredicate(new ResourceSheetPredicate(n));
    }

    protected Color computeSelectedForeground(Component component, ComponentAdapter componentAdapter) {
        Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.column);
        if (object != null) {
            Resource resource;
            if (object instanceof Assignment) {
                Assignment assignment = (Assignment)object;
                Resource resource2 = assignment.getResource();
                if (resource2 instanceof HumanResource) {
                    HumanResource humanResource = (HumanResource)resource2;
                    if (humanResource.isOverallocated(assignment)) {
                        return OVERALOCATED_COLOR;
                    }
                    if (humanResource.getOvertimeWork(assignment) != 0L) {
                        return OVERTIME_COLOR;
                    }
                }
            } else if (object instanceof Resource && (resource = (Resource)object) instanceof HumanResource) {
                HumanResource humanResource = (HumanResource)resource;
                if (humanResource.isOverallocated()) {
                    return OVERALOCATED_COLOR;
                }
                if (humanResource.getOvertimeWork() != 0L) {
                    return OVERTIME_COLOR;
                }
            }
        }
        return Color.BLACK;
    }

    protected Color computeUnselectedForeground(Component component, ComponentAdapter componentAdapter) {
        Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.column);
        if (object != null) {
            Resource resource;
            if (object instanceof Assignment) {
                Assignment assignment = (Assignment)object;
                Resource resource2 = assignment.getResource();
                if (resource2 instanceof HumanResource) {
                    HumanResource humanResource = (HumanResource)resource2;
                    if (humanResource.isOverallocated(assignment)) {
                        return OVERALOCATED_COLOR;
                    }
                    if (humanResource.getOvertimeWork(assignment) != 0L) {
                        return OVERTIME_COLOR;
                    }
                }
            } else if (object instanceof Resource && (resource = (Resource)object) instanceof HumanResource) {
                HumanResource humanResource = (HumanResource)resource;
                if (humanResource.isOverallocated()) {
                    return OVERALOCATED_COLOR;
                }
                if (humanResource.getOvertimeWork() != 0L) {
                    return OVERTIME_COLOR;
                }
            }
        }
        return Color.BLACK;
    }

    protected void applyForeground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = color = componentAdapter.isSelected() ? this.computeSelectedForeground(component, componentAdapter) : this.computeUnselectedForeground(component, componentAdapter);
        if (color != null) {
            component.setForeground(color);
        }
    }

    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        this.applyForeground(component, componentAdapter);
        Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.column);
        if (object != null) {
            if (object instanceof Resource) {
                component.setFont(component.getFont().deriveFont(1));
            } else {
                component.setFont(component.getFont().deriveFont(0));
            }
        }
        return component;
    }

    public class ResourceSheetPredicate
    implements HighlightPredicate {
        private int testColumn;

        public ResourceSheetPredicate(int n) {
            this.testColumn = n;
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            Object object = componentAdapter.getFilteredValueAt(componentAdapter.row, this.testColumn);
            if (object != null) {
                if (object instanceof Assignment) {
                    return true;
                }
                if (object instanceof Resource) {
                    Resource resource = (Resource)object;
                    return !resource.isEmpty();
                }
            }
            return false;
        }
    }
}

