/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.treetablechart.JArea;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public abstract class JTreeTableChart
extends JPanel {
    protected JTreeTable treeTable;
    protected JArea area;
    private JSplitPane splitPane;
    protected JRowHeader rowHeader;
    protected Task project;
    protected boolean FIRST = true;

    public JTreeTableChart() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createComponents(), "Center");
    }

    public void setProject(Task task) {
        this.project = task;
        this.treeTable.setProject(task);
        this.rowHeader.setTableModel(this.treeTable.getModel());
        this.area.setProject(task);
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    public JArea getArea() {
        return this.area;
    }

    protected abstract JTreeTable createTreeTable();

    protected abstract JArea createArea();

    protected JPanel createLeftComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.treeTable));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Rectangle rectangle = JTreeTableChart.this.area.getChartArea().getVisibleRect();
                double d = rectangle.getY();
                double d2 = adjustmentEvent.getAdjustable().getValue();
                int n = (int)Math.abs(d2 - d);
                int n2 = d2 - d > 0.0 ? rectangle.y + rectangle.height : rectangle.y - n;
                JTreeTableChart.this.area.getChartArea().scrollRectToVisible(new Rectangle(rectangle.x, n2, rectangle.width, n));
            }
        });
        jScrollPane.getViewport().setBackground(this.treeTable.getBackground());
        this.rowHeader = new JRowHeader((JTable)((Object)this.treeTable));
        jScrollPane.setRowHeaderView(this.rowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.setPreferredSize(new Dimension(315, 600));
        this.treeTable.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JTreeTableChart.this.area.getChartArea().revalidate();
            }
        });
        return jPanel;
    }

    protected JPanel createRightComponent() {
        return this.area;
    }

    private JSplitPane createComponents() {
        this.treeTable = this.createTreeTable();
        this.area = this.createArea();
        JPanel jPanel = this.createLeftComponent();
        JPanel jPanel2 = this.createRightComponent();
        this.splitPane = new JSplitPane(1);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.splitPane.setLeftComponent(jPanel);
        this.splitPane.setRightComponent(jPanel2);
        this.splitPane.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(330);
        this.splitPane.setPreferredSize(new Dimension(800, 500));
        this.splitPane.setDividerSize(8);
        return this.splitPane;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public JRowHeader getRowHeader() {
        return this.rowHeader;
    }
}

