/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.CurrencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.util.TaskDurationFormat;
import com.sbs.jpm.ui.component.util.TaskWorkDurationFormat;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTableChart;
import com.sbs.jpm.ui.treetablechart.model.TaskTreeTableModel;
import com.sbs.jpm.ui.treetablechart.util.InfoCellRenderer;
import com.standbysoft.component.date.DateSelectionException;
import com.standbysoft.component.date.swing.JDatePicker;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;

public abstract class JTaskTreeTable
extends JTreeTable {
    protected JDatePicker datePicker;
    protected JDatePicker deadlineDatePicker;
    protected int totalVerticalNumPages;
    protected int totalHorizontalNumPages;
    protected double pageHeight;
    protected double pageWidth;
    protected double headerHeightOnPage;
    protected double tableWidth;
    protected static final JFormattedTextField formattedTextField = new JFormattedTextField();

    public JTaskTreeTable(JTreeTableChart jTreeTableChart, TreeTableModel treeTableModel) {
        super(jTreeTableChart, treeTableModel);
    }

    protected void setHeaderWidths() {
        this.setRootVisible(UIManager.getInstance().isShowProjectRoot());
        this.getColumnExt(TaskTreeTableModel.TASK_NAME).setMinWidth(50);
        this.getColumnExt(TaskTreeTableModel.TASK_NAME).setPreferredWidth(150);
        this.getColumnExt(TaskTreeTableModel.INFO).setMinWidth(20);
        this.getColumnExt(TaskTreeTableModel.INFO).setPreferredWidth(30);
        this.getColumnExt(TaskTreeTableModel.INFO).setCellRenderer((TableCellRenderer)new InfoCellRenderer(new DefaultTableCellRenderer()));
        this.getColumnExt(TaskTreeTableModel.START).setPreferredWidth(150);
        this.getColumnExt(TaskTreeTableModel.DEADLINE).setPreferredWidth(150);
        this.getColumnExt(TaskTreeTableModel.END).setPreferredWidth(150);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_START).setPreferredWidth(150);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_END).setPreferredWidth(150);
        this.getColumnExt(TaskTreeTableModel.FIXED_COST).setPreferredWidth(100);
        this.getColumnExt(TaskTreeTableModel.ACCRUAL).setPreferredWidth(100);
        this.getColumnExt(TaskTreeTableModel.COST).setPreferredWidth(100);
    }

    protected void setRenderersAndEditors() {
        this.datePicker = new JDatePicker();
        this.datePicker.setEditable(true);
        try {
            this.datePicker.setEmptySelectionAllowed(false);
        }
        catch (DateSelectionException dateSelectionException) {
            Common.logException("Error:", dateSelectionException);
        }
        this.datePicker.setEmptySelectionText("");
        this.datePicker.setDateFormat(UIManager.getInstance().getDateFormat());
        this.deadlineDatePicker = new JDatePicker();
        this.deadlineDatePicker.setEditable(true);
        this.deadlineDatePicker.setDateFormat(UIManager.getInstance().getDateFormat());
        TableCellEditor tableCellEditor = JDatePicker.createTableCellEditor((JDatePicker)this.datePicker);
        this.getColumnExt(TaskTreeTableModel.START).setCellEditor(tableCellEditor);
        this.getColumnExt(TaskTreeTableModel.START).setCellRenderer((TableCellRenderer)new DateRenderer(this.getDefaultRenderer(Date.class), tableCellEditor));
        TableCellEditor tableCellEditor2 = JDatePicker.createTableCellEditor((JDatePicker)this.datePicker);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_START).setCellEditor(tableCellEditor2);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_START).setCellRenderer((TableCellRenderer)new DateRenderer(this.getDefaultRenderer(Date.class), tableCellEditor2));
        TableCellEditor tableCellEditor3 = JDatePicker.createTableCellEditor((JDatePicker)this.datePicker);
        this.getColumnExt(TaskTreeTableModel.END).setCellEditor(tableCellEditor3);
        this.getColumnExt(TaskTreeTableModel.END).setCellRenderer((TableCellRenderer)new DateRenderer(this.getDefaultRenderer(Date.class), tableCellEditor3));
        TableCellEditor tableCellEditor4 = JDatePicker.createTableCellEditor((JDatePicker)this.datePicker);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_END).setCellEditor(tableCellEditor4);
        this.getColumnExt(TaskTreeTableModel.ACTUAL_END).setCellRenderer((TableCellRenderer)new DateRenderer(this.getDefaultRenderer(Date.class), tableCellEditor4));
        TableCellEditor tableCellEditor5 = JDatePicker.createTableCellEditor((JDatePicker)this.deadlineDatePicker);
        this.getColumnExt(TaskTreeTableModel.DEADLINE).setCellEditor(tableCellEditor5);
        this.getColumnExt(TaskTreeTableModel.DEADLINE).setCellRenderer((TableCellRenderer)new DateRenderer(this.getDefaultRenderer(Date.class), tableCellEditor5));
        this.getColumnExt(TaskTreeTableModel.ACCRUAL).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setHorizontalAlignment(4);
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        String[] stringArray = new String[]{Task.START, Task.PRORATED, Task.END};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        this.getColumnExt(TaskTreeTableModel.ACCRUAL).setCellEditor((TableCellEditor)new DefaultCellEditor(jComboBox));
        this.getColumnExt(TaskTreeTableModel.CALENDAR).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setHorizontalAlignment(4);
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.getColumnExt(TaskTreeTableModel.PERCENT_COMPLETE).setCellRenderer((TableCellRenderer)new CompletionCellRenderer());
        this.getColumnExt(TaskTreeTableModel.PERCENT_WORK_COMPLETE).setCellRenderer((TableCellRenderer)new CompletionCellRenderer());
        this.getColumnExt(TaskTreeTableModel.DURATION).setCellRenderer((TableCellRenderer)new DurationCellRenderer());
        this.getColumnExt(TaskTreeTableModel.DURATION).setCellEditor((TableCellEditor)new DurationCellEditor(formattedTextField));
        this.getColumnExt(TaskTreeTableModel.ACTUAL_DURATION).setCellRenderer((TableCellRenderer)new DurationCellRenderer());
        this.getColumnExt(TaskTreeTableModel.ACTUAL_DURATION).setCellEditor((TableCellEditor)new DurationCellEditor(formattedTextField));
        this.getColumnExt(TaskTreeTableModel.REMAINING_DURATION).setCellRenderer((TableCellRenderer)new DurationCellRenderer());
        this.getColumnExt(TaskTreeTableModel.REMAINING_DURATION).setCellEditor((TableCellEditor)new DurationCellEditor(formattedTextField));
        this.getColumnExt(TaskTreeTableModel.WORK).setCellRenderer((TableCellRenderer)new WorkCellRenderer());
        this.getColumnExt(TaskTreeTableModel.WORK).setCellEditor((TableCellEditor)new WorkCellEditor(formattedTextField));
        this.getColumnExt(TaskTreeTableModel.ACTUAL_WORK).setCellRenderer((TableCellRenderer)new WorkCellRenderer());
        this.getColumnExt(TaskTreeTableModel.ACTUAL_WORK).setCellEditor((TableCellEditor)new WorkCellEditor(formattedTextField));
        this.getColumnExt(TaskTreeTableModel.REMAINING_WORK).setCellRenderer((TableCellRenderer)new WorkCellRenderer());
        this.getColumnExt(TaskTreeTableModel.REMAINING_WORK).setCellEditor((TableCellEditor)new WorkCellEditor(formattedTextField));
        this.getColumnExt(TaskTreeTableModel.FIXED_COST).setCellRenderer((TableCellRenderer)new CostCellRenderer());
        this.getColumnExt(TaskTreeTableModel.COST).setCellRenderer((TableCellRenderer)new CostCellRenderer());
        this.getColumnExt(TaskTreeTableModel.ACTUAL_COST).setCellRenderer((TableCellRenderer)new CostCellRenderer());
        this.getColumnExt(TaskTreeTableModel.REMAINING_COST).setCellRenderer((TableCellRenderer)new CostCellRenderer());
        this.getColumnExt(TaskTreeTableModel.CALENDAR).setCellEditor((TableCellEditor)new CalendarEditor(new JComboBox()));
    }

    static {
        formattedTextField.setHorizontalAlignment(4);
    }

    protected class CompletionCellRenderer
    extends DefaultTableCellRenderer {
        public CompletionCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TreePath treePath = JTaskTreeTable.this.getPathForRow(n);
            Task task = (Task)treePath.getLastPathComponent();
            if (task.isEmpty()) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            double d = (Double)object;
            NumberFormat numberFormat = NumberFormat.getPercentInstance();
            String string = numberFormat.format(d / 100.0);
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    protected class DateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private TableCellRenderer delegate;
        private TableCellEditor cellEditor;

        public DateRenderer(TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
            this.delegate = tableCellRenderer;
            this.cellEditor = tableCellEditor;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel;
            if (object != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
                String string = simpleDateFormat.format((Date)object);
                jLabel = (JLabel)this.delegate.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
                if (bl2 && bl) {
                    return this.cellEditor.getTableCellEditorComponent(jTable, object, false, n, n2);
                }
            } else {
                jLabel = (JLabel)this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            jLabel.setHorizontalAlignment(4);
            return jLabel;
        }
    }

    protected class CostCellRenderer
    extends DefaultTableCellRenderer {
        public CostCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TreePath treePath = JTaskTreeTable.this.getPathForRow(n);
            Task task = (Task)treePath.getLastPathComponent();
            if (task.isEmpty()) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            Double d = (Double)object;
            Formatter formatter = new Formatter();
            formatter.format(JTaskTreeTable.this.project.getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f", d);
            String string = formatter.toString();
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    protected class CalendarEditor
    extends DefaultCellEditor {
        public CalendarEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>(JTaskTreeTable.this.project.getCompany().getCalendarList());
            linkedList.add(0, (CalendarManager)((Object)Common.I18N_RP.getString("useCompanyCalendar")));
            jComboBox.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
            return jComboBox;
        }
    }

    protected class WorkCellEditor
    extends DefaultCellEditor {
        private JFormattedTextField taskWorkDuration;
        private TaskWorkDurationFormat df;

        public WorkCellEditor(JFormattedTextField jFormattedTextField) {
            super(jFormattedTextField);
            this.taskWorkDuration = jFormattedTextField;
            this.df = new TaskWorkDurationFormat();
            this.delegate = new WorkEditorDelegate();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TreePath treePath = JTaskTreeTable.this.getPathForRow(n);
            Task task = (Task)treePath.getLastPathComponent();
            this.df.setTask(task);
            this.taskWorkDuration.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.df)));
            this.taskWorkDuration.setValue(object);
            return this.taskWorkDuration;
        }

        private class WorkEditorDelegate
        extends DefaultCellEditor.EditorDelegate {
            private WorkEditorDelegate() {
                super(WorkCellEditor.this);
            }

            public void setValue(Object object) {
                WorkCellEditor.this.taskWorkDuration.setValue(object);
            }

            public Object getCellEditorValue() {
                return WorkCellEditor.this.taskWorkDuration.getValue();
            }

            public boolean stopCellEditing() {
                try {
                    WorkCellEditor.this.taskWorkDuration.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return super.stopCellEditing();
            }
        }
    }

    protected class DurationCellEditor
    extends DefaultCellEditor {
        private JFormattedTextField taskDuration;
        private TaskDurationFormat df;

        public DurationCellEditor(JFormattedTextField jFormattedTextField) {
            super(jFormattedTextField);
            this.taskDuration = jFormattedTextField;
            this.taskDuration.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.df = new TaskDurationFormat();
            this.delegate = new DurationEditorDelegate();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TreePath treePath = JTaskTreeTable.this.getPathForRow(n);
            Task task = (Task)treePath.getLastPathComponent();
            this.df.setTask(task);
            this.taskDuration.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.df)));
            this.taskDuration.setValue(object);
            return this.taskDuration;
        }

        private class DurationEditorDelegate
        extends DefaultCellEditor.EditorDelegate {
            private DurationEditorDelegate() {
                super(DurationCellEditor.this);
            }

            public void setValue(Object object) {
                DurationCellEditor.this.taskDuration.setValue(object);
            }

            public Object getCellEditorValue() {
                return DurationCellEditor.this.taskDuration.getValue();
            }

            public boolean stopCellEditing() {
                try {
                    DurationCellEditor.this.taskDuration.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return super.stopCellEditing();
            }
        }
    }

    protected class WorkCellRenderer
    extends DefaultTableCellRenderer {
        public WorkCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TreePath treePath = JTaskTreeTable.this.getPathForRow(n);
            Task task = (Task)treePath.getLastPathComponent();
            if (task.isEmpty()) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            String string = TaskWorkDurationFormat.formatWork(task, (Long)object);
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    protected class DurationCellRenderer
    extends DefaultTableCellRenderer {
        public DurationCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TreePath treePath = JTaskTreeTable.this.getPathForRow(n);
            Task task = (Task)treePath.getLastPathComponent();
            if (task.isEmpty()) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            String string = TaskDurationFormat.formatDuration(task, (Long)object);
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }
}

