/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CurrencyManager;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTableChart;
import com.sbs.jpm.ui.treetablechart.ResourceSheetHighlighter;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.ui.treetablechart.model.ResourceTreeTableModel;
import java.awt.Component;
import java.io.Serializable;
import java.util.Formatter;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JResourceTreeTable
extends JTreeTable {
    public JResourceTreeTable(JTreeTableChart jTreeTableChart) {
        super(jTreeTableChart, (TreeTableModel)new ResourceTreeTableModel());
        this.addHighlighter((Highlighter)new ResourceSheetHighlighter(0));
        this.setHorizontalScrollEnabled(false);
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.expandAll();
    }

    protected ChartTreeTableModel createModel(Task task) {
        return new ResourceTreeTableModel((JTreeTable)this, task.getCompany());
    }

    protected void setHeaderWidths() {
        this.getColumn(ResourceTreeTableModel.NAME).setMinWidth(50);
        this.getColumn(ResourceTreeTableModel.NAME).setPreferredWidth(200);
    }

    protected void setRenderersAndEditors() {
        this.getColumn(ResourceTreeTableModel.TOTAL_WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(ResourceTreeTableModel.ACTUAL_WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(ResourceTreeTableModel.REMAINING_WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(ResourceTreeTableModel.STANDARD_WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(ResourceTreeTableModel.OVERTIME_WORK).setCellRenderer(new WorkCellRenderer());
        this.getColumn(ResourceTreeTableModel.TOTAL_COST).setCellRenderer(new CostCellRenderer());
        this.getColumn(ResourceTreeTableModel.ACTUAL_COST).setCellRenderer(new CostCellRenderer());
        this.getColumn(ResourceTreeTableModel.REMAINING_COST).setCellRenderer(new CostCellRenderer());
        this.getColumn(ResourceTreeTableModel.STANDARD_COST).setCellRenderer(new CostCellRenderer());
        this.getColumn(ResourceTreeTableModel.OVERTIME_COST).setCellRenderer(new CostCellRenderer());
    }

    class CostCellRenderer
    extends DefaultTableCellRenderer {
        public CostCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Serializable serializable;
            if (object == null) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            Object object2 = JResourceTreeTable.this.getPathForRow(n).getLastPathComponent();
            if (object2 instanceof Resource ? ((Resource)(serializable = (Resource)object2)).isEmpty() : object2 instanceof Task && ((Task)(serializable = (Task)object2)).isEmpty()) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            serializable = (Double)object;
            Formatter formatter = new Formatter();
            formatter.format(JResourceTreeTable.this.project.getCompany().getRootTask().getCurrencyUnit() + "%." + CurrencyManager.getFractionDigits() + "f", serializable);
            String string = formatter.toString();
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }
    }

    class WorkCellRenderer
    extends DefaultTableCellRenderer {
        public WorkCellRenderer() {
            this.setHorizontalAlignment(4);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            if (object == null) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            Object object3 = JResourceTreeTable.this.getPathForRow(n).getLastPathComponent();
            if (object3 instanceof Resource ? ((Resource)(object2 = (Resource)object3)).isEmpty() : object3 instanceof Task && ((Task)(object2 = (Task)object3)).isEmpty()) {
                return super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
            }
            if (object instanceof Long) {
                Double d = (double)((Long)object);
                d = d / (double)JResourceTreeTable.this.project.getDurationManager().getDuration(DurationManager.HOUR);
                Formatter formatter = new Formatter();
                if (d - (double)d.longValue() != 0.0) {
                    formatter.format("%.1f", d);
                } else {
                    formatter.format("%.0f", d);
                }
                object2 = formatter.toString() + DurationManager.HOUR;
            } else {
                Double d = (Double)object;
                Formatter formatter = new Formatter();
                if (d - (double)d.longValue() != 0.0) {
                    formatter.format("%.1f", d);
                } else {
                    formatter.format("%.0f", d);
                }
                if (object3 instanceof MaterialResource) {
                    MaterialResource materialResource = (MaterialResource)object3;
                    object2 = formatter.toString() + (materialResource.getMeasurementUnit() != null ? materialResource.getMeasurementUnit() : "");
                } else {
                    Assignment assignment = (Assignment)object3;
                    MaterialResource materialResource = (MaterialResource)assignment.getResource();
                    object2 = formatter.toString() + (materialResource.getMeasurementUnit() != null ? materialResource.getMeasurementUnit() : "");
                }
            }
            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }
    }
}

