/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.treetablechart;

import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.ui.component.CustomTableHeaderCellRenderer;
import com.sbs.jpm.ui.component.util.EnhancedScrollPaneLayout;
import com.sbs.jpm.ui.treetablechart.JChartArea;
import com.sbs.jpm.ui.treetablechart.JTimeScaleArea;
import com.sbs.jpm.ui.treetablechart.JTreeTable;
import com.sbs.jpm.ui.treetablechart.JTreeTableChart;
import com.sbs.jpm.ui.treetablechart.chart.ChartUIConfiguration;
import com.sbs.jpm.ui.treetablechart.chart.Painter;
import com.sbs.jpm.ui.treetablechart.chart.StyledPainterImpl;
import com.sbs.jpm.ui.treetablechart.time.TimeFrame;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleAdapter;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;

public abstract class JArea
extends JPanel {
    public static final int EXTRA_SPACE = 1600;
    protected JTreeTable treetable;
    protected JTreeTableChart treeTableChart;
    protected Task project;
    protected Painter painter;
    protected ChartUIConfiguration chartUIConfiguration;
    protected TimeScaleManager timeScaleManager;
    protected JTimeScaleArea timeScaleArea;
    protected JChartArea chartArea;
    private JScrollPane downScrollPane;
    private ScrollBarHandler scrollBarHandler;
    private TimeScaleHandler timeScaleHandler;
    private TaskHandler taskHandler;
    private boolean split;
    private boolean insertTask;

    public JArea(JTreeTableChart jTreeTableChart, JTreeTable jTreeTable) {
        this.treetable = jTreeTable;
        this.treeTableChart = jTreeTableChart;
        this.split = false;
        this.insertTask = false;
        this.scrollBarHandler = new ScrollBarHandler();
        this.timeScaleHandler = new TimeScaleHandler();
        this.taskHandler = new TaskHandler();
        Font font = this.getFont();
        this.chartUIConfiguration = new ChartUIConfiguration(font);
        this.painter = new StyledPainterImpl(this.chartUIConfiguration);
        this.timeScaleArea = new JTimeScaleArea(this);
        this.chartArea = this.createChartArea();
        this.timeScaleArea.setPainter(this.painter);
        this.chartArea.setPainter(this.painter);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.timeScaleArea);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.downScrollPane = new JScrollPane(this.chartArea);
        this.downScrollPane.setLayout(new EnhancedScrollPaneLayout());
        this.downScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.downScrollPane.setVerticalScrollBarPolicy(21);
        this.downScrollPane.getHorizontalScrollBar().addAdjustmentListener(this.scrollBarHandler);
        this.add((Component)jScrollPane, "North");
        this.add((Component)this.downScrollPane, "Center");
        this.timeScaleManager = this.createTimeScaleManager();
        this.timeScaleManager.addTimeScaleListener(this.timeScaleHandler);
        this.chartArea.setTimeScaleManager(this.timeScaleManager);
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean bl) {
        this.split = bl;
    }

    protected abstract TimeScaleManager createTimeScaleManager();

    protected abstract JChartArea createChartArea();

    public void setProject(Task task) {
        if (this.project != null) {
            this.project.removeTaskListener(this.taskHandler);
        }
        this.project = task;
        task.addTaskListener(this.taskHandler);
        this.timeScaleManager.setProject(task);
        this.getChartArea().scrollRectToVisible(new Rectangle(1550, this.getChartArea().getVisibleRect().y, 10, 10));
        this.timeScaleArea.setProject(task);
        this.chartArea.setProject(task);
        TableColumnModel tableColumnModel = this.treetable.getColumnModel();
        tableColumnModel.getColumn(0).setHeaderRenderer(new CustomTableHeaderCellRenderer(this.treetable.getTableHeader().getDefaultRenderer(), this.timeScaleManager));
    }

    public JTreeTable getTreetable() {
        return this.treetable;
    }

    public TimeScaleManager getTimeScaleManager() {
        return this.timeScaleManager;
    }

    public void setTreeTableManager(TreeTableManager treeTableManager) {
        this.chartArea.setTreeTableManager(treeTableManager);
        this.repaint();
    }

    public JTreeTableChart getTreeTableChart() {
        return this.treeTableChart;
    }

    public ChartUIConfiguration getChartUIConfiguration() {
        return this.chartUIConfiguration;
    }

    public JChartArea getChartArea() {
        return this.chartArea;
    }

    public JTimeScaleArea getTimeScaleArea() {
        return this.timeScaleArea;
    }

    public JScrollPane getDownScrollPane() {
        return this.downScrollPane;
    }

    public void setTimeScaleManager(TimeScaleManager timeScaleManager) {
        this.downScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.scrollBarHandler);
        this.timeScaleManager.removeTimeScaleListener(this.timeScaleHandler);
        this.timeScaleManager = timeScaleManager;
        this.timeScaleManager.addTimeScaleListener(this.timeScaleHandler);
        this.chartArea.setTimeScaleManager(timeScaleManager);
        this.downScrollPane.getHorizontalScrollBar().addAdjustmentListener(this.scrollBarHandler);
    }

    public TimeFrame getVisibleTimeFrame() {
        if (this.project != null) {
            Rectangle rectangle = this.chartArea.getVisibleRect();
            Date date = new Date(this.timeScaleManager.getMilis(rectangle.x));
            Date date2 = new Date(this.timeScaleManager.getMilis(rectangle.x + rectangle.width));
            return new TimeFrame(date, date2);
        }
        return new TimeFrame(new Date(), new Date());
    }

    public boolean isInsertTask() {
        return this.insertTask;
    }

    public void setInsertTask(boolean bl) {
        this.insertTask = bl;
    }

    private class TimeScaleHandler
    extends TimeScaleAdapter {
        private TimeScaleHandler() {
        }

        public void focusOnDateChanged(TimeScaleEvent timeScaleEvent) {
            TimeScaleManager timeScaleManager = (TimeScaleManager)timeScaleEvent.getSource();
            Date date = timeScaleEvent.getOldFocusDate();
            Date date2 = timeScaleManager.getFocusDate();
            int n = (int)timeScaleManager.convertMilisToPixels(date2.getTime() - date.getTime());
            Rectangle rectangle = JArea.this.getChartArea().getVisibleRect();
            JArea.this.getChartArea().scrollRectToVisible(new Rectangle(rectangle.x + n, rectangle.y, rectangle.width, rectangle.height));
        }

        public void focusDateChanged(TimeScaleEvent timeScaleEvent) {
            JArea.this.timeScaleArea.repaint();
        }

        public void shiftChanged(TimeScaleEvent timeScaleEvent) {
            JChartArea jChartArea = JArea.this.getChartArea();
            Rectangle rectangle = jChartArea.getVisibleRect();
            jChartArea.scrollRectToVisible(new Rectangle(rectangle.x + timeScaleEvent.getShift(), rectangle.y, rectangle.width, rectangle.height));
        }

        public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
            JArea.this.timeScaleArea.revalidate();
            JArea.this.chartArea.revalidate();
        }

        public void zoomInChanged(TimeScaleEvent timeScaleEvent) {
            double d = JArea.this.timeScaleManager.getX(JArea.this.timeScaleManager.getFocusDate().getTime());
            Rectangle rectangle = JArea.this.chartArea.getVisibleRect();
            JArea.this.chartArea.scrollRectToVisible(new Rectangle((int)(d -= JArea.this.timeScaleArea.getTimeScaleManager().getFocusPointPercent() / 100.0 * (double)rectangle.width), rectangle.y, rectangle.width, rectangle.height));
        }

        public void zoomOutWillChange(TimeScaleEvent timeScaleEvent) {
            double d = JArea.this.timeScaleManager.getX(JArea.this.timeScaleManager.getFocusDate().getTime());
            Rectangle rectangle = JArea.this.chartArea.getVisibleRect();
            JArea.this.downScrollPane.getHorizontalScrollBar().setValue((int)(d -= JArea.this.timeScaleArea.getTimeScaleManager().getFocusPointPercent() / 100.0 * (double)rectangle.width));
        }

        public void zoomOutChanged(TimeScaleEvent timeScaleEvent) {
            Rectangle rectangle = JArea.this.chartArea.getVisibleRect();
            JArea.this.chartArea.scrollRectToVisible(rectangle);
        }
    }

    private class ScrollBarHandler
    implements AdjustmentListener {
        private ScrollBarHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Rectangle rectangle;
            if (JArea.this.project != null && !JArea.this.timeScaleManager.isAdjusting()) {
                rectangle = JArea.this.chartArea.getVisibleRect();
                if (rectangle.width != 0) {
                    Date date = new Date((long)((double)JArea.this.timeScaleManager.getProjectTimeFrame().getStartDate().getTime() + ((double)rectangle.x + JArea.this.timeScaleArea.getTimeScaleManager().getFocusPointPercent() / 100.0 * (double)rectangle.width) * JArea.this.timeScaleManager.getPixelDuration()));
                    JArea.this.timeScaleManager.setFocusDate(date);
                }
            }
            JArea.this.timeScaleArea.scrollRectToVisible(new Rectangle(JArea.this.chartArea.getVisibleRect().x, JArea.this.timeScaleArea.getVisibleRect().y, JArea.this.timeScaleArea.getVisibleRect().width, JArea.this.timeScaleArea.getVisibleRect().height));
            rectangle = new Rectangle(JArea.this.chartArea.getVisibleRect().x, 0, JArea.this.timeScaleArea.getVisibleRect().width, JArea.this.timeScaleArea.getVisibleRect().height);
            if (JArea.this.timeScaleArea.getGraphics() != null) {
                JArea.this.timeScaleArea.getGraphics().setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                JArea.this.timeScaleArea.repaint(rectangle);
            }
        }
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void assignmentAdded(TaskEvent taskEvent) {
            JArea.this.chartArea.revalidate();
            JArea.this.timeScaleArea.revalidate();
        }

        public void assignmentRemoved(TaskEvent taskEvent) {
            JArea.this.chartArea.revalidate();
            JArea.this.timeScaleArea.revalidate();
        }

        public void childAdded(TaskEvent taskEvent) {
            JArea.this.chartArea.revalidate();
            JArea.this.timeScaleArea.revalidate();
        }

        public void childRemoved(TaskEvent taskEvent) {
            JArea.this.chartArea.revalidate();
            JArea.this.timeScaleArea.revalidate();
        }

        public void childWillRemove(TaskEvent taskEvent) {
            JArea.this.chartArea.revalidate();
            JArea.this.timeScaleArea.revalidate();
        }

        public void dataChanged(TaskEvent taskEvent) {
            JArea.this.chartArea.revalidate();
            JArea.this.timeScaleArea.revalidate();
        }

        public void forcedWorkingChanged(TaskEvent taskEvent) {
            JArea.this.revalidate();
        }

        public void predecessorAdded(TaskEvent taskEvent) {
            JArea.this.revalidate();
        }

        public void predecessorRemoved(TaskEvent taskEvent) {
            JArea.this.revalidate();
        }

        public void successorAdded(TaskEvent taskEvent) {
            JArea.this.revalidate();
        }

        public void successorRemoved(TaskEvent taskEvent) {
            JArea.this.revalidate();
        }
    }
}

