/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.CustomFlavor;
import com.sbs.jpm.ui.action.TaskSelection;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.WBSTaskDetailView;
import com.sbs.jpm.ui.component.view.ViewCommon;
import com.sbs.jpm.ui.treetablechart.JWBSTreeTable;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.ui.treetablechart.model.TaskTreeTableModel;
import com.sbs.jpm.undo.DeleteEmptyTasksEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskDownEdit;
import com.sbs.jpm.undo.TaskIndentEdit;
import com.sbs.jpm.undo.TaskInsertEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.TaskNonEmptyEdit;
import com.sbs.jpm.undo.TaskOutdentEdit;
import com.sbs.jpm.undo.TaskPasteEdit;
import com.sbs.jpm.undo.TaskPasteSerializableEdit;
import com.sbs.jpm.undo.TaskUpEdit;
import com.sbs.util.ExcelAdapter;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class JProjectViewWBS
extends JProjectView
implements CustomPageable {
    private static final long serialVersionUID = 1L;
    private JWBSTreeTable wbs;
    private WBSTaskDetailView taskView;
    private JRowHeader rowHeader;
    private JToggleButton infoButton;
    private JCheckBoxMenuItem infoItem;
    private Action insertAction;
    private Action insertSubtaskAction;
    private Action deleteAction;
    private Action indentAction;
    private Action outdentAction;
    private Action upAction;
    private Action downAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action newTaskAction;
    private Action detailsAction;
    private JPopupMenu popupMenu;
    private JSplitPane splitPane;

    private JPanel createContentsWBS() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.wbs = new JWBSTreeTable();
        this.wbs.setProjectView(this);
        this.wbs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JProjectViewWBS.this.wbs.grabFocus();
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JProjectViewWBS.this.updateToolbar();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.wbs));
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.getViewport().setBackground(this.wbs.getBackground());
        this.rowHeader = new JRowHeader((JTable)((Object)this.wbs));
        jScrollPane.setRowHeaderView(this.rowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 9, 0));
        return jPanel;
    }

    private JPanel createContentsTask() {
        this.taskView = new WBSTaskDetailView();
        this.taskView.setVisible(false);
        return this.taskView;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.popupMenu = new JPopupMenu();
        this.splitPane = new JSplitPane(0, this.createContentsWBS(), this.createContentsTask());
        this.splitPane.setResizeWeight(0.7);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        jPanel.add((Component)this.splitPane, "Center");
        this.taskView.setTask(null);
        return jPanel;
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.wbs.setProject(task);
        this.rowHeader.setTableModel(this.wbs.getModel());
        this.wbs.expandAll();
    }

    protected void createToolBar() {
        super.createToolBar();
        this.setPopup();
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.insertAction.setEnabled(false);
        this.insertSubtaskAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.indentAction.setEnabled(false);
        this.outdentAction.setEnabled(false);
        this.upAction.setEnabled(false);
        this.downAction.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        JButton jButton = new JButton(this.insertAction);
        jButton.setFocusable(false);
        this.toolBar.add(jButton);
        JButton jButton2 = new JButton(this.insertSubtaskAction);
        jButton2.setFocusable(false);
        this.toolBar.add(jButton2);
        JButton jButton3 = new JButton(this.deleteAction);
        jButton3.setFocusable(false);
        this.toolBar.addSeparator();
        JButton jButton4 = new JButton(this.indentAction);
        jButton4.setFocusable(false);
        this.toolBar.add(jButton4);
        JButton jButton5 = new JButton(this.outdentAction);
        jButton5.setFocusable(false);
        this.toolBar.add(jButton5);
        JButton jButton6 = new JButton(this.upAction);
        jButton6.setFocusable(false);
        this.toolBar.add(jButton6);
        JButton jButton7 = new JButton(this.downAction);
        jButton7.setFocusable(false);
        this.toolBar.add(jButton7);
        jButton = new JButton(this.expandAllAction);
        jButton.setFocusable(false);
        this.toolBar.add(jButton);
        jButton2 = new JButton(this.collapseAllAction);
        jButton2.setFocusable(false);
        this.toolBar.add(jButton2);
        jButton3 = new JButton(this.cutAction);
        jButton3.setFocusable(false);
        jButton4 = new JButton(this.copyAction);
        jButton4.setFocusable(false);
        jButton5 = new JButton(this.pasteAction);
        jButton5.setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.infoButton);
    }

    private void insertTask(Task task, Task task2, int n, CompoundEdit compoundEdit) {
        LinkedList<Dependency> linkedList;
        Task[] taskArray = task2.getChildList().toArray(new Task[0]);
        int n2 = taskArray.length;
        for (int i = 0; i < n2; ++i) {
            linkedList = taskArray[i];
            this.insertTask(task2, (Task)((Object)linkedList), i, compoundEdit);
        }
        LinkedList<Dependency> linkedList2 = new LinkedList<Dependency>();
        linkedList = task2.getPredecessorDependencies().iterator();
        while (linkedList.hasNext()) {
            linkedList2.add((Dependency)linkedList.next());
        }
        linkedList = new LinkedList<Dependency>();
        Object object = task2.getSuccessorDependencies().iterator();
        while (object.hasNext()) {
            linkedList.add(object.next());
        }
        object = new LinkedList();
        Object object2 = task2.getAssignments().iterator();
        while (object2.hasNext()) {
            object.add(object2.next());
        }
        object2 = new TaskPasteEdit(task, task2, n, linkedList2, linkedList, (List<Assignment>)object, "02-10-2009 : 12:31:01");
        compoundEdit.addEdit((UndoableEdit)object2);
        TaskPlanner.rescheduleTree(task);
    }

    private void setPopup() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke3 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(39, 256) : KeyStroke.getKeyStroke(39, 128);
        KeyStroke keyStroke4 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(37, 256) : KeyStroke.getKeyStroke(37, 128);
        KeyStroke keyStroke5 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(38, 256) : KeyStroke.getKeyStroke(38, 128);
        KeyStroke keyStroke6 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(40, 256) : KeyStroke.getKeyStroke(40, 128);
        KeyStroke keyStroke7 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(107, 256) : KeyStroke.getKeyStroke(107, 128);
        KeyStroke keyStroke8 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(109, 256) : KeyStroke.getKeyStroke(109, 128);
        KeyStroke keyStroke9 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(88, 256) : KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke10 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke11 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 128);
        KeyStroke keyStroke12 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.insertAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertLine.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        TreePath treePath = treeSelectionModel.getSelectionPath();
                        Task task = (Task)treePath.getLastPathComponent();
                        if (task.getParent() != null) {
                            Task task2 = task.getParent();
                            int n = task2.getChildIndex(task);
                            final int n2 = JProjectViewWBS.this.wbs.getRowForPath(treePath);
                            Company company = task2.getCompany();
                            Task task3 = new Task(company.getIdGenerator().getNewId());
                            task2.addChild(n, task3);
                            ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                            TaskInsertEdit taskInsertEdit = new TaskInsertEdit(task2, task3, n, "02-10-2009 12:44:06");
                            extendedCompoundEdit.addEdit(taskInsertEdit);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JProjectViewWBS.this.wbs.setRowSelectionInterval(n2, n2);
                                }
                            });
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("insertLine") : Common.I18N_ACTIONS.getString("insertLine") + " (Insert)";
        this.insertAction.putValue("ShortDescription", string);
        this.insertAction.putValue("AcceleratorKey", keyStroke);
        this.newTaskAction = new AbstractAction(Common.I18N_ACTIONS.getString("task.new"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Task task;
                        TreePath treePath = treeSelectionModel.getSelectionPath();
                        Task task2 = (Task)treePath.getLastPathComponent();
                        if (task2.getParent() != null) {
                            Task task3 = task2.getParent();
                            int n = task3.getChildIndex(task2);
                            final int n2 = JProjectViewWBS.this.wbs.getRowForPath(treePath);
                            Company company = task3.getCompany();
                            task = new Task(company.getIdGenerator().getNewId());
                            task3.addChild(n, task);
                            task.setName(Common.I18N_ACTIONS.getString("task.new"));
                            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                            TaskInsertEdit taskInsertEdit = new TaskInsertEdit(task3, task, n, "02-10-2009 12:44:07");
                            TaskNameEdit taskNameEdit = new TaskNameEdit(task, "", task.getName(), "02-10-2009 12:41:07");
                            extendedCompoundEdit.addEdit(taskInsertEdit);
                            extendedCompoundEdit.addEdit(taskNameEdit);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JProjectViewWBS.this.wbs.setRowSelectionInterval(n2, n2);
                                }
                            });
                        } else {
                            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                            task = ((ChartTreeTableModel)JProjectViewWBS.this.wbs.getTreeTableModel()).insertEmptyTasks(task2, extendedCompoundEdit, true);
                            TaskNameEdit taskNameEdit = new TaskNameEdit(task, task.getName(), Common.I18N_ACTIONS.getString("task.new"), "02-10-2009 12:41:08");
                            task.setName(Common.I18N_ACTIONS.getString("task.new"));
                            TaskNonEmptyEdit taskNonEmptyEdit = new TaskNonEmptyEdit(task, "02-10-2009 : 12:40:06");
                            extendedCompoundEdit.addEdit(taskNonEmptyEdit);
                            extendedCompoundEdit.addEdit(taskNameEdit);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                        }
                        task.setDirty(true, true);
                        TaskPlanner.rescheduleTree(task);
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        this.newTaskAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.new"));
        this.insertSubtaskAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertSubtask.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                    TreePath treePath = treeSelectionModel.getSelectionPath();
                    Task task = (Task)treePath.getLastPathComponent();
                    if (!task.isEmpty()) {
                        Serializable serializable;
                        JProjectView.BLOCK_UPDATE = true;
                        try {
                            Company company = task.getCompany();
                            Task task2 = new Task(company.getIdGenerator().getNewId());
                            JProjectViewWBS.this.insertTask(task, task2, task.getChildNumber(), extendedCompoundEdit);
                            task.addChild(task.getChildNumber(), task2);
                            task2.setName(Common.I18N_ACTIONS.getString("subtask"));
                            task.setDirty(true, false);
                            TaskPlanner.rescheduleTree(task);
                            extendedCompoundEdit.end();
                            serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewWBS.this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                            JProjectViewWBS.this.wbs.expandPath(new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                            JProjectViewWBS.this.wbs.getTreeSelectionModel().setSelectionPath(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                        }
                        finally {
                            JProjectView.BLOCK_UPDATE = false;
                            JProjectViewWBS.this.updateToolbar();
                        }
                        int n = JProjectViewWBS.this.wbs.getRowForPath(treeSelectionModel.getSelectionPath());
                        int n2 = JProjectViewWBS.this.wbs.convertColumnIndexToView(JProjectViewWBS.this.wbs.getColumn(TaskTreeTableModel.TASK_NAME).getModelIndex());
                        JProjectViewWBS.this.wbs.editCellAt(n, n2);
                        serializable = (JTextComponent)JProjectViewWBS.this.wbs.getEditorComponent();
                        ((JComponent)serializable).grabFocus();
                        ((JTextComponent)serializable).selectAll();
                    }
                }
            }
        };
        this.insertSubtaskAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("subtask.insert"));
        this.deleteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
                    final int n = treePathArray.length;
                    final int n2 = JProjectViewWBS.this.wbs.getRowForPath(treePathArray[n - 1]);
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                        for (int i = 0; i < treePathArray.length; ++i) {
                            int n3;
                            Task task = (Task)treePathArray[i].getLastPathComponent();
                            if (task.getParent() == null || (n3 = JProjectViewWBS.this.wbs.getRowForPath(treePathArray[i])) < 0 || n3 >= JProjectViewWBS.this.wbs.getRowCount() - 1) continue;
                            boolean bl = false;
                            if (task.getParent().equals((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot())) {
                                bl = true;
                            }
                            ViewCommon.deleteTask(task, extendedCompoundEdit);
                            if (!bl) continue;
                            List<Task> list = task.getParent().removeEmptyTasks();
                            DeleteEmptyTasksEdit deleteEmptyTasksEdit = new DeleteEmptyTasksEdit(task.getParent(), list, "15-09-09 12:37:04");
                            extendedCompoundEdit.addEdit(deleteEmptyTasksEdit);
                        }
                        TaskPlanner.rescheduleTree(JProjectViewWBS.this.project);
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int n3 = n2 - n + 1;
                                if (n2 == JProjectViewWBS.this.wbs.getRowCount() - 1) {
                                    --n3;
                                }
                                JProjectViewWBS.this.wbs.setRowSelectionInterval(n3, n3);
                            }
                        });
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        this.deleteAction.putValue("AcceleratorKey", keyStroke2);
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.delete") + " (Delete)");
        this.indentAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/indent.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                    for (int i = 0; i < nArray.length; ++i) {
                        linkedList.add((Task)JProjectViewWBS.this.wbs.getPathForRow(nArray[i]).getLastPathComponent());
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        Task task2 = taskArray[i];
                        if (!task2.isDescendent(linkedList)) continue;
                        linkedList.remove(task2);
                    }
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Serializable serializable;
                        Task task;
                        block7: for (Task task2 : linkedList) {
                            task = task2.getParent();
                            if (task == null) continue;
                            serializable = null;
                            for (int i = 0; i < task.getChildNumber(); ++i) {
                                Task task3 = task.getChildAt(i);
                                if (!task3.isEmpty() && !task3.equals(task2)) {
                                    serializable = task3;
                                    continue;
                                }
                                if (task3.isEmpty() || serializable == null) continue;
                                boolean bl = JProjectViewWBS.this.wbs.isExpanded(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                TaskIndentEdit taskIndentEdit = new TaskIndentEdit((Task)serializable, task2, "02-10-2009 12:48:02");
                                try {
                                    task2.indent((Task)serializable);
                                }
                                catch (CircularRelationshipException circularRelationshipException) {
                                    Common.logException("Error:", circularRelationshipException);
                                    JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                                    break block7;
                                }
                                JProjectViewWBS.this.wbs.expandPath(new TreePath(((Task)serializable).getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                if (bl) {
                                    JProjectViewWBS.this.wbs.expandPath(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                } else {
                                    JProjectViewWBS.this.wbs.collapsePath(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                }
                                extendedCompoundEdit.addEdit(taskIndentEdit);
                                continue block7;
                            }
                        }
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree(JProjectViewWBS.this.project);
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            task = taskArray[i];
                            serializable = new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray());
                            JProjectViewWBS.this.wbs.getTreeSelectionModel().addSelectionPath((TreePath)serializable);
                            JProjectViewWBS.this.wbs.scrollPathToVisible((TreePath)serializable);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.indent") + " (Cmmd-Right)" : Common.I18N_ACTIONS.getString("task.indent") + " (Ctrl-Right)";
        this.indentAction.putValue("ShortDescription", string);
        this.indentAction.putValue("AcceleratorKey", keyStroke3);
        this.outdentAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/outdent.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Task task;
                        int n;
                        int[] nArray = treeSelectionModel.getSelectionRows();
                        Arrays.sort(nArray);
                        LinkedList<Integer> linkedList = new LinkedList<Integer>();
                        for (int i = 0; i < nArray.length; ++i) {
                            linkedList.add(nArray[i]);
                        }
                        Collections.reverse(linkedList);
                        LinkedList<Task> linkedList2 = new LinkedList<Task>();
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                        Task[] taskArray = linkedList.iterator();
                        while (taskArray.hasNext()) {
                            n = (Integer)taskArray.next();
                            linkedList2.add((Task)JProjectViewWBS.this.wbs.getPathForRow(n).getLastPathComponent());
                        }
                        taskArray = linkedList2.toArray(new Task[0]);
                        for (n = 0; n < taskArray.length; ++n) {
                            Task task2 = taskArray[n];
                            if (!task2.isDescendent(linkedList2)) continue;
                            linkedList2.remove(task2);
                        }
                        for (Task task2 : linkedList2) {
                            task = task2.getParent();
                            boolean bl = task2.isLeaf() ? true : JProjectViewWBS.this.wbs.isExpanded(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                            int n2 = task.getChildIndex(task2);
                            Task[] taskArray2 = task.getChildList().toArray(new Task[0]);
                            int n3 = taskArray2.length;
                            TaskOutdentEdit taskOutdentEdit = new TaskOutdentEdit(task, task2, "02-10-2009 : 12:33:01");
                            ExtendedCompoundEdit extendedCompoundEdit2 = new ExtendedCompoundEdit();
                            int n4 = n2 + 1;
                            try {
                                for (n4 = n2 + 1; n4 < n3; ++n4) {
                                    Task task3 = taskArray2[n4];
                                    TaskIndentEdit taskIndentEdit = new TaskIndentEdit(task2, task3, "02-10-2009 12:48:03");
                                    task3.indent(task2);
                                    extendedCompoundEdit2.addEdit(taskIndentEdit);
                                }
                                task2.outdent();
                                extendedCompoundEdit2.addEdit(taskOutdentEdit);
                                extendedCompoundEdit2.end();
                                if (bl) {
                                    JProjectViewWBS.this.wbs.expandPath(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                } else {
                                    JProjectViewWBS.this.wbs.collapsePath(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                }
                                extendedCompoundEdit.addEdit(extendedCompoundEdit2);
                            }
                            catch (CircularRelationshipException circularRelationshipException) {
                                Common.logException("Error:", circularRelationshipException);
                                JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                                for (int i = n4 - 1; i > n2; --i) {
                                    Task task4 = taskArray2[i];
                                    task4.outdent();
                                }
                                JProjectView.BLOCK_UPDATE = false;
                                JProjectViewWBS.this.updateToolbar();
                                return;
                            }
                        }
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree(JProjectViewWBS.this.project);
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            task = taskArray[i];
                            TreePath treePath = new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray());
                            JProjectViewWBS.this.wbs.getTreeSelectionModel().addSelectionPath(treePath);
                            JProjectViewWBS.this.wbs.scrollPathToVisible(treePath);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.outdent") + " (Cmmd-Left)" : Common.I18N_ACTIONS.getString("task.outdent") + " (Ctrl-Left)";
        this.outdentAction.putValue("ShortDescription", string);
        this.outdentAction.putValue("AcceleratorKey", keyStroke4);
        this.upAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/up.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Serializable serializable;
                        LinkedList<Task> linkedList = new LinkedList<Task>();
                        ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                        for (int i = 0; i < treePathArray.length; ++i) {
                            linkedList.add((Task)treePathArray[i].getLastPathComponent());
                        }
                        Task[] taskArray = linkedList.toArray(new Task[0]);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task = taskArray[i];
                            if (!task.isDescendent(linkedList)) continue;
                            linkedList.remove(task);
                        }
                        for (Task task : linkedList) {
                            boolean bl = JProjectViewWBS.this.wbs.isExpanded(new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                            serializable = new TaskUpEdit(task, "01-10-2009 17:25:02");
                            task.moveUp();
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                            if (bl) {
                                JProjectViewWBS.this.wbs.expandPath(new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                continue;
                            }
                            JProjectViewWBS.this.wbs.collapsePath(new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                        }
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task = taskArray[i];
                            serializable = new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray());
                            JProjectViewWBS.this.wbs.getTreeSelectionModel().addSelectionPath((TreePath)serializable);
                            JProjectViewWBS.this.wbs.scrollPathToVisible((TreePath)serializable);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.up") + " (Cmmd-Up)" : Common.I18N_ACTIONS.getString("task.up") + " (Ctrl-Up)";
        this.upAction.putValue("ShortDescription", string);
        this.upAction.putValue("AcceleratorKey", keyStroke5);
        this.downAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/down.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Serializable serializable;
                        Task task;
                        int n;
                        LinkedList<Task> linkedList = new LinkedList<Task>();
                        ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                        for (int i = 0; i < treePathArray.length; ++i) {
                            linkedList.add((Task)treePathArray[i].getLastPathComponent());
                        }
                        Task[] taskArray = linkedList.toArray(new Task[0]);
                        for (n = 0; n < taskArray.length; ++n) {
                            task = taskArray[n];
                            if (!task.isDescendent(linkedList)) continue;
                            linkedList.remove(task);
                        }
                        taskArray = linkedList.toArray(new Task[0]);
                        for (n = taskArray.length - 1; n >= 0; --n) {
                            task = taskArray[n];
                            boolean bl = JProjectViewWBS.this.wbs.isExpanded(new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                            serializable = new TaskDownEdit(task, "02-10-2009 13:29:02");
                            task.moveDown();
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                            if (bl) {
                                JProjectViewWBS.this.wbs.expandPath(new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                continue;
                            }
                            JProjectViewWBS.this.wbs.collapsePath(new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                        }
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task2 = taskArray[i];
                            serializable = new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray());
                            JProjectViewWBS.this.wbs.getTreeSelectionModel().addSelectionPath((TreePath)serializable);
                            JProjectViewWBS.this.wbs.scrollPathToVisible((TreePath)serializable);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.down") + " (Cmmd-Down)" : Common.I18N_ACTIONS.getString("task.down") + " (Ctrl-Down)";
        this.downAction.putValue("ShortDescription", string);
        this.downAction.putValue("AcceleratorKey", keyStroke6);
        this.cutAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    Object object;
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                    for (int i = 0; i < nArray.length; ++i) {
                        Task task = (Task)JProjectViewWBS.this.wbs.getPathForRow(nArray[i]).getLastPathComponent();
                        if (task.isEmpty()) continue;
                        linkedList.add(task);
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        object = taskArray[i];
                        if (!((Task)object).isDescendent(linkedList)) continue;
                        linkedList.remove(object);
                    }
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Object object2;
                        List<Task> list = Task.cloneTasks(linkedList, JProjectViewWBS.this.project.getCompany().getIdGenerator(), false);
                        object = new TaskSelection(list, ExcelAdapter.tasksToString(JProjectViewWBS.this.wbs));
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                        for (Task task : linkedList) {
                            boolean bl = false;
                            if (task.getParent().equals((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot())) {
                                bl = true;
                            }
                            ViewCommon.deleteTask(task, extendedCompoundEdit);
                            if (!bl) continue;
                            object2 = task.getParent().removeEmptyTasks();
                            DeleteEmptyTasksEdit deleteEmptyTasksEdit = new DeleteEmptyTasksEdit(task.getParent(), (List<Task>)object2, "15-09-09 12:37:05");
                            extendedCompoundEdit.addEdit(deleteEmptyTasksEdit);
                        }
                        TaskPlanner.rescheduleTree(JProjectViewWBS.this.project);
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewWBS.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task = taskArray[i];
                            object2 = new TreePath(task.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray());
                            JProjectViewWBS.this.wbs.getTreeSelectionModel().addSelectionPath((TreePath)object2);
                            JProjectViewWBS.this.wbs.scrollPathToVisible((TreePath)object2);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewWBS.this.updateToolbar();
                    }
                }
            }
        };
        this.cutAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("cut"));
        this.cutAction.putValue("AcceleratorKey", keyStroke9);
        this.copyAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewWBS.this.wbs.getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    Object object;
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    for (int i = 0; i < nArray.length; ++i) {
                        Task task = (Task)JProjectViewWBS.this.wbs.getPathForRow(nArray[i]).getLastPathComponent();
                        if (task.isEmpty()) continue;
                        linkedList.add(task);
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        object = taskArray[i];
                        if (!((Task)object).isDescendent(linkedList)) continue;
                        linkedList.remove(object);
                    }
                    List<Task> list = Task.cloneTasks(linkedList, JProjectViewWBS.this.project.getCompany().getIdGenerator(), false);
                    object = new TaskSelection(list, ExcelAdapter.tasksToString(JProjectViewWBS.this.wbs));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                }
            }
        };
        this.copyAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("copy"));
        this.copyAction.putValue("AcceleratorKey", keyStroke10);
        this.pasteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                block22: {
                    if (JProjectViewWBS.this.wbs.getSelectedRowCount() != 0) {
                        JProjectView.BLOCK_UPDATE = true;
                        try {
                            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                            try {
                                if (transferable == null) break block22;
                                if (transferable.isDataFlavorSupported(CustomFlavor.taskListFlavor)) {
                                    Object object;
                                    int n;
                                    Task task;
                                    List list = (List)transferable.getTransferData(CustomFlavor.taskListFlavor);
                                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewWBS.this.project);
                                    int n2 = JProjectViewWBS.this.wbs.getSelectedRow();
                                    if (n2 == 0 && JProjectViewWBS.this.project.getChildNumber() == 0) {
                                        task = JProjectViewWBS.this.project;
                                        n = 0;
                                    } else {
                                        object = (Task)JProjectViewWBS.this.wbs.getPathForRow(n2).getLastPathComponent();
                                        object = ((ChartTreeTableModel)JProjectViewWBS.this.wbs.getTreeTableModel()).insertEmptyTasks((Task)object, extendedCompoundEdit, false);
                                        task = ((Task)object).getParent();
                                        n = task.getChildIndex((Task)object) + 1;
                                    }
                                    object = Task.cloneTasks(list, JProjectViewWBS.this.project.getCompany().getIdGenerator(), true);
                                    List<Task> list2 = Task.cloneTasks((List<Task>)object, JProjectViewWBS.this.project.getCompany().getIdGenerator(), false);
                                    int n3 = 0;
                                    Object object2 = object.iterator();
                                    while (object2.hasNext()) {
                                        Task task2 = (Task)object2.next();
                                        task2.updateClonedAssignments(JProjectViewWBS.this.project.getCompany());
                                        JProjectViewWBS.this.insertTask(task, task2, n, extendedCompoundEdit);
                                        task.addChild(n, task2);
                                        task2.addClonnedAssignments(false);
                                        extendedCompoundEdit.addEdit(new TaskPasteSerializableEdit(task, list2.get(n3++), n));
                                        ++n;
                                        JProjectViewWBS.this.wbs.expandPath(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                        JProjectViewWBS.this.wbs.getTreeSelectionModel().setSelectionPath(new TreePath(task2.getPath((Task)JProjectViewWBS.this.wbs.getTreeTableModel().getRoot()).toArray()));
                                    }
                                    task.setDirty(true, false);
                                    TaskPlanner.rescheduleTree(JProjectViewWBS.this.project.getCompany().getRootTask());
                                    extendedCompoundEdit.end();
                                    object2 = new UndoableEditEvent(this, extendedCompoundEdit);
                                    JProjectViewWBS.this.fireUndoableEditHappened((UndoableEditEvent)object2);
                                    break block22;
                                }
                                if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block22;
                                int n = JProjectViewWBS.this.wbs.getSelectedRows()[0];
                                int n4 = JProjectViewWBS.this.wbs.getSelectedColumns()[0];
                                try {
                                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                                    int n5 = 0;
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String string2 = stringTokenizer.nextToken();
                                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
                                        int n6 = 0;
                                        while (stringTokenizer2.hasMoreTokens()) {
                                            String string3 = stringTokenizer2.nextToken();
                                            if (n + n5 < JProjectViewWBS.this.wbs.getRowCount() && n4 + n6 < JProjectViewWBS.this.wbs.getColumnCount()) {
                                                Serializable serializable;
                                                Class clazz = JProjectViewWBS.this.wbs.getColumnClass(n4 + n6);
                                                if (clazz.equals(Date.class)) {
                                                    serializable = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
                                                    Date date = serializable.parse(string3);
                                                    JProjectViewWBS.this.wbs.setValueAt(date, n + n5, n4 + n6);
                                                } else if (clazz.equals(Double.class)) {
                                                    serializable = Double.valueOf(Double.parseDouble(string3));
                                                    JProjectViewWBS.this.wbs.setValueAt(serializable, n + n5, n4 + n6);
                                                } else if (clazz.equals(Long.class)) {
                                                    serializable = Long.valueOf(Long.parseLong(string3));
                                                    JProjectViewWBS.this.wbs.setValueAt(serializable, n + n5, n4 + n6);
                                                } else {
                                                    JProjectViewWBS.this.wbs.setValueAt(string3, n + n5, n4 + n6);
                                                }
                                            }
                                            ++n6;
                                        }
                                        ++n5;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Common.logException("Error:", exception);
                                }
                            }
                            catch (UnsupportedFlavorException unsupportedFlavorException) {
                                unsupportedFlavorException.printStackTrace();
                                Common.logException("Error:", unsupportedFlavorException);
                            }
                            catch (IOException iOException) {
                                Common.logException("Error:", iOException);
                                iOException.printStackTrace();
                            }
                        }
                        finally {
                            JProjectView.BLOCK_UPDATE = false;
                            JProjectViewWBS.this.updateToolbar();
                        }
                    }
                }
            }
        };
        this.pasteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("paste"));
        this.pasteAction.putValue("AcceleratorKey", keyStroke11);
        this.expandAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/expand.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewWBS.this.wbs.expandAll();
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("expandAll") + " (Cmmd-+)" : Common.I18N_ACTIONS.getString("expandAll") + " (Ctrl-+)";
        this.expandAllAction.putValue("ShortDescription", string);
        this.expandAllAction.putValue("AcceleratorKey", keyStroke7);
        this.collapseAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/collapse.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewWBS.this.wbs.collapseAll();
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("collapseAll") + " (Cmmd--)" : Common.I18N_ACTIONS.getString("collapseAll") + " (Ctrl--)";
        this.collapseAllAction.putValue("ShortDescription", string);
        this.collapseAllAction.putValue("AcceleratorKey", keyStroke8);
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewWBS.this.taskView.isVisible()) {
                    JProjectViewWBS.this.taskView.setVisible(true);
                    JProjectViewWBS.this.infoButton.setSelected(true);
                    JProjectViewWBS.this.infoItem.setSelected(true);
                    JProjectViewWBS.this.splitPane.setDividerLocation(-1);
                    JProjectViewWBS.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewWBS.this.taskView.setVisible(false);
                    JProjectViewWBS.this.infoButton.setSelected(false);
                    JProjectViewWBS.this.infoItem.setSelected(false);
                    JProjectViewWBS.this.splitPane.setDividerSize(0);
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.detailsAction.putValue("AcceleratorKey", keyStroke12);
        ActionMap actionMap = this.wbs.getActionMap();
        actionMap.put("insert", this.insertAction);
        actionMap.put("delete", this.deleteAction);
        actionMap.put("indent", this.indentAction);
        actionMap.put("outdent", this.outdentAction);
        actionMap.put("up", this.upAction);
        actionMap.put("down", this.downAction);
        actionMap.put("cut", this.cutAction);
        actionMap.put("copy", this.copyAction);
        actionMap.put("paste", this.pasteAction);
        actionMap.put("expandAll", this.expandAllAction);
        actionMap.put("collapseAll", this.collapseAllAction);
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.wbs.getInputMap(1);
        inputMap.put(keyStroke, "insert");
        inputMap.put(keyStroke2, "delete");
        inputMap.put(keyStroke3, "indent");
        inputMap.put(keyStroke4, "outdent");
        inputMap.put(keyStroke5, "up");
        inputMap.put(keyStroke6, "down");
        inputMap.put(keyStroke9, "cut");
        inputMap.put(keyStroke10, "copy");
        inputMap.put(keyStroke11, "paste");
        inputMap.put(keyStroke7, "expandAll");
        inputMap.put(keyStroke8, "collapseAll");
        inputMap.put(keyStroke12, "details");
        JMenuItem jMenuItem = new JMenuItem(this.insertAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("insertLine"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.insertSubtaskAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("subtask.insert"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.newTaskAction);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.delete"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.indentAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.indent"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.outdentAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.outdent"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.upAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.up"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.downAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.down"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.cutAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("cut"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.copyAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("copy"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.pasteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("paste"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.task"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.tooltip"));
        this.infoItem.setAccelerator(keyStroke12);
        this.infoItem.setSelected(false);
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewWBS.this.infoButton.doClick();
            }
        });
        this.popupMenu.add(this.infoItem);
        this.wbs.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = JProjectViewWBS.this.wbs.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath[] treePathArray = JProjectViewWBS.this.wbs.getTreeSelectionModel().getSelectionPaths();
                    boolean bl = false;
                    if (treePathArray != null) {
                        for (int i = 0; i < treePathArray.length; ++i) {
                            TreePath treePath2 = treePathArray[i];
                            if (!treePath2.equals(treePath)) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JProjectViewWBS.this.wbs.getTreeSelectionModel().setSelectionPath(treePath);
                    }
                    JProjectViewWBS.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.taskView.isVisible());
        this.infoItem.setSelected(this.taskView.isVisible());
    }

    protected void updateDetailsAndToolbar() {
        this.taskView.setTask(null);
        int n = this.wbs.getSelectedRowCount();
        int[] nArray = this.wbs.getSelectedRows();
        if (n != 0) {
            Task task3;
            Object object;
            int n2;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            boolean bl6 = false;
            boolean bl7 = false;
            Arrays.sort(nArray);
            LinkedList<Task> linkedList = new LinkedList<Task>();
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add((Task)this.wbs.getPathForRow(nArray[i]).getLastPathComponent());
            }
            Task[] taskArray = linkedList.toArray(new Task[0]);
            for (n2 = 0; n2 < taskArray.length; ++n2) {
                object = taskArray[n2];
                if (!((Task)object).isEmpty()) {
                    bl6 = true;
                    bl7 = true;
                }
                if (!((Task)object).isDescendent(linkedList)) continue;
                linkedList.remove(object);
            }
            n2 = 0;
            if (linkedList.size() > 0) {
                object = (Task)linkedList.get(0);
                if (object.equals(this.project)) {
                    bl2 = false;
                }
                if (((Task)object).isEmpty() || ((Task)object).getParent() == null || ((Task)object).isParentSplitted()) {
                    n2 = 0;
                } else {
                    task3 = ((Task)object).getParent();
                    for (int i = task3.getChildIndex((Task)object) - 1; i >= 0; --i) {
                        Task task2 = task3.getChildAt(i);
                        if (task2.isEmpty()) continue;
                        if (task2.isSplitted()) break;
                        n2 = 1;
                        break;
                    }
                }
            }
            for (Task task3 : linkedList) {
                Task task4 = task3.getParent();
                if (task3.isEmpty() || task4 == null || task3.isParentSplitted()) {
                    bl = false;
                    bl3 = false;
                    bl4 = false;
                    bl5 = false;
                    break;
                }
                if (task3.isProject()) {
                    bl = false;
                    bl3 = false;
                }
                bl3 = bl3 && !task4.equals((Task)this.wbs.getTreeTableModel().getRoot());
                bl4 = bl4 && task4.getChildIndex(task3) != 0;
                bl5 = bl5 && task4.getChildIndex(task3) != task4.getChildNumber() - 1;
                bl = bl && n2 != 0;
            }
            this.deleteAction.setEnabled(bl2);
            this.outdentAction.setEnabled(bl3);
            this.upAction.setEnabled(bl4);
            this.downAction.setEnabled(bl5);
            this.indentAction.setEnabled(bl);
            this.cutAction.setEnabled(bl6);
            this.copyAction.setEnabled(bl7);
            object = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (object != null && (object.isDataFlavorSupported(CustomFlavor.taskListFlavor) || object.isDataFlavorSupported(DataFlavor.stringFlavor))) {
                if (n == 1) {
                    task3 = (Task)this.wbs.getPathForRow(this.wbs.getSelectedRow()).getLastPathComponent();
                    this.pasteAction.setEnabled(!task3.isParentSplitted());
                }
            } else {
                this.pasteAction.setEnabled(false);
            }
        } else {
            this.deleteAction.setEnabled(false);
            this.outdentAction.setEnabled(false);
            this.upAction.setEnabled(false);
            this.downAction.setEnabled(false);
            this.indentAction.setEnabled(false);
            this.cutAction.setEnabled(false);
            this.copyAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
        }
        if (n == 1) {
            Task task = (Task)this.wbs.getPathForRow(this.wbs.getSelectedRow()).getLastPathComponent();
            if (!task.isEmpty()) {
                this.insertSubtaskAction.setEnabled(!task.isParentSplitted());
                this.taskView.setTask(task);
            } else {
                this.insertSubtaskAction.setEnabled(false);
            }
            if (task.getParent() != null && !task.isParentSplitted()) {
                this.insertAction.setEnabled(true);
            } else {
                this.insertAction.setEnabled(false);
            }
        } else {
            this.insertSubtaskAction.setEnabled(false);
            this.insertAction.setEnabled(false);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.rowHeader.setBackground(Color.WHITE);
        int n2 = this.wbs.print(graphics, pageFormat, n);
        this.rowHeader.setBackground((Color)javax.swing.UIManager.get("TableHeader.background"));
        return n2;
    }

    public int getNumberOfPages() {
        return this.wbs.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.wbs.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.wbs.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.wbs.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.wbs.getVerticalNumberOfPages();
    }

    public Dimension getPrintSize() {
        return this.wbs.getPrintSize();
    }

    public JWBSTreeTable getWbs() {
        return this.wbs;
    }

    public JRowHeader getRowHeader() {
        return this.rowHeader;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public JToggleButton getInfoButton() {
        return this.infoButton;
    }
}

