/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.TaskDetailView;
import com.sbs.jpm.ui.component.ZoomDropDownButton;
import com.sbs.jpm.ui.treetablechart.JArea;
import com.sbs.jpm.ui.treetablechart.JTaskChart;
import com.sbs.jpm.ui.treetablechart.JTaskSheetTreeTable;
import com.sbs.jpm.ui.treetablechart.time.TaskCostTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.TaskWorkTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleAdapter;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JProjectViewTaskSheet
extends JProjectView
implements CustomPageable {
    private ZoomDropDownButton zoomInButton;
    private ZoomDropDownButton zoomOutButton;
    private JToggleButton infoButton;
    private JCheckBoxMenuItem infoItem;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action expandAction;
    private Action collapseAction;
    private Action gotoAction;
    private Action detailsAction;
    private JPopupMenu popupMenu;
    private TaskDetailView taskView;
    private JSplitPane splitPane;
    private JTaskChart taskSheet;

    public JProjectViewTaskSheet() {
        this.taskSheet.getArea().getTimeScaleManager().addTimeScaleListener(new TimeScaleAdapter(){

            public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
                TimeScaleManager timeScaleManager = (TimeScaleManager)timeScaleEvent.getSource();
                JProjectViewTaskSheet.this.zoomInButton.setEnabled(timeScaleManager.canZoomIn());
                JProjectViewTaskSheet.this.zoomOutButton.setEnabled(timeScaleManager.canZoomOut());
            }
        });
    }

    private JPanel createContentsTaskSheet() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.taskSheet = new JTaskChart();
        this.taskSheet.getTreeTable().setProjectView(this);
        this.taskSheet.getTreeTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JProjectViewTaskSheet.this.taskSheet.getTreeTable().grabFocus();
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JProjectViewTaskSheet.this.updateToolbar();
                }
            }
        });
        jPanel.add((Component)this.taskSheet, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 9, 0));
        return jPanel;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.splitPane = new JSplitPane(0, this.createContentsTaskSheet(), this.createContentsTask());
        this.splitPane.setResizeWeight(0.8);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        jPanel.add((Component)this.splitPane, "Center");
        return jPanel;
    }

    private JPanel createContentsTask() {
        this.taskView = new TaskDetailView(false);
        this.taskView.setVisible(false);
        return this.taskView;
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.taskSheet.setProject(task);
        this.taskSheet.getTreeTable().expandAll();
    }

    protected void createToolBar() {
        super.createToolBar();
        this.setPopup();
        JButton jButton = new JButton();
        this.zoomInButton = new ZoomDropDownButton(jButton, this.taskSheet.getArea().getTimeScaleManager());
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        jButton.setToolTipText(Common.I18N_ACTIONS.getString("zoomIn") + " (Ctrl + mouse wheel up)");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewTaskSheet.this.taskSheet.getArea().getTimeScaleManager().zoomIn();
            }
        });
        JButton jButton2 = new JButton();
        this.zoomOutButton = new ZoomDropDownButton(jButton2, this.taskSheet.getArea().getTimeScaleManager());
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        jButton2.setToolTipText(Common.I18N_ACTIONS.getString("zoomOut") + " (Ctrl + mouse wheel down)");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewTaskSheet.this.taskSheet.getArea().getTimeScaleManager().zoomOut();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton jToggleButton = new JToggleButton(Common.I18N_ACTIONS.getString("cost"), true);
        jToggleButton.setToolTipText(Common.I18N_ACTIONS.getString("cost.tooltip"));
        jToggleButton.setMnemonic(67);
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JArea jArea = JProjectViewTaskSheet.this.taskSheet.getArea();
                jArea.setTreeTableManager(new TaskCostTreeTableManager((JTaskSheetTreeTable)jArea.getTreetable(), jArea.getTimeScaleManager()));
            }
        });
        jToggleButton.putClientProperty("Quaqua.Button.style", "toggleEast");
        JToggleButton jToggleButton2 = new JToggleButton(Common.I18N_ACTIONS.getString("work"), false);
        jToggleButton2.setToolTipText(Common.I18N_ACTIONS.getString("work.tooltip"));
        jToggleButton2.setMnemonic(87);
        jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JArea jArea = JProjectViewTaskSheet.this.taskSheet.getArea();
                jArea.setTreeTableManager(new TaskWorkTreeTableManager((JTaskSheetTreeTable)jArea.getTreetable(), jArea.getTimeScaleManager()));
            }
        });
        jToggleButton2.putClientProperty("Quaqua.Button.style", "toggleWest");
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.gotoAction.setEnabled(false);
        JButton jButton3 = new JButton(this.expandAllAction);
        jButton3.setFocusable(false);
        this.toolBar.add(jButton3);
        JButton jButton4 = new JButton(this.collapseAllAction);
        jButton4.setFocusable(false);
        this.toolBar.add(jButton4);
        JButton jButton5 = new JButton(this.gotoAction);
        jButton5.setFocusable(false);
        this.toolBar.add(jButton5);
        this.toolBar.addSeparator();
        this.toolBar.add(jToggleButton2);
        this.toolBar.add(jToggleButton);
        this.toolBar.addSeparator();
        this.zoomInButton.addToToolBar(this.toolBar);
        this.zoomOutButton.addToToolBar(this.toolBar);
        this.toolBar.add(this.infoButton);
    }

    public void showInfo() {
        this.taskView.setVisible(true);
        this.splitPane.setDividerLocation(-1);
        this.infoButton.setSelected(true);
    }

    private void setPopup() {
        KeyStroke keyStroke = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(107, 256) : KeyStroke.getKeyStroke(107, 128);
        KeyStroke keyStroke2 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(109, 256) : KeyStroke.getKeyStroke(109, 128);
        KeyStroke keyStroke3 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(71, 256) : KeyStroke.getKeyStroke(71, 128);
        KeyStroke keyStroke4 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.expandAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/expand.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewTaskSheet.this.taskSheet.getTreeTable().expandAll();
            }
        };
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("expandAll") + " (Cmmd-+)" : Common.I18N_ACTIONS.getString("expandAll") + " (Ctrl-+)";
        this.expandAllAction.putValue("ShortDescription", string);
        this.expandAllAction.putValue("AcceleratorKey", keyStroke);
        this.collapseAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/collapse.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewTaskSheet.this.taskSheet.getTreeTable().collapseAll();
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("collapseAll") + " (Cmmd--)" : Common.I18N_ACTIONS.getString("collapseAll") + " (Ctrl--)";
        this.collapseAllAction.putValue("ShortDescription", string);
        this.collapseAllAction.putValue("AcceleratorKey", keyStroke2);
        this.expandAction = new AbstractAction(Common.I18N_ACTIONS.getString("expand"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewTaskSheet.this.taskSheet.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        JProjectViewTaskSheet.this.taskSheet.getTreeTable().expandRow(nArray[i]);
                    }
                }
            }
        };
        this.expandAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("expand"));
        this.collapseAction = new AbstractAction(Common.I18N_ACTIONS.getString("collapse"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewTaskSheet.this.taskSheet.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        JProjectViewTaskSheet.this.taskSheet.getTreeTable().collapseRow(nArray[i]);
                    }
                }
            }
        };
        this.collapseAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("collapse"));
        this.gotoAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/go_to.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewTaskSheet.this.taskSheet.getTreeTable().getSelectedRowCount() == 1) {
                    int n = JProjectViewTaskSheet.this.taskSheet.getTreeTable().getSelectedRow();
                    Task task = (Task)JProjectViewTaskSheet.this.taskSheet.getTreeTable().getPathForRow(n).getLastPathComponent();
                    JProjectViewTaskSheet.this.taskSheet.getArea().getTimeScaleManager().focusOnDate(task.getStartDate());
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.focusOn") + " (Cmmd-G)" : Common.I18N_ACTIONS.getString("task.focusOn") + " (Ctrl-G)";
        this.gotoAction.putValue("ShortDescription", string);
        this.gotoAction.putValue("AcceleratorKey", keyStroke3);
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewTaskSheet.this.taskView.isVisible()) {
                    JProjectViewTaskSheet.this.taskView.setVisible(true);
                    JProjectViewTaskSheet.this.infoButton.setSelected(true);
                    JProjectViewTaskSheet.this.infoItem.setSelected(true);
                    JProjectViewTaskSheet.this.splitPane.setDividerLocation(-1);
                    JProjectViewTaskSheet.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewTaskSheet.this.taskView.setVisible(false);
                    JProjectViewTaskSheet.this.infoButton.setSelected(false);
                    JProjectViewTaskSheet.this.infoItem.setSelected(false);
                    JProjectViewTaskSheet.this.splitPane.setDividerSize(0);
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.detailsAction.putValue("AcceleratorKey", keyStroke3);
        ActionMap actionMap = this.taskSheet.getTreeTable().getActionMap();
        actionMap.put("expandAll", this.expandAllAction);
        actionMap.put("collapseAll", this.collapseAllAction);
        actionMap.put("goto", this.gotoAction);
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.taskSheet.getTreeTable().getInputMap(1);
        inputMap.put(keyStroke, "expandAll");
        inputMap.put(keyStroke2, "collapseAll");
        inputMap.put(keyStroke3, "goto");
        inputMap.put(keyStroke4, "details");
        JMenuItem jMenuItem = new JMenuItem(this.expandAction);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.collapseAction);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.gotoAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.focusOn"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.task"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.tooltip"));
        this.infoItem.setAccelerator(keyStroke4);
        this.infoItem.setSelected(false);
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewTaskSheet.this.infoButton.doClick();
            }
        });
        this.popupMenu.add(this.infoItem);
        this.taskSheet.getTreeTable().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = JProjectViewTaskSheet.this.taskSheet.getTreeTable().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath[] treePathArray = JProjectViewTaskSheet.this.taskSheet.getTreeTable().getTreeSelectionModel().getSelectionPaths();
                    boolean bl = false;
                    if (treePathArray != null) {
                        for (int i = 0; i < treePathArray.length; ++i) {
                            TreePath treePath2 = treePathArray[i];
                            if (!treePath2.equals(treePath)) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JProjectViewTaskSheet.this.taskSheet.getTreeTable().getTreeSelectionModel().setSelectionPath(treePath);
                    }
                    JProjectViewTaskSheet.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected void updateDetailsAndToolbar() {
        int[] nArray = this.taskSheet.getTreeTable().getSelectedRows();
        int n = this.taskSheet.getTreeTable().getSelectedRowCount();
        LinkedList<Task> linkedList = new LinkedList<Task>();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            Task task = (Task)this.taskSheet.getTreeTable().getPathForRow(n2).getLastPathComponent();
            linkedList.add(task);
        }
        this.taskView.setTasks(linkedList);
        if (n == 1) {
            Task task = (Task)this.taskSheet.getTreeTable().getPathForRow(this.taskSheet.getTreeTable().getSelectedRow()).getLastPathComponent();
            if (!task.isEmpty()) {
                this.gotoAction.setEnabled(true);
            } else {
                this.gotoAction.setEnabled(false);
            }
        } else {
            this.gotoAction.setEnabled(false);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.taskSheet.print(graphics, pageFormat, n);
    }

    public int getNumberOfPages() {
        return this.taskSheet.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.taskSheet.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.taskSheet.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.taskSheet.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.taskSheet.getVerticalNumberOfPages();
    }

    public Dimension getPrintSize() {
        return this.taskSheet.getPrintSize();
    }

    public JTaskChart getTaskSheet() {
        return this.taskSheet;
    }

    public JToggleButton getInfoButton() {
        return this.infoButton;
    }

    public TaskDetailView getTaskView() {
        return this.taskView;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.taskView.isVisible());
        this.infoItem.setSelected(this.taskView.isVisible());
    }
}

