/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.view.JProjectViewHumanResource;
import com.sbs.jpm.ui.component.view.JProjectViewMaterialResource;
import com.sbs.jpm.ui.core.Data;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JProjectViewResources
extends JProjectView
implements CustomPageable {
    public static final int HUMAN = 0;
    public static final int MATERIAL = 1;
    private JProjectViewHumanResource humanResourceView;
    private JProjectViewMaterialResource materialResourceView;
    private JTabbedPane tabbedPane;

    public void setProject(Task task) {
        super.setProject(task);
        this.humanResourceView.setProject(task);
        this.materialResourceView.setProject(task);
    }

    protected void updateDetailsAndToolbar() {
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tabbedPane.setFocusable(false);
        this.humanResourceView = new JProjectViewHumanResource();
        this.materialResourceView = new JProjectViewMaterialResource();
        this.tabbedPane.add(Common.I18N_RP.getString("guide.human"), this.humanResourceView);
        this.tabbedPane.add(Common.I18N_RP.getString("guide.material"), this.materialResourceView);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                JProject jProject = Common.getApplication().getWorkspace().getJProject();
                jProject.getAreaView().setActiveView(JAreaView.DEFINE_RESOURCES);
                Data data = n == 0 ? ActionManager.getActionManager().getData(3) : ActionManager.getActionManager().getData(4);
                jProject.getGuidePanel().setData(data);
                jProject.getGuidePanel().getDetailsTitleLabel().setText(data.getName());
                if (!jProject.getResourceButton().isSelected()) {
                    if (n == 0) {
                        jProject.getGuidePanel().getTree().setSelectionRow(10);
                    } else {
                        jProject.getGuidePanel().getTree().setSelectionRow(11);
                    }
                }
            }
        };
        this.tabbedPane.addChangeListener(changeListener);
        jPanel.add((Component)this.tabbedPane, "Center");
        return jPanel;
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setSelectedTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public JToolBar getToolBar() {
        return ((JProjectView)this.tabbedPane.getSelectedComponent()).getToolBar();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = this.tabbedPane.getSelectedIndex();
        if (n2 == 0) {
            JRowHeader jRowHeader = this.humanResourceView.getRowHeader();
            jRowHeader.setBackground(Color.WHITE);
            int n3 = this.humanResourceView.getResourceTable().print(graphics, pageFormat, n);
            jRowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
            return n3;
        }
        JRowHeader jRowHeader = this.materialResourceView.getRowHeader();
        jRowHeader.setBackground(Color.WHITE);
        int n4 = this.materialResourceView.getResourceTable().print(graphics, pageFormat, n);
        jRowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        return n4;
    }

    public int getNumberOfPages() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0) {
            return this.humanResourceView.getResourceTable().getNumberOfPages();
        }
        return this.materialResourceView.getResourceTable().getNumberOfPages();
    }

    public Dimension getPrintSize() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0) {
            return this.humanResourceView.getResourceTable().getPrintSize();
        }
        return this.materialResourceView.getResourceTable().getPrintSize();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        int n2 = this.tabbedPane.getSelectedIndex();
        if (n2 == 0) {
            return this.humanResourceView.getResourceTable().getPageFormat(n);
        }
        return this.materialResourceView.getResourceTable().getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        int n2 = this.tabbedPane.getSelectedIndex();
        if (n2 == 0) {
            return this.humanResourceView.getResourceTable().getPrintable(n);
        }
        return this.materialResourceView.getResourceTable().getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0) {
            return this.humanResourceView.getResourceTable().getHorizontalNumberOfPages();
        }
        return this.materialResourceView.getResourceTable().getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0) {
            return this.humanResourceView.getResourceTable().getVerticalNumberOfPages();
        }
        return this.materialResourceView.getResourceTable().getVerticalNumberOfPages();
    }

    public JProjectViewHumanResource getHumanResourceView() {
        return this.humanResourceView;
    }

    public JProjectViewMaterialResource getMaterialResourceView() {
        return this.materialResourceView;
    }
}

