/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.action.CustomFlavor;
import com.sbs.jpm.ui.action.TaskSelection;
import com.sbs.jpm.ui.component.ConflictDropDownButton;
import com.sbs.jpm.ui.component.DependencyDropDownButton;
import com.sbs.jpm.ui.component.JCatchUpDialog;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.TaskDetailView;
import com.sbs.jpm.ui.component.ZoomDropDownButton;
import com.sbs.jpm.ui.component.view.JProjectViewResourceSheet;
import com.sbs.jpm.ui.component.view.ViewCommon;
import com.sbs.jpm.ui.treetablechart.JChartArea;
import com.sbs.jpm.ui.treetablechart.JGanttChart;
import com.sbs.jpm.ui.treetablechart.model.ChartTreeTableModel;
import com.sbs.jpm.ui.treetablechart.model.TaskTreeTableModel;
import com.sbs.jpm.ui.treetablechart.time.GanttScaleManager;
import com.sbs.jpm.ui.treetablechart.time.SheetScaleManager;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleAdapter;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import com.sbs.jpm.undo.DeleteEmptyTasksEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskAddDependencyEdit;
import com.sbs.jpm.undo.TaskDownEdit;
import com.sbs.jpm.undo.TaskIndentEdit;
import com.sbs.jpm.undo.TaskInsertEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.TaskNonEmptyEdit;
import com.sbs.jpm.undo.TaskOutdentEdit;
import com.sbs.jpm.undo.TaskPasteEdit;
import com.sbs.jpm.undo.TaskPasteSerializableEdit;
import com.sbs.jpm.undo.TaskRemoveDependencyEdit;
import com.sbs.jpm.undo.TaskUpEdit;
import com.sbs.util.ExcelAdapter;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class JProjectViewGantt
extends JProjectView
implements CustomPageable {
    private static final long serialVersionUID = 1L;
    protected JGanttChart gantt;
    private TaskDetailView taskView;
    private JProjectViewResourceSheet resourceSheetView;
    private JSplitPane splitPane;
    private JSplitPane levelingSplitPane;
    private JToggleButton infoButton;
    private JToggleButton levelingButton;
    private JCheckBoxMenuItem infoItem;
    private JToggleButton showCriticalPathButton;
    private JButton assignResourceButton;
    private ZoomDropDownButton zoomInButton;
    private ConflictDropDownButton conflictButton;
    private DependencyDropDownButton linkButton;
    private JButton breakButton;
    private JButton insertTaskButton;
    private ZoomDropDownButton zoomOutButton;
    private Action insertAction;
    private Action taskInsertAction;
    private Action newTaskAction;
    private Action insertSubtaskAction;
    private Action deleteAction;
    private Action indentAction;
    private Action outdentAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action upAction;
    private Action downAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private GotoAction gotoAction;
    private Action detailsAction;
    private Action splitAction;
    private Action catchUpAction;
    private Action levelingAction;
    private Action gotoTaskAction;
    public final Cursor BREAK_TASK_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/breakTaskCursor.png")).getImage(), new Point(0, 0), "BreakTaskCursor");
    public final Cursor INSERT_TASK_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(this.getClass().getClassLoader().getResource("com/sbs/jpm/ui/images/insertTaskCursor.png")).getImage(), new Point(0, 0), "InsertTaskCursor");
    private Action linkAction;
    private Action unlinkAction;
    private JPopupMenu popupMenu;

    public JProjectViewGantt() {
        this.gantt.getArea().getTimeScaleManager().addTimeScaleListener(new TimeScaleAdapter(){

            public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
                TimeScaleManager timeScaleManager = (TimeScaleManager)timeScaleEvent.getSource();
                JProjectViewGantt.this.zoomInButton.setEnabled(timeScaleManager.canZoomIn());
                JProjectViewGantt.this.zoomOutButton.setEnabled(timeScaleManager.canZoomOut());
            }
        });
    }

    protected void createGantt() {
        this.gantt = new JGanttChart();
    }

    protected JPanel createContentsGantt() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.createGantt();
        this.gantt.getTreeTable().setProjectView(this);
        this.gantt.getTreeTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JProjectViewGantt.this.gantt.getTreeTable().grabFocus();
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JProjectViewGantt.this.updateToolbar();
                }
            }
        });
        this.gantt.getArea().getDownScrollPane().getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JChartArea jChartArea = JProjectViewGantt.this.gantt.getArea().getChartArea();
                JChartArea jChartArea2 = JProjectViewGantt.this.resourceSheetView.getResourceSheet().getArea().getChartArea();
                jChartArea2.scrollRectToVisible(new Rectangle(jChartArea.getVisibleRect().x, jChartArea2.getVisibleRect().y, jChartArea2.getVisibleRect().width, jChartArea2.getVisibleRect().height));
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("dividerLocation")) {
                    int n = jSplitPane.getDividerLocation();
                    JProjectViewGantt.this.resourceSheetView.getResourceSheet().getSplitPane().setDividerLocation(n - 60);
                }
            }
        };
        this.gantt.getSplitPane().addPropertyChangeListener(propertyChangeListener);
        jPanel.add((Component)this.gantt, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 9, 0));
        return jPanel;
    }

    protected JPanel createResourceSheet() {
        this.resourceSheetView = new JProjectViewResourceSheet();
        this.resourceSheetView.getResourceSheet().getArea().setTimeScaleManager(this.gantt.getArea().getTimeScaleManager());
        this.resourceSheetView.getResourceSheet().getArea().getDownScrollPane().setHorizontalScrollBarPolicy(31);
        this.resourceSheetView.getResourceSheet().getResourceSheetData().addWorkData(7);
        this.resourceSheetView.getResourceSheet().getTreeTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().getSelectedRowCount() == 1) {
                        Object object = JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().getPathForRow(JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().getSelectedRow()).getLastPathComponent();
                        if (object instanceof Assignment) {
                            JProjectViewGantt.this.gotoTaskAction.setEnabled(true);
                        } else {
                            JProjectViewGantt.this.gotoTaskAction.setEnabled(false);
                        }
                    } else {
                        JProjectViewGantt.this.gotoTaskAction.setEnabled(false);
                    }
                }
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("dividerLocation")) {
                    int n = jSplitPane.getDividerLocation();
                    JProjectViewGantt.this.gantt.getSplitPane().setDividerLocation(n + 60);
                }
            }
        };
        this.resourceSheetView.getResourceSheet().getSplitPane().addPropertyChangeListener(propertyChangeListener);
        this.resourceSheetView.setVisible(false);
        return this.resourceSheetView;
    }

    private JPanel createContentsTask() {
        this.taskView = new TaskDetailView(true);
        this.taskView.setVisible(false);
        return this.taskView;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.popupMenu = new JPopupMenu();
        this.splitPane = new JSplitPane(0, this.createContentsGantt(), this.createContentsTask());
        this.splitPane.setResizeWeight(0.8);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.levelingSplitPane = new JSplitPane(0, this.splitPane, this.createResourceSheet());
        this.levelingSplitPane.setResizeWeight(0.8);
        this.levelingSplitPane.setDividerSize(5);
        this.levelingSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (SystemUtilities.isOSMac()) {
            this.splitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
            this.levelingSplitPane.putClientProperty("Quaqua.SplitPane.style", "bar");
        }
        jPanel.add((Component)this.levelingSplitPane, "Center");
        this.taskView.setTasks(new LinkedList<Task>());
        return jPanel;
    }

    private void loadExpandedState(Task task) {
        for (Task task2 : task.getChildList()) {
            if (task2.isEmpty()) continue;
            if (task2.isExpanded()) {
                this.gantt.getTreeTable().expandPath(new TreePath(task2.getPath(this.project).toArray()));
            }
            this.loadExpandedState(task2);
        }
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.gantt.setProject(task);
        this.loadExpandedState(task);
        this.resourceSheetView.setProject(task);
        this.resourceSheetView.getResourceSheet().getTreeTable().collapseAll();
        this.conflictButton.setConflictManager(task.getCompany().getConflictManager());
    }

    public JGanttChart getGantt() {
        return this.gantt;
    }

    public void showInfo() {
        this.taskView.setVisible(true);
        this.infoButton.setSelected(true);
        this.splitPane.setDividerLocation(-1);
        this.splitPane.setDividerSize(5);
    }

    public void showLeveling() {
        TimeScaleManager timeScaleManager = this.gantt.getArea().getTimeScaleManager();
        SheetScaleManager sheetScaleManager = new SheetScaleManager(timeScaleManager);
        this.resourceSheetView.setVisible(true);
        this.levelingButton.setSelected(true);
        this.levelingSplitPane.setDividerLocation(-1);
        this.levelingSplitPane.setDividerSize(5);
        this.gantt.getArea().setTimeScaleManager(sheetScaleManager);
        this.resourceSheetView.getResourceSheet().getArea().setTimeScaleManager(sheetScaleManager);
        this.zoomInButton.setScaleManager(sheetScaleManager);
        this.zoomOutButton.setScaleManager(sheetScaleManager);
    }

    private void insertTask(Task task, Task task2, int n, CompoundEdit compoundEdit) {
        Object object2 = task2.getChildList().toArray(new Task[0]);
        int n2 = ((Task[])object2).length;
        for (int i = 0; i < n2; ++i) {
            Task object3 = object2[i];
            this.insertTask(task2, object3, i, compoundEdit);
        }
        object2 = new LinkedList();
        for (Dependency dependency : task2.getPredecessorDependencies()) {
            object2.add(dependency);
        }
        LinkedList linkedList = new LinkedList();
        for (Dependency dependency : task2.getSuccessorDependencies()) {
            linkedList.add(dependency);
        }
        LinkedList linkedList2 = new LinkedList();
        for (Assignment assignment : task2.getAssignments()) {
            linkedList2.add(assignment);
        }
        TaskPasteEdit taskPasteEdit = new TaskPasteEdit(task, task2, n, (List<Dependency>)object2, linkedList, linkedList2, "02-10-2009 : 12:31:02");
        compoundEdit.addEdit(taskPasteEdit);
    }

    private void setPopup() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke3 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(39, 256) : KeyStroke.getKeyStroke(39, 128);
        KeyStroke keyStroke4 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(37, 256) : KeyStroke.getKeyStroke(37, 128);
        KeyStroke keyStroke5 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(38, 256) : KeyStroke.getKeyStroke(38, 128);
        KeyStroke keyStroke6 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(40, 256) : KeyStroke.getKeyStroke(40, 128);
        KeyStroke keyStroke7 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(107, 256) : KeyStroke.getKeyStroke(107, 128);
        KeyStroke keyStroke8 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(109, 256) : KeyStroke.getKeyStroke(109, 128);
        KeyStroke keyStroke9 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(71, 256) : KeyStroke.getKeyStroke(71, 128);
        KeyStroke keyStroke10 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(76, 256) : KeyStroke.getKeyStroke(76, 128);
        KeyStroke keyStroke11 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(85, 256) : KeyStroke.getKeyStroke(85, 128);
        KeyStroke keyStroke12 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(88, 256) : KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke13 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke14 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 128);
        KeyStroke keyStroke15 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.insertAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertLine.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        TreePath treePath = treeSelectionModel.getSelectionPath();
                        Task task = (Task)treePath.getLastPathComponent();
                        if (task.getParent() != null) {
                            Task task2 = task.getParent();
                            int n = task2.getChildIndex(task);
                            final int n2 = JProjectViewGantt.this.gantt.getTreeTable().getRowForPath(treePath);
                            Company company = task.getCompany();
                            Task task3 = new Task(company.getIdGenerator().getNewId());
                            task2.addChild(n, task3);
                            ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                            TaskInsertEdit taskInsertEdit = new TaskInsertEdit(task2, task3, n, "02-10-2009 12:44:04");
                            extendedCompoundEdit.addEdit(taskInsertEdit);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JProjectViewGantt.this.gantt.getTreeTable().setRowSelectionInterval(n2, n2);
                                }
                            });
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("insertLine") : Common.I18N_ACTIONS.getString("insertLine") + " (Insert)";
        this.insertAction.putValue("ShortDescription", string);
        this.insertAction.putValue("AcceleratorKey", keyStroke);
        this.newTaskAction = new AbstractAction(Common.I18N_ACTIONS.getString("task.new"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Task task;
                        TreePath treePath = treeSelectionModel.getSelectionPath();
                        Task task2 = (Task)treePath.getLastPathComponent();
                        if (task2.getParent() != null) {
                            Task task3 = task2.getParent();
                            int n = task3.getChildIndex(task2);
                            final int n2 = JProjectViewGantt.this.gantt.getTreeTable().getRowForPath(treePath);
                            Company company = task3.getCompany();
                            task = new Task(company.getIdGenerator().getNewId());
                            task3.addChild(n, task);
                            task.setName(Common.I18N_ACTIONS.getString("task.new"));
                            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task3);
                            TaskInsertEdit taskInsertEdit = new TaskInsertEdit(task3, task, n, "02-10-2009 12:44:05");
                            TaskNameEdit taskNameEdit = new TaskNameEdit(task, "", task.getName(), "02-10-2009 12:41:04");
                            extendedCompoundEdit.addEdit(taskInsertEdit);
                            extendedCompoundEdit.addEdit(taskNameEdit);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JProjectViewGantt.this.gantt.getTreeTable().setRowSelectionInterval(n2, n2);
                                }
                            });
                        } else {
                            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                            task = ((ChartTreeTableModel)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel()).insertEmptyTasks(task2, extendedCompoundEdit, true);
                            task.setName(Common.I18N_ACTIONS.getString("task.new"));
                            TaskNonEmptyEdit taskNonEmptyEdit = new TaskNonEmptyEdit(task, "02-10-2009 : 12:40:03");
                            extendedCompoundEdit.addEdit(taskNonEmptyEdit);
                            TaskNameEdit taskNameEdit = new TaskNameEdit(task, task.getName(), Common.I18N_ACTIONS.getString("task.new"), "02-10-2009 12:41:05");
                            extendedCompoundEdit.addEdit(taskNameEdit);
                            extendedCompoundEdit.end();
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        }
                        task.setDirty(true, true);
                        TaskPlanner.rescheduleTree(task);
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        this.newTaskAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.new"));
        this.insertSubtaskAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertSubtask.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                    TreePath treePath = treeSelectionModel.getSelectionPath();
                    Task task = (Task)treePath.getLastPathComponent();
                    if (!task.isEmpty()) {
                        Serializable serializable;
                        JProjectView.BLOCK_UPDATE = true;
                        try {
                            Company company = task.getCompany();
                            Task task2 = new Task(company.getIdGenerator().getNewId());
                            JProjectViewGantt.this.insertTask(task, task2, task.getChildNumber(), extendedCompoundEdit);
                            task.addChild(task.getChildNumber(), task2);
                            task2.setName(Common.I18N_ACTIONS.getString("subtask"));
                            task.setDirty(true, false);
                            TaskPlanner.rescheduleTree(task);
                            extendedCompoundEdit.end();
                            serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewGantt.this.fireUndoableEditHappened((UndoableEditEvent)serializable);
                            JProjectViewGantt.this.gantt.getTreeTable().expandPath(new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                            JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().setSelectionPath(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                        }
                        finally {
                            JProjectView.BLOCK_UPDATE = false;
                            JProjectViewGantt.this.updateToolbar();
                        }
                        int n = JProjectViewGantt.this.gantt.getTreeTable().getRowForPath(treeSelectionModel.getSelectionPath());
                        int n2 = JProjectViewGantt.this.gantt.getTreeTable().convertColumnIndexToView(JProjectViewGantt.this.gantt.getTreeTable().getColumn(TaskTreeTableModel.TASK_NAME).getModelIndex());
                        JProjectViewGantt.this.gantt.getTreeTable().editCellAt(n, n2);
                        serializable = (JTextComponent)JProjectViewGantt.this.gantt.getTreeTable().getEditorComponent();
                        ((JComponent)serializable).grabFocus();
                        ((JTextComponent)serializable).selectAll();
                    }
                }
            }
        };
        this.insertSubtaskAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("subtask.insert"));
        this.taskInsertAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertTask.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.getApplication().setCursor(JProjectViewGantt.this.INSERT_TASK_CURSOR);
                JProjectViewGantt.this.gantt.getArea().setInsertTask(true);
            }
        };
        this.taskInsertAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.insert"));
        this.deleteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
                    final int n = treePathArray.length;
                    final int n2 = JProjectViewGantt.this.gantt.getTreeTable().getRowForPath(treePathArray[n - 1]);
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                        for (int i = 0; i < treePathArray.length; ++i) {
                            int n3;
                            Task task = (Task)treePathArray[i].getLastPathComponent();
                            if (task.getParent() == null || (n3 = JProjectViewGantt.this.gantt.getTreeTable().getRowForPath(treePathArray[i])) < 0 || n3 >= JProjectViewGantt.this.gantt.getTreeTable().getRowCount() - 1) continue;
                            boolean bl = false;
                            if (task.getParent().equals((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot())) {
                                bl = true;
                            }
                            ViewCommon.deleteTask(task, extendedCompoundEdit);
                            if (!bl) continue;
                            List<Task> list = task.getParent().removeEmptyTasks();
                            DeleteEmptyTasksEdit deleteEmptyTasksEdit = new DeleteEmptyTasksEdit(task.getParent(), list, "15-09-09 12:37:02");
                            extendedCompoundEdit.addEdit(deleteEmptyTasksEdit);
                        }
                        TaskPlanner.rescheduleTree(JProjectViewGantt.this.project);
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int n3 = n2 - n + 1;
                                if (n2 == JProjectViewGantt.this.gantt.getTreeTable().getRowCount() - 1) {
                                    --n3;
                                }
                                JProjectViewGantt.this.gantt.getTreeTable().setRowSelectionInterval(n3, n3);
                            }
                        });
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        this.deleteAction.putValue("AcceleratorKey", keyStroke2);
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.delete") + " (Delete)");
        this.indentAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/indent.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                    for (int i = 0; i < nArray.length; ++i) {
                        linkedList.add((Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(nArray[i]).getLastPathComponent());
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        Task task2 = taskArray[i];
                        if (!task2.isDescendent(linkedList)) continue;
                        linkedList.remove(task2);
                    }
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Serializable serializable;
                        Task task;
                        block7: for (Task task2 : linkedList) {
                            task = task2.getParent();
                            if (task == null) continue;
                            serializable = null;
                            for (int i = 0; i < task.getChildNumber(); ++i) {
                                Task task3 = task.getChildAt(i);
                                if (!task3.isEmpty() && !task3.equals(task2)) {
                                    serializable = task3;
                                    continue;
                                }
                                if (task3.isEmpty() || serializable == null) continue;
                                boolean bl = JProjectViewGantt.this.gantt.getTreeTable().isExpanded(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                TaskIndentEdit taskIndentEdit = new TaskIndentEdit((Task)serializable, task2, "02-10-2009 12:48:00");
                                try {
                                    task2.indent((Task)serializable);
                                }
                                catch (CircularRelationshipException circularRelationshipException) {
                                    Common.logException("Error:", circularRelationshipException);
                                    JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                                    break block7;
                                }
                                JProjectViewGantt.this.gantt.getTreeTable().expandPath(new TreePath(((Task)serializable).getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                if (bl) {
                                    JProjectViewGantt.this.gantt.getTreeTable().expandPath(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                } else {
                                    JProjectViewGantt.this.gantt.getTreeTable().collapsePath(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                }
                                extendedCompoundEdit.addEdit(taskIndentEdit);
                                continue block7;
                            }
                        }
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree(JProjectViewGantt.this.project);
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            task = taskArray[i];
                            serializable = new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray());
                            JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().addSelectionPath((TreePath)serializable);
                            JProjectViewGantt.this.gantt.getTreeTable().scrollPathToVisible((TreePath)serializable);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.indent") + " (Cmmd-Right)" : Common.I18N_ACTIONS.getString("task.indent") + " (Ctrl-Right)";
        this.indentAction.putValue("ShortDescription", string);
        this.indentAction.putValue("AcceleratorKey", keyStroke3);
        this.outdentAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/outdent.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Task task;
                        int n;
                        int[] nArray = treeSelectionModel.getSelectionRows();
                        Arrays.sort(nArray);
                        LinkedList<Integer> linkedList = new LinkedList<Integer>();
                        for (int i = 0; i < nArray.length; ++i) {
                            linkedList.add(nArray[i]);
                        }
                        Collections.reverse(linkedList);
                        LinkedList<Task> linkedList2 = new LinkedList<Task>();
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                        Task[] taskArray = linkedList.iterator();
                        while (taskArray.hasNext()) {
                            n = (Integer)taskArray.next();
                            linkedList2.add((Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(n).getLastPathComponent());
                        }
                        taskArray = linkedList2.toArray(new Task[0]);
                        for (n = 0; n < taskArray.length; ++n) {
                            Task task2 = taskArray[n];
                            if (!task2.isDescendent(linkedList2)) continue;
                            linkedList2.remove(task2);
                        }
                        for (Task task2 : linkedList2) {
                            task = task2.getParent();
                            boolean bl = task2.isLeaf() ? true : JProjectViewGantt.this.gantt.getTreeTable().isExpanded(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                            int n2 = task.getChildIndex(task2);
                            Task[] taskArray2 = task.getChildList().toArray(new Task[0]);
                            int n3 = taskArray2.length;
                            TaskOutdentEdit taskOutdentEdit = new TaskOutdentEdit(task, task2, "02-10-2009 : 12:33:00");
                            ExtendedCompoundEdit extendedCompoundEdit2 = new ExtendedCompoundEdit();
                            int n4 = n2 + 1;
                            try {
                                for (n4 = n2 + 1; n4 < n3; ++n4) {
                                    Task task3 = taskArray2[n4];
                                    TaskIndentEdit taskIndentEdit = new TaskIndentEdit(task2, task3, "02-10-2009 12:48:01");
                                    task3.indent(task2);
                                    extendedCompoundEdit2.addEdit(taskIndentEdit);
                                }
                                task2.outdent();
                                extendedCompoundEdit2.addEdit(taskOutdentEdit);
                                extendedCompoundEdit2.end();
                                if (bl) {
                                    JProjectViewGantt.this.gantt.getTreeTable().expandPath(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                } else {
                                    JProjectViewGantt.this.gantt.getTreeTable().collapsePath(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                }
                                extendedCompoundEdit.addEdit(extendedCompoundEdit2);
                            }
                            catch (CircularRelationshipException circularRelationshipException) {
                                Common.logException("Error:", circularRelationshipException);
                                JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                                for (int i = n4 - 1; i > n2; --i) {
                                    Task task4 = taskArray2[i];
                                    task4.outdent();
                                }
                                JProjectView.BLOCK_UPDATE = false;
                                JProjectViewGantt.this.updateToolbar();
                                return;
                            }
                        }
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree(JProjectViewGantt.this.project);
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            task = taskArray[i];
                            TreePath treePath = new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray());
                            JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().addSelectionPath(treePath);
                            JProjectViewGantt.this.gantt.getTreeTable().scrollPathToVisible(treePath);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.outdent") + " (Cmmd-Left)" : Common.I18N_ACTIONS.getString("task.outdent") + " (Ctrl-Left)";
        this.outdentAction.putValue("ShortDescription", string);
        this.outdentAction.putValue("AcceleratorKey", keyStroke4);
        this.upAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/up.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Serializable serializable;
                        LinkedList<Task> linkedList = new LinkedList<Task>();
                        ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                        for (int i = 0; i < treePathArray.length; ++i) {
                            linkedList.add((Task)treePathArray[i].getLastPathComponent());
                        }
                        Task[] taskArray = linkedList.toArray(new Task[0]);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task = taskArray[i];
                            if (!task.isDescendent(linkedList)) continue;
                            linkedList.remove(task);
                        }
                        for (Task task : linkedList) {
                            boolean bl = JProjectViewGantt.this.gantt.getTreeTable().isExpanded(new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                            serializable = new TaskUpEdit(task, "01-10-2009 17:25:01");
                            task.moveUp();
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                            if (bl) {
                                JProjectViewGantt.this.gantt.getTreeTable().expandPath(new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                continue;
                            }
                            JProjectViewGantt.this.gantt.getTreeTable().collapsePath(new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                        }
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task = taskArray[i];
                            serializable = new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray());
                            JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().addSelectionPath((TreePath)serializable);
                            JProjectViewGantt.this.gantt.getTreeTable().scrollPathToVisible((TreePath)serializable);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.up") + " (Cmmd-Up)" : Common.I18N_ACTIONS.getString("task.up") + " (Ctrl-Up)";
        this.upAction.putValue("ShortDescription", string);
        this.upAction.putValue("AcceleratorKey", keyStroke5);
        this.downAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/down.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    TreePath[] treePathArray = treeSelectionModel.getSelectionPaths();
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Serializable serializable;
                        Task task;
                        int n;
                        LinkedList<Task> linkedList = new LinkedList<Task>();
                        ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                        for (int i = 0; i < treePathArray.length; ++i) {
                            linkedList.add((Task)treePathArray[i].getLastPathComponent());
                        }
                        Task[] taskArray = linkedList.toArray(new Task[0]);
                        for (n = 0; n < taskArray.length; ++n) {
                            task = taskArray[n];
                            if (!task.isDescendent(linkedList)) continue;
                            linkedList.remove(task);
                        }
                        taskArray = linkedList.toArray(new Task[0]);
                        for (n = taskArray.length - 1; n >= 0; --n) {
                            task = taskArray[n];
                            boolean bl = JProjectViewGantt.this.gantt.getTreeTable().isExpanded(new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                            serializable = new TaskDownEdit(task, "02-10-2009 13:29:01");
                            task.moveDown();
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                            if (bl) {
                                JProjectViewGantt.this.gantt.getTreeTable().expandPath(new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                continue;
                            }
                            JProjectViewGantt.this.gantt.getTreeTable().collapsePath(new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                        }
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task2 = taskArray[i];
                            serializable = new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray());
                            JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().addSelectionPath((TreePath)serializable);
                            JProjectViewGantt.this.gantt.getTreeTable().scrollPathToVisible((TreePath)serializable);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.down") + " (Cmmd-Down)" : Common.I18N_ACTIONS.getString("task.down") + " (Ctrl-Down)";
        this.downAction.putValue("ShortDescription", string);
        this.downAction.putValue("AcceleratorKey", keyStroke6);
        this.cutAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    Object object;
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                    for (int i = 0; i < nArray.length; ++i) {
                        Task task = (Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(nArray[i]).getLastPathComponent();
                        if (task.isEmpty()) continue;
                        linkedList.add(task);
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        object = taskArray[i];
                        if (!((Task)object).isDescendent(linkedList)) continue;
                        linkedList.remove(object);
                    }
                    List<Task> list = Task.cloneTasks(linkedList, JProjectViewGantt.this.project.getCompany().getIdGenerator(), false);
                    object = new TaskSelection(list, ExcelAdapter.tasksToString(JProjectViewGantt.this.gantt.getTreeTable()));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        Object object2;
                        for (Task task : linkedList) {
                            boolean bl = false;
                            if (task.getParent().equals((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot())) {
                                bl = true;
                            }
                            ViewCommon.deleteTask(task, extendedCompoundEdit);
                            if (!bl) continue;
                            object2 = task.getParent().removeEmptyTasks();
                            DeleteEmptyTasksEdit deleteEmptyTasksEdit = new DeleteEmptyTasksEdit(task.getParent(), (List<Task>)object2, "15-09-09 12:37:03");
                            extendedCompoundEdit.addEdit(deleteEmptyTasksEdit);
                        }
                        TaskPlanner.rescheduleTree(JProjectViewGantt.this.project);
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        for (int i = 0; i < taskArray.length; ++i) {
                            Task task = taskArray[i];
                            object2 = new TreePath(task.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray());
                            JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().addSelectionPath((TreePath)object2);
                            JProjectViewGantt.this.gantt.getTreeTable().scrollPathToVisible((TreePath)object2);
                        }
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewGantt.this.updateToolbar();
                    }
                }
            }
        };
        this.cutAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("cut"));
        this.cutAction.putValue("AcceleratorKey", keyStroke12);
        this.copyAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeSelectionModel treeSelectionModel = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel();
                if (!treeSelectionModel.isSelectionEmpty()) {
                    Object object;
                    int[] nArray = treeSelectionModel.getSelectionRows();
                    Arrays.sort(nArray);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    for (int i = 0; i < nArray.length; ++i) {
                        Task task = (Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(nArray[i]).getLastPathComponent();
                        if (task.isEmpty()) continue;
                        linkedList.add(task);
                    }
                    Task[] taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        object = taskArray[i];
                        if (!((Task)object).isDescendent(linkedList)) continue;
                        linkedList.remove(object);
                    }
                    List<Task> list = Task.cloneTasks(linkedList, JProjectViewGantt.this.project.getCompany().getIdGenerator(), false);
                    object = new TaskSelection(list, ExcelAdapter.tasksToString(JProjectViewGantt.this.gantt.getTreeTable()));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                }
            }
        };
        this.copyAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("copy"));
        this.copyAction.putValue("AcceleratorKey", keyStroke13);
        this.pasteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                block22: {
                    if (JProjectViewGantt.this.gantt.getTreeTable().getSelectedRowCount() != 0) {
                        JProjectView.BLOCK_UPDATE = true;
                        try {
                            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                            try {
                                if (transferable == null) break block22;
                                if (transferable.isDataFlavorSupported(CustomFlavor.taskListFlavor)) {
                                    Object object;
                                    Object object2;
                                    int n;
                                    Task task;
                                    List list = (List)transferable.getTransferData(CustomFlavor.taskListFlavor);
                                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                                    int n2 = JProjectViewGantt.this.gantt.getTreeTable().getSelectedRow();
                                    if (n2 == 0 && JProjectViewGantt.this.project.getChildNumber() == 0) {
                                        task = JProjectViewGantt.this.project;
                                        n = 0;
                                    } else {
                                        object2 = (Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(n2).getLastPathComponent();
                                        object = (ChartTreeTableModel)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel();
                                        object2 = ((ChartTreeTableModel)((Object)object)).insertEmptyTasks((Task)object2, extendedCompoundEdit, false);
                                        task = ((Task)object2).getParent();
                                        n = task.getChildIndex((Task)object2) + 1;
                                    }
                                    object2 = Task.cloneTasks(list, JProjectViewGantt.this.project.getCompany().getIdGenerator(), true);
                                    object = Task.cloneTasks((List<Task>)object2, JProjectViewGantt.this.project.getCompany().getIdGenerator(), false);
                                    int n3 = 0;
                                    Object object3 = object2.iterator();
                                    while (object3.hasNext()) {
                                        Task task2 = (Task)object3.next();
                                        task2.updateClonedAssignments(JProjectViewGantt.this.project.getCompany());
                                        JProjectViewGantt.this.insertTask(task, task2, n, extendedCompoundEdit);
                                        task.addChild(n, task2);
                                        task2.addClonnedAssignments(false);
                                        extendedCompoundEdit.addEdit(new TaskPasteSerializableEdit(task, (Task)object.get(n3++), n));
                                        ++n;
                                        JProjectViewGantt.this.gantt.getTreeTable().expandPath(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                        JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().setSelectionPath(new TreePath(task2.getPath((Task)JProjectViewGantt.this.gantt.getTreeTable().getTreeTableModel().getRoot()).toArray()));
                                    }
                                    task.setDirty(true);
                                    TaskPlanner.rescheduleTree(JProjectViewGantt.this.project.getCompany().getRootTask());
                                    extendedCompoundEdit.end();
                                    object3 = new UndoableEditEvent(this, extendedCompoundEdit);
                                    JProjectViewGantt.this.fireUndoableEditHappened((UndoableEditEvent)object3);
                                    break block22;
                                }
                                if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block22;
                                int n = JProjectViewGantt.this.gantt.getTreeTable().getSelectedRows()[0];
                                int n4 = JProjectViewGantt.this.gantt.getTreeTable().getSelectedColumns()[0];
                                try {
                                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                                    int n5 = 0;
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String string2 = stringTokenizer.nextToken();
                                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
                                        int n6 = 0;
                                        while (stringTokenizer2.hasMoreTokens()) {
                                            String string3 = stringTokenizer2.nextToken();
                                            if (n + n5 < JProjectViewGantt.this.gantt.getTreeTable().getRowCount() && n4 + n6 < JProjectViewGantt.this.gantt.getTreeTable().getColumnCount()) {
                                                Serializable serializable;
                                                Class clazz = JProjectViewGantt.this.gantt.getTreeTable().getColumnClass(n4 + n6);
                                                if (clazz.equals(Date.class)) {
                                                    serializable = new SimpleDateFormat(UIManager.getInstance().getDateFormat());
                                                    Date date = serializable.parse(string3);
                                                    JProjectViewGantt.this.gantt.getTreeTable().setValueAt(date, n + n5, n4 + n6);
                                                } else if (clazz.equals(Double.class)) {
                                                    serializable = Double.valueOf(Double.parseDouble(string3));
                                                    JProjectViewGantt.this.gantt.getTreeTable().setValueAt(serializable, n + n5, n4 + n6);
                                                } else if (clazz.equals(Long.class)) {
                                                    serializable = Long.valueOf(Long.parseLong(string3));
                                                    JProjectViewGantt.this.gantt.getTreeTable().setValueAt(serializable, n + n5, n4 + n6);
                                                } else {
                                                    JProjectViewGantt.this.gantt.getTreeTable().setValueAt(string3, n + n5, n4 + n6);
                                                }
                                            }
                                            ++n6;
                                        }
                                        ++n5;
                                    }
                                }
                                catch (Exception exception) {
                                    Common.logException("Error:", exception);
                                    exception.printStackTrace();
                                }
                            }
                            catch (UnsupportedFlavorException unsupportedFlavorException) {
                                Common.logException("Error:", unsupportedFlavorException);
                                unsupportedFlavorException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                Common.logException("Error:", iOException);
                                iOException.printStackTrace();
                            }
                        }
                        finally {
                            JProjectView.BLOCK_UPDATE = false;
                            JProjectViewGantt.this.updateToolbar();
                        }
                    }
                }
            }
        };
        this.pasteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("paste"));
        this.pasteAction.putValue("AcceleratorKey", keyStroke14);
        this.expandAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/expand.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt.this.gantt.getTreeTable().expandAll();
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("expandAll") + " (Cmmd-+)" : Common.I18N_ACTIONS.getString("expandAll") + " (Ctrl-+)";
        this.expandAllAction.putValue("ShortDescription", string);
        this.expandAllAction.putValue("AcceleratorKey", keyStroke7);
        this.collapseAllAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/collapse.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt.this.gantt.getTreeTable().collapseAll();
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("collapseAll") + " (Cmmd--)" : Common.I18N_ACTIONS.getString("collapseAll") + " (Ctrl--)";
        this.collapseAllAction.putValue("ShortDescription", string);
        this.collapseAllAction.putValue("AcceleratorKey", keyStroke8);
        this.gotoAction = new GotoAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/go_to.png"))){};
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.focusOn") + " (Cmmd-G)" : Common.I18N_ACTIONS.getString("task.focusOn") + " (Ctrl-G)";
        this.gotoAction.putValue("ShortDescription", string);
        this.gotoAction.putValue("AcceleratorKey", keyStroke9);
        this.linkAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/link.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JProjectView.BLOCK_UPDATE = true;
                try {
                    Cloneable cloneable;
                    int[] nArray = JProjectViewGantt.this.gantt.getTreeTable().getSelectedRows();
                    LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
                    for (int i = 0; i < nArray.length; ++i) {
                        cloneable = (Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(nArray[i]).getLastPathComponent();
                        if (((Task)cloneable).isEmpty()) continue;
                        linkedList.add(cloneable);
                    }
                    if (linkedList.size() > 1) {
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)linkedList.get(0));
                        cloneable = new LinkedList();
                        for (int i = 0; i < linkedList.size() - 1; ++i) {
                            Task task = (Task)linkedList.get(i);
                            Task task2 = (Task)linkedList.get(i + 1);
                            Company company = task.getCompany();
                            Dependency dependency = new Dependency(company.getIdGenerator().getNewId());
                            dependency.setPredecessor(task);
                            dependency.setSuccessor(task2);
                            dependency.adjustDependencyForSplit();
                            try {
                                if (!Task.addDependency(dependency, true)) continue;
                                TaskAddDependencyEdit taskAddDependencyEdit = new TaskAddDependencyEdit(dependency, "09/11/09 13:02:02");
                                cloneable.add(dependency);
                                extendedCompoundEdit.addEdit(taskAddDependencyEdit);
                                continue;
                            }
                            catch (CircularRelationshipException circularRelationshipException) {
                                Common.logException("Error:", circularRelationshipException);
                                JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                                Iterator iterator = cloneable.iterator();
                                while (iterator.hasNext()) {
                                    Dependency dependency2 = (Dependency)iterator.next();
                                    Task.removeDependency(dependency2);
                                }
                                TaskPlanner.rescheduleTree((Task)linkedList.get(0));
                                JProjectView.BLOCK_UPDATE = false;
                                JProjectViewGantt.this.updateToolbar();
                                return;
                            }
                        }
                        if (cloneable.size() > 0) {
                            extendedCompoundEdit.end();
                            TaskPlanner.rescheduleTree((Task)linkedList.get(0));
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                            JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                        }
                    }
                }
                finally {
                    JProjectView.BLOCK_UPDATE = false;
                    JProjectViewGantt.this.updateToolbar();
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.link") + " (Cmmd-L)" : Common.I18N_ACTIONS.getString("task.link") + " (Ctrl-L)";
        this.linkAction.putValue("ShortDescription", string);
        this.linkAction.putValue("AcceleratorKey", keyStroke10);
        this.unlinkAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/unlink.png"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JProjectView.BLOCK_UPDATE = true;
                try {
                    Task task;
                    int n;
                    int[] nArray = JProjectViewGantt.this.gantt.getTreeTable().getSelectedRows();
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(JProjectViewGantt.this.project);
                    LinkedList<Task> linkedList = new LinkedList<Task>();
                    for (n = 0; n < nArray.length; ++n) {
                        task = (Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(nArray[n]).getLastPathComponent();
                        if (task.isEmpty() || task.isParentSplitted()) continue;
                        linkedList.add(task);
                    }
                    for (n = 0; n < linkedList.size(); ++n) {
                        task = (Task)linkedList.get(n);
                        for (int i = 0; i < linkedList.size(); ++i) {
                            UndoableEditEvent undoableEditEvent;
                            TaskRemoveDependencyEdit taskRemoveDependencyEdit;
                            Dependency dependency;
                            int n2;
                            Task task2 = (Task)linkedList.get(i);
                            if (task.equals(task2)) continue;
                            Dependency[] dependencyArray = task.getSuccessorDependencies().toArray(new Dependency[0]);
                            for (n2 = 0; n2 < dependencyArray.length; ++n2) {
                                dependency = dependencyArray[n2];
                                if (!dependency.getSuccessor().equals(task2)) continue;
                                taskRemoveDependencyEdit = new TaskRemoveDependencyEdit(dependency, "01-10-2009 19:26:01");
                                Task.removeDependency(dependency);
                                extendedCompoundEdit.addEdit(taskRemoveDependencyEdit);
                                undoableEditEvent = new UndoableEditEvent(this, taskRemoveDependencyEdit);
                                JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                            }
                            dependencyArray = task2.getSuccessorDependencies().toArray(new Dependency[0]);
                            for (n2 = 0; n2 < dependencyArray.length; ++n2) {
                                dependency = dependencyArray[n2];
                                if (!dependency.getSuccessor().equals(task)) continue;
                                taskRemoveDependencyEdit = new TaskRemoveDependencyEdit(dependency, "01-10-2009 19:26:02");
                                Task.removeDependency(dependency);
                                extendedCompoundEdit.addEdit(taskRemoveDependencyEdit);
                                undoableEditEvent = new UndoableEditEvent(this, taskRemoveDependencyEdit);
                                JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                            }
                        }
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree(JProjectViewGantt.this.project);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    JProjectViewGantt.this.fireUndoableEditHappened(undoableEditEvent);
                }
                finally {
                    JProjectView.BLOCK_UPDATE = false;
                    JProjectViewGantt.this.updateToolbar();
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("task.unlink") + " (Cmmd-U)" : Common.I18N_ACTIONS.getString("task.unlink") + " (Ctrl-U)";
        this.unlinkAction.putValue("ShortDescription", string);
        this.unlinkAction.putValue("AcceleratorKey", keyStroke11);
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewGantt.this.taskView.isVisible()) {
                    JProjectViewGantt.this.taskView.setVisible(true);
                    JProjectViewGantt.this.infoButton.setSelected(true);
                    JProjectViewGantt.this.infoItem.setSelected(true);
                    JProjectViewGantt.this.splitPane.setDividerLocation(-1);
                    JProjectViewGantt.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewGantt.this.taskView.setVisible(false);
                    JProjectViewGantt.this.infoButton.setSelected(false);
                    JProjectViewGantt.this.infoItem.setSelected(false);
                    JProjectViewGantt.this.splitPane.setDividerSize(0);
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.detailsAction.putValue("AcceleratorKey", keyStroke15);
        this.splitAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/break_task.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Common.getApplication().setCursor(JProjectViewGantt.this.BREAK_TASK_CURSOR);
                JProjectViewGantt.this.gantt.getArea().setSplit(true);
            }
        };
        this.splitAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("task.break"));
        this.catchUpAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/catch_up.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                Task[] taskArray;
                LinkedList<Task> linkedList = new LinkedList<Task>();
                int[] nArray = JProjectViewGantt.this.gantt.getTreeTable().getSelectedRows();
                int n = JProjectViewGantt.this.gantt.getTreeTable().getSelectedRowCount();
                if (n != 0) {
                    Arrays.sort(nArray);
                    for (int i = 0; i < nArray.length; ++i) {
                        Task task = (Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(nArray[i]).getLastPathComponent();
                        if (task.isEmpty()) continue;
                        linkedList.add(task);
                    }
                    taskArray = linkedList.toArray(new Task[0]);
                    for (int i = 0; i < taskArray.length; ++i) {
                        Task task = taskArray[i];
                        if (!task.isDescendent(linkedList)) continue;
                        linkedList.remove(task);
                    }
                }
                taskArray = new JCatchUpDialog(JProjectViewGantt.this, linkedList, JProjectViewGantt.this.project);
                taskArray.setVisible(true);
            }
        };
        this.catchUpAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("updateCompletion"));
        this.levelingAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/splitGantt.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeScaleManager timeScaleManager;
                TimeScaleManager timeScaleManager2 = JProjectViewGantt.this.gantt.getArea().getTimeScaleManager();
                if (!JProjectViewGantt.this.resourceSheetView.isVisible()) {
                    timeScaleManager = new SheetScaleManager(timeScaleManager2);
                    JProjectViewGantt.this.resourceSheetView.setVisible(true);
                    JProjectViewGantt.this.levelingButton.setSelected(true);
                    JProjectViewGantt.this.levelingSplitPane.setDividerLocation(-1);
                    JProjectViewGantt.this.levelingSplitPane.setDividerSize(5);
                } else {
                    timeScaleManager = new GanttScaleManager(timeScaleManager2);
                    JProjectViewGantt.this.resourceSheetView.setVisible(false);
                    JProjectViewGantt.this.levelingButton.setSelected(false);
                    JProjectViewGantt.this.levelingSplitPane.setDividerSize(0);
                }
                JProjectViewGantt.this.gantt.getArea().setTimeScaleManager(timeScaleManager);
                JProjectViewGantt.this.resourceSheetView.getResourceSheet().getArea().setTimeScaleManager(timeScaleManager);
                JProjectViewGantt.this.zoomInButton.setScaleManager(timeScaleManager);
                JProjectViewGantt.this.zoomOutButton.setScaleManager(timeScaleManager);
            }
        };
        this.levelingAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("details.leveling"));
        ActionMap actionMap = this.gantt.getTreeTable().getActionMap();
        actionMap.put("insert", this.insertAction);
        actionMap.put("delete", this.deleteAction);
        actionMap.put("indent", this.indentAction);
        actionMap.put("outdent", this.outdentAction);
        actionMap.put("up", this.upAction);
        actionMap.put("down", this.downAction);
        actionMap.put("link", this.linkAction);
        actionMap.put("unlink", this.unlinkAction);
        actionMap.put("cut", this.cutAction);
        actionMap.put("copy", this.copyAction);
        actionMap.put("paste", this.pasteAction);
        actionMap.put("expandAll", this.expandAllAction);
        actionMap.put("collapseAll", this.collapseAllAction);
        actionMap.put("goto", this.gotoAction);
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.gantt.getTreeTable().getInputMap(1);
        inputMap.put(keyStroke, "insert");
        inputMap.put(keyStroke2, "delete");
        inputMap.put(keyStroke3, "indent");
        inputMap.put(keyStroke4, "outdent");
        inputMap.put(keyStroke5, "up");
        inputMap.put(keyStroke6, "down");
        inputMap.put(keyStroke10, "link");
        inputMap.put(keyStroke11, "unlink");
        inputMap.put(keyStroke12, "cut");
        inputMap.put(keyStroke13, "copy");
        inputMap.put(keyStroke14, "paste");
        inputMap.put(keyStroke7, "expandAll");
        inputMap.put(keyStroke8, "collapseAll");
        inputMap.put(keyStroke9, "goto");
        inputMap.put(keyStroke15, "details");
        JMenuItem jMenuItem = new JMenuItem(this.insertAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("insertLine"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.insertSubtaskAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("subtask.insert"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.newTaskAction);
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.delete"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.indentAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.indent"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.outdentAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.outdent"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.upAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.up"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.downAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.down"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.cutAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("cut"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.copyAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("copy"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.pasteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("paste"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.gotoAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.focusOn"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.linkAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.link"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.unlinkAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("task.unlink"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.task"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setToolTipText(Common.I18N_ACTIONS.getString("details.tooltip"));
        this.infoItem.setAccelerator(keyStroke15);
        this.infoItem.setSelected(false);
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt.this.infoButton.doClick();
            }
        });
        this.popupMenu.add(this.infoItem);
        this.gotoTaskAction = new GotoTaskAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/selectTaskLine.png"))){};
        this.gotoTaskAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("selectTaskInGantt"));
        jMenuItem = new JMenuItem(this.gotoTaskAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("selectTaskInGantt"));
        this.resourceSheetView.getPopupMenu().addSeparator();
        this.resourceSheetView.getPopupMenu().add(jMenuItem);
        this.gantt.getTreeTable().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = JProjectViewGantt.this.gantt.getTreeTable().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath[] treePathArray = JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().getSelectionPaths();
                    boolean bl = false;
                    if (treePathArray != null) {
                        for (int i = 0; i < treePathArray.length; ++i) {
                            TreePath treePath2 = treePathArray[i];
                            if (!treePath2.equals(treePath)) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().setSelectionPath(treePath);
                    }
                    JProjectViewGantt.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected void createToolBar() {
        super.createToolBar();
        this.setPopup();
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.breakButton = new JButton(this.splitAction);
        this.breakButton.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                Common.getApplication().setCursor(Cursor.getDefaultCursor());
                JProjectViewGantt.this.gantt.getArea().setSplit(false);
            }
        });
        this.insertTaskButton = new JButton(this.taskInsertAction);
        this.insertTaskButton.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                Common.getApplication().setCursor(Cursor.getDefaultCursor());
                JProjectViewGantt.this.gantt.getArea().setInsertTask(false);
            }
        });
        JButton jButton = new JButton(this.catchUpAction);
        jButton.setFocusable(false);
        this.levelingButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/splitGantt.png")), false);
        this.levelingButton.setAction(this.levelingAction);
        this.showCriticalPathButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/critical.png")), false);
        this.showCriticalPathButton.setToolTipText(Common.I18N_ACTIONS.getString("criticalPath"));
        this.showCriticalPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt.this.project.getCompany().setShowCriticalPath(JProjectViewGantt.this.showCriticalPathButton.isSelected());
                JProjectViewGantt.this.gantt.getArea().repaint();
            }
        });
        JButton jButton2 = new JButton();
        this.zoomInButton = new ZoomDropDownButton(jButton2, this.gantt.getArea().getTimeScaleManager());
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif")));
        jButton2.setToolTipText(Common.I18N_ACTIONS.getString("zoomIn") + " (Ctrl + mouse wheel up)");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt.this.gantt.getArea().getTimeScaleManager().zoomIn();
            }
        });
        JButton jButton3 = new JButton();
        this.zoomOutButton = new ZoomDropDownButton(jButton3, this.gantt.getArea().getTimeScaleManager());
        jButton3.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif")));
        jButton3.setToolTipText(Common.I18N_ACTIONS.getString("zoomOut") + " (Ctrl + mouse wheel down)");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt.this.gantt.getArea().getTimeScaleManager().zoomOut();
            }
        });
        this.assignResourceButton = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/assign.png")));
        this.assignResourceButton.setToolTipText(Common.I18N_ACTIONS.getString("assignResources"));
        this.assignResourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewGantt.this.taskView.setSelectedIndex(3);
                JProjectViewGantt.this.showInfo();
            }
        });
        this.insertAction.setEnabled(false);
        this.insertSubtaskAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.indentAction.setEnabled(false);
        this.outdentAction.setEnabled(false);
        this.upAction.setEnabled(false);
        this.downAction.setEnabled(false);
        this.gotoAction.setEnabled(false);
        this.gotoTaskAction.setEnabled(false);
        this.linkAction.setEnabled(false);
        this.unlinkAction.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        JButton jButton4 = new JButton(this.insertAction);
        jButton4.setFocusable(false);
        this.toolBar.add(jButton4);
        JButton jButton5 = new JButton(this.insertSubtaskAction);
        jButton5.setFocusable(false);
        this.toolBar.add(jButton5);
        JButton jButton6 = new JButton(this.deleteAction);
        jButton6.setFocusable(false);
        this.toolBar.addSeparator();
        JButton jButton7 = new JButton(this.indentAction);
        jButton7.setFocusable(false);
        this.toolBar.add(jButton7);
        JComponent jComponent = new JButton(this.outdentAction);
        jComponent.setFocusable(false);
        this.toolBar.add(jComponent);
        JButton jButton8 = new JButton(this.upAction);
        jButton8.setFocusable(false);
        this.toolBar.add(jButton8);
        JButton jButton9 = new JButton(this.downAction);
        jButton9.setFocusable(false);
        this.toolBar.add(jButton9);
        jButton4 = new JButton(this.expandAllAction);
        jButton4.setFocusable(false);
        this.toolBar.add(jButton4);
        jButton5 = new JButton(this.collapseAllAction);
        jButton5.setFocusable(false);
        this.toolBar.add(jButton5);
        this.toolBar.addSeparator();
        jButton6 = new JButton(this.cutAction);
        jButton6.setFocusable(false);
        jButton7 = new JButton(this.copyAction);
        jButton7.setFocusable(false);
        jComponent = new JButton(this.pasteAction);
        jComponent.setFocusable(false);
        jButton8 = new JButton();
        this.linkButton = new DependencyDropDownButton(jButton8, this);
        this.linkButton.addToToolBar(this.toolBar);
        jButton8.setFocusable(false);
        jButton8.setAction(this.linkAction);
        jButton9 = new JButton(this.unlinkAction);
        jButton9.setFocusable(false);
        this.toolBar.add(jButton9);
        jButton6 = new JButton(this.gotoAction);
        jButton6.setFocusable(false);
        this.toolBar.add(jButton6);
        jButton7 = new JButton(this.gotoTaskAction);
        jButton7.setFocusable(false);
        this.resourceSheetView.getToolBar().add(jButton7);
        this.toolBar.add(this.showCriticalPathButton);
        this.toolBar.add(this.assignResourceButton);
        this.toolBar.add(jButton);
        this.levelingButton.setFocusable(false);
        this.infoButton.setFocusable(false);
        this.toolBar.setFloatable(false);
        if (SystemUtilities.isOSMac()) {
            this.toolBar.setRollover(false);
        } else {
            this.toolBar.setRollover(true);
        }
        this.toolBar.add(this.showCriticalPathButton);
        this.toolBar.add(this.breakButton);
        this.zoomInButton.addToToolBar(this.toolBar);
        this.zoomOutButton.addToToolBar(this.toolBar);
        this.toolBar.add(this.levelingButton);
        this.toolBar.add(this.infoButton);
        jComponent = new JToolBar();
        ((JToolBar)jComponent).setFloatable(false);
        if (SystemUtilities.isOSMac()) {
            ((JToolBar)jComponent).setRollover(false);
        } else {
            ((JToolBar)jComponent).setRollover(true);
        }
        jButton8 = new JButton(this.gantt.getArea().getChartArea().getCalendaristicAction());
        jComponent.add(jButton8);
        jButton9 = new JButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/conflict.png")));
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Task task = JProjectViewGantt.this.project.getCompany().getConflictManager().getConflictAt(0).getTask();
                if (!task.getProjectTask().equals(JProjectViewGantt.this.project) && !task.getProjectTask().isDescendent(JProjectViewGantt.this.project)) {
                    Common.getApplication().getWorkspace().getJProject().setCurrentProject(JProjectViewGantt.this.project.getCompany().getRootTask());
                    JProjectViewGantt.this.revalidate();
                }
                TreePath treePath = new TreePath(task.getPath(JProjectViewGantt.this.project).toArray());
                JProjectViewGantt.this.gantt.getTreeTable().scrollPathToVisible(treePath);
                JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().setSelectionPath(treePath);
            }
        });
        this.conflictButton = new ConflictDropDownButton(jButton9, this);
        this.conflictButton.addToToolBar((JToolBar)jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder());
        this.gantt.getArea().getDownScrollPane().add("HorizontalLeft", jComponent);
    }

    protected void updateDetailsAndToolbar() {
        boolean bl;
        int n;
        int[] nArray = this.gantt.getTreeTable().getSelectedRows();
        int n2 = this.gantt.getTreeTable().getSelectedRowCount();
        if (n2) {
            int n3;
            Object object2;
            int n4;
            boolean bl2 = true;
            n = 1;
            bl = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = false;
            Arrays.sort(nArray);
            LinkedList<Task> linkedList = new LinkedList<Task>();
            for (int i = 0; i < nArray.length; ++i) {
                linkedList.add((Task)this.gantt.getTreeTable().getPathForRow(nArray[i]).getLastPathComponent());
            }
            Task[] taskArray = linkedList.toArray(new Task[0]);
            for (n4 = 0; n4 < taskArray.length; ++n4) {
                object2 = taskArray[n4];
                if (!((Task)object2).isEmpty()) {
                    bl5 = true;
                    bl6 = true;
                }
                if (!((Task)object2).isDescendent(linkedList)) continue;
                linkedList.remove(object2);
            }
            n4 = 0;
            if (linkedList.size() > 0) {
                object2 = (Task)linkedList.get(0);
                if (object2.equals(this.project)) {
                    bl2 = false;
                }
                if (((Task)object2).isEmpty() || ((Task)object2).getParent() == null || ((Task)object2).isParentSplitted()) {
                    n4 = 0;
                } else {
                    Task object3 = ((Task)object2).getParent();
                    for (n3 = object3.getChildIndex((Task)object2) - 1; n3 >= 0; --n3) {
                        Task task = object3.getChildAt(n3);
                        if (task.isEmpty()) continue;
                        if (task.isSplitted()) break;
                        n4 = 1;
                        break;
                    }
                }
            }
            for (Task task : linkedList) {
                Task task2 = task.getParent();
                if (task.isEmpty() || task2 == null || task.isParentSplitted()) {
                    n = 0;
                    bl = false;
                    bl3 = false;
                    bl4 = false;
                    break;
                }
                if (task.isProject()) {
                    n = 0;
                    bl = false;
                }
                bl = bl && !task2.equals((Task)this.gantt.getTreeTable().getTreeTableModel().getRoot());
                bl3 = bl3 && task2.getChildIndex(task) != 0;
                bl4 = bl4 && task2.getChildIndex(task) != task2.getChildNumber() - 1;
                n = n != 0 && n4 != 0 ? 1 : 0;
            }
            this.deleteAction.setEnabled(bl2);
            this.outdentAction.setEnabled(bl);
            this.upAction.setEnabled(bl3);
            this.downAction.setEnabled(bl4);
            this.indentAction.setEnabled(n != 0);
            this.cutAction.setEnabled(bl5);
            this.copyAction.setEnabled(bl6);
            object2 = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (object2 != null && (object2.isDataFlavorSupported(CustomFlavor.taskListFlavor) || object2.isDataFlavorSupported(DataFlavor.stringFlavor))) {
                if (n2) {
                    Task task = (Task)this.gantt.getTreeTable().getPathForRow(this.gantt.getTreeTable().getSelectedRow()).getLastPathComponent();
                    this.pasteAction.setEnabled(!task.isParentSplitted());
                }
            } else {
                this.pasteAction.setEnabled(false);
            }
            int[] nArray2 = this.gantt.getTreeTable().getSelectedRows();
            n3 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                Task task = (Task)this.gantt.getTreeTable().getPathForRow(nArray2[i]).getLastPathComponent();
                if (task.isEmpty()) continue;
                ++n3;
            }
            this.linkAction.setEnabled(n3 > 1);
            this.unlinkAction.setEnabled(n3 > 1);
        } else {
            this.deleteAction.setEnabled(false);
            this.outdentAction.setEnabled(false);
            this.upAction.setEnabled(false);
            this.downAction.setEnabled(false);
            this.indentAction.setEnabled(false);
            this.cutAction.setEnabled(false);
            this.copyAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
        }
        LinkedList<Task> linkedList = new LinkedList<Task>();
        for (n = 0; n < n2; n += 1) {
            bl = nArray[n];
            Task task = (Task)this.gantt.getTreeTable().getPathForRow(bl ? 1 : 0).getLastPathComponent();
            linkedList.add(task);
        }
        this.taskView.setTasks(linkedList);
        if (n2) {
            Task task = (Task)this.gantt.getTreeTable().getPathForRow(this.gantt.getTreeTable().getSelectedRow()).getLastPathComponent();
            if (!task.isEmpty()) {
                this.insertSubtaskAction.setEnabled(!task.isParentSplitted());
                this.gotoAction.setEnabled(true);
            } else {
                this.insertSubtaskAction.setEnabled(false);
                this.gotoAction.setEnabled(false);
            }
            if (task.getParent() != null && !task.isParentSplitted()) {
                this.insertAction.setEnabled(true);
            } else {
                this.insertAction.setEnabled(false);
            }
        } else {
            this.insertSubtaskAction.setEnabled(false);
            this.insertAction.setEnabled(false);
            this.gotoAction.setEnabled(false);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.gantt.print(graphics, pageFormat, n);
    }

    public int getNumberOfPages() {
        return this.gantt.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.gantt.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.gantt.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.gantt.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.gantt.getVerticalNumberOfPages();
    }

    public TaskDetailView getTaskView() {
        return this.taskView;
    }

    public JToggleButton getInfoButton() {
        return this.infoButton;
    }

    public void gotoTask(Task task) {
        this.gotoAction.gotoTask(task);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.taskView.isVisible());
        this.infoItem.setSelected(this.taskView.isVisible());
        this.levelingButton.setSelected(this.resourceSheetView.isVisible());
        TimeScaleManager timeScaleManager = this.gantt.getArea().getTimeScaleManager();
        TimeScaleManager timeScaleManager2 = this.resourceSheetView.isVisible() ? new SheetScaleManager(timeScaleManager) : new GanttScaleManager(timeScaleManager);
        this.gantt.getArea().setTimeScaleManager(timeScaleManager2);
        this.resourceSheetView.getResourceSheet().getArea().setTimeScaleManager(timeScaleManager2);
        this.zoomInButton.setScaleManager(timeScaleManager2);
        this.zoomOutButton.setScaleManager(timeScaleManager2);
    }

    public JToggleButton getShowCriticalPathButton() {
        return this.showCriticalPathButton;
    }

    public JSplitPane getLevelingSplitPane() {
        return this.levelingSplitPane;
    }

    public Dimension getPrintSize() {
        return this.gantt.getPrintSize();
    }

    public JButton getBreakButton() {
        return this.breakButton;
    }

    public Action getCatchUpAction() {
        return this.catchUpAction;
    }

    public JButton getInsertTaskButton() {
        return this.insertTaskButton;
    }

    class GotoTaskAction
    extends AbstractAction {
        public GotoTaskAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().getSelectedRowCount() == 1) {
                int n = JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().getSelectedRow();
                TreePath treePath = JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().getPathForRow(n);
                Object object = treePath.getLastPathComponent();
                if (object instanceof Assignment) {
                    Task task = ((Assignment)object).getTask();
                    if (!task.getProjectTask().equals(JProjectViewGantt.this.project) && !task.getProjectTask().isDescendent(JProjectViewGantt.this.project)) {
                        Common.getApplication().getWorkspace().getJProject().setCurrentProject(JProjectViewGantt.this.project.getCompany().getRootTask());
                        JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().expandPath(treePath);
                        JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().scrollPathToVisible(treePath);
                        JProjectViewGantt.this.resourceSheetView.getResourceSheet().getTreeTable().getTreeSelectionModel().setSelectionPath(treePath);
                        JProjectViewGantt.this.resourceSheetView.getResourceSheet().revalidate();
                        JProjectViewGantt.this.gantt.revalidate();
                    }
                    TreePath treePath2 = new TreePath(task.getPath(JProjectViewGantt.this.project).toArray());
                    JProjectViewGantt.this.gantt.getTreeTable().scrollPathToVisible(treePath2);
                    JProjectViewGantt.this.gantt.getTreeTable().getTreeSelectionModel().setSelectionPath(treePath2);
                }
            }
        }
    }

    class GotoAction
    extends AbstractAction {
        public GotoAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JProjectViewGantt.this.gantt.getTreeTable().getSelectedRowCount() == 1) {
                int n = JProjectViewGantt.this.gantt.getTreeTable().getSelectedRow();
                Task task = (Task)JProjectViewGantt.this.gantt.getTreeTable().getPathForRow(n).getLastPathComponent();
                JProjectViewGantt.this.gantt.getArea().getTimeScaleManager().focusOnDate(task.getStartDate());
            }
        }

        public void gotoTask(Task task) {
            JProjectViewGantt.this.gantt.getArea().getTimeScaleManager().focusOnDate(task.getStartDate());
        }
    }
}

