/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.ui.action.ClientSelection;
import com.sbs.jpm.ui.action.CustomFlavor;
import com.sbs.jpm.ui.component.ClientDetailView;
import com.sbs.jpm.ui.component.JClientsTable;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.model.ClientsTableModel;
import com.sbs.jpm.undo.ClientDeleteEdit;
import com.sbs.jpm.undo.ClientInsertEdit;
import com.sbs.jpm.undo.DeleteEmptyClientsEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.util.ExcelAdapter;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;

public class JProjectViewClients
extends JProjectView
implements CustomPageable {
    private static final long serialVersionUID = 1L;
    private JClientsTable clientTable;
    private ClientDetailView clientView;
    private JRowHeader rowHeader;
    private JToggleButton infoButton;
    private JCheckBoxMenuItem infoItem;
    private Action insertAction;
    private Action deleteAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action detailsAction;
    private JPopupMenu popupMenu;
    private JSplitPane splitPane;

    private JPanel createContentsClientTable() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.clientTable = new JClientsTable();
        this.clientTable.setProjectView(this);
        this.clientTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JProjectViewClients.this.updateToolbar();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.clientTable));
        jScrollPane.getViewport().setBackground(this.clientTable.getBackground());
        this.rowHeader = new JRowHeader((JTable)((Object)this.clientTable));
        jScrollPane.setRowHeaderView(this.rowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 9, 0));
        return jPanel;
    }

    private JPanel createContentsClient() {
        this.clientView = new ClientDetailView();
        this.clientView.setVisible(false);
        return this.clientView;
    }

    protected JPanel createContents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.splitPane = new JSplitPane(0, this.createContentsClientTable(), this.createContentsClient());
        this.splitPane.setResizeWeight(0.7);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.splitPane, "Center");
        this.clientView.setClient(null);
        return jPanel;
    }

    public void setProject(Task task) {
        super.setProject(task);
        this.clientTable.setProject(task);
        this.rowHeader.setTableModel(this.clientTable.getModel());
    }

    protected void createToolBar() {
        super.createToolBar();
        this.setPopup();
        this.infoButton = new JToggleButton(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")), false);
        this.infoButton.setAction(this.detailsAction);
        this.insertAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        JButton jButton = new JButton(this.insertAction);
        jButton.setFocusable(false);
        this.toolBar.add(jButton);
        JButton jButton2 = new JButton(this.deleteAction);
        jButton2.setFocusable(false);
        this.toolBar.add(jButton2);
        this.toolBar.addSeparator();
        JButton jButton3 = new JButton(this.cutAction);
        jButton3.setFocusable(false);
        this.toolBar.add(jButton3);
        JButton jButton4 = new JButton(this.copyAction);
        jButton4.setFocusable(false);
        this.toolBar.add(jButton4);
        JButton jButton5 = new JButton(this.pasteAction);
        jButton5.setFocusable(false);
        this.toolBar.add(jButton5);
        this.toolBar.addSeparator();
        this.toolBar.add(this.infoButton);
    }

    private void setPopup() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke3 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(88, 256) : KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke4 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(67, 256) : KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke5 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(86, 256) : KeyStroke.getKeyStroke(86, 128);
        KeyStroke keyStroke6 = SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(68, 256) : KeyStroke.getKeyStroke(68, 128);
        this.insertAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/insertLine.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JProjectViewClients.this.clientTable.getSelectedRowCount() == 1) {
                    int n = JProjectViewClients.this.clientTable.getSelectedRow();
                    ClientsTableModel clientsTableModel = (ClientsTableModel)JProjectViewClients.this.clientTable.getModel();
                    Company company = clientsTableModel.getCompany();
                    Client client = new Client(company.getIdGenerator().getNewId());
                    ClientInsertEdit clientInsertEdit = new ClientInsertEdit(company, client, n, "06/10/2009 13:14:00");
                    company.addClient(n, client);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, clientInsertEdit);
                    JProjectViewClients.this.fireUndoableEditHappened(undoableEditEvent);
                    JProjectViewClients.this.clientTable.setRowSelectionInterval(n, n);
                }
            }
        };
        this.insertAction.putValue("AcceleratorKey", keyStroke);
        String string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("insertLine") : Common.I18N_ACTIONS.getString("insertLine") + " (Insert)";
        this.insertAction.putValue("ShortDescription", string);
        this.deleteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/delete.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewClients.this.clientTable.getSelectedRows();
                int n = nArray.length;
                int n2 = nArray[n - 1];
                ClientsTableModel clientsTableModel = (ClientsTableModel)JProjectViewClients.this.clientTable.getModel();
                Company company = clientsTableModel.getCompany();
                LinkedList<Client> linkedList = new LinkedList<Client>();
                for (int i = 0; i < nArray.length; ++i) {
                    int n3 = nArray[i];
                    if (n3 >= company.getClientsNumber()) continue;
                    linkedList.add(company.getClientAt(n3));
                }
                ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                for (Client client : linkedList) {
                    int n4 = company.getClientIndex(client);
                    ClientDeleteEdit clientDeleteEdit = new ClientDeleteEdit(company, client, n4, "06/10/2009 13:15:00");
                    company.removeClient(client);
                    List<Client> list = company.removeEmptyClients();
                    DeleteEmptyClientsEdit deleteEmptyClientsEdit = new DeleteEmptyClientsEdit(company, list, 1);
                    extendedCompoundEdit.addEdit(clientDeleteEdit);
                    extendedCompoundEdit.addEdit(deleteEmptyClientsEdit);
                }
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                JProjectViewClients.this.fireUndoableEditHappened(undoableEditEvent);
                int n5 = n2 - n + 1;
                if (n5 != 0 && n2 == JProjectViewClients.this.clientTable.getRowCount() - 1) {
                    --n5;
                }
                JProjectViewClients.this.clientTable.setRowSelectionInterval(n5, n5);
            }
        };
        this.deleteAction.putValue("AcceleratorKey", keyStroke2);
        this.deleteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("client.delete") + " (Delete)");
        this.cutAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewClients.this.clientTable.getSelectedRows();
                if (JProjectViewClients.this.clientTable.getSelectedRowCount() != 0) {
                    Object object;
                    Company company = ((ClientsTableModel)JProjectViewClients.this.clientTable.getModel()).getCompany();
                    Arrays.sort(nArray);
                    LinkedList<Client> linkedList = new LinkedList<Client>();
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] >= company.getClientsNumber() || ((Client)(object = company.getClientAt(nArray[i]))).isEmpty()) continue;
                        linkedList.add((Client)object);
                    }
                    List<Client> list = Company.cloneClients(linkedList, JProjectViewClients.this.project.getCompany().getIdGenerator());
                    object = new ClientSelection(list, ExcelAdapter.toString(JProjectViewClients.this.clientTable));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                    JProjectView.BLOCK_UPDATE = true;
                    try {
                        for (Client client : linkedList) {
                            ClientDeleteEdit clientDeleteEdit = new ClientDeleteEdit(company, client, company.getClientIndex(client), "06/10/2009 13:15:01");
                            company.removeClient(client);
                            extendedCompoundEdit.addEdit(clientDeleteEdit);
                            company.removeEmptyClients();
                        }
                        extendedCompoundEdit.end();
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        JProjectViewClients.this.fireUndoableEditHappened(undoableEditEvent);
                        int n = 0;
                        for (Client client : linkedList) {
                            n = company.getClientIndex(client);
                            JProjectViewClients.this.clientTable.getSelectionModel().addSelectionInterval(n, n);
                        }
                        JProjectViewClients.this.clientTable.scrollRowToVisible(n);
                    }
                    finally {
                        JProjectView.BLOCK_UPDATE = false;
                        JProjectViewClients.this.updateToolbar();
                    }
                }
            }
        };
        this.cutAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("cut"));
        this.cutAction.putValue("AcceleratorKey", keyStroke3);
        this.copyAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif"))){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JProjectViewClients.this.clientTable.getSelectedRows();
                if (JProjectViewClients.this.clientTable.getSelectedRowCount() != 0) {
                    Object object;
                    Company company = ((ClientsTableModel)JProjectViewClients.this.clientTable.getModel()).getCompany();
                    Arrays.sort(nArray);
                    LinkedList<Client> linkedList = new LinkedList<Client>();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] >= company.getClientsNumber() || ((Client)(object = company.getClientAt(nArray[i]))).isEmpty()) continue;
                        linkedList.add((Client)object);
                    }
                    List<Client> list = Company.cloneClients(linkedList, JProjectViewClients.this.project.getCompany().getIdGenerator());
                    object = new ClientSelection(list, ExcelAdapter.toString(JProjectViewClients.this.clientTable));
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, null);
                }
            }
        };
        this.copyAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("copy"));
        this.copyAction.putValue("AcceleratorKey", keyStroke4);
        this.pasteAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                block15: {
                    if (JProjectViewClients.this.clientTable.getSelectedRowCount() != 0) {
                        JProjectView.BLOCK_UPDATE = true;
                        try {
                            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                            List list = null;
                            try {
                                if (transferable == null) break block15;
                                if (transferable.isDataFlavorSupported(CustomFlavor.clientListFlavor)) {
                                    Company company;
                                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                                    int n = JProjectViewClients.this.clientTable.getSelectedRow();
                                    if (n > (company = ((ClientsTableModel)JProjectViewClients.this.clientTable.getModel()).getCompany()).getClientsNumber()) {
                                        ((ClientsTableModel)JProjectViewClients.this.clientTable.getModel()).insertEmptyClients(n - company.getClientsNumber(), extendedCompoundEdit);
                                    }
                                    list = (List)transferable.getTransferData(CustomFlavor.clientListFlavor);
                                    List<Client> list2 = Company.cloneClients(list, JProjectViewClients.this.project.getCompany().getIdGenerator());
                                    JProjectViewClients.this.clientTable.getSelectionModel().clearSelection();
                                    for (Client client : list2) {
                                        ClientInsertEdit clientInsertEdit = new ClientInsertEdit(company, client, n, "06/10/2009 13:14:01");
                                        extendedCompoundEdit.addEdit(clientInsertEdit);
                                        company.addClient(n, client);
                                        JProjectViewClients.this.clientTable.getSelectionModel().addSelectionInterval(n, n);
                                        ++n;
                                    }
                                    extendedCompoundEdit.end();
                                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                                    JProjectViewClients.this.fireUndoableEditHappened(undoableEditEvent);
                                    break block15;
                                }
                                if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block15;
                                int n = JProjectViewClients.this.clientTable.getSelectedRows()[0];
                                int n2 = JProjectViewClients.this.clientTable.getSelectedColumns()[0];
                                try {
                                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
                                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                                    int n3 = 0;
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String string2 = stringTokenizer.nextToken();
                                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
                                        int n4 = 0;
                                        while (stringTokenizer2.hasMoreTokens()) {
                                            String string3 = stringTokenizer2.nextToken();
                                            if (n + n3 < JProjectViewClients.this.clientTable.getRowCount() && n2 + n4 < JProjectViewClients.this.clientTable.getColumnCount()) {
                                                JProjectViewClients.this.clientTable.setValueAt(string3, n + n3, n2 + n4);
                                            }
                                            ++n4;
                                        }
                                        ++n3;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Common.logException("Error:", exception);
                                }
                            }
                            catch (UnsupportedFlavorException unsupportedFlavorException) {
                                Common.logException("Error:", unsupportedFlavorException);
                                unsupportedFlavorException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                Common.logException("Error:", iOException);
                                iOException.printStackTrace();
                            }
                        }
                        finally {
                            JProjectView.BLOCK_UPDATE = false;
                            JProjectViewClients.this.updateToolbar();
                        }
                    }
                }
            }
        };
        this.pasteAction.putValue("ShortDescription", Common.I18N_ACTIONS.getString("paste"));
        this.pasteAction.putValue("AcceleratorKey", keyStroke5);
        this.detailsAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png"))){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JProjectViewClients.this.clientView.isVisible()) {
                    JProjectViewClients.this.clientView.setVisible(true);
                    JProjectViewClients.this.infoButton.setSelected(true);
                    JProjectViewClients.this.infoItem.setSelected(true);
                    JProjectViewClients.this.splitPane.setDividerLocation(-1);
                    JProjectViewClients.this.splitPane.setDividerSize(5);
                } else {
                    JProjectViewClients.this.clientView.setVisible(false);
                    JProjectViewClients.this.infoButton.setSelected(false);
                    JProjectViewClients.this.infoItem.setSelected(false);
                    JProjectViewClients.this.splitPane.setDividerSize(0);
                }
            }
        };
        string = SystemUtilities.isOSMac() ? Common.I18N_ACTIONS.getString("details.tooltip") + " (Cmmd-D)" : Common.I18N_ACTIONS.getString("details.tooltip") + " (Ctrl-D)";
        this.detailsAction.putValue("ShortDescription", string);
        this.detailsAction.putValue("AcceleratorKey", keyStroke6);
        ActionMap actionMap = this.clientTable.getActionMap();
        actionMap.put("insert", this.insertAction);
        actionMap.put("delete", this.deleteAction);
        actionMap.put("cut", this.cutAction);
        actionMap.put("copy", this.copyAction);
        actionMap.put("paste", this.pasteAction);
        actionMap.put("details", this.detailsAction);
        InputMap inputMap = this.clientTable.getInputMap(1);
        inputMap.put(keyStroke, "insert");
        inputMap.put(keyStroke2, "delete");
        inputMap.put(keyStroke3, "cut");
        inputMap.put(keyStroke4, "copy");
        inputMap.put(keyStroke5, "paste");
        inputMap.put(keyStroke6, "details");
        JMenuItem jMenuItem = new JMenuItem(this.insertAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("insertLine"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.deleteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("client.delete"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        jMenuItem = new JMenuItem(this.cutAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("cut"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.copyAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("copy"));
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this.pasteAction);
        jMenuItem.setText(Common.I18N_ACTIONS.getString("paste"));
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        this.infoItem = new JCheckBoxMenuItem(Common.I18N_ACTIONS.getString("details.client"), new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/info.png")));
        this.infoItem.setAccelerator(keyStroke6);
        this.infoItem.setSelected(false);
        this.infoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JProjectViewClients.this.infoButton.doClick();
            }
        });
        this.popupMenu.add(this.infoItem);
        this.clientTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = JProjectViewClients.this.clientTable.rowAtPoint(mouseEvent.getPoint());
                    int[] nArray = JProjectViewClients.this.clientTable.getSelectedRows();
                    boolean bl = false;
                    if (nArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n2 = nArray[i];
                            if (n2 != n) continue;
                            bl = true;
                        }
                    }
                    if (!bl) {
                        JProjectViewClients.this.clientTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    JProjectViewClients.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    protected void updateDetailsAndToolbar() {
        Object object;
        Client client;
        int n;
        int n2;
        Object object2;
        this.clientView.setClient(null);
        int n3 = this.clientTable.getSelectedRowCount();
        int[] nArray = this.clientTable.getSelectedRows();
        if (n3 != 0) {
            object2 = ((ClientsTableModel)this.clientTable.getModel()).getCompany();
            if (n3 == 1) {
                if (nArray[0] < ((Company)object2).getClientsNumber()) {
                    this.insertAction.setEnabled(true);
                } else {
                    this.insertAction.setEnabled(false);
                }
            } else {
                this.insertAction.setEnabled(false);
            }
            n2 = 0;
            n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] >= ((Company)object2).getClientsNumber() || (client = ((Company)object2).getClientAt(nArray[i])).isEmpty()) continue;
                n2 = 1;
                n = 1;
            }
            this.deleteAction.setEnabled(true);
            this.cutAction.setEnabled(n2 != 0);
            this.copyAction.setEnabled(n != 0);
            object = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (object != null && (object.isDataFlavorSupported(CustomFlavor.clientListFlavor) || object.isDataFlavorSupported(DataFlavor.stringFlavor))) {
                this.pasteAction.setEnabled(true);
            } else {
                this.pasteAction.setEnabled(false);
            }
        } else {
            this.insertAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.cutAction.setEnabled(false);
            this.copyAction.setEnabled(false);
            this.pasteAction.setEnabled(false);
        }
        object2 = this.clientTable.getSelectionModel();
        n2 = object2.getMinSelectionIndex();
        n = object2.getMaxSelectionIndex();
        if (n2 == n && n2 != -1 && n2 < ((Company)(object = ((ClientsTableModel)this.clientTable.getModel()).getCompany())).getClientsNumber()) {
            client = ((Company)object).getClientAt(n2);
            this.clientView.setClient(client);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.rowHeader.setBackground(Color.WHITE);
        int n2 = this.clientTable.print(graphics, pageFormat, n);
        this.rowHeader.setBackground((Color)UIManager.get("TableHeader.background"));
        return n2;
    }

    public int getNumberOfPages() {
        return this.clientTable.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.clientTable.getPageFormat(n);
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.clientTable.getPrintable(n);
    }

    public int getHorizontalNumberOfPages() {
        return this.clientTable.getHorizontalNumberOfPages();
    }

    public int getVerticalNumberOfPages() {
        return this.clientTable.getVerticalNumberOfPages();
    }

    public Dimension getPrintSize() {
        return this.clientTable.getPrintSize();
    }

    public JClientsTable getClientTable() {
        return this.clientTable;
    }

    public JRowHeader getRowHeader() {
        return this.rowHeader;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void updateInfoButtons() {
        this.infoButton.setSelected(this.clientView.isVisible());
        this.infoItem.setSelected(this.clientView.isVisible());
    }

    public JToggleButton getInfoButton() {
        return this.infoButton;
    }
}

