/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.view;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.undo.ProjectAssumptionsEdit;
import com.sbs.jpm.undo.ProjectConstraintsEdit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;

public class JProjectViewAssumptions
extends JProjectView {
    private JPanel bodyPanel;
    private int totalVerticalNumPages;
    private int totalHorizontalNumPages;
    private double pageHeight;
    private double pageWidth;
    private JTextArea projectConstraintsArea;
    private JTextArea projectAssumptionsArea;
    private DocumentListener assumptionsListener;
    private DocumentListener constraintsListener;
    private AssumptionsHandler assumptionHandler;
    private ConstraintsHandler constraintsHandler;
    private TaskListener taskHandler = new TaskHandler();

    public JProjectViewAssumptions() {
        this.assumptionHandler = new AssumptionsHandler();
        this.constraintsHandler = new ConstraintsHandler();
        this.assumptionsListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewAssumptions.this.projectAssumptionsArea.getText().equals(JProjectViewAssumptions.this.project.getAssumptions())) {
                    JProjectViewAssumptions.this.project.setAssumptions(JProjectViewAssumptions.this.projectAssumptionsArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewAssumptions.this.projectAssumptionsArea.getText().equals(JProjectViewAssumptions.this.project.getAssumptions())) {
                    JProjectViewAssumptions.this.project.setAssumptions(JProjectViewAssumptions.this.projectAssumptionsArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.constraintsListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewAssumptions.this.projectConstraintsArea.getText().equals(JProjectViewAssumptions.this.project.getConstraints())) {
                    JProjectViewAssumptions.this.project.setConstraints(JProjectViewAssumptions.this.projectConstraintsArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!JProjectViewAssumptions.this.projectConstraintsArea.getText().equals(JProjectViewAssumptions.this.project.getConstraints())) {
                    JProjectViewAssumptions.this.project.setConstraints(JProjectViewAssumptions.this.projectConstraintsArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    protected void updateDetailsAndToolbar() {
    }

    public void setProject(Task task) {
        if (this.project != null) {
            this.project.removeTaskListener(this.taskHandler);
        }
        super.setProject(task);
        if (this.project != null) {
            this.projectAssumptionsArea.setEnabled(true);
            this.projectConstraintsArea.setEnabled(true);
            this.updateValues();
            new JTextComponentUndoHandler(this.projectAssumptionsArea);
            new JTextComponentUndoHandler(this.projectConstraintsArea);
            this.project.addTaskListener(this.taskHandler);
        } else {
            this.projectAssumptionsArea.setEnabled(false);
            this.projectConstraintsArea.setEnabled(false);
            this.updateValues();
        }
    }

    protected JPanel createContents() {
        Insets insets = new Insets(5, 5, 5, 5);
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new GridBagLayout());
        this.projectAssumptionsArea = new JTextArea();
        this.projectAssumptionsArea.setLineWrap(true);
        this.projectAssumptionsArea.setWrapStyleWord(true);
        this.projectConstraintsArea = new JTextArea();
        this.projectConstraintsArea.setLineWrap(true);
        this.projectConstraintsArea.setWrapStyleWord(true);
        this.bodyPanel.add((Component)new JLabel(Common.I18N_RP.getString("project.assumptions") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 5));
        this.bodyPanel.add((Component)new JScrollPane(this.projectAssumptionsArea), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        Dimension dimension = new Dimension(2, 2);
        jPanel.setMinimumSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setPreferredSize(dimension);
        this.bodyPanel.add((Component)jPanel, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        this.bodyPanel.add((Component)new JLabel(Common.I18N_RP.getString("project.constraints") + ":"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.bodyPanel.add((Component)new JScrollPane(this.projectConstraintsArea), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return this.bodyPanel;
    }

    private void updateValues() {
        this.removeListeners();
        if (this.project != null) {
            try {
                this.projectAssumptionsArea.setText(this.project.getAssumptions());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                this.projectConstraintsArea.setText(this.project.getConstraints());
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.projectAssumptionsArea.setText("");
            this.projectConstraintsArea.setText("");
        }
        this.addListeners();
    }

    private void addListeners() {
        this.projectAssumptionsArea.addFocusListener(this.assumptionHandler);
        this.projectConstraintsArea.addFocusListener(this.constraintsHandler);
        this.projectAssumptionsArea.getDocument().addDocumentListener(this.assumptionsListener);
        this.projectConstraintsArea.getDocument().addDocumentListener(this.constraintsListener);
    }

    private void removeListeners() {
        this.projectAssumptionsArea.getDocument().removeDocumentListener(this.assumptionsListener);
        this.projectConstraintsArea.getDocument().removeDocumentListener(this.constraintsListener);
        this.projectAssumptionsArea.removeFocusListener(this.assumptionHandler);
        this.projectConstraintsArea.removeFocusListener(this.constraintsHandler);
    }

    private void computeValues() {
        PageFormat pageFormat = this.getPageFormat(0);
        this.pageHeight = pageFormat.getImageableHeight() * 1.3 / PrintManager.ZOOM - 2.0 - 20.0;
        this.pageWidth = pageFormat.getImageableWidth() * 1.3 / PrintManager.ZOOM - 2.0 - 2.0;
        this.totalVerticalNumPages = (int)Math.ceil((double)this.getHeight() / this.pageHeight);
        this.totalHorizontalNumPages = (int)Math.ceil((double)this.getWidth() / this.pageWidth);
    }

    public int getHorizontalNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages;
    }

    public int getVerticalNumberOfPages() {
        this.computeValues();
        return this.totalVerticalNumPages;
    }

    public Dimension getPrintSize() {
        Dimension dimension = new Dimension();
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public int getNumberOfPages() {
        this.computeValues();
        return this.totalHorizontalNumPages * this.totalVerticalNumPages;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return Common.getApplication().getPageFormat();
    }

    private class ConstraintsHandler
    implements FocusListener {
        private String oldConstraints = "";

        private ConstraintsHandler() {
        }

        private void doIt() {
            String string = JProjectViewAssumptions.this.projectConstraintsArea.getText();
            if (!string.equals(this.oldConstraints)) {
                ProjectConstraintsEdit projectConstraintsEdit = new ProjectConstraintsEdit(JProjectViewAssumptions.this.project, this.oldConstraints, string, "02/10/2009 17:57:00");
                JProjectViewAssumptions.this.project.setConstraints(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, projectConstraintsEdit);
                JProjectViewAssumptions.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldConstraints = JProjectViewAssumptions.this.projectConstraintsArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class AssumptionsHandler
    implements FocusListener {
        private String oldAssumptions = "";

        private AssumptionsHandler() {
        }

        private void doIt() {
            String string = JProjectViewAssumptions.this.projectAssumptionsArea.getText();
            if (!string.equals(this.oldAssumptions)) {
                ProjectAssumptionsEdit projectAssumptionsEdit = new ProjectAssumptionsEdit(JProjectViewAssumptions.this.project, this.oldAssumptions, string, "02/10/2009 17:50:00");
                JProjectViewAssumptions.this.project.setAssumptions(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, projectAssumptionsEdit);
                JProjectViewAssumptions.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldAssumptions = JProjectViewAssumptions.this.projectAssumptionsArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void projectAssumptionsChanged(TaskEvent taskEvent) {
            JProjectViewAssumptions.this.updateValues();
        }

        public void projectConstraintsChanged(TaskEvent taskEvent) {
            JProjectViewAssumptions.this.updateValues();
        }
    }
}

