/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.util;

import com.sbs.jpm.Common;
import com.sbs.util.SystemUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JTextComponentUndoHandler {
    public JTextComponentUndoHandler(JTextComponent jTextComponent) {
        final UndoManager undoManager = new UndoManager();
        Document document = jTextComponent.getDocument();
        document.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        jTextComponent.getActionMap().put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        jTextComponent.getInputMap().put(SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(90, 256) : KeyStroke.getKeyStroke(39, 128), "Undo");
        jTextComponent.getActionMap().put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    Common.logException("Error:", cannotRedoException);
                }
            }
        });
        jTextComponent.getInputMap().put(SystemUtilities.isOSMac() ? KeyStroke.getKeyStroke(89, 256) : KeyStroke.getKeyStroke(39, 128), "Redo");
    }
}

