/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.renderer;

import com.sbs.jpm.ui.treetablechart.time.CostTreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.ResourceSheetData;
import com.sbs.jpm.ui.treetablechart.time.TreeTableManager;
import com.sbs.jpm.ui.treetablechart.time.WorkTreeTableManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ResourceChartDataTypeTableCellRenderer
extends JLabel
implements ListCellRenderer {
    private ResourceSheetData resourceSheetData;

    public ResourceChartDataTypeTableCellRenderer(ResourceSheetData resourceSheetData) {
        this.resourceSheetData = resourceSheetData;
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setForeground(jList.getForeground());
        this.setBackground(new Color(255, 252, 233));
        this.setFont(jList.getFont());
        return this;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        TreeTableManager treeTableManager = this.resourceSheetData.getResourceChart().getArea().getChartArea().getTreeTableManager();
        List<Integer> list = treeTableManager instanceof WorkTreeTableManager ? this.resourceSheetData.getWorkDataList() : (treeTableManager instanceof CostTreeTableManager ? this.resourceSheetData.getCostDataList() : new LinkedList<Integer>());
        for (int i = 1; i <= list.size(); ++i) {
            graphics.drawString(ResourceSheetData.typeAsString(list.get(i - 1)), 0, i * 18 - 3);
        }
        Color color = graphics.getColor();
        Color color2 = UIManager.getColor("Table.gridColor");
        graphics.setColor(color2);
        for (int i = 1; i <= list.size(); ++i) {
            graphics.drawLine(0, i * 18 - 1, this.getWidth(), i * 18 - 1);
        }
        graphics.setColor(color);
    }
}

