/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.renderer;

import com.sbs.jpm.ui.component.renderer.CellDefaultColorAndBorderModel;
import com.sbs.util.SystemUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ComboBoxRenderer
implements TableCellRenderer {
    private JLabel label;
    private JPanel panel = new JPanel();
    private CellDefaultColorAndBorderModel cellColorAndBorderModel;
    private Insets insets = new Insets(0, 0, 0, 0);
    private GetComboButton comboButton;
    private boolean comboShowOnlyAtFocus = true;

    public ComboBoxRenderer(Object[] objectArray, CellDefaultColorAndBorderModel cellDefaultColorAndBorderModel, boolean bl, boolean bl2, boolean bl3) {
        this.label = new JLabel();
        this.label.setOpaque(bl);
        this.label.setHorizontalTextPosition(2);
        this.panel.setOpaque(bl);
        this.cellColorAndBorderModel = cellDefaultColorAndBorderModel;
        this.comboShowOnlyAtFocus = bl3;
        this.comboButton = this.createGetButtonInstance(bl2);
        Insets insets = new Insets(0, 0, 0, 0);
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 1, insets, 0, 0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.panel.setBackground(this.cellColorAndBorderModel.getCellBackgroundColor(jTable, bl, bl2));
        this.label.setBackground(this.cellColorAndBorderModel.getCellBackgroundColor(jTable, bl, bl2));
        this.label.setForeground(this.cellColorAndBorderModel.getCellForegroundColor(jTable, bl, bl2));
        this.panel.setBorder(this.cellColorAndBorderModel.getCellBorder(jTable, bl, bl2));
        this.label.setText(object != null ? object.toString() : "");
        this.label.setFont(jTable.getFont());
        if (this.comboShowOnlyAtFocus) {
            if (bl && bl2) {
                this.panel.add(this.comboButton.getComboButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 22, 3, this.insets, 0, 0));
            } else {
                this.panel.remove(this.comboButton.getComboButton());
            }
        } else if (bl) {
            this.panel.add(this.comboButton.getComboButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 22, 3, this.insets, 0, 0));
        } else {
            this.panel.remove(this.comboButton.getComboButton());
        }
        return this.panel;
    }

    public GetComboButton createGetButtonInstance(boolean bl) {
        String string = UIManager.getLookAndFeel().getID();
        if (string.equals("Metal")) {
            return new DefaultComboBoxButton(bl);
        }
        if (string.equals("Metal")) {
            return new DefaultComboBoxButton(bl);
        }
        if (string.equals("Aqua")) {
            return new DefaultComboBoxButton(bl);
        }
        if (string.equals("JGoodies Plastic 3D")) {
            return new DefaultComboBoxButton(bl);
        }
        if (string.equals("JGoodies Plastic XP")) {
            return new DefaultComboBoxButton(bl);
        }
        if (string.equals("JGoodies Plastic")) {
            return new DefaultComboBoxButton(bl);
        }
        if (string.equals("Windows")) {
            String string2 = System.getProperty("java.version");
            if (SystemUtilities.isOSWindowsXP()) {
                if (string2.compareTo("1.6") < 0) {
                    return new SafeComboBoxButton();
                }
                return new DefaultComboBoxButton(bl);
            }
        }
        return new SafeComboBoxButton();
    }

    class DefaultComboBoxButton
    implements GetComboButton {
        private Component button;

        public DefaultComboBoxButton(boolean bl) {
            JComboBox jComboBox = new JComboBox();
            jComboBox.setEditable(bl);
            for (int i = 0; i < jComboBox.getComponentCount(); ++i) {
                Component component = jComboBox.getComponent(i);
                String string = jComboBox.getComponent(i).getClass().getName();
                if (!string.contains("utton")) continue;
                this.button = component;
                this.button.setMinimumSize(new Dimension(20, 0));
                this.button.setPreferredSize(this.button.getMinimumSize());
                break;
            }
        }

        public Component getComboButton() {
            return this.button;
        }
    }

    class SafeComboBoxButton
    implements GetComboButton {
        private Component button;

        public SafeComboBoxButton() {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/comboButtonVista.png"));
            this.button = new JButton(imageIcon);
            this.button.setMinimumSize(new Dimension(18, 18));
            this.button.setPreferredSize(this.button.getMinimumSize());
        }

        public Component getComboButton() {
            return this.button;
        }
    }

    static interface GetComboButton {
        public Component getComboButton();
    }
}

