/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.CircularRelationshipException;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DependencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.ui.component.model.AbstractDependencyTableModel;
import com.sbs.jpm.undo.DependencyLagEdit;
import com.sbs.jpm.undo.DependencyTypeEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskAddDependencyEdit;
import com.sbs.jpm.undo.TaskRemoveDependencyEdit;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuccessorsTableModel
extends AbstractDependencyTableModel {
    public static final String SUCCESSOR = Common.I18N_RP.getString("column.successor");
    public static final String SUCCESSOR_START_DATE = Common.I18N_RP.getString("column.successorStartDate");

    @Override
    protected void createColumns() {
        this.titles.add(SUCCESSOR);
        this.titles.add(TYPE);
        this.titles.add(LAG);
        this.titles.add(SUCCESSOR_START_DATE);
        this.columnsType.add(Task.class);
        this.columnsType.add(String.class);
        this.columnsType.add(Long.class);
        this.columnsType.add(Date.class);
    }

    public SuccessorsTableModel() {
    }

    public SuccessorsTableModel(List<Task> list) {
        super(list);
    }

    @Override
    protected void computeDependencies() {
        this.dependencies = new LinkedList();
        for (Task task : this.data) {
            for (Dependency dependency : task.getSuccessorDependencies()) {
                boolean bl = false;
                for (AbstractDependencyTableModel.TaskDependencies taskDependencies : this.dependencies) {
                    if (!dependency.getSuccessor().equals(taskDependencies.getTask())) continue;
                    bl = true;
                    taskDependencies.addDependency(dependency);
                    break;
                }
                if (bl) continue;
                AbstractDependencyTableModel.TaskDependencies taskDependencies = new AbstractDependencyTableModel.TaskDependencies(dependency.getSuccessor());
                taskDependencies.addDependency(dependency);
                this.dependencies.add(taskDependencies);
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n == this.dependencies.size()) {
            Object object222;
            if (object == null || !(object instanceof Task)) {
                return;
            }
            Task task = (Task)object;
            for (Object object222 : this.dependencies) {
                if (!task.equals(((AbstractDependencyTableModel.TaskDependencies)object222).getTask())) continue;
                return;
            }
            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
            object222 = new LinkedList();
            for (Task task2 : this.data) {
                Dependency dependency = new Dependency(task2.getCompany().getIdGenerator().getNewId());
                dependency.setSuccessor(task);
                dependency.setPredecessor(task2);
                dependency.adjustDependencyForSplit();
                try {
                    if (!Task.addDependency(dependency, true)) continue;
                    TaskAddDependencyEdit taskAddDependencyEdit = new TaskAddDependencyEdit(dependency, "09/11/09 13:02:05");
                    object222.add(dependency);
                    extendedCompoundEdit.addEdit(taskAddDependencyEdit);
                }
                catch (CircularRelationshipException circularRelationshipException) {
                    Common.logException("Error:", circularRelationshipException);
                    JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                    Iterator iterator = object222.iterator();
                    while (iterator.hasNext()) {
                        Dependency dependency2 = (Dependency)iterator.next();
                        Task.removeDependency(dependency2);
                    }
                    TaskPlanner.rescheduleTree(task);
                    super.fireTableDataChanged();
                    return;
                }
            }
            if (object222.size() > 0) {
                extendedCompoundEdit.end();
                TaskPlanner.rescheduleTree(task);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            }
        } else {
            String string = (String)this.getValueAt(n, 1);
            Long l = (Long)this.getValueAt(n, 2);
            if (n2 == 0) {
                Object object3;
                Cloneable cloneable;
                Object object422;
                if (object == null || !(object instanceof Task)) {
                    return;
                }
                Task task = (Task)object;
                AbstractDependencyTableModel.TaskDependencies taskDependencies = (AbstractDependencyTableModel.TaskDependencies)this.dependencies.get(n);
                if (taskDependencies.getTask().equals(task)) {
                    return;
                }
                for (Object object422 : this.dependencies) {
                    if (!task.equals(((AbstractDependencyTableModel.TaskDependencies)object422).getTask())) continue;
                    return;
                }
                AbstractDependencyTableModel.TaskDependencies taskDependencies2 = (AbstractDependencyTableModel.TaskDependencies)this.dependencies.get(n);
                super.removeListeners();
                object422 = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                Dependency[] dependencyArray = taskDependencies2.getDependencies().toArray(new Dependency[0]);
                LinkedList<Task> linkedList = new LinkedList<Task>();
                LinkedList<Cloneable> linkedList2 = new LinkedList<Cloneable>();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    cloneable = dependencyArray[i];
                    linkedList.add(((Dependency)cloneable).getPredecessor());
                    object3 = new TaskRemoveDependencyEdit((Dependency)cloneable, "01-10-2009 19:26:04");
                    linkedList2.add(cloneable);
                    Task.removeDependency((Dependency)cloneable);
                    ((CompoundEdit)object422).addEdit((UndoableEdit)object3);
                }
                super.setListeners();
                Task task3 = taskDependencies2.getTask();
                taskDependencies2.setTask(task);
                cloneable = new LinkedList();
                for (Task task4 : linkedList) {
                    Dependency dependency = new Dependency(task4.getCompany().getIdGenerator().getNewId());
                    dependency.setPredecessor(task4);
                    dependency.setSuccessor(task);
                    if (string != null) {
                        dependency.setType(DependencyManager.getDependencyType(string));
                    }
                    if (l != null) {
                        dependency.setTaskDelay(l);
                    }
                    dependency.adjustDependencyForSplit();
                    try {
                        if (!Task.addDependency(dependency, true)) continue;
                        TaskAddDependencyEdit taskAddDependencyEdit = new TaskAddDependencyEdit(dependency, "09/11/09 13:02:06");
                        cloneable.add(dependency);
                        ((CompoundEdit)object422).addEdit(taskAddDependencyEdit);
                    }
                    catch (CircularRelationshipException circularRelationshipException) {
                        Common.logException("Error:", circularRelationshipException);
                        JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("task.schedulingConflict"), 0);
                        Iterator iterator = cloneable.iterator();
                        while (iterator.hasNext()) {
                            Dependency dependency3 = (Dependency)iterator.next();
                            Task.removeDependency(dependency3);
                        }
                        try {
                            for (Dependency dependency2 : linkedList2) {
                                Task.addDependency(dependency2, false);
                            }
                        }
                        catch (CircularRelationshipException circularRelationshipException2) {
                            Common.logException("Error:", circularRelationshipException2);
                            JOptionPane.showMessageDialog(Common.getApplication(), circularRelationshipException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("dataFlavour.null"), 0);
                        }
                        taskDependencies2.setTask(task3);
                        TaskPlanner.rescheduleTree(task);
                        super.fireTableDataChanged();
                        return;
                    }
                }
                if (cloneable.size() > 0 || linkedList2.size() > 0) {
                    ((CompoundEdit)object422).end();
                    TaskPlanner.rescheduleTree(task);
                    object3 = new UndoableEditEvent(this, (UndoableEdit)object422);
                    this.fireUndoableEditHappened((UndoableEditEvent)object3);
                }
            } else if (n2 == 1) {
                int n3 = DependencyManager.getDependencyType((String)object);
                AbstractDependencyTableModel.TaskDependencies taskDependencies = (AbstractDependencyTableModel.TaskDependencies)this.dependencies.get(n);
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(taskDependencies.getTask());
                for (Dependency dependency : taskDependencies.getDependencies()) {
                    DependencyTypeEdit dependencyTypeEdit = new DependencyTypeEdit(dependency, dependency.getType(), n3, "15-09-09 12:26:01");
                    dependency.setType(n3);
                    extendedCompoundEdit.addEdit(dependencyTypeEdit);
                }
                extendedCompoundEdit.end();
                TaskPlanner.rescheduleTree(taskDependencies.getTask());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            } else if (n2 == 2) {
                long l2 = (Long)object;
                if (l2 < 0L && this.parentSplitted) {
                    return;
                }
                AbstractDependencyTableModel.TaskDependencies taskDependencies = (AbstractDependencyTableModel.TaskDependencies)this.dependencies.get(n);
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(taskDependencies.getTask());
                for (Dependency dependency : taskDependencies.getDependencies()) {
                    DependencyLagEdit dependencyLagEdit = new DependencyLagEdit(dependency, dependency.getTaskDelay(), l2, "15-09-09 12:31:01");
                    dependency.setTaskDelay(l2);
                    extendedCompoundEdit.addEdit(dependencyLagEdit);
                }
                extendedCompoundEdit.end();
                TaskPlanner.rescheduleTree(taskDependencies.getTask());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            }
        }
    }

    @Override
    public void successorAddedEvent(TaskEvent taskEvent) {
        Dependency dependency = taskEvent.getDependency();
        boolean bl = false;
        for (AbstractDependencyTableModel.TaskDependencies taskDependencies : this.dependencies) {
            if (!dependency.getSuccessor().equals(taskDependencies.getTask())) continue;
            bl = true;
            taskDependencies.addDependency(dependency);
            int n = this.dependencies.indexOf(taskDependencies);
            this.fireTableRowsUpdated(n, n);
            break;
        }
        if (!bl) {
            AbstractDependencyTableModel.TaskDependencies taskDependencies = new AbstractDependencyTableModel.TaskDependencies(dependency.getSuccessor());
            taskDependencies.addDependency(dependency);
            this.dependencies.add(taskDependencies);
            dependency.getSuccessor().addTaskListener(this.taskHandler);
            int n = this.dependencies.size() - 1;
            this.fireTableRowsInserted(n, n);
        }
    }

    @Override
    public void successorRemovedEvent(TaskEvent taskEvent) {
        Dependency dependency = taskEvent.getDependency();
        for (AbstractDependencyTableModel.TaskDependencies taskDependencies : this.dependencies) {
            if (!dependency.getSuccessor().equals(taskDependencies.getTask())) continue;
            taskDependencies.removeDependency(dependency);
            int n = this.dependencies.indexOf(taskDependencies);
            if (taskDependencies.getDependencies().isEmpty()) {
                taskDependencies.getTask().removeTaskListener(this.taskHandler);
                this.dependencies.remove(taskDependencies);
                this.fireTableRowsDeleted(n, n);
                break;
            }
            this.fireTableRowsUpdated(n, n);
            break;
        }
    }

    @Override
    protected void predecessorAddedEvent(TaskEvent taskEvent) {
    }

    @Override
    protected void predecessorRemovedEvent(TaskEvent taskEvent) {
    }
}

