/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.ResourceAdapter;
import com.sbs.jpm.core.event.ResourceEvent;
import com.sbs.jpm.core.field.FieldManager;
import com.sbs.jpm.ui.component.JHumanResourcesTable;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.HResourceCalendarEdit;
import com.sbs.jpm.undo.HResourceEmailEdit;
import com.sbs.jpm.undo.HResourceMaxUnitsEdit;
import com.sbs.jpm.undo.HResourceNonEmptyEdit;
import com.sbs.jpm.undo.HResourceOvtRateEdit;
import com.sbs.jpm.undo.HResourcePhoneNoEdit;
import com.sbs.jpm.undo.ResourceAdditionalFieldEdit;
import com.sbs.jpm.undo.ResourceCodeEdit;
import com.sbs.jpm.undo.ResourceNameEdit;
import com.sbs.jpm.undo.ResourceStdRateEdit;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;

public class HumanResourcesTableModel
extends AbstractTableModel {
    public static final int EMPTY_ROWS = 50;
    public static final String RESOURCE_NAME = Common.I18N_RP.getString("column.resourceName");
    public static final String STANDARD_RATE = Common.I18N_RP.getString("column.standardRate");
    public static final String OVERTIME_RATE = Common.I18N_RP.getString("column.overtimeRate");
    public static final String MAX_UNIT = Common.I18N_RP.getString("column.maxUnits");
    public static final String CALENDAR = Common.I18N_RP.getString("column.calendar");
    public static final String CODE = Common.I18N_RP.getString("column.code");
    public static final String PHONE = Common.I18N_RP.getString("column.phone");
    public static final String EMAIL = Common.I18N_RP.getString("column.email");
    protected List titles;
    protected List columnsType;
    protected List emptyResources;
    private Company company;
    private EventListenerList listeners;
    protected ResourceHandler resourceHandler;
    private JHumanResourcesTable table;

    public HumanResourcesTableModel() {
        this(null, new Company());
    }

    public HumanResourcesTableModel(JHumanResourcesTable jHumanResourcesTable, Company company) {
        int n;
        this.company = company;
        this.table = jHumanResourcesTable;
        this.listeners = new EventListenerList();
        this.titles = new LinkedList();
        this.columnsType = new LinkedList();
        this.titles.add(RESOURCE_NAME);
        this.titles.add(STANDARD_RATE);
        this.titles.add(OVERTIME_RATE);
        this.titles.add(CALENDAR);
        this.titles.add(MAX_UNIT);
        this.titles.add(EMAIL);
        this.titles.add(PHONE);
        this.titles.add(CODE);
        for (n = 1; n <= 10; ++n) {
            this.titles.add(FieldManager.CUSTOM_NAME + n);
        }
        this.columnsType.add(String.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(CalendarManager.class);
        this.columnsType.add(Double.class);
        this.columnsType.add(String.class);
        this.columnsType.add(String.class);
        this.columnsType.add(String.class);
        for (n = 0; n < 10; ++n) {
            this.columnsType.add(String.class);
        }
        this.emptyResources = new LinkedList();
        for (n = 0; n < 50; ++n) {
            this.emptyResources.add(new HumanResource(Long.MIN_VALUE));
        }
        this.resourceHandler = new ResourceHandler();
        this.addResourcesListeners();
        this.company.addCompanyListener(new CompanyAdapter(){

            public void resourceAdded(CompanyEvent companyEvent) {
                Resource resource = companyEvent.getResource();
                if (resource instanceof HumanResource) {
                    resource.addResourceListener(HumanResourcesTableModel.this.resourceHandler);
                    int n = companyEvent.getResourceIndex();
                    HumanResourcesTableModel.this.fireTableRowsInserted(n, n);
                }
            }

            public void resourceRemoved(CompanyEvent companyEvent) {
                Resource resource = companyEvent.getResource();
                if (resource instanceof HumanResource) {
                    resource.removeResourceListener(HumanResourcesTableModel.this.resourceHandler);
                    int n = companyEvent.getResourceIndex();
                    HumanResourcesTableModel.this.fireTableRowsDeleted(n, n);
                }
            }
        });
    }

    private void addResourcesListeners() {
        for (int i = 0; i < this.company.getHumanResourcesNumber(); ++i) {
            this.company.getHumanResourceAt(i).addResourceListener(this.resourceHandler);
        }
    }

    public Company getCompany() {
        return this.company;
    }

    public int getRowCount() {
        if (this.company == null) {
            return 0;
        }
        return this.getCompany().getHumanResourcesNumber() + 50;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n >= this.getCompany().getHumanResourcesNumber()) {
            return n2 == 0;
        }
        HumanResource humanResource = this.getCompany().getHumanResourceAt(n);
        if (humanResource.isEmpty()) {
            return n2 == 0;
        }
        return true;
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.getCompany().getHumanResourcesNumber()) {
            return null;
        }
        HumanResource humanResource = this.getCompany().getHumanResourceAt(n);
        if (!humanResource.isEmpty()) {
            HumanResource humanResource2 = humanResource;
            if (n2 >= this.titles.size() - 10) {
                return humanResource2.getFieldAt(n2 - (this.titles.size() - 10));
            }
            if (n2 == 0) {
                return humanResource.getName();
            }
            if (n2 == 1) {
                return humanResource.getStandardRate();
            }
            if (n2 == 2) {
                return humanResource2.getOvertimeRate();
            }
            if (n2 == 4) {
                return humanResource2.getMaxUnits();
            }
            if (n2 == 3) {
                return humanResource2.getCalendar();
            }
            if (n2 == 5) {
                return humanResource2.getEmail();
            }
            if (n2 == 6) {
                return humanResource2.getPhoneNo();
            }
            if (n2 == 7) {
                return humanResource2.getCode();
            }
        } else {
            return null;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEmptyResources(int n, CompoundEdit compoundEdit) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            HumanResource humanResource = new HumanResource(this.company.getIdGenerator().getNewId());
            this.company.addResource(humanResource, compoundEdit);
        }
        n2 = this.company.getHumanResourcesNumber();
        JProjectView.BLOCK_UPDATE = true;
        try {
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            JProjectView.BLOCK_UPDATE = false;
        }
        catch (Throwable throwable) {
            JProjectView.BLOCK_UPDATE = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HumanResourcesTableModel.this.table.getProjectView().updateToolbar();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void setValueAt(Object object, int n, int n2) {
        HumanResource humanResource;
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.getCompany().getRootTask());
        if (n >= this.getCompany().getHumanResourcesNumber()) {
            if (object.toString().equals("")) {
                return;
            }
            this.insertEmptyResources(n - this.getCompany().getHumanResourcesNumber() + 1, extendedCompoundEdit);
        }
        HumanResource humanResource2 = humanResource = this.getCompany().getHumanResourceAt(n);
        boolean bl = humanResource2.isEmpty();
        boolean bl2 = true;
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (n2 >= this.titles.size() - 10) {
            int n3 = n2 - (this.titles.size() - 10);
            abstractUndoableEdit = new ResourceAdditionalFieldEdit(humanResource, humanResource.getFieldAt(n3), object.toString(), n3, "09/11/09 15:04:00");
            humanResource.setFieldAt(n3, object.toString());
            bl2 = false;
        } else {
            switch (n2) {
                case 0: {
                    if (!object.toString().equals("")) {
                        abstractUndoableEdit = new ResourceNameEdit(humanResource, humanResource.getName(), object.toString(), "09/11/09 13:14:02");
                        humanResource.setName(object.toString());
                    }
                    bl2 = false;
                    break;
                }
                case 1: {
                    if (object != null) {
                        double d = (Double)object;
                        abstractUndoableEdit = new ResourceStdRateEdit(humanResource, humanResource.getStandardRate(), d, "09/11/09 13:12:02");
                        ((Resource)humanResource).setStandardRate(d);
                    }
                    bl2 = true;
                    break;
                }
                case 2: {
                    if (object != null) {
                        double d = (Double)object;
                        abstractUndoableEdit = new HResourceOvtRateEdit(humanResource2, humanResource2.getOvertimeRate(), d, "09/11/09 15:23:00");
                        humanResource2.setOvertimeRate(d);
                    }
                    bl2 = true;
                    break;
                }
                case 4: {
                    if (object != null) {
                        double d = (Double)object;
                        abstractUndoableEdit = new HResourceMaxUnitsEdit(humanResource2, humanResource2.getMaxUnits(), d, "09/11/09 15:27:01");
                        humanResource2.setMaxUnits(d);
                    }
                    bl2 = true;
                    break;
                }
                case 3: {
                    CalendarManager calendarManager = object instanceof CalendarManager ? (CalendarManager)object : null;
                    abstractUndoableEdit = new HResourceCalendarEdit(humanResource2, humanResource2.getCalendar(), calendarManager, "15-09-09 12:18:01");
                    humanResource2.setCalendar(calendarManager);
                    bl2 = true;
                    break;
                }
                case 5: {
                    if (object != null && !object.toString().equals("")) {
                        String string = object.toString();
                        abstractUndoableEdit = new HResourceEmailEdit(humanResource2, humanResource2.getEmail(), string, "09/11/09 15:29:01");
                        humanResource2.setEmail(string);
                    }
                    bl2 = false;
                    break;
                }
                case 6: {
                    if (object != null && !object.toString().equals("")) {
                        String string = object.toString();
                        abstractUndoableEdit = new HResourcePhoneNoEdit(humanResource2, humanResource2.getPhoneNo(), string, "09/11/09 15:22:00");
                        humanResource2.setPhoneNo(string);
                    }
                    bl2 = false;
                    break;
                }
                case 7: {
                    if (object != null && !object.toString().equals("")) {
                        String string = object.toString();
                        abstractUndoableEdit = new ResourceCodeEdit(humanResource, humanResource.getCode(), string, "09/11/09 15:01:03");
                        humanResource.setCode(string);
                    }
                    bl2 = false;
                }
            }
        }
        if (bl) {
            HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(humanResource, "09/11/09 15:26:08");
            extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
        }
        if (abstractUndoableEdit != null) {
            extendedCompoundEdit.addEdit(abstractUndoableEdit);
        }
        if (!bl && bl2) {
            TaskPlanner.rescheduleTree(this.getCompany().getRootTask());
        } else {
            extendedCompoundEdit.discardReschedule();
        }
        extendedCompoundEdit.end();
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
        this.fireUndoableEditHappened(undoableEditEvent);
        if (bl) {
            this.table.getProjectView().updateToolbar();
        }
    }

    public Class getColumnClass(int n) {
        return (Class)this.columnsType.get(n);
    }

    public String getColumnName(int n) {
        return (String)this.titles.get(n);
    }

    public void setColumnName(int n, String string) {
        this.titles.set(n, string);
    }

    public int getColumnCount() {
        return this.titles.size();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class ResourceHandler
    extends ResourceAdapter {
        private ResourceHandler() {
        }

        public void dataChanged(ResourceEvent resourceEvent) {
            HumanResource humanResource = (HumanResource)resourceEvent.getSource();
            int n = HumanResourcesTableModel.this.company.getHumanResourceIndex(humanResource);
            HumanResourcesTableModel.this.fireTableRowsUpdated(n, n);
        }
    }
}

