/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.Contact;
import com.sbs.jpm.core.event.ClientEvent;
import com.sbs.jpm.core.event.ClientListener;
import com.sbs.jpm.core.event.ContactAdapter;
import com.sbs.jpm.core.event.ContactEvent;
import com.sbs.jpm.undo.ClientAddContactEdit;
import com.sbs.jpm.undo.ContactEmailEdit;
import com.sbs.jpm.undo.ContactNameEdit;
import com.sbs.jpm.undo.ContactNotesEdit;
import com.sbs.jpm.undo.ContactPhoneEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;

public class ContactsTableModel
extends AbstractTableModel {
    public static final String NAME = Common.I18N_RP.getString("column.contactName");
    public static final String NOTES = Common.I18N_RP.getString("column.notes");
    public static final String PHONE = Common.I18N_RP.getString("column.phone");
    public static final String EMAIL = Common.I18N_RP.getString("column.email");
    private static String[] columns = new String[]{NAME, EMAIL, PHONE, NOTES};
    private static Class[] columnsType = new Class[]{String.class, String.class, String.class, String.class};
    private Client data;
    protected ContactHandler contactHandler;
    private EventListenerList listeners;

    public ContactsTableModel() {
    }

    public ContactsTableModel(Client client) {
        this.data = client;
        this.listeners = new EventListenerList();
        this.contactHandler = new ContactHandler();
        this.addContactsListeners();
        this.data.addClientListener(new ClientListener(){

            public void contactAdded(ClientEvent clientEvent) {
                Contact contact = clientEvent.getContact();
                contact.addContactListener(ContactsTableModel.this.contactHandler);
                int n = clientEvent.getContactIndex();
                ContactsTableModel.this.fireTableRowsInserted(n, n);
            }

            public void contactRemoved(ClientEvent clientEvent) {
                Contact contact = clientEvent.getContact();
                contact.removeContactListener(ContactsTableModel.this.contactHandler);
                int n = clientEvent.getContactIndex();
                ContactsTableModel.this.fireTableRowsDeleted(n, n);
            }

            public void dataChanged(ClientEvent clientEvent) {
            }

            public void notesChanged(ClientEvent clientEvent) {
            }
        });
    }

    private void addContactsListeners() {
        for (Contact contact : this.data.getContacts()) {
            contact.addContactListener(this.contactHandler);
        }
    }

    public Client getClient() {
        return this.data;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.getClient().getContactsNumber() + 1;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n == this.getClient().getContactsNumber()) {
            return n2 == 0;
        }
        return true;
    }

    public Object getValueAt(int n, int n2) {
        if (n < this.getClient().getContactsNumber()) {
            Contact contact = this.getClient().getContactAt(n);
            if (n2 == 0) {
                return contact.getName();
            }
            if (n2 == 1) {
                return contact.getEmail();
            }
            if (n2 == 2) {
                return contact.getPhone();
            }
            if (n2 == 3) {
                return contact.getNotes();
            }
        } else {
            return null;
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n == this.getClient().getContactsNumber()) {
            if (object.toString().equals("")) {
                return;
            }
            ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
            Contact contact = new Contact(this.data.getOwner().getIdGenerator().getNewId());
            ClientAddContactEdit clientAddContactEdit = new ClientAddContactEdit(this.getClient(), contact, 4);
            extendedCompoundEdit.addEdit(clientAddContactEdit);
            this.getClient().addContact(contact);
            ContactNameEdit contactNameEdit = new ContactNameEdit(contact, contact.getName(), object.toString(), 1);
            contact.setName(object.toString());
            extendedCompoundEdit.addEdit(contactNameEdit);
            extendedCompoundEdit.end();
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
            this.fireUndoableEditHappened(undoableEditEvent);
        } else {
            Contact contact = this.getClient().getContactAt(n);
            if (n2 == 0) {
                ContactNameEdit contactNameEdit = new ContactNameEdit(contact, contact.getName(), object.toString(), 2);
                contact.setName(object.toString());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, contactNameEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            } else if (n2 == 1) {
                ContactEmailEdit contactEmailEdit = new ContactEmailEdit(contact, contact.getName(), object.toString(), 3);
                contact.setEmail(object.toString());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, contactEmailEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            } else if (n2 == 2) {
                ContactPhoneEdit contactPhoneEdit = new ContactPhoneEdit(contact, contact.getName(), object.toString(), 1);
                contact.setPhone(object.toString());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, contactPhoneEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            } else if (n2 == 3) {
                ContactNotesEdit contactNotesEdit = new ContactNotesEdit(contact, contact.getName(), object.toString(), 1);
                contact.setNotes(object.toString());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, contactNotesEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            }
        }
    }

    public Class getColumnClass(int n) {
        return columnsType[n];
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getColumnCount() {
        return columns.length;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private class ContactHandler
    extends ContactAdapter {
        private ContactHandler() {
        }

        public void dataChanged(ContactEvent contactEvent) {
            Contact contact = (Contact)contactEvent.getSource();
            int n = ContactsTableModel.this.data.getContactIndex(contact);
            ContactsTableModel.this.fireTableRowsUpdated(n, n);
        }
    }
}

