/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Assignment;
import com.sbs.jpm.core.DurationManager;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.core.Resource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.event.ResourceAdapter;
import com.sbs.jpm.core.event.ResourceEvent;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentTableModel
extends AbstractTableModel {
    public static final String RESOURCE = Common.I18N_RP.getString("column.resource");
    public static final String UNITS = Common.I18N_RP.getString("column.units");
    public static final String ASSIGNMENT_WORK = Common.I18N_RP.getString("column.assignmentWork");
    public static final String ASSIGNMENT_QUANTITY = Common.I18N_RP.getString("column.assignmentQuantity");
    private static String[] columns = new String[]{RESOURCE, UNITS, ASSIGNMENT_WORK, ASSIGNMENT_QUANTITY};
    private static Class[] columnsType = new Class[]{Resource.class, Double.class, Double.class, Double.class};
    private List<Task> tasksList = new LinkedList<Task>();
    private List<ResourceAssignments> resourcesAssignmentsLists = new LinkedList<ResourceAssignments>();
    private EventListenerList listeners = new EventListenerList();
    private ResourceHandler resourceHandler = new ResourceHandler();
    private TaskHandler taskHandler = new TaskHandler();
    static final DurationManager durationManager = new DurationManager();

    public AssignmentTableModel() {
        this(new LinkedList<Task>());
    }

    public AssignmentTableModel(List<Task> list) {
        this.removeListeners();
        LinkedList<Task> linkedList = new LinkedList<Task>();
        if (list != null) {
            for (Task task : list) {
                if (task.isSplitted()) {
                    for (Task task2 : task.getChildList()) {
                        linkedList.add(task2);
                    }
                    continue;
                }
                linkedList.add(task);
            }
        }
        this.tasksList = linkedList;
        this.listeners = new EventListenerList();
        this.resourcesAssignmentsLists = this.cumputeAssignments();
        this.setListeners();
    }

    public void discard() {
        this.removeListeners();
    }

    private void setListeners() {
        for (ResourceAssignments object : this.resourcesAssignmentsLists) {
            Resource resource = object.getResource();
            resource.addResourceListener(this.resourceHandler);
        }
        for (Task task : this.tasksList) {
            task.addTaskListener(this.taskHandler);
        }
    }

    private void removeListeners() {
        for (Task object : this.tasksList) {
            object.removeTaskListener(this.taskHandler);
        }
        for (ResourceAssignments resourceAssignments : this.resourcesAssignmentsLists) {
            Resource resource = resourceAssignments.getResource();
            resource.removeResourceListener(this.resourceHandler);
        }
    }

    private List<ResourceAssignments> cumputeAssignments() {
        this.resourcesAssignmentsLists = new LinkedList<ResourceAssignments>();
        for (Task task : this.tasksList) {
            if (task.isSplitted()) {
                for (Task task2 : task.getChildList()) {
                    AssignmentTableModel.addLocalAssigments(task2, this.resourcesAssignmentsLists);
                }
                continue;
            }
            AssignmentTableModel.addLocalAssigments(task, this.resourcesAssignmentsLists);
        }
        return this.resourcesAssignmentsLists;
    }

    private static void addLocalAssigments(Task task, List<ResourceAssignments> list) {
        for (Assignment assignment : task.getAssignments()) {
            boolean bl = false;
            for (ResourceAssignments resourceAssignments : list) {
                if (!assignment.getResource().equals(resourceAssignments.getResource())) continue;
                bl = true;
                resourceAssignments.addAssignment(assignment);
                break;
            }
            if (bl) continue;
            ResourceAssignments resourceAssignments = new ResourceAssignments(assignment.getResource());
            resourceAssignments.addAssignment(assignment);
            list.add(resourceAssignments);
        }
    }

    public List<Task> getTasks() {
        return this.tasksList;
    }

    @Override
    public int getRowCount() {
        return this.resourcesAssignmentsLists.size() + 1;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n == this.resourcesAssignmentsLists.size()) {
            return n2 == 0;
        }
        Resource resource = this.resourcesAssignmentsLists.get(n).resource;
        if (resource instanceof MaterialResource) {
            return n2 == 0 || n2 == 3;
        }
        return n2 != 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < this.resourcesAssignmentsLists.size()) {
            ResourceAssignments resourceAssignments = this.resourcesAssignmentsLists.get(n);
            Resource resource = resourceAssignments.getResource();
            if (n2 == 0) {
                return resource;
            }
            if (n2 == 1) {
                if (resource instanceof MaterialResource) {
                    return null;
                }
                boolean bl = true;
                double d = resourceAssignments.getAssignments().get(0).getUnits();
                for (Assignment assignment : resourceAssignments.getAssignments()) {
                    if (d == assignment.getUnits()) continue;
                    bl = false;
                }
                if (bl) {
                    return d;
                }
                return null;
            }
            if (n2 == 2) {
                if (resource instanceof MaterialResource) {
                    return null;
                }
                boolean bl = true;
                double d = resourceAssignments.getAssignments().get(0).getWork();
                for (Assignment assignment : resourceAssignments.getAssignments()) {
                    if (d == (double)assignment.getWork()) continue;
                    bl = false;
                }
                if (bl) {
                    return d;
                }
                return null;
            }
            if (n2 == 3) {
                if (resource instanceof HumanResource) {
                    return null;
                }
                boolean bl = true;
                double d = resourceAssignments.getAssignments().get(0).getUnits();
                for (Assignment assignment : resourceAssignments.getAssignments()) {
                    if (d == assignment.getUnits()) continue;
                    bl = false;
                }
                if (bl) {
                    return d;
                }
                return null;
            }
        } else {
            return null;
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object != null) {
            if (n == this.resourcesAssignmentsLists.size()) {
                if (object == null || !(object instanceof Resource)) {
                    return;
                }
                Resource resource = (Resource)object;
                for (ResourceAssignments object22 : this.resourcesAssignmentsLists) {
                    if (!resource.equals(object22.getResource())) continue;
                    return;
                }
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.tasksList.get(0));
                for (Task undoableEditEvent : this.tasksList) {
                    Assignment assignment = new Assignment(undoableEditEvent.getCompany().getIdGenerator().getNewId(), undoableEditEvent, resource);
                    assignment.assignIt(extendedCompoundEdit);
                }
                TaskPlanner.rescheduleTree(this.tasksList.get(0));
                extendedCompoundEdit.end();
                UndoableEditEvent extendedCompoundEdit2 = new UndoableEditEvent(this, extendedCompoundEdit);
                this.fireUndoableEditHappened(extendedCompoundEdit2);
            } else if (n2 == 0) {
                if (object == null || !(object instanceof Resource)) {
                    return;
                }
                Resource resource = (Resource)object;
                ResourceAssignments resourceAssignments = this.resourcesAssignmentsLists.get(n);
                if (!resourceAssignments.getResource().equals(resource)) {
                    for (ResourceAssignments resourceAssignments2 : this.resourcesAssignmentsLists) {
                        if (!resource.equals(resourceAssignments2.getResource())) continue;
                        return;
                    }
                    ResourceAssignments extendedCompoundEdit = this.resourcesAssignmentsLists.get(n);
                    this.removeListeners();
                    ExtendedCompoundEdit extendedCompoundEdit2 = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.tasksList.get(0));
                    LinkedList<Assignment> linkedList = new LinkedList<Assignment>();
                    for (Assignment assignment : extendedCompoundEdit.getAssignments()) {
                        Assignment assignment2 = new Assignment(assignment.getTask().getCompany().getIdGenerator().getNewId(), assignment.getTask(), resource);
                        assignment.discard(extendedCompoundEdit2);
                        assignment2.assignIt(extendedCompoundEdit2);
                        linkedList.add(assignment2);
                    }
                    extendedCompoundEdit.setResource(resource);
                    extendedCompoundEdit.getAssignments().clear();
                    for (Assignment assignment : linkedList) {
                        extendedCompoundEdit.addAssignment(assignment);
                    }
                    this.setListeners();
                    TaskPlanner.rescheduleTree(this.tasksList.get(0));
                    extendedCompoundEdit2.end();
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit2);
                    this.fireUndoableEditHappened(undoableEditEvent);
                }
            } else if (n2 == 1) {
                Double d = (Double)object;
                ResourceAssignments resourceAssignments = this.resourcesAssignmentsLists.get(n);
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.tasksList.get(0));
                for (Assignment assignment : resourceAssignments.getAssignments()) {
                    assignment.setUnits(d, extendedCompoundEdit);
                }
                TaskPlanner.rescheduleTree(this.tasksList.get(0));
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            } else if (n2 == 2) {
                ResourceAssignments resourceAssignments = this.resourcesAssignmentsLists.get(n);
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.tasksList.get(0));
                boolean bl = true;
                double d = 0.0;
                for (Assignment assignment : resourceAssignments.getAssignments()) {
                    boolean bl2;
                    if (bl2) {
                        bl2 = false;
                        d = ((Long)object).longValue();
                    }
                    double d2 = assignment.getWork();
                    double d3 = assignment.getUnits();
                    double d4 = d * d3 / d2;
                    assignment.setUnits(d4, extendedCompoundEdit);
                }
                TaskPlanner.rescheduleTree(this.tasksList.get(0));
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            } else if (n2 == 3) {
                Double d = (Double)object;
                ResourceAssignments resourceAssignments = this.resourcesAssignmentsLists.get(n);
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.tasksList.get(0));
                for (Assignment assignment : resourceAssignments.getAssignments()) {
                    assignment.setUnits(d, extendedCompoundEdit);
                }
                TaskPlanner.rescheduleTree(this.tasksList.get(0));
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                this.fireUndoableEditHappened(undoableEditEvent);
            }
        }
    }

    public Class getColumnClass(int n) {
        return columnsType[n];
    }

    @Override
    public String getColumnName(int n) {
        return columns[n];
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    public List<ResourceAssignments> getAssignments() {
        return this.resourcesAssignmentsLists;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceAssignments {
        private Resource resource;
        private List<Assignment> assignments;

        public ResourceAssignments(Resource resource) {
            this.resource = resource;
            this.assignments = new LinkedList<Assignment>();
        }

        public void addAssignment(Assignment assignment) {
            this.assignments.add(assignment);
        }

        public void removeAssignment(Assignment assignment) {
            this.assignments.remove(assignment);
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }

        public List<Assignment> getAssignments() {
            return this.assignments;
        }
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void assignmentAdded(TaskEvent taskEvent) {
            Assignment assignment = taskEvent.getAssignment();
            boolean bl = false;
            for (ResourceAssignments resourceAssignments : AssignmentTableModel.this.resourcesAssignmentsLists) {
                if (!assignment.getResource().equals(resourceAssignments.getResource())) continue;
                bl = true;
                resourceAssignments.addAssignment(assignment);
                int n = AssignmentTableModel.this.resourcesAssignmentsLists.indexOf(resourceAssignments);
                AssignmentTableModel.this.fireTableRowsUpdated(n, n);
                break;
            }
            if (!bl) {
                ResourceAssignments resourceAssignments = new ResourceAssignments(assignment.getResource());
                resourceAssignments.addAssignment(assignment);
                AssignmentTableModel.this.resourcesAssignmentsLists.add(resourceAssignments);
                assignment.getResource().addResourceListener(AssignmentTableModel.this.resourceHandler);
                int n = AssignmentTableModel.this.resourcesAssignmentsLists.size() - 1;
                AssignmentTableModel.this.fireTableRowsInserted(n, n);
            }
        }

        public void assignmentRemoved(TaskEvent taskEvent) {
            Assignment assignment = taskEvent.getAssignment();
            for (ResourceAssignments resourceAssignments : AssignmentTableModel.this.resourcesAssignmentsLists) {
                if (!assignment.getResource().equals(resourceAssignments.getResource())) continue;
                resourceAssignments.removeAssignment(assignment);
                int n = AssignmentTableModel.this.resourcesAssignmentsLists.indexOf(resourceAssignments);
                if (resourceAssignments.getAssignments().isEmpty()) {
                    resourceAssignments.getResource().removeResourceListener(AssignmentTableModel.this.resourceHandler);
                    AssignmentTableModel.this.resourcesAssignmentsLists.remove(resourceAssignments);
                    AssignmentTableModel.this.fireTableRowsDeleted(n, n);
                    break;
                }
                AssignmentTableModel.this.fireTableRowsUpdated(n, n);
                break;
            }
        }
    }

    private class ResourceHandler
    extends ResourceAdapter {
        private ResourceHandler() {
        }

        public void dataChanged(ResourceEvent resourceEvent) {
            Resource resource = (Resource)resourceEvent.getSource();
            int n = 0;
            for (ResourceAssignments resourceAssignments : AssignmentTableModel.this.resourcesAssignmentsLists) {
                if (!resource.equals(resourceAssignments.getResource())) continue;
                n = AssignmentTableModel.this.resourcesAssignmentsLists.indexOf(resourceAssignments);
            }
            AssignmentTableModel.this.fireTableRowsUpdated(n, n);
        }
    }
}

