/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component.model;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.PeriodInDay;
import com.sbs.jpm.calendar.event.DayWorkingPatternEvent;
import com.sbs.jpm.calendar.event.DayWorkingPatternListener;
import com.sbs.jpm.core.InvalidOperationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPeriodTableModel
extends AbstractTableModel {
    public static final String FROM = Common.I18N_RP.getString("column.from");
    public static final String TO = Common.I18N_RP.getString("column.to");
    protected static String[] columns = new String[]{FROM, TO};
    protected static Class[] columnsType = new Class[]{Long.class, Long.class};
    protected List<DayWorkingPattern> days;
    protected PatternHandler patternHandler;
    protected Map viewToModelMap;
    protected CalendarManager calendar;

    public CalendarManager getCalendar() {
        return this.calendar;
    }

    public AbstractPeriodTableModel(CalendarManager calendarManager) {
        this(new LinkedList<DayWorkingPattern>(), calendarManager);
    }

    public AbstractPeriodTableModel(List<DayWorkingPattern> list, CalendarManager calendarManager) {
        this.days = list;
        this.calendar = calendarManager;
        this.viewToModelMap = new HashMap();
        this.refresh();
        this.patternHandler = new PatternHandler();
        this.addPatternsListeners();
    }

    private void refresh() {
        if (!this.hasIdenticalDays()) {
            return;
        }
        if (this.days.isEmpty()) {
            return;
        }
        PeriodInDay[] periodInDayArray = this.days.get(0).getPeriodsInDay();
        this.viewToModelMap.clear();
        int n = 0;
        for (int i = 0; i < periodInDayArray.length; ++i) {
            PeriodInDay periodInDay = periodInDayArray[i];
            if (!periodInDay.isWorking()) continue;
            this.viewToModelMap.put(n++, i);
        }
    }

    public int convertRowIndexToModel(int n) {
        return (Integer)this.viewToModelMap.get(n);
    }

    private void addPatternsListeners() {
        for (DayWorkingPattern dayWorkingPattern : this.days) {
            dayWorkingPattern.addDayWorkingPatternListener(this.patternHandler);
        }
    }

    public List getDayPatterns() {
        return this.days;
    }

    private boolean hasIdenticalDays() {
        for (int i = 0; i < this.days.size() - 1; ++i) {
            DayWorkingPattern dayWorkingPattern;
            DayWorkingPattern dayWorkingPattern2 = this.days.get(i);
            if (dayWorkingPattern2.equals(dayWorkingPattern = this.days.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getRowCount() {
        return this.viewToModelMap.size() + 1;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.viewToModelMap.size() == n) {
            return n2 != 1;
        }
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (!this.hasIdenticalDays() || this.days.isEmpty()) {
            return null;
        }
        if (this.viewToModelMap.size() == n) {
            return null;
        }
        int n3 = (Integer)this.viewToModelMap.get(n);
        DayWorkingPattern dayWorkingPattern = this.days.get(0);
        PeriodInDay[] periodInDayArray = dayWorkingPattern.getPeriodsInDay();
        if (n2 == 0) {
            return periodInDayArray[n3].getStartPeriod();
        }
        return periodInDayArray[n3].getEndPeriod();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object != null && !this.days.isEmpty()) {
            if (!this.hasIdenticalDays()) {
                if (this.calendar != null) {
                    this.calendar.beginTransaction();
                }
                for (int i = 0; i < this.days.size(); ++i) {
                    DayWorkingPattern dayWorkingPattern = this.days.get(i);
                    dayWorkingPattern.setWorking(false);
                    if (n2 != 0) continue;
                    try {
                        dayWorkingPattern.addAlternance(new PeriodInDay(true, (Long)object, (Long)object + 60000L));
                        continue;
                    }
                    catch (InvalidOperationException invalidOperationException) {
                        return;
                    }
                }
                this.refresh();
                this.fireTableDataChanged();
                if (this.calendar != null) {
                    this.calendar.endTransaction();
                }
            } else if (this.viewToModelMap.size() == n) {
                if (this.calendar != null) {
                    this.calendar.beginTransaction();
                }
                for (int i = 0; i < this.days.size(); ++i) {
                    DayWorkingPattern dayWorkingPattern = this.days.get(i);
                    if (n2 != 0) continue;
                    try {
                        dayWorkingPattern.addAlternance(new PeriodInDay(true, (Long)object, (Long)object + 60000L));
                        continue;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                this.refresh();
                this.fireTableDataChanged();
                if (this.calendar != null) {
                    this.calendar.endTransaction();
                }
            } else {
                int n3 = (Integer)this.viewToModelMap.get(n);
                if (this.calendar != null) {
                    this.calendar.beginTransaction();
                }
                for (int i = 0; i < this.days.size(); ++i) {
                    PeriodInDay periodInDay;
                    PeriodInDay periodInDay2;
                    DayWorkingPattern dayWorkingPattern = this.days.get(i);
                    if (n2 == 0) {
                        periodInDay2 = dayWorkingPattern.getPeriodInDayAt(n3);
                        if (object.equals(periodInDay2.getStartPeriod())) continue;
                        try {
                            periodInDay = new PeriodInDay(true, (Long)object, periodInDay2.getEndPeriod());
                        }
                        catch (Exception exception) {
                            Common.logException("Error:", exception);
                            return;
                        }
                        try {
                            dayWorkingPattern.replaceAlternance(periodInDay2, periodInDay);
                        }
                        catch (Exception exception) {
                            Common.logException("Error:", exception);
                            dayWorkingPattern.addAlternance(periodInDay2);
                        }
                        continue;
                    }
                    periodInDay2 = dayWorkingPattern.getPeriodInDayAt(n3);
                    if (object.equals(periodInDay2.getEndPeriod())) continue;
                    try {
                        periodInDay = new PeriodInDay(true, periodInDay2.getStartPeriod(), (Long)object);
                    }
                    catch (Exception exception) {
                        Common.logException("Error:", exception);
                        return;
                    }
                    try {
                        dayWorkingPattern.replaceAlternance(periodInDay2, periodInDay);
                        continue;
                    }
                    catch (Exception exception) {
                        Common.logException("Error:", exception);
                        dayWorkingPattern.addAlternance(periodInDay2);
                    }
                }
                this.refresh();
                this.fireTableDataChanged();
                if (this.calendar != null) {
                    this.calendar.endTransaction();
                }
            }
        }
    }

    public Class getColumnClass(int n) {
        return columnsType[n];
    }

    @Override
    public String getColumnName(int n) {
        return columns[n];
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    protected class PatternHandler
    implements DayWorkingPatternListener {
        protected PatternHandler() {
        }

        public void dayWorkingPatternChanged(DayWorkingPatternEvent dayWorkingPatternEvent) {
            AbstractPeriodTableModel.this.refresh();
            AbstractPeriodTableModel.this.fireTableDataChanged();
        }
    }
}

