/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.ui.component.DropDownButton;
import com.sbs.jpm.ui.treetablechart.time.TimeScaleManager;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleAdapter;
import com.sbs.jpm.ui.treetablechart.time.event.TimeScaleEvent;
import com.sbs.jpm.ui.treetablechart.time.renderer.TimeScaleRendererCombination;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class ZoomDropDownButton
extends DropDownButton {
    private TimeScaleManager scaleManager;
    private JPopupMenu popup;
    private JButton button;
    private ButtonGroup buttonGroup;

    public ZoomDropDownButton(JButton jButton, TimeScaleManager timeScaleManager) {
        super(jButton);
        this.button = jButton;
        this.scaleManager = timeScaleManager;
        this.setScaleManager(timeScaleManager);
        this.popup = new JPopupMenu();
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < timeScaleManager.getScaleCombinationLength(); ++i) {
            TimeScaleRendererCombination timeScaleRendererCombination = timeScaleManager.getScaleCombination(i);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(timeScaleRendererCombination.getBottomRenderer().getName());
            jCheckBoxMenuItem.addActionListener(new ScaleAction(i));
            this.popup.add(jCheckBoxMenuItem);
            this.buttonGroup.add(jCheckBoxMenuItem);
        }
        ((JCheckBoxMenuItem)this.popup.getComponent(timeScaleManager.getCurrentScaleCursor())).setSelected(true);
    }

    public void setBackground(Color color) {
        this.button.setBackground(color);
        super.setBackground(color);
    }

    protected JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setScaleManager(TimeScaleManager timeScaleManager) {
        this.scaleManager = timeScaleManager;
        timeScaleManager.addTimeScaleListener(new TimeScaleAdapter(){

            public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
                TimeScaleManager timeScaleManager = (TimeScaleManager)timeScaleEvent.getSource();
                ((JCheckBoxMenuItem)ZoomDropDownButton.this.popup.getComponent(timeScaleManager.getCurrentScaleCursor())).setSelected(true);
            }
        });
    }

    class ScaleAction
    implements ActionListener {
        private int scaleCursor;

        public ScaleAction(int n) {
            this.scaleCursor = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoomDropDownButton.this.scaleManager.setCurrentScaleCursor(this.scaleCursor);
        }
    }
}

