/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.undo.TaskNotesEdit;
import com.sbs.jpm.undo.UndoHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class WBSTaskDetailView
extends JPanel {
    private UndoHandler undoHandler;
    private EventListenerList listeners = new EventListenerList();
    private Task task;
    private JLabel taskNameLabel;
    private JLabel taskNotesLabel;
    private JTextArea taskNotesArea;
    private JPanel panel;
    private DocumentListener taskNotesListener;
    private NotesHandler notesHandler;
    private TaskListener taskHandler;

    public WBSTaskDetailView() {
        this.setLayout(new BorderLayout());
        this.taskHandler = new TaskHandler();
        this.notesHandler = new NotesHandler();
        this.add((Component)this.createContents(), "Center");
        this.taskNotesListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!WBSTaskDetailView.this.taskNotesArea.getText().equals(WBSTaskDetailView.this.task.getNotes())) {
                    WBSTaskDetailView.this.task.setNotes(WBSTaskDetailView.this.taskNotesArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!WBSTaskDetailView.this.taskNotesArea.getText().equals(WBSTaskDetailView.this.task.getNotes())) {
                    WBSTaskDetailView.this.task.setNotes(WBSTaskDetailView.this.taskNotesArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    public void setTask(Task task) {
        if (this.task != null) {
            this.task.removeTaskListener(this.taskHandler);
        }
        this.task = task != null && task.isEmpty() ? null : task;
        if (this.task == null) {
            this.removeListeners();
            this.taskNameLabel.setText(" ");
            this.taskNotesArea.setText("");
            this.taskNameLabel.setEnabled(false);
            this.taskNotesLabel.setEnabled(false);
            this.taskNotesArea.setEnabled(false);
            this.addListeners();
        } else {
            this.updateValues();
        }
        if (this.task != null) {
            this.task.addTaskListener(this.taskHandler);
        }
    }

    private JComponent createContents() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.taskNameLabel = new JLabel("");
        this.taskNotesLabel = new JLabel(Common.I18N_RP.getString("task.notes") + ":");
        this.taskNotesArea = new JTextArea();
        this.taskNotesArea.setLineWrap(true);
        this.taskNotesArea.setWrapStyleWord(true);
        this.panel.add((Component)this.taskNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.panel.add((Component)this.taskNotesLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.panel.add((Component)new JScrollPane(this.taskNotesArea, 20, 31), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return this.panel;
    }

    private void addListeners() {
        this.taskNotesArea.getDocument().addDocumentListener(this.taskNotesListener);
        this.taskNotesArea.addFocusListener(this.notesHandler);
    }

    private void removeListeners() {
        this.taskNotesArea.getDocument().removeDocumentListener(this.taskNotesListener);
        this.taskNotesArea.removeFocusListener(this.notesHandler);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void updateValues() {
        this.removeListeners();
        this.taskNameLabel.setEnabled(true);
        this.taskNotesArea.setEnabled(true);
        this.taskNotesLabel.setEnabled(true);
        this.taskNotesArea.setEnabled(true);
        this.taskNameLabel.setText(this.task.getName());
        try {
            this.taskNotesArea.setText(this.task.getNotes());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        new JTextComponentUndoHandler(this.taskNotesArea);
        this.removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(this.task.getCompany().getUndoManager());
        this.addUndoableEditListener(this.undoHandler);
        this.addListeners();
    }

    private class NotesHandler
    implements FocusListener {
        private String oldNotes = "";

        private NotesHandler() {
        }

        private void doIt() {
            String string = WBSTaskDetailView.this.taskNotesArea.getText();
            if (!string.equals(this.oldNotes)) {
                TaskNotesEdit taskNotesEdit = new TaskNotesEdit(WBSTaskDetailView.this.task, this.oldNotes, string, "05/10/2009 16:56:00");
                WBSTaskDetailView.this.task.setNotes(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, taskNotesEdit);
                WBSTaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldNotes = WBSTaskDetailView.this.taskNotesArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            WBSTaskDetailView.this.updateValues();
        }

        public void notesChanged(TaskEvent taskEvent) {
            WBSTaskDetailView.this.updateValues();
        }
    }
}

