/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.constraint.ALAP;
import com.sbs.jpm.core.constraint.ASAP;
import com.sbs.jpm.core.constraint.Constraint;
import com.sbs.jpm.core.constraint.ConstraintManager;
import com.sbs.jpm.core.constraint.SNET;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.core.event.CompanyListener;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.component.JAssignmentTable;
import com.sbs.jpm.ui.component.JCorner;
import com.sbs.jpm.ui.component.JPredecessorsTable;
import com.sbs.jpm.ui.component.JRowHeader;
import com.sbs.jpm.ui.component.JSuccessorsTable;
import com.sbs.jpm.ui.component.model.AbstractDependencyTableModel;
import com.sbs.jpm.ui.component.model.AssignmentTableModel;
import com.sbs.jpm.ui.component.model.PredecessorsTableModel;
import com.sbs.jpm.ui.component.model.SuccessorsTableModel;
import com.sbs.jpm.ui.component.util.CompletionFormat;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.ui.component.util.TaskDurationFormat;
import com.sbs.jpm.ui.component.util.TaskWorkDurationFormat;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import com.sbs.jpm.ui.event.JApplicationEvent;
import com.sbs.jpm.ui.event.JApplicationListener;
import com.sbs.jpm.ui.treetablechart.JArea;
import com.sbs.jpm.ui.treetablechart.chart.ChartUIConfiguration;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskCalendarEdit;
import com.sbs.jpm.undo.TaskCompletionEdit;
import com.sbs.jpm.undo.TaskConstraintEdit;
import com.sbs.jpm.undo.TaskDeadlineEdit;
import com.sbs.jpm.undo.TaskDurationEdit;
import com.sbs.jpm.undo.TaskFixedUnitsEdit;
import com.sbs.jpm.undo.TaskForceResourcesCalendarEdit;
import com.sbs.jpm.undo.TaskNameEdit;
import com.sbs.jpm.undo.TaskNotesEdit;
import com.sbs.jpm.undo.TaskWorkCompletionEdit;
import com.sbs.jpm.undo.TaskWorkDrivenEdit;
import com.sbs.jpm.undo.TaskWorkEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.ColorChooserNoHSB;
import com.sbs.util.TristateCheckBox;
import com.standbysoft.component.date.DateSelectionException;
import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.JDatePicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDetailView
extends JPanel {
    static final Insets insets = new Insets(5, 5, 5, 5);
    static final Insets insets0Left = new Insets(5, 0, 5, 5);
    static final Insets insets0Right = new Insets(5, 5, 5, 0);
    static final Insets insets0All = new Insets(0, 0, 0, 0);
    public static final int DETAILS = 0;
    public static final int PREDECESSORS = 1;
    public static final int SUCCESSORS = 2;
    public static final int RESOURCES = 3;
    public static final int NOTES = 4;
    public static final int COLORS = 5;
    private UndoHandler undoHandler;
    private EventListenerList listeners;
    private List<Task> tasks;
    private JTabbedPane tabbedPane;
    private JLabel taskNameLabel;
    private JLabel totalWorkLabel;
    private JLabel taskDurationLabel;
    private JLabel taskCompletionLabel;
    private JLabel taskWorkCompletionLabel;
    private JLabel taskCalendarLabel;
    private JLabel taskStartDateLabel;
    private JLabel taskEndDateLabel;
    private JLabel taskWorkLabel;
    private JFormattedTextField taskWorkField;
    private JLabel subtreeWorkValue;
    private JPanel subtreeWorkPanel = new JPanel();
    private JPanel workInfoPanel = new JPanel();
    JRowHeader predecessorRowHeader;
    JRowHeader successorRowHeader;
    JRowHeader assignmentRowHeader;
    private JLabel taskDeadlineDateLabel;
    private JLabel constraintTypeLabel;
    private JLabel constraintDateLabel;
    private JLabel taskNotesLabel;
    private JComboBox taskCalendarCombo;
    private JDatePicker taskStartDatePicker;
    private JDatePicker taskEndDatePicker;
    private JFormattedTextField taskDurationField;
    private JFormattedTextField taskCompletionField;
    private JFormattedTextField taskWorkCompletionField;
    private JTextField taskNameField;
    private JTextArea taskNotesArea;
    private TristateCheckBox taskForcedWorkingCheck;
    private TristateCheckBox milestoneCheck;
    private TristateCheckBox taskWorkDrivenCheck1;
    private TristateCheckBox taskWorkDrivenCheck2;
    private TristateCheckBox taskFixedUnitsCheck1;
    private TristateCheckBox taskFixedUnitsCheck2;
    private JComboBox taskConstraintsCombo;
    private JDatePicker taskConstraintDatePicker;
    private JDatePicker taskDeadlineDatePicker;
    private JPredecessorsTable predecessorsTable;
    private JSuccessorsTable successorsTable;
    private JAssignmentTable assignmentTable;
    private ItemListener taskConstraintItemListener;
    private ItemListener calendarItemListener;
    private NameHandler taskNameListener;
    private NotesHandler taskNotesHandler;
    private DurationHandler taskDurationListener;
    private WorkHandler taskWorkListener;
    private CompletionHandler taskCompletionListener;
    private WorkCompletionHandler taskWorkCompletionListener;
    private DateSelectionListener taskStartDateListener;
    private DateSelectionListener taskEndDateListener;
    private DateSelectionListener taskDeadlineDateListener;
    private DateSelectionListener taskConstraintDateListener;
    private DocumentListener taskNotesListener;
    private ItemListener forcedWorkingItemListener;
    private ItemListener milestoneItemListener;
    private ItemListener workDrivenItemListener;
    private ItemListener fixedUnitsItemListener;
    private TaskDurationFormat durationFormat;
    private TaskWorkDurationFormat workDurationFormat;
    private CompletionFormat completionFormat;
    private TaskListener taskHandler;
    private CompanyListener companyHandler;
    private boolean useColorsTab;
    private boolean isProject;
    private boolean isPhase;
    private boolean isSplitted;
    private boolean isParentSplitted;
    private boolean isEmpty;
    private BarCustomizePanel barCustomizePanel;

    public TaskDetailView(boolean bl) {
        this.useColorsTab = bl;
        this.tasks = new LinkedList<Task>();
        this.listeners = new EventListenerList();
        this.setLayout(new BorderLayout());
        this.durationFormat = new TaskDurationFormat();
        this.workDurationFormat = new TaskWorkDurationFormat();
        this.completionFormat = new CompletionFormat();
        this.taskHandler = new TaskHandler();
        this.companyHandler = new CompanyHandler();
        this.add((Component)this.createContents(), "Center");
        final UIManager uIManager = UIManager.getInstance();
        uIManager.addJApplicationListener(new JApplicationListener(){

            public void dateFormatChanged(JApplicationEvent jApplicationEvent) {
                TaskDetailView.this.taskStartDatePicker.setDateFormat(uIManager.getDateFormat());
                TaskDetailView.this.taskEndDatePicker.setDateFormat(uIManager.getDateFormat());
                TaskDetailView.this.taskConstraintDatePicker.setDateFormat(uIManager.getDateFormat());
                TaskDetailView.this.taskDeadlineDatePicker.setDateFormat(uIManager.getDateFormat());
                TaskDetailView.this.revalidate();
            }
        });
        this.taskNameListener = new NameHandler();
        this.taskNotesHandler = new NotesHandler();
        this.taskDurationListener = new DurationHandler();
        this.taskWorkListener = new WorkHandler();
        this.taskCompletionListener = new CompletionHandler();
        this.taskWorkCompletionListener = new WorkCompletionHandler();
        this.taskStartDateListener = new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                if (!TaskDetailView.this.taskStartDatePicker.getSelectedDate().equals(((Task)TaskDetailView.this.tasks.get(0)).getStartDate())) {
                    SNET sNET = new SNET(dateSelectionEvent.getFirstDate());
                    if (TaskDetailView.this.tasks.size() > 0) {
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                        for (Task task : TaskDetailView.this.tasks) {
                            if (task.isSplitted()) {
                                task = task.getChildAt(0);
                            }
                            TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(task, task.getConstraint(), sNET, true, "09/11/09 12:37:07");
                            task.setForce(true);
                            task.setConstraint(sNET);
                            extendedCompoundEdit.addEdit(taskConstraintEdit);
                        }
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, extendedCompoundEdit);
                        TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                    }
                }
            }
        };
        this.taskEndDateListener = new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                if (!TaskDetailView.this.taskEndDatePicker.getSelectedDate().equals(((Task)TaskDetailView.this.tasks.get(0)).getEndDate()) && TaskDetailView.this.tasks.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    for (Task task : TaskDetailView.this.tasks) {
                        if (task.isSplitted()) {
                            task = task.getChildAt(task.getChildNumber() - 1);
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(TaskDetailView.this.taskEndDatePicker.getSelectedDate());
                        CalendarManager calendarManager = task.getUsedCalendar();
                        long l = calendarManager.getDuration(task.getStartDate(), calendar.getTime(), true);
                        TaskDurationEdit taskDurationEdit = new TaskDurationEdit(task, task.getDuration(), l, "02-10-2009 13:00:03");
                        task.changeDuration(l);
                        extendedCompoundEdit.addEdit(taskDurationEdit);
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.calendarItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && TaskDetailView.this.tasks.size() > 0) {
                    CalendarManager calendarManager = itemEvent.getItem() instanceof CalendarManager ? (CalendarManager)itemEvent.getItem() : null;
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    for (Task task : TaskDetailView.this.tasks) {
                        if (task.isSplitted()) {
                            for (Task task2 : task.getChildList()) {
                                TaskCalendarEdit taskCalendarEdit = new TaskCalendarEdit(task2, task2.getCalendar(), calendarManager, "09/11/09 12:53:03");
                                task2.setCalendar(calendarManager);
                                extendedCompoundEdit.addEdit(taskCalendarEdit);
                            }
                        }
                        TaskCalendarEdit taskCalendarEdit = new TaskCalendarEdit(task, task.getCalendar(), calendarManager, "09/11/09 12:53:04");
                        task.setCalendar(calendarManager);
                        extendedCompoundEdit.addEdit(taskCalendarEdit);
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.taskConstraintItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)itemEvent.getItem();
                    if (TaskDetailView.this.tasks.size() > 0) {
                        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                        for (Task task : TaskDetailView.this.tasks) {
                            Date date = task.getStartDate();
                            if (string.equals(ConstraintManager.SNET) || string.equals(ConstraintManager.SNLT) || string.equals(ConstraintManager.MSO)) {
                                date = task.getStartDate();
                            } else if (string.equals(ConstraintManager.FNET) || string.equals(ConstraintManager.FNLT) || string.equals(ConstraintManager.MFO)) {
                                date = task.getEndDate();
                            }
                            Constraint constraint = ConstraintManager.createConstraint(string, date);
                            TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(task, task.getConstraint(), constraint, "09/11/09 12:37:03");
                            task.setConstraint(constraint);
                            extendedCompoundEdit.addEdit(taskConstraintEdit);
                        }
                        extendedCompoundEdit.end();
                        TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                        TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                    }
                }
            }
        };
        this.taskConstraintDateListener = new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                Date date = dateSelectionEvent.getFirstDate();
                String string = (String)TaskDetailView.this.taskConstraintsCombo.getSelectedItem();
                Constraint constraint = ConstraintManager.createConstraint(string, date);
                if (TaskDetailView.this.tasks.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    for (Task task : TaskDetailView.this.tasks) {
                        TaskConstraintEdit taskConstraintEdit = new TaskConstraintEdit(task, task.getConstraint(), constraint, "09/11/09 12:37:04");
                        task.setConstraint(constraint);
                        extendedCompoundEdit.addEdit(taskConstraintEdit);
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.taskDeadlineDateListener = new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                Serializable serializable;
                Date date = TaskDetailView.this.taskDeadlineDatePicker.getSelectedDate();
                if (date != null) {
                    serializable = Calendar.getInstance();
                    ((Calendar)serializable).setTime(date);
                    date.setTime(((Calendar)serializable).getTimeInMillis());
                }
                serializable = new ExtendedCompoundEdit();
                for (Task task : TaskDetailView.this.tasks) {
                    TaskDeadlineEdit taskDeadlineEdit = new TaskDeadlineEdit(task, task.getDeadlineDate(), date, "09/11/2009 12:33:00");
                    task.setDeadlineDate(date);
                    ((CompoundEdit)serializable).addEdit(taskDeadlineEdit);
                }
                ((CompoundEdit)serializable).end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, (UndoableEdit)((Object)serializable));
                TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        };
        this.forcedWorkingItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (TaskDetailView.this.tasks.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    boolean bl = itemEvent.getStateChange() == 1;
                    for (Task task : TaskDetailView.this.tasks) {
                        if (task.isSplitted()) {
                            for (Task task2 : task.getChildList()) {
                                task2.setForcedWorking(itemEvent.getStateChange() == 1);
                                extendedCompoundEdit.addEdit(new TaskForceResourcesCalendarEdit(task2, bl, "02-10-2009 12:50:00"));
                            }
                            continue;
                        }
                        task.setForcedWorking(itemEvent.getStateChange() == 1);
                        extendedCompoundEdit.addEdit(new TaskForceResourcesCalendarEdit(task, bl, "02-10-2009 12:50:01"));
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.milestoneItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!TaskDetailView.this.tasks.isEmpty()) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    for (Task task : TaskDetailView.this.tasks) {
                        Serializable serializable;
                        long l;
                        if (itemEvent.getStateChange() == 1) {
                            l = 0L;
                        } else {
                            serializable = task.getProjectTask().getDurationManager();
                            l = serializable.getDuration(serializable.getDefaultUnit());
                        }
                        serializable = new TaskDurationEdit(task, task.getDuration(), l, "02-10-2009 13:00:04");
                        task.changeDuration(l);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.workDrivenItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (TaskDetailView.this.tasks.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    boolean bl = itemEvent.getStateChange() == 1;
                    for (Task task : TaskDetailView.this.tasks) {
                        task.setWorkDriven(bl);
                        extendedCompoundEdit.addEdit(new TaskWorkDrivenEdit(task, bl, "01-10-2009 17:18:00"));
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.fixedUnitsItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (TaskDetailView.this.tasks.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    boolean bl = itemEvent.getStateChange() == 1;
                    for (Task task : TaskDetailView.this.tasks) {
                        task.setFixedUnits(bl);
                        extendedCompoundEdit.addEdit(new TaskFixedUnitsEdit(task, bl, "02-10-2009 12:51:00"));
                    }
                    extendedCompoundEdit.end();
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
        this.taskNotesListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                for (Task task : TaskDetailView.this.tasks) {
                    if (TaskDetailView.this.taskNotesArea.getText().equals(task.getNotes())) continue;
                    task.setNotes(TaskDetailView.this.taskNotesArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                for (Task task : TaskDetailView.this.tasks) {
                    if (TaskDetailView.this.taskNotesArea.getText().equals(task.getNotes())) continue;
                    task.setNotes(TaskDetailView.this.taskNotesArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    public void setTasks(List<Task> list) {
        if (!this.tasks.isEmpty()) {
            for (Task task : this.tasks) {
                task.removeTaskListener(this.taskHandler);
            }
            this.tasks.get(0).getCompany().removeCompanyListener(this.companyHandler);
        }
        this.isProject = false;
        this.isPhase = false;
        this.isEmpty = false;
        this.isSplitted = false;
        this.isParentSplitted = false;
        boolean bl = true;
        boolean bl2 = true;
        for (Task object : list) {
            if (object.isEmpty()) {
                this.isEmpty = true;
            }
            if (!object.isLeaf() && !object.isSplitted()) {
                this.isPhase = true;
            }
            if (object.isProject()) {
                this.isProject = true;
            }
            if (object.isSplitted()) {
                this.isSplitted = true;
            }
            if (object.isParentSplitted()) {
                this.isParentSplitted = true;
                if (list.contains(object.getParent())) {
                    bl = false;
                }
            }
            if (object.hasHumanResources()) continue;
            bl2 = false;
        }
        if (list.isEmpty() || this.isEmpty) {
            this.setEmptyValues();
        } else {
            this.tasks = list;
            LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>(list.get(0).getCompany().getCalendarList());
            if (this.isProject) {
                linkedList.add(0, (CalendarManager)((Object)Common.I18N_RP.getString("useCompanyCalendar")));
            } else {
                linkedList.add(0, (CalendarManager)((Object)Common.I18N_RP.getString("useProjectCalendar")));
            }
            this.taskCalendarCombo.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
            this.updateValues();
            new JTextComponentUndoHandler(this.taskNotesArea);
            this.removeUndoableEditListener(this.undoHandler);
            this.predecessorsTable.removeUndoableEditListener(this.undoHandler);
            ((AbstractDependencyTableModel)this.predecessorsTable.getModel()).removeUndoableEditListener(this.undoHandler);
            this.successorsTable.removeUndoableEditListener(this.undoHandler);
            ((AbstractDependencyTableModel)this.successorsTable.getModel()).removeUndoableEditListener(this.undoHandler);
            this.assignmentTable.removeUndoableEditListener(this.undoHandler);
            ((AssignmentTableModel)this.assignmentTable.getModel()).discard();
            ((AssignmentTableModel)this.assignmentTable.getModel()).removeUndoableEditListener(this.undoHandler);
            this.undoHandler = new UndoHandler(list.get(0).getCompany().getUndoManager());
            this.assignmentTable.setModel(new AssignmentTableModel(list));
            this.assignmentRowHeader.setTableModel(this.assignmentTable.getModel());
            this.assignmentRowHeader.revalidate();
            ((AbstractDependencyTableModel)this.predecessorsTable.getModel()).discard();
            this.predecessorsTable.setModel(new PredecessorsTableModel(list));
            this.predecessorRowHeader.setTableModel(this.predecessorsTable.getModel());
            this.predecessorRowHeader.revalidate();
            ((AbstractDependencyTableModel)this.successorsTable.getModel()).discard();
            this.successorsTable.setModel(new SuccessorsTableModel(list));
            this.successorRowHeader.setTableModel(this.successorsTable.getModel());
            this.successorRowHeader.revalidate();
            this.addUndoableEditListener(this.undoHandler);
            this.predecessorsTable.addUndoableEditListener(this.undoHandler);
            ((AbstractDependencyTableModel)this.predecessorsTable.getModel()).addUndoableEditListener(this.undoHandler);
            this.successorsTable.addUndoableEditListener(this.undoHandler);
            ((AbstractDependencyTableModel)this.successorsTable.getModel()).addUndoableEditListener(this.undoHandler);
            this.assignmentTable.addUndoableEditListener(this.undoHandler);
            ((AssignmentTableModel)this.assignmentTable.getModel()).addUndoableEditListener(this.undoHandler);
            if (this.useColorsTab) {
                this.barCustomizePanel.setTasks(list);
            }
            this.tabbedPane.setEnabled(true);
            this.taskCalendarLabel.setEnabled(!this.isParentSplitted);
            this.taskCalendarCombo.setEnabled(!this.isParentSplitted);
            this.taskNameLabel.setEnabled(true);
            this.taskNameField.setEnabled(true);
            this.taskNotesArea.setEnabled(true);
            this.taskNotesLabel.setEnabled(true);
            this.predecessorsTable.setEnabled(true);
            this.predecessorsTable.setEditable(true);
            this.successorsTable.setEnabled(true);
            this.successorsTable.setEditable(true);
            this.taskDeadlineDateLabel.setEnabled(!this.isParentSplitted);
            this.taskDeadlineDatePicker.setEnabled(!this.isParentSplitted);
            if (this.isProject) {
                this.assignmentTable.setEnabled(false);
                this.assignmentTable.setEditable(false);
                this.taskForcedWorkingCheck.setEnabled(false);
                this.tabbedPane.setEnabledAt(3, false);
                this.milestoneCheck.setEnabled(false);
                this.subtreeWorkPanel.setVisible(true);
                this.constraintTypeLabel.setEnabled(false);
                this.taskConstraintsCombo.setEnabled(false);
            } else {
                this.assignmentTable.setEnabled(true);
                this.assignmentTable.setEditable(true);
                this.taskForcedWorkingCheck.setEnabled(!this.isParentSplitted);
                this.tabbedPane.setEnabledAt(3, true);
                if (this.isPhase) {
                    this.taskDurationLabel.setEnabled(false);
                    this.totalWorkLabel.setEnabled(false);
                    this.taskCompletionLabel.setEnabled(false);
                    this.taskWorkCompletionLabel.setEnabled(false);
                    this.taskStartDateLabel.setEnabled(false);
                    this.taskEndDateLabel.setEnabled(false);
                    this.constraintTypeLabel.setEnabled(false);
                    this.taskConstraintsCombo.setEnabled(false);
                    this.taskDurationField.setEnabled(false);
                    this.taskWorkField.setEnabled(false);
                    this.taskCompletionField.setEnabled(false);
                    this.taskWorkCompletionField.setEnabled(false);
                    this.taskStartDatePicker.setEnabled(false);
                    this.taskEndDatePicker.setEnabled(false);
                    this.milestoneCheck.setEnabled(false);
                    this.subtreeWorkPanel.setVisible(true);
                } else {
                    this.taskDurationLabel.setEnabled(bl);
                    this.totalWorkLabel.setEnabled(bl);
                    this.taskEndDateLabel.setEnabled(bl);
                    this.taskDurationField.setEnabled(bl);
                    this.taskWorkField.setEnabled(bl);
                    this.taskEndDatePicker.setEnabled(bl);
                    this.taskStartDateLabel.setEnabled(bl);
                    this.taskStartDatePicker.setEnabled(bl);
                    this.taskCompletionLabel.setEnabled(bl);
                    this.taskWorkCompletionLabel.setEnabled(bl);
                    this.taskCompletionField.setEnabled(bl);
                    this.taskWorkCompletionField.setEnabled(bl);
                    this.constraintTypeLabel.setEnabled(true);
                    this.taskConstraintsCombo.setEnabled(true);
                    this.milestoneCheck.setEnabled(true);
                    this.subtreeWorkPanel.setVisible(false);
                }
            }
            for (Task task : this.tasks) {
                task.addTaskListener(this.taskHandler);
            }
            this.tasks.get(0).getCompany().addCompanyListener(this.companyHandler);
        }
    }

    private void setEmptyValues() {
        this.removeListeners();
        this.taskNameField.setText("");
        this.taskDurationField.setValue(0);
        this.taskWorkField.setValue(0);
        this.taskCompletionField.setValue(0);
        this.taskWorkCompletionField.setValue(0);
        this.taskCalendarCombo.setModel(new DefaultComboBoxModel());
        this.taskStartDatePicker.setSelectedDate(null);
        this.taskEndDatePicker.setSelectedDate(null);
        this.taskConstraintDatePicker.setSelectedDate(null);
        this.taskDeadlineDatePicker.setSelectedDate(null);
        this.taskConstraintsCombo.setSelectedItem(null);
        this.taskForcedWorkingCheck.setSelected(false);
        this.milestoneCheck.setSelected(false);
        this.taskWorkDrivenCheck1.setVisible(true);
        this.taskWorkDrivenCheck1.setSelected(false);
        this.taskWorkDrivenCheck2.setVisible(true);
        this.taskWorkDrivenCheck2.setSelected(false);
        this.taskFixedUnitsCheck1.setVisible(true);
        this.taskFixedUnitsCheck1.setSelected(false);
        this.taskFixedUnitsCheck2.setVisible(true);
        this.taskFixedUnitsCheck2.setSelected(false);
        this.taskWorkLabel.setText("0h");
        this.taskNotesArea.setText("");
        AssignmentTableModel assignmentTableModel = new AssignmentTableModel();
        this.assignmentTable.setModel(assignmentTableModel);
        this.assignmentTable.setEditable(false);
        PredecessorsTableModel predecessorsTableModel = new PredecessorsTableModel();
        this.predecessorsTable.setModel(predecessorsTableModel);
        this.predecessorsTable.setEditable(false);
        SuccessorsTableModel successorsTableModel = new SuccessorsTableModel();
        this.successorsTable.setModel(successorsTableModel);
        this.successorsTable.setEditable(false);
        this.tabbedPane.setEnabled(false);
        this.taskCalendarCombo.setEnabled(false);
        this.taskStartDatePicker.setEnabled(false);
        this.taskEndDatePicker.setEnabled(false);
        this.taskDeadlineDatePicker.setEnabled(false);
        this.taskDurationField.setEnabled(false);
        this.taskWorkField.setEnabled(false);
        this.taskWorkDrivenCheck1.setEnabled(false);
        this.taskWorkDrivenCheck2.setEnabled(false);
        this.taskFixedUnitsCheck1.setEnabled(false);
        this.taskFixedUnitsCheck2.setEnabled(false);
        this.taskCompletionField.setEnabled(false);
        this.taskWorkCompletionField.setEnabled(false);
        this.taskNameField.setEnabled(false);
        this.taskNotesArea.setEnabled(false);
        this.taskForcedWorkingCheck.setEnabled(false);
        this.milestoneCheck.setEnabled(false);
        this.taskConstraintsCombo.setEnabled(false);
        this.taskConstraintDatePicker.setEnabled(false);
        this.predecessorsTable.setEnabled(false);
        this.successorsTable.setEnabled(false);
        this.assignmentTable.setEnabled(false);
        this.taskNameLabel.setEnabled(false);
        this.taskDurationLabel.setEnabled(false);
        this.totalWorkLabel.setEnabled(false);
        this.taskCompletionLabel.setEnabled(false);
        this.taskWorkCompletionLabel.setEnabled(false);
        this.taskCalendarLabel.setEnabled(false);
        this.taskStartDateLabel.setEnabled(false);
        this.taskEndDateLabel.setEnabled(false);
        this.taskDeadlineDateLabel.setEnabled(false);
        this.constraintTypeLabel.setEnabled(false);
        this.constraintDateLabel.setEnabled(false);
        this.taskNotesLabel.setEnabled(false);
        this.addListeners();
    }

    private void addListeners() {
        this.taskNameField.addActionListener(this.taskNameListener);
        this.taskNameField.addFocusListener(this.taskNameListener);
        this.taskNotesArea.addFocusListener(this.taskNotesHandler);
        this.taskDurationField.addActionListener(this.taskDurationListener);
        this.taskDurationField.addFocusListener(this.taskDurationListener);
        this.taskWorkField.addActionListener(this.taskWorkListener);
        this.taskWorkField.addFocusListener(this.taskWorkListener);
        this.taskCompletionField.addActionListener(this.taskCompletionListener);
        this.taskCompletionField.addFocusListener(this.taskCompletionListener);
        this.taskWorkCompletionField.addActionListener(this.taskWorkCompletionListener);
        this.taskWorkCompletionField.addFocusListener(this.taskWorkCompletionListener);
        this.taskCalendarCombo.addItemListener(this.calendarItemListener);
        this.taskConstraintsCombo.addItemListener(this.taskConstraintItemListener);
        this.taskConstraintDatePicker.addDateSelectionListener(this.taskConstraintDateListener);
        this.taskStartDatePicker.addDateSelectionListener(this.taskStartDateListener);
        this.taskEndDatePicker.addDateSelectionListener(this.taskEndDateListener);
        this.taskDeadlineDatePicker.addDateSelectionListener(this.taskDeadlineDateListener);
        this.taskForcedWorkingCheck.addItemListener(this.forcedWorkingItemListener);
        this.milestoneCheck.addItemListener(this.milestoneItemListener);
        this.taskWorkDrivenCheck1.addItemListener(this.workDrivenItemListener);
        this.taskWorkDrivenCheck2.addItemListener(this.workDrivenItemListener);
        this.taskFixedUnitsCheck1.addItemListener(this.fixedUnitsItemListener);
        this.taskFixedUnitsCheck2.addItemListener(this.fixedUnitsItemListener);
        this.taskNotesArea.getDocument().addDocumentListener(this.taskNotesListener);
    }

    private void removeListeners() {
        this.taskNameField.removeActionListener(this.taskNameListener);
        this.taskNameField.removeFocusListener(this.taskNameListener);
        this.taskNotesArea.removeFocusListener(this.taskNotesHandler);
        this.taskDurationField.removeActionListener(this.taskDurationListener);
        this.taskDurationField.removeFocusListener(this.taskDurationListener);
        this.taskWorkField.removeActionListener(this.taskWorkListener);
        this.taskWorkField.removeFocusListener(this.taskWorkListener);
        this.taskCompletionField.removeActionListener(this.taskCompletionListener);
        this.taskCompletionField.removeFocusListener(this.taskCompletionListener);
        this.taskWorkCompletionField.removeActionListener(this.taskWorkCompletionListener);
        this.taskWorkCompletionField.removeFocusListener(this.taskWorkCompletionListener);
        this.taskCalendarCombo.removeItemListener(this.calendarItemListener);
        this.taskConstraintsCombo.removeItemListener(this.taskConstraintItemListener);
        this.taskConstraintDatePicker.removeDateSelectionListener(this.taskConstraintDateListener);
        this.taskStartDatePicker.removeDateSelectionListener(this.taskStartDateListener);
        this.taskEndDatePicker.removeDateSelectionListener(this.taskEndDateListener);
        this.taskDeadlineDatePicker.removeDateSelectionListener(this.taskDeadlineDateListener);
        this.taskForcedWorkingCheck.removeItemListener(this.forcedWorkingItemListener);
        this.milestoneCheck.removeItemListener(this.milestoneItemListener);
        this.taskWorkDrivenCheck1.removeItemListener(this.workDrivenItemListener);
        this.taskWorkDrivenCheck2.removeItemListener(this.workDrivenItemListener);
        this.taskFixedUnitsCheck1.removeItemListener(this.fixedUnitsItemListener);
        this.taskFixedUnitsCheck2.removeItemListener(this.fixedUnitsItemListener);
        this.taskNotesArea.getDocument().removeDocumentListener(this.taskNotesListener);
    }

    private JPanel createDetailsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.taskNameLabel = new JLabel(Common.I18N_RP.getString("task.name") + ":");
        this.taskDurationLabel = new JLabel(Common.I18N_RP.getString("task.duration") + ":");
        this.taskCompletionLabel = new JLabel(Common.I18N_RP.getString("task.completion") + ":");
        this.taskWorkCompletionLabel = new JLabel(Common.I18N_RP.getString("task.workCompletion") + ":");
        this.taskCalendarLabel = new JLabel(Common.I18N_RP.getString("task.calendar") + ":");
        this.taskStartDateLabel = new JLabel(Common.I18N_RP.getString("task.startDate") + ":");
        this.taskEndDateLabel = new JLabel(Common.I18N_RP.getString("task.endDate") + ":");
        this.taskDeadlineDateLabel = new JLabel(Common.I18N_RP.getString("task.deadlineDate") + ":");
        this.taskEndDateLabel.setEnabled(false);
        this.constraintTypeLabel = new JLabel(Common.I18N_RP.getString("task.constraintType") + ":");
        this.constraintDateLabel = new JLabel(Common.I18N_RP.getString("task.constraintDate") + ":");
        this.totalWorkLabel = new JLabel(Common.I18N_RP.getString("task.totalWork") + ": ");
        this.taskNameField = new JTextField(30);
        this.taskDurationField = new JFormattedTextField();
        this.taskDurationField.setHorizontalAlignment(4);
        this.taskDurationField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.durationFormat)));
        this.taskWorkField = new JFormattedTextField();
        this.taskWorkField.setHorizontalAlignment(4);
        this.taskWorkField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.workDurationFormat)));
        this.taskCompletionField = new JFormattedTextField();
        this.taskCompletionField.setHorizontalAlignment(4);
        this.taskCompletionField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.completionFormat)));
        this.taskWorkCompletionField = new JFormattedTextField();
        this.taskWorkCompletionField.setHorizontalAlignment(4);
        this.taskWorkCompletionField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.completionFormat)));
        this.taskCalendarCombo = new JComboBox();
        this.taskStartDatePicker = new JDatePicker(true);
        try {
            this.taskStartDatePicker.setEmptySelectionAllowed(false);
        }
        catch (DateSelectionException dateSelectionException) {
            Common.logException("Error:", dateSelectionException);
        }
        this.taskStartDatePicker.setEmptySelectionText("");
        this.taskStartDatePicker.setDateFormat(UIManager.getInstance().getDateFormat());
        this.taskEndDatePicker = new JDatePicker(true);
        try {
            this.taskEndDatePicker.setEmptySelectionAllowed(false);
        }
        catch (DateSelectionException dateSelectionException) {
            Common.logException("Error:", dateSelectionException);
        }
        this.taskEndDatePicker.setEmptySelectionText("");
        this.taskEndDatePicker.setDateFormat(UIManager.getInstance().getDateFormat());
        this.taskEndDatePicker.setEnabled(this.taskStartDatePicker.isEnabled());
        this.taskDeadlineDatePicker = new JDatePicker(true);
        try {
            this.taskDeadlineDatePicker.setEmptySelectionAllowed(true);
            this.taskDeadlineDatePicker.setEmptySelectionText("");
        }
        catch (DateSelectionException dateSelectionException) {
            Common.logException("Error:", dateSelectionException);
        }
        this.taskDeadlineDatePicker.setDateFormat(UIManager.getInstance().getDateFormat());
        this.taskConstraintsCombo = new JComboBox<String>(ConstraintManager.getConstraintList());
        this.taskConstraintDatePicker = new JDatePicker(true);
        try {
            this.taskConstraintDatePicker.setEmptySelectionAllowed(false);
        }
        catch (DateSelectionException dateSelectionException) {
            Common.logException("Error:", dateSelectionException);
        }
        this.taskConstraintDatePicker.setEmptySelectionText("");
        this.taskConstraintDatePicker.setDateFormat(UIManager.getInstance().getDateFormat());
        this.taskForcedWorkingCheck = new TristateCheckBox(Common.I18N_RP.getString("task.resourcesUseTaskCalendar"));
        this.taskForcedWorkingCheck.setTristateEnabled(false);
        this.milestoneCheck = new TristateCheckBox(Common.I18N_RP.getString("task.milestone"));
        this.milestoneCheck.setTristateEnabled(false);
        this.taskWorkDrivenCheck1 = new TristateCheckBox(Common.I18N_RP.getString("task.makeWorkDriven"));
        this.taskWorkDrivenCheck1.setTristateEnabled(false);
        this.taskWorkDrivenCheck1.setToolTipText(Common.I18N_RP.getString("task.makeWorkDriven.tooltip"));
        this.taskFixedUnitsCheck1 = new TristateCheckBox(Common.I18N_RP.getString("task.makeFixedUnits"));
        this.taskFixedUnitsCheck1.setToolTipText(Common.I18N_RP.getString("task.makeFixedUnits.tooltip"));
        this.taskFixedUnitsCheck1.setTristateEnabled(false);
        Dimension dimension = new Dimension(20, (int)this.taskConstraintsCombo.getMinimumSize().getHeight());
        jPanel.add((Component)this.taskNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.taskNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.taskDurationLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.taskDurationField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.totalWorkLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.taskWorkField, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.taskCalendarLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.taskCalendarCombo.setMinimumSize(dimension);
        jPanel.add((Component)this.taskCalendarCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.taskStartDateLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.taskStartDatePicker.setMinimumSize(dimension);
        jPanel.add((Component)this.taskStartDatePicker, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.taskEndDateLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.taskEndDatePicker.setMinimumSize(dimension);
        jPanel.add((Component)this.taskEndDatePicker, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.constraintTypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.taskConstraintsCombo.setMinimumSize(dimension);
        jPanel.add((Component)this.taskConstraintsCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.constraintDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.taskConstraintDatePicker.setMinimumSize(dimension);
        jPanel.add((Component)this.taskConstraintDatePicker, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.taskDeadlineDateLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        this.taskDeadlineDatePicker.setMinimumSize(dimension);
        jPanel.add((Component)this.taskDeadlineDatePicker, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.milestoneCheck, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.taskForcedWorkingCheck.setMinimumSize(dimension);
        jPanel.add((Component)this.taskForcedWorkingCheck, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        jPanel.add((Component)this.taskCompletionLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel.add((Component)this.taskCompletionField, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.taskWorkCompletionLabel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        jPanel.add((Component)this.taskWorkCompletionField, new GridBagConstraints(5, 3, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.taskFixedUnitsCheck1, new GridBagConstraints(0, 4, 6, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.taskWorkDrivenCheck1, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 6, 6, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        return jPanel;
    }

    private JPanel createPredecessorsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.predecessorsTable = new JPredecessorsTable();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.predecessorsTable));
        this.predecessorRowHeader = new JRowHeader((JTable)((Object)this.predecessorsTable));
        this.predecessorRowHeader.setFixedCellWidth(20);
        jScrollPane.setRowHeaderView(this.predecessorRowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, insets0All, 0, 0));
        return jPanel;
    }

    private JPanel createSuccessorsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.successorsTable = new JSuccessorsTable();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.successorsTable));
        this.successorRowHeader = new JRowHeader((JTable)((Object)this.successorsTable));
        this.successorRowHeader.setFixedCellWidth(20);
        jScrollPane.setRowHeaderView(this.successorRowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, insets0All, 0, 0));
        return jPanel;
    }

    private JPanel createResourcesTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.assignmentTable = new JAssignmentTable();
        this.taskWorkDrivenCheck2 = new TristateCheckBox(Common.I18N_RP.getString("task.makeWorkDriven"));
        this.taskWorkDrivenCheck2.setTristateEnabled(false);
        this.taskFixedUnitsCheck2 = new TristateCheckBox(Common.I18N_RP.getString("task.makeFixedUnits"));
        this.taskFixedUnitsCheck2.setToolTipText(Common.I18N_RP.getString("task.makeFixedUnits.tooltip"));
        this.taskFixedUnitsCheck2.setTristateEnabled(false);
        this.taskWorkLabel = new JLabel("0h");
        this.taskWorkLabel.setFont(this.taskWorkLabel.getFont().deriveFont(1));
        this.taskWorkLabel.setForeground(Color.DARK_GRAY);
        this.subtreeWorkValue = new JLabel("0h");
        this.subtreeWorkValue.setFont(this.subtreeWorkValue.getFont().deriveFont(1));
        this.subtreeWorkValue.setForeground(Color.DARK_GRAY);
        this.subtreeWorkPanel.setLayout(new GridBagLayout());
        this.subtreeWorkPanel.add((Component)new JLabel(Common.I18N_RP.getString("task.phaseWork") + ": "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 1, insets0Right, 0, 0));
        this.subtreeWorkPanel.add((Component)this.subtreeWorkValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 23, 1, insets0Left, 0, 0));
        this.workInfoPanel.setLayout(new GridBagLayout());
        this.workInfoPanel.add((Component)new JLabel(Common.I18N_RP.getString("task.totalWork") + ": "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, insets0Right, 0, 0));
        this.workInfoPanel.add((Component)this.taskWorkLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, insets0Left, 0, 0));
        this.workInfoPanel.add((Component)this.taskFixedUnitsCheck2, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        this.workInfoPanel.add((Component)this.taskWorkDrivenCheck2, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        this.workInfoPanel.add((Component)this.subtreeWorkPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 23, 1, insets, 0, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.assignmentTable));
        this.assignmentRowHeader = new JRowHeader((JTable)((Object)this.assignmentTable));
        this.assignmentRowHeader.setFixedCellWidth(20);
        jScrollPane.setRowHeaderView(this.assignmentRowHeader);
        JCorner jCorner = new JCorner();
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jCorner);
        jCorner = new JCorner();
        jScrollPane.setCorner("LOWER_LEFT_CORNER", jCorner);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, insets0All, 0, 0));
        jPanel.add((Component)this.workInfoPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 1, insets0All, 0, 0));
        return jPanel;
    }

    private JPanel createNotesTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.taskNotesLabel = new JLabel(Common.I18N_RP.getString("task.notes") + ":");
        this.taskNotesArea = new JTextArea();
        this.taskNotesArea.setLineWrap(true);
        this.taskNotesArea.setWrapStyleWord(true);
        jPanel.add((Component)this.taskNotesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)new JScrollPane(this.taskNotesArea, 20, 31), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JComponent createContents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(Common.I18N_RP.getString("task.details"), this.createDetailsTab());
        this.tabbedPane.add(Common.I18N_RP.getString("task.predecessors"), this.createPredecessorsTab());
        this.tabbedPane.add(Common.I18N_RP.getString("task.successors"), this.createSuccessorsTab());
        this.tabbedPane.add(Common.I18N_RP.getString("task.resources"), this.createResourcesTab());
        this.tabbedPane.add(Common.I18N_RP.getString("task.notes"), this.createNotesTab());
        if (this.useColorsTab) {
            this.barCustomizePanel = new BarCustomizePanel();
            this.tabbedPane.add(Common.I18N_RP.getString("task.colors"), new JScrollPane(this.barCustomizePanel, 20, 30));
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TaskDetailView.this.tabbedPane.getSelectedIndex() == 1) {
                    TaskDetailView.this.predecessorsTable.selected();
                } else if (TaskDetailView.this.tabbedPane.getSelectedIndex() == 2) {
                    TaskDetailView.this.successorsTable.selected();
                } else if (TaskDetailView.this.tabbedPane.getSelectedIndex() == 3) {
                    TaskDetailView.this.assignmentTable.selected();
                }
                if (TaskDetailView.this.tabbedPane.getSelectedIndex() == 4) {
                    TaskDetailView.this.taskNotesArea.grabFocus();
                }
            }
        });
        return this.tabbedPane;
    }

    public void setSelectedIndex(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateValues() {
        void var13_22;
        void var12_17;
        Serializable serializable;
        this.removeListeners();
        this.isProject = false;
        this.isPhase = false;
        this.isSplitted = false;
        this.isParentSplitted = false;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = this.tasks.get(0).isMilestone();
        boolean bl5 = true;
        boolean bl6 = this.tasks.get(0).isWorkDriven();
        boolean bl7 = true;
        boolean bl8 = this.tasks.get(0).isFixedUnits();
        boolean bl9 = true;
        boolean bl10 = this.tasks.get(0).isForcedWorking();
        if (this.tasks.get(0).isSplitted() && this.tasks.get(0).getChildNumber() != 0) {
            bl10 = this.tasks.get(0).getChildAt(0).isForcedWorking();
            bl8 = this.tasks.get(0).getChildAt(0).isFixedUnits();
            bl6 = this.tasks.get(0).getChildAt(0).isWorkDriven();
            bl4 = this.tasks.get(0).getChildAt(0).isMilestone();
        }
        for (Task object2 : this.tasks) {
            if (object2.isEmpty()) {
                this.isEmpty = true;
            }
            if (!object2.isLeaf() && !object2.isSplitted()) {
                this.isPhase = true;
            }
            if (object2.isProject()) {
                this.isProject = true;
            }
            if (object2.isSplitted()) {
                this.isSplitted = true;
            }
            if (object2.isParentSplitted()) {
                this.isParentSplitted = true;
                if (this.tasks.contains(object2.getParent())) {
                    bl = false;
                }
            }
            if (!object2.hasHumanResources()) {
                bl2 = false;
            }
            if (object2.isFixedUnits() != bl8) {
                bl7 = false;
            }
            if (object2.isWorkDriven() != bl6) {
                bl5 = false;
            }
            if (object2.isMilestone() != bl4) {
                bl3 = false;
            }
            if (object2.isForcedWorking() == bl10) continue;
            bl9 = false;
        }
        if (this.isProject) {
            this.constraintDateLabel.setEnabled(false);
            this.taskConstraintDatePicker.setEnabled(false);
            this.taskWorkDrivenCheck1.setEnabled(false);
            this.taskWorkDrivenCheck1.setVisible(false);
            this.taskWorkDrivenCheck2.setEnabled(false);
            this.taskWorkDrivenCheck2.setVisible(false);
            this.taskFixedUnitsCheck1.setEnabled(false);
            this.taskFixedUnitsCheck1.setVisible(false);
            this.taskFixedUnitsCheck2.setEnabled(false);
            this.taskFixedUnitsCheck2.setVisible(false);
        } else if (this.isPhase) {
            this.constraintDateLabel.setEnabled(false);
            this.taskConstraintDatePicker.setEnabled(false);
            this.taskWorkDrivenCheck1.setEnabled(false);
            this.taskWorkDrivenCheck1.setVisible(false);
            this.taskWorkDrivenCheck2.setEnabled(false);
            this.taskWorkDrivenCheck2.setVisible(false);
            this.taskFixedUnitsCheck1.setEnabled(false);
            this.taskFixedUnitsCheck1.setVisible(false);
            this.taskFixedUnitsCheck2.setEnabled(false);
            this.taskFixedUnitsCheck2.setVisible(false);
        } else {
            boolean bl11 = false;
            for (Task task : this.tasks) {
                serializable = task.getConstraint();
                if (!(serializable instanceof ASAP) && !(serializable instanceof ALAP)) continue;
                bl11 = true;
                break;
            }
            if (bl11) {
                this.constraintDateLabel.setEnabled(false);
                this.taskConstraintDatePicker.setEnabled(false);
            } else {
                this.constraintDateLabel.setEnabled(true);
                this.taskConstraintDatePicker.setEnabled(true);
            }
            if (this.isParentSplitted) {
                this.taskWorkDrivenCheck1.setEnabled(false);
                this.taskWorkDrivenCheck2.setEnabled(false);
                this.taskFixedUnitsCheck1.setEnabled(false);
                this.taskFixedUnitsCheck2.setEnabled(false);
            } else {
                this.taskWorkDrivenCheck1.setEnabled(true);
                this.taskWorkDrivenCheck2.setEnabled(true);
                this.taskFixedUnitsCheck1.setEnabled(true);
                this.taskFixedUnitsCheck2.setEnabled(true);
            }
            this.taskWorkDrivenCheck1.setVisible(true);
            this.taskWorkDrivenCheck2.setVisible(true);
            this.taskFixedUnitsCheck1.setVisible(true);
            this.taskFixedUnitsCheck2.setVisible(true);
            this.taskWorkField.setEnabled(bl);
        }
        Object object3 = this.tasks.get(0).getName();
        Long l = this.tasks.get(0).isLeaf() || this.tasks.get(0).isSplitted() ? this.tasks.get(0).getDuration() : this.tasks.get(0).getWorkingDuration();
        Long l2 = this.tasks.get(0).getWork();
        serializable = new Double(this.tasks.get(0).getCompletion());
        Double d = new Double(this.tasks.get(0).getWorkCompletion());
        Date date = this.tasks.get(0).getStartDate();
        Date date2 = this.tasks.get(0).getEndDate();
        Date date3 = this.tasks.get(0).getDeadlineDate();
        String string = ConstraintManager.getConstraintType(this.tasks.get(0).getConstraint());
        Date date4 = this.tasks.get(0).getConstraint().getDate();
        String string2 = this.tasks.get(0).getNotes();
        CalendarManager calendarManager = this.tasks.get(0).getCalendar();
        for (Task task : this.tasks) {
            if (object3 != null && task.getName() != null && !task.getName().equals(object3)) {
                object3 = "";
            }
            if (var12_17 != null) {
                if (task.isLeaf() || task.isSplitted()) {
                    if (task.getDuration() != var12_17.longValue()) {
                        Object var12_18 = null;
                    }
                } else if (task.getWorkingDuration() != var12_17.longValue()) {
                    Object var12_19 = null;
                }
            }
            if (var13_22 != null && task.getWork() != var13_22.longValue()) {
                Object var13_23 = null;
            }
            if (serializable != null && task.getCompletion() != ((Double)serializable).doubleValue()) {
                serializable = null;
            }
            if (d != null && task.getWorkCompletion() != d.doubleValue()) {
                d = null;
            }
            if (date != null && task.getStartDate() != null && !task.getStartDate().equals(date)) {
                date = null;
            }
            if (date2 != null && task.getEndDate() != null && !task.getEndDate().equals(date2)) {
                date2 = null;
            }
            if (task.getDeadlineDate() == null) {
                if (date3 != null) {
                    date3 = null;
                }
            } else if (task.getDeadlineDate() != null) {
                if (date3 == null) {
                    date3 = null;
                } else if (!task.getDeadlineDate().equals(date3)) {
                    date3 = null;
                }
            }
            if (!ConstraintManager.getConstraintType(task.getConstraint()).equals(string)) {
                string = null;
            }
            if (task.getConstraint().getDate() == null && date4 != null) {
                date4 = null;
            } else if (task.getConstraint().getDate() != null) {
                if (date4 == null) {
                    date4 = null;
                } else if (!task.getConstraint().getDate().equals(date4)) {
                    date4 = null;
                }
            }
            if (!task.getNotes().equals(string2)) {
                string2 = "";
            }
            if (task.getCalendar() == null && calendarManager != null) {
                calendarManager = null;
                continue;
            }
            if (task.getCalendar() == null) continue;
            if (calendarManager == null) {
                calendarManager = null;
                continue;
            }
            if (task.getCalendar().equals(calendarManager)) continue;
            calendarManager = null;
        }
        if (this.isProject || this.isPhase) {
            string = null;
            date4 = null;
        }
        this.durationFormat.setTask(this.tasks.get(0));
        this.workDurationFormat.setTask(this.tasks.get(0));
        this.taskNameField.setText((String)object3);
        this.taskDurationField.setValue(var12_17);
        this.taskWorkField.setValue(var13_22);
        this.taskCompletionField.setValue(serializable);
        this.taskWorkCompletionField.setValue(d);
        this.taskStartDatePicker.setSelectedDate(date);
        this.taskEndDatePicker.setSelectedDate(date2);
        this.taskDeadlineDatePicker.setSelectedDate(date3);
        if (bl9) {
            if (bl10) {
                this.taskForcedWorkingCheck.setState(TristateCheckBox.SELECTED);
            } else {
                this.taskForcedWorkingCheck.setState(TristateCheckBox.NOT_SELECTED);
            }
        } else {
            this.taskForcedWorkingCheck.setState(TristateCheckBox.DONT_CARE);
        }
        if (bl5) {
            if (bl6) {
                this.taskWorkDrivenCheck1.setState(TristateCheckBox.SELECTED);
                this.taskWorkDrivenCheck2.setState(TristateCheckBox.SELECTED);
            } else {
                this.taskWorkDrivenCheck1.setState(TristateCheckBox.NOT_SELECTED);
                this.taskWorkDrivenCheck2.setState(TristateCheckBox.NOT_SELECTED);
            }
        } else {
            this.taskWorkDrivenCheck1.setState(TristateCheckBox.DONT_CARE);
            this.taskWorkDrivenCheck2.setState(TristateCheckBox.DONT_CARE);
        }
        if (bl7) {
            if (bl8) {
                this.taskFixedUnitsCheck1.setState(TristateCheckBox.SELECTED);
                this.taskFixedUnitsCheck2.setState(TristateCheckBox.SELECTED);
            } else {
                this.taskFixedUnitsCheck1.setState(TristateCheckBox.NOT_SELECTED);
                this.taskFixedUnitsCheck2.setState(TristateCheckBox.NOT_SELECTED);
            }
        } else {
            this.taskFixedUnitsCheck1.setState(TristateCheckBox.DONT_CARE);
            this.taskFixedUnitsCheck2.setState(TristateCheckBox.DONT_CARE);
        }
        if (bl3) {
            if (bl4) {
                this.milestoneCheck.setState(TristateCheckBox.SELECTED);
            } else {
                this.milestoneCheck.setState(TristateCheckBox.NOT_SELECTED);
            }
        } else {
            this.milestoneCheck.setState(TristateCheckBox.DONT_CARE);
        }
        this.taskConstraintsCombo.setSelectedItem(string);
        this.taskConstraintDatePicker.setSelectedDate(date4);
        try {
            this.taskNotesArea.setText(string2);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        long l3 = 0L;
        for (Task task : this.tasks) {
            l3 += task.getWork();
        }
        this.taskWorkLabel.setText(TaskWorkDurationFormat.formatWork(this.tasks.get(0), l3));
        if (calendarManager == null) {
            this.taskCalendarCombo.setSelectedIndex(0);
        } else {
            this.taskCalendarCombo.setSelectedItem(calendarManager);
        }
        long l4 = 0L;
        for (Task task : this.tasks) {
            l4 += task.getWorkExceptChildren();
        }
        this.subtreeWorkValue.setText(TaskWorkDurationFormat.formatWork(this.tasks.get(0), Double.valueOf(l4)));
        this.addListeners();
    }

    private class TaskHandler
    extends TaskAdapter {
        private TaskHandler() {
        }

        public void assignmentAdded(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void assignmentRemoved(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void nameChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void splittedChanged(TaskEvent taskEvent) {
            if (TaskDetailView.this.useColorsTab) {
                TaskDetailView.this.barCustomizePanel.setTasks(TaskDetailView.this.tasks);
            }
            AssignmentTableModel assignmentTableModel = (AssignmentTableModel)TaskDetailView.this.assignmentTable.getModel();
            assignmentTableModel.removeUndoableEditListener(TaskDetailView.this.undoHandler);
            TaskDetailView.this.assignmentTable.setModel(new AssignmentTableModel(TaskDetailView.this.tasks));
            assignmentTableModel.addUndoableEditListener(TaskDetailView.this.undoHandler);
        }

        public void notesChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void fixedCostChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void accrualChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void forcedWorkingChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void fixedUnitsChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void childAdded(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void childRemoved(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void predecessorAdded(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void predecessorRemoved(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void dataChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }

        public void taskTypeChanged(TaskEvent taskEvent) {
            TaskDetailView.this.updateValues();
        }
    }

    private class CompanyHandler
    extends CompanyAdapter {
        private CompanyHandler() {
        }

        public void calendarAdded(CompanyEvent companyEvent) {
            this.refresh();
        }

        public void calendarRemoved(CompanyEvent companyEvent) {
            this.refresh();
        }

        private void refresh() {
            LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>(((Task)TaskDetailView.this.tasks.get(0)).getCompany().getCalendarList());
            boolean bl = false;
            CalendarManager calendarManager = ((Task)TaskDetailView.this.tasks.get(0)).getCalendar();
            if (calendarManager != null) {
                for (Task task : TaskDetailView.this.tasks) {
                    if (task.isProject()) {
                        bl = true;
                    }
                    if (task.getCalendar() == null) {
                        calendarManager = null;
                        continue;
                    }
                    if (task.getCalendar().equals(calendarManager)) continue;
                    calendarManager = null;
                }
            } else {
                for (Task task : TaskDetailView.this.tasks) {
                    if (!task.isProject()) continue;
                    bl = true;
                }
            }
            if (bl) {
                linkedList.add(0, (CalendarManager)((Object)Common.I18N_RP.getString("useCompanyCalendar")));
            } else {
                linkedList.add(0, (CalendarManager)((Object)Common.I18N_RP.getString("useProjectCalendar")));
            }
            TaskDetailView.this.taskCalendarCombo.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
            if (calendarManager == null) {
                TaskDetailView.this.taskCalendarCombo.setSelectedIndex(0);
            } else {
                TaskDetailView.this.taskCalendarCombo.setSelectedItem(calendarManager);
            }
        }
    }

    private class WorkCompletionHandler
    implements FocusListener,
    ActionListener {
        private WorkCompletionHandler() {
        }

        private void doIt() {
            try {
                TaskDetailView.this.taskWorkCompletionField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            double d = (Double)TaskDetailView.this.taskWorkCompletionField.getValue();
            double d2 = ((Task)TaskDetailView.this.tasks.get(0)).getWorkCompletion();
            if (d != d2) {
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                for (Task task : TaskDetailView.this.tasks) {
                    Serializable serializable;
                    int n;
                    Serializable serializable2;
                    if (task.isParentSplitted()) {
                        serializable2 = task.getParent();
                        int n2 = ((Task)serializable2).getChildIndex(task);
                        for (n = 0; n < n2; ++n) {
                            Task task2 = ((Task)serializable2).getChildAt(n);
                            serializable = new TaskWorkCompletionEdit(task2, task2.getWorkCompletion(), 100.0, "01-10-2009 17:20:00");
                            task2.setWorkCompletion(100.0, true);
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                        }
                    }
                    serializable2 = new TaskWorkCompletionEdit(task, task.getWorkCompletion(), d, "01-10-2009 17:20:01");
                    task.setWorkCompletion(d, true);
                    extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable2));
                    if (task.isParentSplitted()) {
                        Task task3 = task.getParent();
                        n = task3.getChildIndex(task);
                        for (int i = n + 1; i < task3.getChildNumber(); ++i) {
                            serializable = task3.getChildAt(i);
                            serializable2 = new TaskWorkCompletionEdit((Task)serializable, ((Task)serializable).getWorkCompletion(), 0.0, "01-10-2009 17:20:05");
                            ((Task)serializable).setWorkCompletion(0.0, true);
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable2));
                        }
                    }
                    TaskPlanner.rescheduleTree(task);
                }
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class CompletionHandler
    implements FocusListener,
    ActionListener {
        private CompletionHandler() {
        }

        private void doIt() {
            try {
                TaskDetailView.this.taskCompletionField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            double d = (Double)TaskDetailView.this.taskCompletionField.getValue();
            double d2 = ((Task)TaskDetailView.this.tasks.get(0)).getCompletion();
            if (d != d2) {
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                for (Task task : TaskDetailView.this.tasks) {
                    Serializable serializable;
                    int n;
                    Serializable serializable2;
                    if (task.isParentSplitted()) {
                        serializable2 = task.getParent();
                        int n2 = ((Task)serializable2).getChildIndex(task);
                        for (n = 0; n < n2; ++n) {
                            Task task2 = ((Task)serializable2).getChildAt(n);
                            serializable = new TaskCompletionEdit(task2, task.getCompletion(), 100.0, "09/11/09 12:40:02");
                            task2.setCompletion(100.0);
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                        }
                    }
                    serializable2 = new TaskCompletionEdit(task, task.getCompletion(), d, "09/11/09 12:40:03");
                    task.setCompletion(d);
                    extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable2));
                    if (task.isParentSplitted()) {
                        Task task3 = task.getParent();
                        n = task3.getChildIndex(task);
                        for (int i = n + 1; i < task3.getChildNumber(); ++i) {
                            serializable = task3.getChildAt(i);
                            serializable2 = new TaskCompletionEdit((Task)serializable, task.getCompletion(), 0.0, "09/11/09 12:40:04");
                            ((Task)serializable).setCompletion(0.0);
                            extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable2));
                        }
                    }
                    TaskPlanner.rescheduleTree(task);
                }
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class WorkHandler
    implements FocusListener,
    ActionListener {
        private WorkHandler() {
        }

        private void doIt() {
            long l;
            try {
                TaskDetailView.this.taskWorkField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            long l2 = l = ((Task)TaskDetailView.this.tasks.get(0)).isLeaf() || ((Task)TaskDetailView.this.tasks.get(0)).isSplitted() ? ((Task)TaskDetailView.this.tasks.get(0)).getWork() : ((Task)TaskDetailView.this.tasks.get(0)).getWorkExceptChildren();
            if (!TaskDetailView.this.taskWorkField.getValue().equals(l)) {
                long l3 = (Long)TaskDetailView.this.taskWorkField.getValue();
                if (TaskDetailView.this.tasks.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    for (Task task : TaskDetailView.this.tasks) {
                        TaskWorkEdit taskWorkEdit = new TaskWorkEdit(task, l3, "01-10-2009 17:31:00");
                        task.changeWork(l3, true);
                        extendedCompoundEdit.addEdit(taskWorkEdit);
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class DurationHandler
    implements FocusListener,
    ActionListener {
        private DurationHandler() {
        }

        private void doIt() {
            long l;
            try {
                TaskDetailView.this.taskDurationField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            long l2 = l = ((Task)TaskDetailView.this.tasks.get(0)).isLeaf() || ((Task)TaskDetailView.this.tasks.get(0)).isSplitted() ? ((Task)TaskDetailView.this.tasks.get(0)).getDuration() : ((Task)TaskDetailView.this.tasks.get(0)).getWorkingDuration();
            if (!TaskDetailView.this.taskDurationField.getValue().equals(l)) {
                long l3 = (Long)TaskDetailView.this.taskDurationField.getValue();
                if (TaskDetailView.this.tasks.size() > 0) {
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit((Task)TaskDetailView.this.tasks.get(0));
                    for (Task task : TaskDetailView.this.tasks) {
                        TaskDurationEdit taskDurationEdit = new TaskDurationEdit(task, task.getDuration(), l3, "02-10-2009 13:00:05");
                        task.changeDuration(l3);
                        extendedCompoundEdit.addEdit(taskDurationEdit);
                    }
                    extendedCompoundEdit.end();
                    TaskPlanner.rescheduleTree((Task)TaskDetailView.this.tasks.get(0));
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class NotesHandler
    implements FocusListener {
        private String oldNotes = "";

        private NotesHandler() {
        }

        private void doIt() {
            String string = TaskDetailView.this.taskNotesArea.getText();
            if (!string.equals(this.oldNotes)) {
                ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                for (Task task : TaskDetailView.this.tasks) {
                    TaskNotesEdit taskNotesEdit = new TaskNotesEdit(task, this.oldNotes, string, "05/10/2009 16:56:00");
                    task.setNotes(string);
                    extendedCompoundEdit.addEdit(taskNotesEdit);
                }
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldNotes = TaskDetailView.this.taskNotesArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class NameHandler
    implements FocusListener,
    ActionListener {
        private NameHandler() {
        }

        private void doIt() {
            if (!TaskDetailView.this.taskNameField.getText().equals("")) {
                String string = TaskDetailView.this.taskNameField.getText();
                ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                for (Task task : TaskDetailView.this.tasks) {
                    TaskNameEdit taskNameEdit = new TaskNameEdit(task, task.getName(), string, "02-10-2009 12:41:09");
                    task.setName(string);
                    extendedCompoundEdit.addEdit(taskNameEdit);
                }
                extendedCompoundEdit.end();
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                TaskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BarCustomizePanel
    extends JPanel
    implements ChangeListener {
        private JColorChooser colorChooser;
        private JPanel sampleBarColor;
        private List<Task> currentTasks;
        JButton restoreSubtreeColorsButton;
        private boolean temporaryIgnoreMessages = false;
        private JCheckBox currentTaskCheckBox = new JCheckBox();
        private JLabel currentTaskLabel;
        private JLabel activitiesLabel;
        private JLabel phasesLabel;
        private JLabel milestonesLabel;
        private JCheckBox activitiesCheckbox = new JCheckBox();
        private JCheckBox phasesCheckbox = new JCheckBox();
        private JCheckBox milestonesCheckbox = new JCheckBox();
        private Action defaultColorAction = new AbstractAction(Common.I18N_RP.getString("defaultBarColor")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TaskDetailView.this.tasks.isEmpty() || TaskDetailView.this.isEmpty) {
                    return;
                }
                for (Task task : TaskDetailView.this.tasks) {
                    task.setBarColor(null);
                }
                Color color = BarCustomizePanel.this.computeColor();
                BarCustomizePanel.this.sampleBarColor.setBackground(color);
                BarCustomizePanel.this.defaultColorButton.setEnabled(false);
            }
        };
        private JButton defaultColorButton = new JButton(this.defaultColorAction);
        private ItemListener checkChangeListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (BarCustomizePanel.this.temporaryIgnoreMessages) {
                    return;
                }
                Color color = BarCustomizePanel.this.colorChooser.getColor();
                JCheckBox jCheckBox = null;
                if (itemEvent.getStateChange() == 2) {
                    jCheckBox = (JCheckBox)itemEvent.getSource();
                }
                for (Task task : TaskDetailView.this.tasks) {
                    BarCustomizePanel.this.setTreeColor(task, color, jCheckBox);
                }
            }
        };

        private BarCustomizePanel() {
            this.setLayout(new GridBagLayout());
            Insets insets = new Insets(1, 1, 1, 1);
            this.colorChooser = new ColorChooserNoHSB();
            this.colorChooser.setPreviewPanel(new JPanel());
            this.sampleBarColor = new JPanel();
            this.sampleBarColor.setPreferredSize(new Dimension(70, 15));
            this.sampleBarColor.setMaximumSize(this.sampleBarColor.getPreferredSize());
            this.sampleBarColor.setForeground(this.colorChooser.getColor());
            this.sampleBarColor.setBackground(this.colorChooser.getColor());
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(Common.I18N_RP.getString("sampleBarColor") + ":"));
            jPanel.add((Component)this.sampleBarColor, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, insets, 0, 0));
            jPanel.add((Component)this.defaultColorButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, insets, 0, 0));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder(Common.I18N_RP.getString("chooseColor")));
            jPanel2.add((Component)this.colorChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            jPanel2.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBorder(BorderFactory.createTitledBorder(Common.I18N_RP.getString("useSelectedColor") + ": "));
            int n = 0;
            this.currentTaskLabel = new JLabel(Common.I18N_RP.getString("currentTask") + ":");
            jPanel3.add((Component)this.currentTaskLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel3.add((Component)this.currentTaskCheckBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
            this.activitiesLabel = new JLabel(Common.I18N_RP.getString("activitiesSubtasks") + ":");
            jPanel3.add((Component)this.activitiesLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel3.add((Component)this.activitiesCheckbox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.milestonesLabel = new JLabel(Common.I18N_RP.getString("milstonesSubtasks") + ":");
            jPanel3.add((Component)this.milestonesLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel3.add((Component)this.milestonesCheckbox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.phasesLabel = new JLabel(Common.I18N_RP.getString("subPhases") + ":");
            jPanel3.add((Component)this.phasesLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            jPanel3.add((Component)this.phasesCheckbox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.restoreSubtreeColorsButton = new JButton();
            this.restoreSubtreeColorsButton.setAction(new AbstractAction(Common.I18N_RP.getString("defaultSubtreeColors")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TaskDetailView.this.tasks.isEmpty() || TaskDetailView.this.isEmpty) {
                        return;
                    }
                    for (Task task : TaskDetailView.this.tasks) {
                        BarCustomizePanel.this.resetTreeColor(task);
                    }
                    Color color = BarCustomizePanel.this.computeColor();
                    BarCustomizePanel.this.colorChooser.setColor(color);
                    BarCustomizePanel.this.sampleBarColor.setBackground(color);
                    BarCustomizePanel.this.defaultColorButton.setEnabled(false);
                    BarCustomizePanel.this.currentTaskCheckBox.setSelected(false);
                    BarCustomizePanel.this.activitiesCheckbox.setSelected(false);
                    BarCustomizePanel.this.phasesCheckbox.setSelected(false);
                    BarCustomizePanel.this.milestonesCheckbox.setSelected(false);
                }
            });
            jPanel3.add((Component)this.restoreSubtreeColorsButton, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 0, insets, 0, 0));
            this.currentTaskCheckBox.setSelected(true);
            this.currentTaskCheckBox.addItemListener(this.checkChangeListener);
            this.activitiesCheckbox.addItemListener(this.checkChangeListener);
            this.phasesCheckbox.addItemListener(this.checkChangeListener);
            this.milestonesCheckbox.addItemListener(this.checkChangeListener);
            this.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)jPanel3, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 1, insets, 0, 0));
            this.colorChooser.getSelectionModel().addChangeListener(this);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.currentTaskLabel.setEnabled(bl);
            this.activitiesLabel.setEnabled(bl);
            this.phasesLabel.setEnabled(bl);
            this.milestonesLabel.setEnabled(bl);
            this.currentTaskCheckBox.setEnabled(bl);
            this.activitiesCheckbox.setEnabled(bl);
            this.phasesCheckbox.setEnabled(bl);
            this.milestonesCheckbox.setEnabled(bl);
            this.defaultColorButton.setEnabled(bl);
            this.restoreSubtreeColorsButton.setEnabled(bl);
        }

        public void setTasks(List<Task> list) {
            this.temporaryIgnoreMessages = true;
            this.currentTasks = list;
            if (list.isEmpty() || TaskDetailView.this.isEmpty) {
                this.colorChooser.setEnabled(false);
                this.sampleBarColor.setBackground(Color.WHITE);
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            boolean bl = list.get(0).getBarColor() != null && !list.get(0).getBarColor().equals(this.getDefaultColor(list.get(0)));
            for (Task task : list) {
                if (task.getBarColor() == null) continue;
                bl = bl && !task.getBarColor().equals(this.getDefaultColor(task));
            }
            this.activitiesCheckbox.setSelected(false);
            this.phasesCheckbox.setSelected(false);
            this.milestonesCheckbox.setSelected(false);
            if (TaskDetailView.this.isProject || TaskDetailView.this.isPhase || TaskDetailView.this.isSplitted) {
                this.activitiesLabel.setEnabled(true);
                this.phasesLabel.setEnabled(true);
                this.milestonesLabel.setEnabled(true);
                this.activitiesCheckbox.setEnabled(true);
                this.phasesCheckbox.setEnabled(true);
            } else {
                this.activitiesLabel.setEnabled(false);
                this.phasesLabel.setEnabled(false);
                this.milestonesLabel.setEnabled(false);
                this.activitiesCheckbox.setEnabled(false);
                this.phasesCheckbox.setEnabled(false);
                this.milestonesCheckbox.setEnabled(false);
            }
            Color color = this.computeColor();
            this.colorChooser.setColor(color);
            this.sampleBarColor.setBackground(color);
            this.currentTaskCheckBox.setSelected(true);
            this.defaultColorButton.setEnabled(bl);
            this.temporaryIgnoreMessages = false;
        }

        public Color getDefaultColor(Task task) {
            JAreaView jAreaView = Common.getApplication().getWorkspace().getJProject().getAreaView();
            JProjectViewGantt jProjectViewGantt = (JProjectViewGantt)jAreaView.getViewComponent(JAreaView.GANTT);
            JArea jArea = jProjectViewGantt.getGantt().getArea();
            ChartUIConfiguration chartUIConfiguration = jArea.getChartUIConfiguration();
            return chartUIConfiguration.getDefaultColor(task);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.currentTasks.isEmpty() || TaskDetailView.this.isEmpty) {
                return;
            }
            Color color = this.colorChooser.getColor();
            this.sampleBarColor.setBackground(color);
            if (this.temporaryIgnoreMessages) {
                return;
            }
            this.defaultColorButton.setEnabled(true);
            for (Task task : TaskDetailView.this.tasks) {
                this.setTreeColor(task, color, null);
            }
        }

        private Color computeColor() {
            Color color = ((Task)TaskDetailView.this.tasks.get(0)).getBarColor() != null ? ((Task)TaskDetailView.this.tasks.get(0)).getBarColor() : this.getDefaultColor((Task)TaskDetailView.this.tasks.get(0));
            boolean bl = ((Task)TaskDetailView.this.tasks.get(0)).getBarColor() != null && !((Task)TaskDetailView.this.tasks.get(0)).getBarColor().equals(this.getDefaultColor((Task)TaskDetailView.this.tasks.get(0)));
            for (Task task : TaskDetailView.this.tasks) {
                if (color != null) {
                    if (task.getBarColor() != null) {
                        if (!task.getBarColor().equals(color)) {
                            color = null;
                        }
                    } else if (!this.getDefaultColor(task).equals(color)) {
                        color = null;
                    }
                }
                if (task.getBarColor() == null) continue;
                bl = bl && !task.getBarColor().equals(this.getDefaultColor(task));
            }
            if (color == null) {
                color = Color.WHITE;
            }
            return color;
        }

        private void setTreeColor(Task task, Color color, JCheckBox jCheckBox) {
            if (task == null || task.isEmpty()) {
                return;
            }
            if (this.currentTasks.contains(task)) {
                if (this.currentTaskCheckBox.isSelected()) {
                    task.setBarColor(color);
                } else if (jCheckBox == this.currentTaskCheckBox) {
                    task.setBarColor(null);
                }
            } else if (task.isMilestone()) {
                if (this.milestonesCheckbox.isSelected()) {
                    task.setBarColor(color);
                } else if (jCheckBox == this.milestonesCheckbox) {
                    task.setBarColor(null);
                }
            } else if (task.isLeaf()) {
                if (this.activitiesCheckbox.isSelected()) {
                    task.setBarColor(color);
                } else if (this.activitiesCheckbox == jCheckBox) {
                    task.setBarColor(null);
                }
            } else if (this.phasesCheckbox.isSelected()) {
                task.setBarColor(color);
            } else if (jCheckBox == this.phasesCheckbox) {
                task.setBarColor(null);
            }
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task2 = task.getChildAt(i);
                this.setTreeColor(task2, color, jCheckBox);
            }
        }

        private void resetTreeColor(Task task) {
            if (task == null || task.isEmpty()) {
                return;
            }
            task.setBarColor(null);
            for (int i = 0; i < task.getChildNumber(); ++i) {
                Task task2 = task.getChildAt(i);
                this.resetTreeColor(task2);
            }
        }
    }
}

