/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Risk;
import com.sbs.jpm.core.event.RiskEvent;
import com.sbs.jpm.core.event.RiskListener;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.undo.RiskResponsePlanEdit;
import com.sbs.jpm.undo.UndoHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class RiskDetailView
extends JPanel {
    private Risk risk;
    private JLabel riskNameLabel;
    private JLabel riskResponsePlanLabel;
    private JTextArea riskResponsePlanArea;
    private JPanel panel;
    private DocumentListener riskResponsePlanListener;
    private EventListenerList listeners;
    private ResponsePlanHandler responsePlanHandler;
    private UndoHandler undoHandler;
    private RiskListener riskHandler;

    public RiskDetailView() {
        this.setLayout(new BorderLayout());
        this.listeners = new EventListenerList();
        this.responsePlanHandler = new ResponsePlanHandler();
        this.riskHandler = new RiskHandler();
        this.add((Component)this.createContents(), "Center");
        this.riskResponsePlanListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!RiskDetailView.this.riskResponsePlanArea.getText().equals(RiskDetailView.this.risk.getResponsePlan())) {
                    RiskDetailView.this.risk.setResponsePlan(RiskDetailView.this.riskResponsePlanArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!RiskDetailView.this.riskResponsePlanArea.getText().equals(RiskDetailView.this.risk.getResponsePlan())) {
                    RiskDetailView.this.risk.setResponsePlan(RiskDetailView.this.riskResponsePlanArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    public void setRisk(Risk risk) {
        if (this.risk != null) {
            this.risk.removeRiskListener(this.riskHandler);
        }
        this.risk = risk;
        if (this.risk == null) {
            this.removeListeners();
            this.riskNameLabel.setText(" ");
            this.riskResponsePlanArea.setText("");
            this.riskNameLabel.setEnabled(false);
            this.riskResponsePlanLabel.setEnabled(false);
            this.riskResponsePlanArea.setEnabled(false);
            this.addListeners();
        } else {
            this.updateValues();
        }
        if (this.risk != null) {
            this.risk.addRiskListener(this.riskHandler);
        }
    }

    private JComponent createContents() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        Insets insets2 = new Insets(1, 5, 1, 1);
        this.riskNameLabel = new JLabel("");
        this.riskResponsePlanLabel = new JLabel(Common.I18N_RP.getString("risk.notes") + ":");
        this.riskResponsePlanArea = new JTextArea(4, 0);
        this.riskResponsePlanArea.setLineWrap(true);
        this.riskResponsePlanArea.setWrapStyleWord(true);
        JLabel jLabel = new JLabel(Common.I18N_RP.getString("risk.description") + ": ");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        this.riskNameLabel.setFont(this.riskNameLabel.getFont().deriveFont(1));
        jLabel.setForeground(Color.DARK_GRAY);
        this.riskNameLabel.setForeground(Color.DARK_GRAY);
        this.panel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        this.panel.add((Component)this.riskNameLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 0, insets2, 0, 0));
        this.panel.add((Component)this.riskResponsePlanLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        this.panel.add((Component)new JScrollPane(this.riskResponsePlanArea, 20, 31), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return this.panel;
    }

    private void addListeners() {
        this.riskResponsePlanArea.getDocument().addDocumentListener(this.riskResponsePlanListener);
        this.riskResponsePlanArea.addFocusListener(this.responsePlanHandler);
    }

    private void removeListeners() {
        this.riskResponsePlanArea.getDocument().removeDocumentListener(this.riskResponsePlanListener);
        this.riskResponsePlanArea.removeFocusListener(this.responsePlanHandler);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void updateValues() {
        this.removeListeners();
        this.riskNameLabel.setEnabled(true);
        this.riskResponsePlanArea.setEnabled(true);
        this.riskResponsePlanLabel.setEnabled(true);
        String string = this.risk.getDescription().length() > 20 ? this.risk.getDescription().substring(0, 20) + "..." : this.risk.getDescription();
        this.riskNameLabel.setText(string);
        try {
            this.riskResponsePlanArea.setText(this.risk.getResponsePlan());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        new JTextComponentUndoHandler(this.riskResponsePlanArea);
        this.removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(this.risk.getOwner().getUndoManager());
        this.addUndoableEditListener(this.undoHandler);
        this.addListeners();
    }

    private class RiskHandler
    implements RiskListener {
        private RiskHandler() {
        }

        public void dataChanged(RiskEvent riskEvent) {
        }

        public void responsePlanChanged(RiskEvent riskEvent) {
            RiskDetailView.this.updateValues();
        }
    }

    private class ResponsePlanHandler
    implements FocusListener {
        private String oldResponsePlan = "";

        private ResponsePlanHandler() {
        }

        private void doIt() {
            String string = RiskDetailView.this.riskResponsePlanArea.getText();
            if (!string.equals(this.oldResponsePlan)) {
                RiskResponsePlanEdit riskResponsePlanEdit = new RiskResponsePlanEdit(RiskDetailView.this.risk, this.oldResponsePlan, string, "05/10/2009 16:07:00");
                RiskDetailView.this.risk.setResponsePlan(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, riskResponsePlanEdit);
                RiskDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldResponsePlan = RiskDetailView.this.riskResponsePlanArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }
}

