/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.document.DocumentException;
import com.sbs.util.CustomNameFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class MRUList {
    private JMenu fileMenu;
    private int mruCount;
    private static final int MAX_COUNT = 10;
    private int menuIndex;

    public MRUList(JMenu jMenu) {
        this.fileMenu = jMenu;
        this.menuIndex = jMenu.getMenuComponentCount();
        Configuration configuration = Configuration.getInstance();
        List list = (List)configuration.getValue(ConfigurationSetting.MRU_FILES);
        for (int i = list.size() - 1; i >= 0; --i) {
            this.addMRUItem(list.get(i).toString());
        }
    }

    public void addMRUItem(String string) {
        JMenuItem jMenuItem;
        int n;
        final CustomNameFile customNameFile = new CustomNameFile(string);
        JMenuItem jMenuItem2 = new JMenuItem();
        String string2 = "0 " + ((File)customNameFile).getName();
        jMenuItem2.setText(string2);
        jMenuItem2.setToolTipText(((File)customNameFile).getAbsolutePath());
        jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png")));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                    companyDocumentManager.open(customNameFile);
                }
                catch (DocumentException documentException) {
                    Common.logException("Error:", documentException);
                    JOptionPane.showMessageDialog(null, documentException.getLocalizedMessage(), Common.I18N_MESSAGES.getString("file.failedToOpen"), 0);
                }
                Configuration.getInstance().setValue(ConfigurationSetting.CURRENT_DIR, customNameFile.getParent());
            }
        });
        for (n = this.menuIndex; n < this.menuIndex + this.mruCount; ++n) {
            jMenuItem = (JMenuItem)this.fileMenu.getMenuComponent(n);
            if (!jMenuItem.getText().substring(2).equals(string2.substring(2))) continue;
            this.fileMenu.remove(n);
            --this.mruCount;
            break;
        }
        if (this.mruCount == 10) {
            this.fileMenu.remove(this.menuIndex + this.mruCount - 1);
            --this.mruCount;
        }
        this.fileMenu.insert(jMenuItem2, this.menuIndex);
        ++this.mruCount;
        for (n = 0; n < this.mruCount; ++n) {
            jMenuItem = (JMenuItem)this.fileMenu.getMenuComponent(this.menuIndex + n);
            jMenuItem.setText(n + " " + jMenuItem.getText().substring(2));
            jMenuItem.setMnemonic((int)jMenuItem.getText().charAt(0));
        }
    }

    public List getMRUList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = this.menuIndex; i < this.menuIndex + this.mruCount; ++i) {
            JMenuItem jMenuItem = (JMenuItem)this.fileMenu.getMenuComponent(i);
            arrayList.add(jMenuItem.getToolTipText());
        }
        return arrayList;
    }
}

