/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.core.Task;
import com.sbs.jpm.undo.UndoHandler;
import com.sbs.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public abstract class JProjectView
extends JPanel {
    public static boolean BLOCK_UPDATE = false;
    protected Task project;
    protected JToolBar toolBar;
    protected EventListenerList listeners = new EventListenerList();
    protected UndoHandler undoHandler;

    public JProjectView() {
        this.setLayout(new BorderLayout());
        this.setBorder(new LineBorder(Color.GRAY));
        this.add((Component)this.createContents(), "Center");
        this.createToolBar();
    }

    protected abstract JPanel createContents();

    protected void createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        if (SystemUtilities.isOSMac()) {
            this.toolBar.setRollover(false);
        } else {
            this.toolBar.setRollover(true);
        }
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setProject(Task task) {
        this.project = task;
        this.removeUndoableEditListener(this.undoHandler);
        if (task != null) {
            this.undoHandler = new UndoHandler(task.getCompany().getUndoManager());
        }
        this.addUndoableEditListener(this.undoHandler);
    }

    protected abstract void updateDetailsAndToolbar();

    public void updateToolbar() {
        if (!BLOCK_UPDATE) {
            this.updateDetailsAndToolbar();
        }
    }

    public Task getProject() {
        return this.project;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    public void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }
}

