/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.core.Link;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.LinkDescriptionEdit;
import com.sbs.jpm.undo.LinkInsertEdit;
import com.sbs.jpm.undo.LinkNameEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoableEdit;

public class JLinkEditorDialog
extends JDialog {
    private JLabel messageLabel;
    private JLabel linkLabel;
    private JLabel descriptionLabel;
    private JTextField linkField;
    private JButton browseButton;
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea descriptionArea;
    private JFileChooser fileChooser;
    private Link link;
    private Task project;
    private JProjectView projectView;

    public JLinkEditorDialog(Task task, Link link, JProjectView jProjectView) {
        this.link = link;
        this.project = task;
        this.projectView = jProjectView;
        this.setTitle(Common.I18N_RP.getString("insertLink"));
        ((Frame)this.getOwner()).setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.setModal(true);
        this.setResizable(false);
        String string = "<html>" + Common.I18N_RP.getString("enterInternetAddress") + "</html>";
        this.messageLabel = new JLabel(string);
        this.linkLabel = new JLabel(Common.I18N_RP.getString("link") + ": ");
        this.descriptionLabel = new JLabel(Common.I18N_RP.getString("description") + ": ");
        this.linkField = new JTextField(link != null ? link.getName() : "", 20);
        this.linkField.selectAll();
        this.browseButton = new JButton(Common.I18N_RP.getString("browse") + "...");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (JLinkEditorDialog.this.fileChooser == null) {
                    String string = (String)Configuration.getInstance().getValue(ConfigurationSetting.CURRENT_DIR);
                    JLinkEditorDialog.this.fileChooser = new JFileChooser(new File(string));
                }
                if ((n = JLinkEditorDialog.this.fileChooser.showDialog(null, Common.I18N_RP.getString("ok"))) == 0) {
                    String string = JLinkEditorDialog.this.fileChooser.getSelectedFile().getAbsolutePath();
                    string = string.replace('\\', '/');
                    JLinkEditorDialog.this.linkField.setText("file://" + string);
                }
            }
        });
        this.okButton = new JButton(Common.I18N_RP.getString("ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JLinkEditorDialog.this.linkField.getText();
                if (string.toLowerCase().startsWith("www.")) {
                    string = "http://" + string;
                }
                if (JLinkEditorDialog.this.link == null) {
                    Link link = new Link(JLinkEditorDialog.this.project.getCompany().getIdGenerator().getNewId(), string);
                    int n = JLinkEditorDialog.this.project.getLinksNumber();
                    LinkInsertEdit linkInsertEdit = new LinkInsertEdit(JLinkEditorDialog.this.project, link, n, "05/10/2009 11:56:00");
                    link.setDescription(JLinkEditorDialog.this.descriptionArea.getText());
                    JLinkEditorDialog.this.project.addLink(link);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, linkInsertEdit);
                    JLinkEditorDialog.this.projectView.fireUndoableEditHappened(undoableEditEvent);
                } else {
                    Serializable serializable;
                    String string2 = JLinkEditorDialog.this.link.getName();
                    String string3 = JLinkEditorDialog.this.link.getDescription();
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    if (!string2.equals(string)) {
                        serializable = new LinkNameEdit(JLinkEditorDialog.this.link, string2, string, "05/10/2009 12:09:00");
                        JLinkEditorDialog.this.link.setName(string);
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    if (!string3.equals(JLinkEditorDialog.this.descriptionArea.getText())) {
                        serializable = new LinkDescriptionEdit(JLinkEditorDialog.this.link, string3, JLinkEditorDialog.this.descriptionArea.getText(), "05/10/2009 12:17:00");
                        JLinkEditorDialog.this.link.setDescription(JLinkEditorDialog.this.descriptionArea.getText());
                        extendedCompoundEdit.addEdit((UndoableEdit)((Object)serializable));
                    }
                    extendedCompoundEdit.end();
                    serializable = new UndoableEditEvent(this, extendedCompoundEdit);
                    JLinkEditorDialog.this.projectView.fireUndoableEditHappened((UndoableEditEvent)serializable);
                }
                JLinkEditorDialog.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton(Common.I18N_RP.getString("cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JLinkEditorDialog.this.setVisible(false);
            }
        });
        this.descriptionArea = new JTextArea(link != null ? link.getDescription() : "", 5, 20);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JLinkEditorDialog.this.setVisible(false);
            }
        });
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)this.messageLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 1, insets, 0, 0));
        jPanel.add((Component)this.linkLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.linkField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.descriptionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JScrollPane(this.descriptionArea), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        jPanel.add((Component)this.okButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        jPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        return jPanel;
    }
}

