/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Dependency;
import com.sbs.jpm.core.DependencyManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.event.DependencyAdapter;
import com.sbs.jpm.core.event.DependencyEvent;
import com.sbs.jpm.core.event.DependencyListener;
import com.sbs.jpm.ui.component.util.LagFormat;
import com.sbs.jpm.undo.DependencyLagEdit;
import com.sbs.jpm.undo.DependencyTypeEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskRemoveDependencyEdit;
import com.sbs.jpm.undo.UndoHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;

public class JDependencyDetails
extends JDialog {
    private UndoHandler undoHandler;
    private EventListenerList listeners = new EventListenerList();
    private Dependency dependency;
    private JLabel predecessorNameLabel;
    private JLabel successorNameLabel;
    private JLabel predecessorName;
    private JLabel successorName;
    private JLabel lagLabel;
    private JLabel typeLabel;
    private JComboBox typeCombo;
    private JFormattedTextField lagField;
    private ItemListener typeItemListener;
    private DependencyLagHandler dependencyLagListener;
    private LagFormat lagFormat;
    private DependencyListener dependencyHandler;
    private JButton deleteButton;

    public JDependencyDetails(Frame frame) {
        super(frame, Common.I18N_ACTIONS.getString("details.dependency"), true);
        this.setLayout(new BorderLayout());
        this.lagFormat = new LagFormat();
        this.dependencyHandler = new DependencyHandler();
        this.add((Component)this.createContents(), "Center");
        this.dependencyLagListener = new DependencyLagHandler();
        this.typeItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = JDependencyDetails.this.dependency.getType();
                    int n2 = DependencyManager.getDependencyType((String)itemEvent.getItem());
                    JDependencyDetails.this.dependency.setType(n2);
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, ExtendedCompoundEdit.createReschedulSingleEdit(JDependencyDetails.this.dependency.getPredecessor(), new DependencyTypeEdit(JDependencyDetails.this.dependency, n, n2, "15-09-09 12:26:02")));
                    JDependencyDetails.this.fireUndoableEditHappened(undoableEditEvent);
                    TaskPlanner.rescheduleTree(JDependencyDetails.this.dependency.getPredecessor());
                }
            }
        };
    }

    public void setDependency(Dependency dependency) {
        if (this.dependency != null) {
            this.dependency.removeDependencyListener(this.dependencyHandler);
        }
        this.dependency = dependency;
        if (this.dependency != null) {
            dependency.addDependencyListener(this.dependencyHandler);
        }
        this.removeListeners();
        this.predecessorName.setText(dependency.getPredecessor().getName());
        this.successorName.setText(dependency.getSuccessor().getName());
        this.lagFormat.setDependency(dependency);
        this.lagField.setValue(dependency.getTaskDelay());
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(DependencyManager.getDependencyList()));
        this.typeCombo.setSelectedItem(DependencyManager.getDependencyType(dependency));
        Task task = dependency.getPredecessor().getParent();
        if (task != null && task.isSplitted()) {
            this.typeCombo.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.typeCombo.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
        this.lagField.setEnabled(true);
        this.predecessorNameLabel.setEnabled(true);
        this.successorNameLabel.setEnabled(true);
        this.lagLabel.setEnabled(true);
        this.typeLabel.setEnabled(true);
        this.addListeners();
        this.removeUndoableEditListener(this.undoHandler);
        this.undoHandler = new UndoHandler(dependency.getPredecessor().getCompany().getUndoManager());
        this.addUndoableEditListener(this.undoHandler);
    }

    private void addListeners() {
        this.lagField.addActionListener(this.dependencyLagListener);
        this.lagField.addFocusListener(this.dependencyLagListener);
        this.typeCombo.addItemListener(this.typeItemListener);
    }

    private void removeListeners() {
        this.lagField.removeActionListener(this.dependencyLagListener);
        this.lagField.removeFocusListener(this.dependencyLagListener);
        this.typeCombo.removeItemListener(this.typeItemListener);
    }

    private JPanel createDetailsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        this.predecessorName = new JLabel("");
        this.successorName = new JLabel("");
        this.predecessorNameLabel = new JLabel(Common.I18N_RP.getString("predecessor") + ": ");
        this.successorNameLabel = new JLabel(Common.I18N_RP.getString("successor") + ": ");
        this.lagLabel = new JLabel(Common.I18N_RP.getString("lag") + ":");
        this.typeLabel = new JLabel(Common.I18N_RP.getString("type") + ":");
        this.lagField = new JFormattedTextField();
        this.lagField.setColumns(3);
        this.lagField.setHorizontalAlignment(4);
        this.lagField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.lagFormat)));
        this.typeCombo = new JComboBox();
        JButton jButton = new JButton(Common.I18N_RP.getString("close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDependencyDetails.this.setVisible(false);
            }
        });
        this.deleteButton = new JButton(Common.I18N_RP.getString("delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Task.removeDependency(JDependencyDetails.this.dependency);
                TaskPlanner.rescheduleTree(JDependencyDetails.this.dependency.getPredecessor());
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, TaskRemoveDependencyEdit.createRescheduleEdit(JDependencyDetails.this.dependency));
                JDependencyDetails.this.fireUndoableEditHappened(undoableEditEvent);
                JDependencyDetails.this.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout());
        jPanel2.add(this.deleteButton);
        jPanel2.add(jButton);
        jPanel.add((Component)this.predecessorNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.predecessorName, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.successorNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.successorName, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.typeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.typeCombo, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.lagLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.lagField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 24, 0, new Insets(5, 5, 5, 5), 0, 0));
        return jPanel;
    }

    private JComponent createContents() {
        return this.createDetailsTab();
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void updateValues() {
        this.removeListeners();
        this.predecessorName.setText(this.dependency.getPredecessor().getName());
        this.successorName.setText(this.dependency.getSuccessor().getName());
        this.lagField.setValue(this.dependency.getTaskDelay());
        this.typeCombo.setSelectedItem(DependencyManager.getDependencyType(this.dependency));
        this.addListeners();
    }

    private class DependencyLagHandler
    implements FocusListener,
    ActionListener {
        private DependencyLagHandler() {
        }

        private void doIt() {
            try {
                JDependencyDetails.this.lagField.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (!JDependencyDetails.this.lagField.getValue().equals(JDependencyDetails.this.dependency.getTaskDelay())) {
                Task task = JDependencyDetails.this.dependency.getPredecessor().getParent();
                long l = JDependencyDetails.this.dependency.getTaskDelay();
                long l2 = (Long)JDependencyDetails.this.lagField.getValue();
                if (task != null && task.isSplitted() && l2 < 0L) {
                    return;
                }
                JDependencyDetails.this.dependency.setTaskDelay(l2);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, ExtendedCompoundEdit.createReschedulSingleEdit(JDependencyDetails.this.dependency.getPredecessor(), new DependencyLagEdit(JDependencyDetails.this.dependency, l, l2, "15-09-09 12:31:02")));
                JDependencyDetails.this.fireUndoableEditHappened(undoableEditEvent);
                TaskPlanner.rescheduleTree(JDependencyDetails.this.dependency.getPredecessor());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class DependencyHandler
    extends DependencyAdapter {
        private DependencyHandler() {
        }

        public void typeChanged(DependencyEvent dependencyEvent) {
            JDependencyDetails.this.updateValues();
        }

        public void taskDelayChanged(DependencyEvent dependencyEvent) {
            JDependencyDetails.this.updateValues();
        }
    }
}

