/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.ui.UIManager;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.TaskCatchUpEdit;
import com.standbysoft.component.date.DateSelectionException;
import com.standbysoft.component.date.swing.JDatePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCatchUpDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JDatePicker datePicker;
    private JRadioButton projectButton;
    private JRadioButton selectedTasksButton;
    private Task project;
    private JProjectView projectView;
    private List<Task> tasks;

    public JCatchUpDialog(JProjectView jProjectView, List<Task> list, Task task) {
        super(Common.getApplication(), Common.I18N_RP.getString("updateCompletionToDate"), true);
        this.tasks = list;
        this.project = task;
        this.projectView = jProjectView;
        ((Frame)this.getOwner()).setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.pack();
        this.setLocationRelativeTo(Common.getApplication());
        this.setResizable(false);
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        this.datePicker = new JDatePicker(true);
        this.datePicker.setSelectedDate(new Date());
        this.datePicker.setDateFormat((DateFormat)new SimpleDateFormat(UIManager.getInstance().getDateFormat()));
        try {
            this.datePicker.setEmptySelectionAllowed(false);
        }
        catch (DateSelectionException dateSelectionException) {
            Common.logException("Error:", dateSelectionException);
        }
        this.datePicker.setEmptySelectionText("");
        this.projectButton = new JRadioButton(Common.I18N_RP.getString("currentProject"));
        this.selectedTasksButton = new JRadioButton(Common.I18N_RP.getString("selectedTasks"));
        this.selectedTasksButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.projectButton);
        buttonGroup.add(this.selectedTasksButton);
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("updateCompletionToDate") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.datePicker, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.projectButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.selectedTasksButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.createButtonsPanel(), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        return jPanel;
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new GridLayout());
        JButton jButton = new JButton(Common.I18N_RP.getString("cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCatchUpDialog.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCatchUpDialog.this.okAction();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        return jPanel;
    }

    protected void okAction() {
        Object object;
        Date date = this.datePicker.getSelectedDate();
        ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(this.project);
        if (this.projectButton.isSelected()) {
            object = new TaskCatchUpEdit(this.project, date, "09/11/09 12:43:00");
            this.project.catchUp(date);
            extendedCompoundEdit.addEdit((UndoableEdit)object);
        } else {
            for (Task task : this.tasks) {
                TaskCatchUpEdit taskCatchUpEdit = new TaskCatchUpEdit(task, date, "09/11/09 12:43:01");
                task.catchUp(date);
                extendedCompoundEdit.addEdit(taskCatchUpEdit);
            }
        }
        TaskPlanner.rescheduleTree(this.project);
        extendedCompoundEdit.end();
        object = new UndoableEditEvent(this, extendedCompoundEdit);
        this.projectView.fireUndoableEditHappened((UndoableEditEvent)object);
        this.setVisible(false);
    }
}

