/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.baseline.BaselineManager;
import com.sbs.jpm.core.baseline.ProjectBaseline;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class JBaselineDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected Task project;
    protected JComboBox baselines;

    public JBaselineDialog(Frame frame, String string, Task task) {
        super(frame, string, true);
        ((Frame)this.getOwner()).setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.project = task;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setResizable(false);
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        Vector<ProjectBaseline> vector = new Vector<ProjectBaseline>();
        for (int i = 0; i < 10; ++i) {
            ProjectBaseline projectBaseline = this.project.getProjectBaselineAt(i);
            if (projectBaseline == null) continue;
            vector.add(projectBaseline);
        }
        this.baselines = new JComboBox(vector);
        this.baselines.setSelectedIndex(0);
        this.baselines.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
                ProjectBaseline projectBaseline = (ProjectBaseline)object;
                String string = projectBaseline.getDescription();
                string = string != null ? string + "; " : "";
                String string2 = Common.I18N_RP.getString("baseline") + " " + (JBaselineDialog.this.project.getProjectBaselineIndex(projectBaseline) + 1) + "(" + string + (projectBaseline.getDate() != null ? simpleDateFormat.format(projectBaseline.getDate()) : "") + ")";
                return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
            }
        });
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("name") + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.baselines, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.createButtonsPanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        return jPanel;
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new GridLayout());
        JButton jButton = new JButton(Common.I18N_RP.getString("cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBaselineDialog.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(Common.I18N_RP.getString("ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBaselineDialog.this.okAction();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        return jPanel;
    }

    protected void okAction() {
        int n = this.project.getProjectBaselineIndex((ProjectBaseline)this.baselines.getSelectedItem());
        BaselineManager baselineManager = BaselineManager.getInstance();
        baselineManager.setVisibleBaseline(n);
        baselineManager.setShowBaseline(true);
        this.setVisible(false);
    }
}

