/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.ui.JApplication;
import com.sbs.util.SystemUtilities;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JAboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public JAboutDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        Object[] objectArray = new Object[]{JApplication.getApplicationName()};
        this.setTitle(MessageFormat.format(Common.I18N_ACTIONS.getString("help.about"), objectArray));
        ((Frame)this.getOwner()).setIconImage(new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/logo-16.png")).getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.pack();
        this.setResizable(false);
    }

    private JPanel createContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(4, 4, 4, 4);
        JButton jButton = new JButton(Common.I18N_RP.getString("close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAboutDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(jButton);
        String string = JApplication.getApplicationName() + " " + JApplication.getApplicationVersion();
        jPanel.add((Component)new JLabel(string), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        String string2 = Common.I18N_RP.getString("trialVersion");
        jPanel.add((Component)new JLabel(string2), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("copyright")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        Object[] objectArray = new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor")};
        JLabel jLabel = new JLabel(MessageFormat.format(Common.I18N_RP.getString("java"), objectArray));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)new JLabel(Common.I18N_RP.getString("visit") + ":"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        final JLabel jLabel2 = new JLabel("<html><u>" + JApplication.getApplicationSite() + "</u></html>");
        jLabel2.setForeground(Color.BLUE);
        jLabel2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            BrowserLauncher browserLauncher = new BrowserLauncher();
                            browserLauncher.openURLinBrowser(JApplication.getApplicationSite());
                        }
                        catch (Exception exception) {
                            Common.logException("Error:", exception);
                            jLabel2.setText(Common.I18N_RP.getString("goTo") + " " + JApplication.getApplicationSite());
                        }
                    }
                };
                thread.start();
            }
        });
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        if (!SystemUtilities.isOSMac()) {
            jPanel.add((Component)jButton, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 22, 0, insets, 0, 0));
        }
        return jPanel;
    }
}

