/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.calendar.CalendarManager;
import com.sbs.jpm.calendar.DayWorkingPattern;
import com.sbs.jpm.calendar.event.CalendarManagerEvent;
import com.sbs.jpm.calendar.event.CalendarManagerListener;
import com.sbs.jpm.calendar.event.DayWorkingPatternEvent;
import com.sbs.jpm.calendar.event.DayWorkingPatternListener;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.TaskPlanner;
import com.sbs.jpm.core.event.ResourceAdapter;
import com.sbs.jpm.core.event.ResourceEvent;
import com.sbs.jpm.core.event.ResourceListener;
import com.sbs.jpm.ui.component.JResourcePeriodTable;
import com.sbs.jpm.ui.component.model.ResourcePeriodTableModel;
import com.sbs.jpm.ui.component.renderer.ResourceSpecialDateRenderer;
import com.sbs.jpm.ui.component.util.CostFormat;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.ui.component.util.PositiveFormat;
import com.sbs.jpm.undo.CalendarResourcePatternAddEdit;
import com.sbs.jpm.undo.CalendarResourcePatternEdit;
import com.sbs.jpm.undo.CalendarResourcePatternRemoveEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.HResourceCalendarEdit;
import com.sbs.jpm.undo.HResourceEmailEdit;
import com.sbs.jpm.undo.HResourceMaxUnitsEdit;
import com.sbs.jpm.undo.HResourceNonEmptyEdit;
import com.sbs.jpm.undo.HResourceOvtRateEdit;
import com.sbs.jpm.undo.HResourcePhoneNoEdit;
import com.sbs.jpm.undo.ResourceCodeEdit;
import com.sbs.jpm.undo.ResourceNameEdit;
import com.sbs.jpm.undo.ResourceNotesEdit;
import com.sbs.jpm.undo.ResourceStdRateEdit;
import com.sbs.jpm.undo.UndoHandler;
import com.standbysoft.component.date.event.DateSelectionAdapter;
import com.standbysoft.component.date.event.DateSelectionEvent;
import com.standbysoft.component.date.event.DateSelectionListener;
import com.standbysoft.component.date.swing.DateRenderer;
import com.standbysoft.component.date.swing.JMonthView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.undo.AbstractUndoableEdit;

public class HResourceDetailView
extends JPanel {
    private HumanResource resource;
    private UndoHandler undoHandler;
    private EventListenerList listeners = new EventListenerList();
    private JLabel calendarLabel;
    private JLabel nameLabel;
    private JLabel phoneNoLabel;
    private JLabel emailLabel;
    private JLabel codeLabel;
    private JLabel standardRateLabel;
    private JLabel overtimeRateLabel;
    private JLabel maxUnitsLabel;
    private JLabel notesLabel;
    private JLabel defineSpecialDaysLabel;
    private JLabel specialPeriodLabel;
    private JTextField nameField;
    private JTextField codeField;
    private JTextField phoneNoField;
    private JTextField emailField;
    private JFormattedTextField standardRateField;
    private JFormattedTextField overtimeRateField;
    private JFormattedTextField maxUnitsField;
    private JComboBox resourceCalendarCombo;
    private ResourceListener resourceHandler;
    private JTabbedPane tabbedPane;
    private CalendarManager currentCalendar;
    private JTable periodsTable;
    private JMonthView month;
    private JRadioButton nonWorking;
    private JRadioButton working;
    private JRadioButton useDefault;
    private JTextArea notesArea;
    private NameHandler nameListener;
    private NotesHandler notesHandler;
    private PhoneHandler phoneNoListener;
    private EmailHandler emailListener;
    private StandardRateHandler standardRateListener;
    private OvertimeRateHandler overtimeRateListener;
    private MaxUnitsHandler maxUnitsListener;
    private ItemListener calendarItemListener;
    private CodeHandler codeListener;
    private DocumentListener notesListener;
    private CostFormat costFormat;
    private PositiveFormat maxUnitsFormat;
    private Map dayPatternToCalendarMap;
    private PatternHandler patternHandler;
    private DateSelectionHandler dateSelectionHandler;
    private CalendarManagerHandler calendarManagerHandler;

    public HResourceDetailView() {
        this.setLayout(new BorderLayout());
        this.dayPatternToCalendarMap = new HashMap();
        this.patternHandler = new PatternHandler();
        this.dateSelectionHandler = new DateSelectionHandler();
        this.calendarManagerHandler = new CalendarManagerHandler();
        this.costFormat = new CostFormat();
        this.maxUnitsFormat = new PositiveFormat();
        this.resourceHandler = new ResourceHandler();
        this.add((Component)this.createContents(), "Center");
        this.nameListener = new NameHandler();
        this.notesHandler = new NotesHandler();
        this.phoneNoListener = new PhoneHandler();
        this.emailListener = new EmailHandler();
        this.standardRateListener = new StandardRateHandler();
        this.overtimeRateListener = new OvertimeRateHandler();
        this.codeListener = new CodeHandler();
        this.maxUnitsListener = new MaxUnitsHandler();
        this.notesListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!HResourceDetailView.this.notesArea.getText().equals(HResourceDetailView.this.resource.getNotes())) {
                    HResourceDetailView.this.resource.setNotes(HResourceDetailView.this.notesArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!HResourceDetailView.this.notesArea.getText().equals(HResourceDetailView.this.resource.getNotes())) {
                    HResourceDetailView.this.resource.setNotes(HResourceDetailView.this.notesArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.calendarItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CalendarManager calendarManager = itemEvent.getItem() instanceof CalendarManager ? (CalendarManager)itemEvent.getItem() : null;
                    HResourceCalendarEdit hResourceCalendarEdit = new HResourceCalendarEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getCalendar(), calendarManager, "15-09-09 12:18:00");
                    boolean bl = HResourceDetailView.this.resource.isEmpty();
                    HResourceDetailView.this.resource.setCalendar(calendarManager);
                    ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(HResourceDetailView.this.resource.getOwner().getRootTask());
                    TaskPlanner.rescheduleTree(HResourceDetailView.this.resource.getOwner().getRootTask());
                    if (bl) {
                        HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:00");
                        extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    }
                    extendedCompoundEdit.addEdit(hResourceCalendarEdit);
                    extendedCompoundEdit.end();
                    UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                    HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
                }
            }
        };
    }

    public void setResource(HumanResource humanResource) {
        if (this.resource != null) {
            this.resource.removeResourceListener(this.resourceHandler);
        }
        this.resource = humanResource != null && humanResource.isEmpty() ? null : humanResource;
        if (this.resource != null) {
            this.resource.addResourceListener(this.resourceHandler);
        }
        this.periodsTable.setEnabled(false);
        if (this.resource == null) {
            this.removeListeners();
            this.nameField.setText("");
            this.phoneNoField.setText("");
            this.emailField.setText("");
            this.codeField.setText("");
            this.standardRateField.setValue(0);
            this.overtimeRateField.setValue(0);
            this.maxUnitsField.setValue(0);
            this.resourceCalendarCombo.setModel(new DefaultComboBoxModel());
            this.month.setSelectedDate(null);
            this.notesArea.setText("");
            this.calendarLabel.setEnabled(false);
            this.codeLabel.setEnabled(false);
            this.nameLabel.setEnabled(false);
            this.phoneNoLabel.setEnabled(false);
            this.emailLabel.setEnabled(false);
            this.standardRateLabel.setEnabled(false);
            this.overtimeRateLabel.setEnabled(false);
            this.maxUnitsLabel.setEnabled(false);
            this.notesLabel.setEnabled(false);
            this.defineSpecialDaysLabel.setEnabled(false);
            this.specialPeriodLabel.setEnabled(false);
            this.nameField.setEnabled(false);
            this.codeField.setEnabled(false);
            this.phoneNoField.setEnabled(false);
            this.emailField.setEnabled(false);
            this.standardRateField.setEnabled(false);
            this.overtimeRateField.setEnabled(false);
            this.maxUnitsField.setEnabled(false);
            this.resourceCalendarCombo.setEnabled(false);
            this.tabbedPane.setEnabled(false);
            this.month.setEnabled(false);
            this.nonWorking.setEnabled(false);
            this.working.setEnabled(false);
            this.useDefault.setEnabled(false);
            this.notesArea.setEnabled(false);
        } else {
            this.tabbedPane.setEnabled(true);
            this.calendarLabel.setEnabled(true);
            this.codeLabel.setEnabled(true);
            this.nameLabel.setEnabled(true);
            this.phoneNoLabel.setEnabled(true);
            this.emailLabel.setEnabled(true);
            this.standardRateLabel.setEnabled(true);
            this.overtimeRateLabel.setEnabled(true);
            this.maxUnitsLabel.setEnabled(true);
            this.notesLabel.setEnabled(true);
            this.defineSpecialDaysLabel.setEnabled(true);
            this.specialPeriodLabel.setEnabled(true);
            this.nameField.setEnabled(true);
            this.codeField.setEnabled(true);
            this.phoneNoField.setEnabled(true);
            this.emailField.setEnabled(true);
            this.standardRateField.setEnabled(true);
            this.overtimeRateField.setEnabled(true);
            this.maxUnitsField.setEnabled(true);
            this.resourceCalendarCombo.setEnabled(true);
            this.month.setEnabled(true);
            this.notesArea.setEnabled(true);
            this.costFormat.setResource(humanResource);
            this.nameField.setText(humanResource.getName());
            this.codeField.setText(humanResource.getCode());
            this.phoneNoField.setText(humanResource.getPhoneNo());
            this.emailField.setText(humanResource.getEmail());
            this.standardRateField.setValue(humanResource.getStandardRate());
            this.overtimeRateField.setValue(humanResource.getOvertimeRate());
            this.maxUnitsField.setValue(humanResource.getMaxUnits());
            this.notesArea.setText(humanResource.getNotes());
            new JTextComponentUndoHandler(this.notesArea);
            CalendarManager calendarManager = humanResource.getCalendar();
            LinkedList<CalendarManager> linkedList = new LinkedList<CalendarManager>(humanResource.getOwner().getCalendarList());
            linkedList.add(0, (CalendarManager)((Object)Common.I18N_RP.getString("useCompanyCalendar")));
            this.resourceCalendarCombo.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
            if (calendarManager == null) {
                this.resourceCalendarCombo.setSelectedItem(Common.I18N_RP.getString("useCompanyCalendar"));
            } else {
                this.resourceCalendarCombo.setSelectedItem(calendarManager);
            }
            this.setSelectedCalendar(humanResource.getResourceCalendar());
            this.removeUndoableEditListener(this.undoHandler);
            this.undoHandler = new UndoHandler(humanResource.getOwner().getUndoManager());
            this.addUndoableEditListener(this.undoHandler);
            this.addListeners();
        }
    }

    private void addListeners() {
        this.nameField.addActionListener(this.nameListener);
        this.nameField.addFocusListener(this.nameListener);
        this.notesArea.addFocusListener(this.notesHandler);
        this.codeField.addActionListener(this.codeListener);
        this.codeField.addFocusListener(this.codeListener);
        this.phoneNoField.addActionListener(this.phoneNoListener);
        this.phoneNoField.addFocusListener(this.phoneNoListener);
        this.emailField.addActionListener(this.emailListener);
        this.emailField.addFocusListener(this.emailListener);
        this.standardRateField.addActionListener(this.standardRateListener);
        this.standardRateField.addFocusListener(this.standardRateListener);
        this.overtimeRateField.addActionListener(this.overtimeRateListener);
        this.overtimeRateField.addFocusListener(this.overtimeRateListener);
        this.maxUnitsField.addActionListener(this.maxUnitsListener);
        this.maxUnitsField.addFocusListener(this.maxUnitsListener);
        this.notesArea.getDocument().addDocumentListener(this.notesListener);
        this.resourceCalendarCombo.addItemListener(this.calendarItemListener);
    }

    private void removeListeners() {
        this.nameField.removeActionListener(this.nameListener);
        this.nameField.removeFocusListener(this.nameListener);
        this.notesArea.removeFocusListener(this.notesHandler);
        this.codeField.removeActionListener(this.codeListener);
        this.codeField.removeFocusListener(this.codeListener);
        this.phoneNoField.removeActionListener(this.phoneNoListener);
        this.phoneNoField.removeFocusListener(this.phoneNoListener);
        this.emailField.removeActionListener(this.emailListener);
        this.emailField.removeFocusListener(this.emailListener);
        this.standardRateField.removeActionListener(this.standardRateListener);
        this.standardRateField.removeFocusListener(this.standardRateListener);
        this.overtimeRateField.removeActionListener(this.overtimeRateListener);
        this.overtimeRateField.removeFocusListener(this.overtimeRateListener);
        this.maxUnitsField.removeActionListener(this.maxUnitsListener);
        this.maxUnitsField.removeFocusListener(this.maxUnitsListener);
        this.notesArea.getDocument().removeDocumentListener(this.notesListener);
        this.resourceCalendarCombo.removeItemListener(this.calendarItemListener);
    }

    private JPanel createWorkingTimeTab() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.createCalendarTab();
        JPanel jPanel3 = this.createCalendarContentsTab();
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel createCalendarTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 5, 2, 5);
        this.calendarLabel = new JLabel(Common.I18N_RP.getString("calendar") + ":");
        this.resourceCalendarCombo = new JComboBox();
        jPanel.add((Component)this.calendarLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.resourceCalendarCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 0, insets, 0, 0));
        return jPanel;
    }

    private JPanel createCalendarContentsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        this.periodsTable = new JResourcePeriodTable();
        this.periodsTable.setEnabled(false);
        this.month = new JMonthView();
        this.month.setNoneButtonVisible(false);
        this.month.setWeekNumbersVisible(false);
        this.month.addDateSelectionListener((DateSelectionListener)this.dateSelectionHandler);
        this.nonWorking = new JRadioButton(Common.I18N_RP.getString("nonworkingDay"));
        this.nonWorking.setEnabled(false);
        this.nonWorking.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HResourceDetailView.this.selectButtons(true, false, false);
                Date[] dateArray = HResourceDetailView.this.month.getSelectedDates();
                Calendar calendar = Calendar.getInstance();
                Task task = HResourceDetailView.this.resource.getOwner().getRootTask();
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                for (int i = 0; i < dateArray.length; ++i) {
                    calendar.setTime(dateArray[i]);
                    DayWorkingPattern dayWorkingPattern = HResourceDetailView.this.resource.getResourceCalendar().getResourceDayPattern(calendar);
                    if (dayWorkingPattern == null) {
                        DayWorkingPattern dayWorkingPattern2 = HResourceDetailView.this.currentCalendar.getSpecialDayPattern(calendar);
                        if (dayWorkingPattern2 == null) {
                            dayWorkingPattern2 = HResourceDetailView.this.currentCalendar.getDayPattern(calendar.get(7));
                        }
                        if (!dayWorkingPattern2.isWorking()) continue;
                        DayWorkingPattern dayWorkingPattern3 = (DayWorkingPattern)dayWorkingPattern2.clone();
                        CalendarResourcePatternAddEdit calendarResourcePatternAddEdit = new CalendarResourcePatternAddEdit(HResourceDetailView.this.resource, dayWorkingPattern3, calendar, "29/11/09 13:49:00");
                        HResourceDetailView.this.resource.getResourceCalendar().beginTransaction();
                        HResourceDetailView.this.resource.getResourceCalendar().setResourceDayPattern(calendar, dayWorkingPattern3);
                        dayWorkingPattern3.setWorking(false);
                        HResourceDetailView.this.resource.getResourceCalendar().endTransaction();
                        extendedCompoundEdit.addEdit(calendarResourcePatternAddEdit);
                        continue;
                    }
                    HResourceDetailView.this.resource.getResourceCalendar().beginTransaction();
                    dayWorkingPattern.setWorking(false);
                    HResourceDetailView.this.resource.getResourceCalendar().endTransaction();
                }
                extendedCompoundEdit.end();
                HResourceDetailView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
                HResourceDetailView.this.setNewPeriodTableModel();
                TaskPlanner.rescheduleTree(task);
            }
        });
        this.working = new JRadioButton(Common.I18N_RP.getString("customProgram"));
        this.working.setEnabled(false);
        this.working.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HResourceDetailView.this.selectButtons(false, true, false);
                Date[] dateArray = HResourceDetailView.this.month.getSelectedDates();
                Calendar calendar = Calendar.getInstance();
                Task task = HResourceDetailView.this.resource.getOwner().getRootTask();
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                for (int i = 0; i < dateArray.length; ++i) {
                    AbstractUndoableEdit abstractUndoableEdit;
                    DayWorkingPattern dayWorkingPattern;
                    calendar.setTime(dateArray[i]);
                    DayWorkingPattern dayWorkingPattern2 = HResourceDetailView.this.resource.getResourceCalendar().getResourceDayPattern(calendar);
                    if (dayWorkingPattern2 == null) {
                        dayWorkingPattern = (DayWorkingPattern)HResourceDetailView.this.resource.getOwner().getRootTask().getCustomPattern().clone();
                        abstractUndoableEdit = new CalendarResourcePatternAddEdit(HResourceDetailView.this.resource, dayWorkingPattern, calendar, "29/11/09 13:54:00");
                        DayWorkingPattern dayWorkingPattern3 = (DayWorkingPattern)HResourceDetailView.this.resource.getOwner().getRootTask().getCustomPattern().clone();
                        HResourceDetailView.this.resource.getResourceCalendar().beginTransaction();
                        HResourceDetailView.this.resource.getResourceCalendar().setResourceDayPattern(calendar, dayWorkingPattern3);
                        HResourceDetailView.this.resource.getResourceCalendar().endTransaction();
                        extendedCompoundEdit.addEdit(abstractUndoableEdit);
                        continue;
                    }
                    dayWorkingPattern = (DayWorkingPattern)HResourceDetailView.this.resource.getOwner().getRootTask().getCustomPattern().clone();
                    abstractUndoableEdit = new CalendarResourcePatternEdit(HResourceDetailView.this.resource, (DayWorkingPattern)dayWorkingPattern2.clone(), dayWorkingPattern, calendar, "29/11/09 13:57:00");
                    HResourceDetailView.this.resource.getResourceCalendar().beginTransaction();
                    HResourceDetailView.this.resource.getResourceCalendar().setResourceDayPattern(calendar, dayWorkingPattern);
                    HResourceDetailView.this.resource.getResourceCalendar().endTransaction();
                    extendedCompoundEdit.addEdit(abstractUndoableEdit);
                }
                extendedCompoundEdit.end();
                HResourceDetailView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
                HResourceDetailView.this.setNewPeriodTableModel();
                TaskPlanner.rescheduleTree(task);
                HResourceDetailView.this.periodsTable.requestFocusInWindow();
                HResourceDetailView.this.periodsTable.changeSelection(0, 0, true, true);
                HResourceDetailView.this.periodsTable.editCellAt(0, 0);
                Component component = HResourceDetailView.this.periodsTable.getEditorComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }
        });
        this.useDefault = new JRadioButton(Common.I18N_RP.getString("defaultProgram"));
        this.useDefault.setEnabled(false);
        this.useDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HResourceDetailView.this.selectButtons(false, false, true);
                Date[] dateArray = HResourceDetailView.this.month.getSelectedDates();
                Calendar calendar = Calendar.getInstance();
                Task task = HResourceDetailView.this.resource.getOwner().getRootTask();
                ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(task);
                for (int i = 0; i < dateArray.length; ++i) {
                    calendar.setTime(dateArray[i]);
                    DayWorkingPattern dayWorkingPattern = HResourceDetailView.this.resource.getResourceCalendar().getResourceDayPattern(calendar);
                    if (dayWorkingPattern == null) continue;
                    CalendarResourcePatternRemoveEdit calendarResourcePatternRemoveEdit = new CalendarResourcePatternRemoveEdit(HResourceDetailView.this.resource, dayWorkingPattern, calendar, "29/11/09 14:06:00");
                    extendedCompoundEdit.addEdit(calendarResourcePatternRemoveEdit);
                    HResourceDetailView.this.resource.getResourceCalendar().beginTransaction();
                    HResourceDetailView.this.resource.getResourceCalendar().removeResourceDayPattern(calendar);
                    HResourceDetailView.this.resource.getResourceCalendar().endTransaction();
                }
                extendedCompoundEdit.end();
                HResourceDetailView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
                HResourceDetailView.this.setNewPeriodTableModel();
                TaskPlanner.rescheduleTree(task);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.periodsTable);
        jScrollPane.setMinimumSize(new Dimension(100, 110));
        jScrollPane.setPreferredSize(new Dimension(100, 110));
        this.defineSpecialDaysLabel = new JLabel(Common.I18N_RP.getString("specialDays"));
        jPanel.add((Component)this.defineSpecialDaysLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.month, new GridBagConstraints(0, 2, 1, 4, 0.0, 1.0, 23, 0, insets, 0, 0));
        this.specialPeriodLabel = new JLabel(Common.I18N_RP.getString("specialPeriods"));
        jPanel.add((Component)this.specialPeriodLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.nonWorking, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.useDefault, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.working, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 23, 1, new Insets(-10, 0, -10, 0), 0, 0));
        return jPanel;
    }

    private JPanel createDetailsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.nameLabel = new JLabel(Common.I18N_RP.getString("resource.name") + ":");
        this.codeLabel = new JLabel(Common.I18N_RP.getString("resource.code") + ":");
        this.phoneNoLabel = new JLabel(Common.I18N_RP.getString("resource.phone") + ":");
        this.emailLabel = new JLabel(Common.I18N_RP.getString("resource.email") + ":");
        this.standardRateLabel = new JLabel(Common.I18N_RP.getString("resource.standardRate") + ":");
        this.overtimeRateLabel = new JLabel(Common.I18N_RP.getString("resource.overtimeRate") + ":");
        this.maxUnitsLabel = new JLabel(Common.I18N_RP.getString("resource.maxUnits") + ":");
        this.nameField = new JTextField(30);
        this.phoneNoField = new JTextField(30);
        this.emailField = new JTextField(30);
        this.codeField = new JTextField(30);
        this.standardRateField = new JFormattedTextField();
        this.standardRateField.setHorizontalAlignment(4);
        this.standardRateField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.costFormat)));
        this.overtimeRateField = new JFormattedTextField();
        this.overtimeRateField.setHorizontalAlignment(4);
        this.overtimeRateField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.costFormat)));
        this.maxUnitsField = new JFormattedTextField();
        this.maxUnitsField.setHorizontalAlignment(4);
        this.maxUnitsField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(this.maxUnitsFormat)));
        jPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.phoneNoLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.phoneNoField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.emailLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.emailField, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.standardRateLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.standardRateField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.overtimeRateLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.overtimeRateField, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.maxUnitsLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.maxUnitsField, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)this.codeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)this.codeField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, insets, 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 6, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JPanel createNotesTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.notesLabel = new JLabel(Common.I18N_RP.getString("resource.notes") + ":");
        this.notesArea = new JTextArea();
        this.notesArea.setLineWrap(true);
        this.notesArea.setWrapStyleWord(true);
        jPanel.add((Component)this.notesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)new JScrollPane(this.notesArea, 20, 31), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JComponent createContents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(Common.I18N_RP.getString("resource.details"), this.createDetailsTab());
        this.tabbedPane.add(Common.I18N_RP.getString("resource.workingTime"), new JScrollPane(this.createWorkingTimeTab(), 20, 30));
        this.tabbedPane.add(Common.I18N_RP.getString("resource.notes"), this.createNotesTab());
        return this.tabbedPane;
    }

    private void setSelectedCalendar(CalendarManager calendarManager) {
        if (this.currentCalendar != null) {
            this.currentCalendar.removeCalendarManagerListener(this.calendarManagerHandler);
        }
        this.currentCalendar = calendarManager;
        ResourceSpecialDateRenderer resourceSpecialDateRenderer = new ResourceSpecialDateRenderer(this.currentCalendar, this.resource);
        this.month.setDateRenderer((DateRenderer)resourceSpecialDateRenderer);
        this.month.setSelectedDate(null);
        this.currentCalendar.addCalendarManagerListener(this.calendarManagerHandler);
    }

    private void selectButtons(boolean bl, boolean bl2, boolean bl3) {
        this.nonWorking.setSelected(bl);
        this.working.setSelected(bl2);
        this.useDefault.setSelected(bl3);
    }

    private void setNewPeriodTableModel() {
        Cloneable cloneable2;
        for (Cloneable cloneable2 : this.dayPatternToCalendarMap.keySet()) {
            ((DayWorkingPattern)cloneable2).removeDayWorkingPatternListener(this.patternHandler);
        }
        this.dayPatternToCalendarMap.clear();
        Date[] dateArray = this.month.getSelectedDates();
        cloneable2 = new LinkedList();
        for (int i = 0; i < dateArray.length; ++i) {
            Date date = dateArray[i];
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            DayWorkingPattern dayWorkingPattern = this.resource.getResourceCalendar().getResourceDayPattern(calendar);
            dayWorkingPattern = dayWorkingPattern == null ? (this.currentCalendar.getSpecialDayPattern(calendar) == null ? (DayWorkingPattern)this.currentCalendar.getDayPattern(calendar.get(7)).clone() : (DayWorkingPattern)this.currentCalendar.getSpecialDayPattern(calendar).clone()) : (DayWorkingPattern)dayWorkingPattern.clone();
            this.dayPatternToCalendarMap.put(dayWorkingPattern, calendar);
            dayWorkingPattern.addDayWorkingPatternListener(this.patternHandler);
            cloneable2.add(dayWorkingPattern);
        }
        this.periodsTable.setModel(new ResourcePeriodTableModel((List<DayWorkingPattern>)((Object)cloneable2), this.resource));
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void updateValues() {
        this.removeListeners();
        try {
            this.notesArea.setText(this.resource.getNotes());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.nameField.setText(this.resource.getName());
        this.codeField.setText(this.resource.getCode());
        this.phoneNoField.setText(this.resource.getPhoneNo());
        this.emailField.setText(this.resource.getEmail());
        this.standardRateField.setValue(this.resource.getStandardRate());
        this.overtimeRateField.setValue(this.resource.getOvertimeRate());
        this.maxUnitsField.setValue(this.resource.getMaxUnits());
        if (this.resource.getCalendar() == null) {
            this.resourceCalendarCombo.setSelectedItem(Common.I18N_RP.getString("useCompanyCalendar"));
        } else {
            this.resourceCalendarCombo.setSelectedItem(this.resource.getCalendar());
        }
        this.addListeners();
    }

    private class CalendarManagerHandler
    implements CalendarManagerListener {
        private CalendarManagerHandler() {
        }

        public void dayWorkingPatternChanged(CalendarManagerEvent calendarManagerEvent) {
        }

        public void calendarChanged(CalendarManagerEvent calendarManagerEvent) {
            HResourceDetailView.this.month.repaint();
        }

        public void nameChanged(CalendarManagerEvent calendarManagerEvent) {
        }
    }

    private class NotesHandler
    implements FocusListener {
        private String oldNotes = "";

        private NotesHandler() {
        }

        private void doIt() {
            String string = HResourceDetailView.this.notesArea.getText();
            if (!string.equals(this.oldNotes)) {
                ResourceNotesEdit resourceNotesEdit = new ResourceNotesEdit(HResourceDetailView.this.resource, this.oldNotes, string, "05/10/2009 19:01:00");
                HResourceDetailView.this.resource.setNotes(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, resourceNotesEdit);
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldNotes = HResourceDetailView.this.notesArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class CodeHandler
    implements FocusListener,
    ActionListener {
        private CodeHandler() {
        }

        private void doIt() {
            if (!HResourceDetailView.this.codeField.getText().equals(HResourceDetailView.this.resource.getCode())) {
                UndoableEditEvent undoableEditEvent;
                String string = HResourceDetailView.this.codeField.getText();
                ResourceCodeEdit resourceCodeEdit = new ResourceCodeEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getCode(), string, "09/11/09 15:01:00");
                boolean bl = HResourceDetailView.this.resource.isEmpty();
                HResourceDetailView.this.resource.setCode(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:07");
                    extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    extendedCompoundEdit.addEdit(resourceCodeEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, resourceCodeEdit);
                }
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class DateSelectionHandler
    extends DateSelectionAdapter {
        private DateSelectionHandler() {
        }

        public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
            int n = HResourceDetailView.this.month.getSelectedDates().length;
            if (n > 1 || n == 0) {
                HResourceDetailView.this.selectButtons(false, false, false);
            } else {
                Date date = HResourceDetailView.this.month.getSelectedDate();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                DayWorkingPattern dayWorkingPattern = HResourceDetailView.this.resource.getResourceCalendar().getResourceDayPattern(calendar);
                if (dayWorkingPattern == null) {
                    HResourceDetailView.this.selectButtons(false, false, true);
                } else if (dayWorkingPattern.isWorking()) {
                    HResourceDetailView.this.selectButtons(false, true, false);
                } else {
                    HResourceDetailView.this.selectButtons(true, false, false);
                }
            }
            if (n == 0) {
                HResourceDetailView.this.selectButtons(false, false, false);
                HResourceDetailView.this.periodsTable.setEnabled(false);
            } else {
                HResourceDetailView.this.nonWorking.setEnabled(true);
                HResourceDetailView.this.working.setEnabled(true);
                HResourceDetailView.this.useDefault.setEnabled(true);
                HResourceDetailView.this.periodsTable.setEnabled(true);
            }
            HResourceDetailView.this.setNewPeriodTableModel();
        }
    }

    private class PatternHandler
    implements DayWorkingPatternListener {
        private PatternHandler() {
        }

        public void dayWorkingPatternChanged(DayWorkingPatternEvent dayWorkingPatternEvent) {
            DayWorkingPattern dayWorkingPattern = (DayWorkingPattern)dayWorkingPatternEvent.getSource();
            Calendar calendar = (Calendar)HResourceDetailView.this.dayPatternToCalendarMap.get(dayWorkingPattern);
            DayWorkingPattern dayWorkingPattern2 = HResourceDetailView.this.resource.getResourceCalendar().getResourceDayPattern(calendar);
            ExtendedCompoundEdit extendedCompoundEdit = ExtendedCompoundEdit.createRescheduleMultipleEdit(HResourceDetailView.this.resource.getOwner().getRootTask());
            if (dayWorkingPattern2 == null) {
                CalendarResourcePatternAddEdit calendarResourcePatternAddEdit = new CalendarResourcePatternAddEdit(HResourceDetailView.this.resource, dayWorkingPattern, calendar, "29/11/09 17:58:00");
                extendedCompoundEdit.addEdit(calendarResourcePatternAddEdit);
                HResourceDetailView.this.resource.getResourceCalendar().setResourceDayPattern(calendar, dayWorkingPattern);
            } else {
                DayWorkingPattern dayWorkingPattern3 = HResourceDetailView.this.currentCalendar.getSpecialDayPattern(calendar);
                if (dayWorkingPattern3 == null) {
                    dayWorkingPattern3 = HResourceDetailView.this.currentCalendar.getDayPattern(calendar.get(7));
                }
                if (!dayWorkingPattern.equals(dayWorkingPattern3)) {
                    CalendarResourcePatternEdit calendarResourcePatternEdit = new CalendarResourcePatternEdit(HResourceDetailView.this.resource, dayWorkingPattern2, dayWorkingPattern, calendar, "29/11/09 18:02:00");
                    extendedCompoundEdit.addEdit(calendarResourcePatternEdit);
                    HResourceDetailView.this.resource.getResourceCalendar().setResourceDayPattern(calendar, dayWorkingPattern);
                } else {
                    CalendarResourcePatternRemoveEdit calendarResourcePatternRemoveEdit = new CalendarResourcePatternRemoveEdit(HResourceDetailView.this.resource, dayWorkingPattern2, calendar, "29/11/09 18:03:00");
                    extendedCompoundEdit.addEdit(calendarResourcePatternRemoveEdit);
                    HResourceDetailView.this.resource.getResourceCalendar().removeResourceDayPattern(calendar);
                }
            }
            extendedCompoundEdit.end();
            HResourceDetailView.this.fireUndoableEditHappened(new UndoableEditEvent(this, extendedCompoundEdit));
            HResourceDetailView.this.periodsTable.tableChanged(new TableModelEvent(HResourceDetailView.this.periodsTable.getModel()));
            TaskPlanner.rescheduleTree(HResourceDetailView.this.resource.getOwner().getRootTask());
        }
    }

    private class ResourceHandler
    extends ResourceAdapter {
        private ResourceHandler() {
        }

        public void dataChanged(ResourceEvent resourceEvent) {
            HResourceDetailView.this.updateValues();
        }

        public void notesChanged(ResourceEvent resourceEvent) {
            HResourceDetailView.this.updateValues();
        }

        public void assignmentAdded(ResourceEvent resourceEvent) {
        }

        public void assignmentRemoved(ResourceEvent resourceEvent) {
        }
    }

    private class MaxUnitsHandler
    implements FocusListener,
    ActionListener {
        private MaxUnitsHandler() {
        }

        private void doIt() {
            try {
                HResourceDetailView.this.maxUnitsField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            if (!HResourceDetailView.this.maxUnitsField.getValue().equals(HResourceDetailView.this.resource.getMaxUnits())) {
                UndoableEditEvent undoableEditEvent;
                double d = (Double)HResourceDetailView.this.maxUnitsField.getValue();
                HResourceMaxUnitsEdit hResourceMaxUnitsEdit = new HResourceMaxUnitsEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getMaxUnits(), d, "09/11/09 15:27:00");
                boolean bl = HResourceDetailView.this.resource.isEmpty();
                HResourceDetailView.this.resource.setMaxUnits(d);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:06");
                    extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    extendedCompoundEdit.addEdit(hResourceMaxUnitsEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, hResourceMaxUnitsEdit);
                }
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class OvertimeRateHandler
    implements FocusListener,
    ActionListener {
        private OvertimeRateHandler() {
        }

        private void doIt() {
            try {
                HResourceDetailView.this.overtimeRateField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            if (!HResourceDetailView.this.overtimeRateField.getValue().equals(HResourceDetailView.this.resource.getOvertimeRate())) {
                UndoableEditEvent undoableEditEvent;
                double d = (Double)HResourceDetailView.this.overtimeRateField.getValue();
                HResourceOvtRateEdit hResourceOvtRateEdit = new HResourceOvtRateEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getOvertimeRate(), d, "09/11/09 15:23:01");
                boolean bl = HResourceDetailView.this.resource.isEmpty();
                HResourceDetailView.this.resource.setOvertimeRate(d);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:05");
                    extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    extendedCompoundEdit.addEdit(hResourceOvtRateEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, hResourceOvtRateEdit);
                }
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class StandardRateHandler
    implements FocusListener,
    ActionListener {
        private StandardRateHandler() {
        }

        private void doIt() {
            try {
                HResourceDetailView.this.standardRateField.commitEdit();
            }
            catch (ParseException parseException) {
                return;
            }
            if (!HResourceDetailView.this.standardRateField.getValue().equals(HResourceDetailView.this.resource.getStandardRate())) {
                UndoableEditEvent undoableEditEvent;
                double d = (Double)HResourceDetailView.this.standardRateField.getValue();
                ResourceStdRateEdit resourceStdRateEdit = new ResourceStdRateEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getStandardRate(), d, "09/11/09 13:12:00");
                boolean bl = HResourceDetailView.this.resource.isEmpty();
                HResourceDetailView.this.resource.setStandardRate(d);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:04");
                    extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    extendedCompoundEdit.addEdit(resourceStdRateEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, resourceStdRateEdit);
                }
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class EmailHandler
    implements FocusListener,
    ActionListener {
        private EmailHandler() {
        }

        private void doIt() {
            if (!HResourceDetailView.this.emailField.getText().equals(HResourceDetailView.this.resource.getEmail())) {
                UndoableEditEvent undoableEditEvent;
                String string = HResourceDetailView.this.emailField.getText();
                HResourceEmailEdit hResourceEmailEdit = new HResourceEmailEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getEmail(), string, "09/11/09 15:29:00");
                boolean bl = HResourceDetailView.this.resource.isEmpty();
                HResourceDetailView.this.resource.setEmail(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:03");
                    extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    extendedCompoundEdit.addEdit(hResourceEmailEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, hResourceEmailEdit);
                }
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class PhoneHandler
    implements FocusListener,
    ActionListener {
        private PhoneHandler() {
        }

        private void doIt() {
            if (!HResourceDetailView.this.phoneNoField.getText().equals(HResourceDetailView.this.resource.getPhoneNo())) {
                UndoableEditEvent undoableEditEvent;
                String string = HResourceDetailView.this.phoneNoField.getText();
                HResourcePhoneNoEdit hResourcePhoneNoEdit = new HResourcePhoneNoEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getPhoneNo(), string, "09/11/09 15:22:01");
                boolean bl = HResourceDetailView.this.resource.isEmpty();
                HResourceDetailView.this.resource.setPhoneNo(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:02");
                    extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    extendedCompoundEdit.addEdit(hResourcePhoneNoEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, hResourcePhoneNoEdit);
                }
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class NameHandler
    implements FocusListener,
    ActionListener {
        private NameHandler() {
        }

        private void doIt() {
            if (!HResourceDetailView.this.nameField.getText().equals(HResourceDetailView.this.resource.getName())) {
                UndoableEditEvent undoableEditEvent;
                String string = HResourceDetailView.this.nameField.getText();
                ResourceNameEdit resourceNameEdit = new ResourceNameEdit(HResourceDetailView.this.resource, HResourceDetailView.this.resource.getName(), string, "09/11/09 13:14:00");
                boolean bl = HResourceDetailView.this.resource.isEmpty();
                HResourceDetailView.this.resource.setName(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    HResourceNonEmptyEdit hResourceNonEmptyEdit = new HResourceNonEmptyEdit(HResourceDetailView.this.resource, "09/11/09 15:26:01");
                    extendedCompoundEdit.addEdit(hResourceNonEmptyEdit);
                    extendedCompoundEdit.addEdit(resourceNameEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, resourceNameEdit);
                }
                HResourceDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }
}

