/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.conflict.Conflict;
import com.sbs.jpm.core.conflict.ConflictAdapter;
import com.sbs.jpm.core.conflict.ConflictEvent;
import com.sbs.jpm.core.conflict.ConflictListener;
import com.sbs.jpm.core.conflict.ConflictManager;
import com.sbs.jpm.core.conflict.ConflictManagerAdapter;
import com.sbs.jpm.core.conflict.ConflictManagerEvent;
import com.sbs.jpm.core.conflict.ConflictManagerListener;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.ui.component.DropDownButton;
import com.sbs.jpm.ui.component.JProjectView;
import com.sbs.jpm.ui.component.view.JProjectViewGantt;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class ConflictDropDownButton
extends DropDownButton {
    private ConflictManager conflictManager;
    private JPopupMenu popup;
    private JProjectViewGantt view;
    private ConflictManagerListener conflictManagerHandler;
    private ConflictListener conflictHandler;
    private TaskListener taskHandler;

    public ConflictDropDownButton(JButton jButton, JProjectViewGantt jProjectViewGantt) {
        super(jButton);
        this.view = jProjectViewGantt;
        this.conflictManagerHandler = new ConflictManagerHandler();
        this.conflictHandler = new ConflictHandler();
        this.taskHandler = new TaskHandler();
        this.setEnabled(false);
        this.popup = new JPopupMenu();
    }

    private void initPopup() {
        this.popup = new JPopupMenu();
        for (Conflict conflict : this.conflictManager.getConflicts()) {
            conflict.addConflictListener(this.conflictHandler);
            JMenuItem jMenuItem = new JMenuItem(conflict.getTask().getName() + " - " + conflict.getMessage());
            jMenuItem.addActionListener(new ConflictAction(conflict));
            this.popup.add(jMenuItem);
        }
    }

    protected JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setConflictManager(ConflictManager conflictManager) {
        if (this.conflictManager != null) {
            this.conflictManager.removeConflictManagerListener(this.conflictManagerHandler);
        }
        this.conflictManager = conflictManager;
        this.conflictManager.addConflictManagerListener(this.conflictManagerHandler);
        this.initPopup();
        this.setEnabled(this.conflictManager.getConflictNumber() != 0);
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void nameChanged(TaskEvent taskEvent) {
            Task task = (Task)taskEvent.getSource();
            Conflict conflict = ConflictDropDownButton.this.conflictManager.getConflict(task);
            ((JMenuItem)ConflictDropDownButton.this.popup.getComponent(ConflictDropDownButton.this.conflictManager.getConflictIndex(conflict))).setText(task.getName() + " - " + conflict.getMessage());
        }
    }

    class ConflictHandler
    extends ConflictAdapter {
        ConflictHandler() {
        }

        public void conflictChanged(ConflictEvent conflictEvent) {
            Conflict conflict = (Conflict)conflictEvent.getSource();
            ((JMenuItem)ConflictDropDownButton.this.popup.getComponent(ConflictDropDownButton.this.conflictManager.getConflictIndex(conflict))).setText(conflict.getTask().getName() + " - " + conflict.getMessage());
        }
    }

    class ConflictManagerHandler
    extends ConflictManagerAdapter {
        ConflictManagerHandler() {
        }

        public void conflictAdded(ConflictManagerEvent conflictManagerEvent) {
            conflictManagerEvent.getConflict().getTask().addTaskListener(ConflictDropDownButton.this.taskHandler);
            ConflictDropDownButton.this.initPopup();
            ConflictDropDownButton.this.setEnabled(true);
        }

        public void conflictRemoved(ConflictManagerEvent conflictManagerEvent) {
            ConflictManager conflictManager = (ConflictManager)conflictManagerEvent.getSource();
            conflictManagerEvent.getConflict().getTask().removeTaskListener(ConflictDropDownButton.this.taskHandler);
            if (conflictManager.getConflictNumber() == 0) {
                ConflictDropDownButton.this.setEnabled(false);
            }
            ConflictDropDownButton.this.initPopup();
        }
    }

    class ConflictAction
    implements ActionListener {
        private Conflict conflict;

        public ConflictAction(Conflict conflict) {
            this.conflict = conflict;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            JProjectView.BLOCK_UPDATE = true;
            try {
                Task task = ConflictDropDownButton.this.view.getProject();
                Task task2 = this.conflict.getTask();
                if (!task2.getProjectTask().equals(task) && !task2.getProjectTask().isDescendent(task)) {
                    Common.getApplication().getWorkspace().getJProject().setCurrentProject(task.getCompany().getRootTask());
                    ConflictDropDownButton.this.view.revalidate();
                }
                TreePath treePath = new TreePath(task2.getPath(ConflictDropDownButton.this.view.getProject()).toArray());
                ConflictDropDownButton.this.view.getGantt().getTreeTable().scrollPathToVisible(treePath);
                ConflictDropDownButton.this.view.getGantt().getTreeTable().getTreeSelectionModel().setSelectionPath(treePath);
            }
            finally {
                JProjectView.BLOCK_UPDATE = false;
                ConflictDropDownButton.this.view.updateToolbar();
            }
        }
    }
}

