/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.component;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.core.event.ClientAdapter;
import com.sbs.jpm.core.event.ClientEvent;
import com.sbs.jpm.core.event.ClientListener;
import com.sbs.jpm.ui.component.JContactsTable;
import com.sbs.jpm.ui.component.model.ContactsTableModel;
import com.sbs.jpm.ui.component.util.JTextComponentUndoHandler;
import com.sbs.jpm.undo.ClientAddressEdit;
import com.sbs.jpm.undo.ClientNameEdit;
import com.sbs.jpm.undo.ClientNonEmptyEdit;
import com.sbs.jpm.undo.ClientNotesEdit;
import com.sbs.jpm.undo.ClientSiteEdit;
import com.sbs.jpm.undo.ExtendedCompoundEdit;
import com.sbs.jpm.undo.UndoHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class ClientDetailView
extends JPanel {
    private UndoHandler undoHandler;
    private EventListenerList listeners = new EventListenerList();
    private Client client;
    private JLabel nameLabel;
    private JLabel addressLabel;
    private JLabel siteLabel;
    private JLabel notesLabel;
    private JTabbedPane tabbedPane;
    private JContactsTable contactsTable;
    private JTextField nameField;
    private JTextField addressField;
    private JTextField siteField;
    private JTextArea notesArea;
    private NameHandler nameListener;
    private NotesHandler notesHandler;
    private AddressHandler addressListener;
    private SiteHandler siteListener;
    private DocumentListener notesListener;
    private ClientListener clientHandler;

    public ClientDetailView() {
        this.setLayout(new BorderLayout());
        this.clientHandler = new ClientHandler();
        this.add((Component)this.createContents(), "Center");
        this.nameListener = new NameHandler();
        this.notesHandler = new NotesHandler();
        this.addressListener = new AddressHandler();
        this.siteListener = new SiteHandler();
        this.notesListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!ClientDetailView.this.notesArea.getText().equals(ClientDetailView.this.client.getNotes())) {
                    ClientDetailView.this.client.setNotes(ClientDetailView.this.notesArea.getText());
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!ClientDetailView.this.notesArea.getText().equals(ClientDetailView.this.client.getNotes())) {
                    ClientDetailView.this.client.setNotes(ClientDetailView.this.notesArea.getText());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    public void setClient(Client client) {
        if (this.client != null) {
            this.client.removeClientListener(this.clientHandler);
        }
        this.client = client != null && client.isEmpty() ? null : client;
        if (this.client != null) {
            this.client.addClientListener(this.clientHandler);
        }
        if (this.client == null) {
            this.removeListeners();
            this.nameField.setText("");
            this.addressField.setText("");
            this.siteField.setText("");
            this.notesArea.setText("");
            ContactsTableModel contactsTableModel = new ContactsTableModel();
            this.contactsTable.setModel(contactsTableModel);
            this.nameLabel.setEnabled(false);
            this.addressLabel.setEnabled(false);
            this.siteLabel.setEnabled(false);
            this.notesLabel.setEnabled(false);
            this.tabbedPane.setEnabled(false);
            this.nameField.setEnabled(false);
            this.addressField.setEnabled(false);
            this.siteField.setEnabled(false);
            this.contactsTable.setEnabled(false);
            this.notesArea.setEnabled(false);
        } else {
            this.tabbedPane.setEnabled(true);
            this.nameLabel.setEnabled(true);
            this.addressLabel.setEnabled(true);
            this.siteLabel.setEnabled(true);
            this.notesLabel.setEnabled(true);
            this.nameField.setEnabled(true);
            this.addressField.setEnabled(true);
            this.siteField.setEnabled(true);
            this.notesArea.setEnabled(true);
            this.contactsTable.setEnabled(true);
            this.nameField.setText(client.getName());
            this.addressField.setText(client.getAddress());
            this.siteField.setText(client.getSite());
            this.contactsTable.setClient(client);
            this.notesArea.setText(client.getNotes());
            new JTextComponentUndoHandler(this.notesArea);
            this.removeUndoableEditListener(this.undoHandler);
            this.contactsTable.removeUndoableEditListener(this.undoHandler);
            ((ContactsTableModel)this.contactsTable.getModel()).removeUndoableEditListener(this.undoHandler);
            this.undoHandler = new UndoHandler(client.getOwner().getUndoManager());
            this.addUndoableEditListener(this.undoHandler);
            this.contactsTable.addUndoableEditListener(this.undoHandler);
            ((ContactsTableModel)this.contactsTable.getModel()).addUndoableEditListener(this.undoHandler);
            this.addListeners();
        }
    }

    private void addListeners() {
        this.nameField.addActionListener(this.nameListener);
        this.nameField.addFocusListener(this.nameListener);
        this.notesArea.addFocusListener(this.notesHandler);
        this.addressField.addActionListener(this.addressListener);
        this.addressField.addFocusListener(this.addressListener);
        this.siteField.addActionListener(this.siteListener);
        this.siteField.addFocusListener(this.siteListener);
        this.notesArea.getDocument().addDocumentListener(this.notesListener);
    }

    private void removeListeners() {
        this.nameField.removeActionListener(this.nameListener);
        this.nameField.removeFocusListener(this.nameListener);
        this.notesArea.removeFocusListener(this.notesHandler);
        this.addressField.removeActionListener(this.addressListener);
        this.addressField.removeFocusListener(this.addressListener);
        this.siteField.removeActionListener(this.siteListener);
        this.siteField.removeFocusListener(this.siteListener);
        this.notesArea.getDocument().removeDocumentListener(this.notesListener);
    }

    private JPanel createDetailsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.nameLabel = new JLabel(Common.I18N_RP.getString("client.name") + ":");
        this.addressLabel = new JLabel(Common.I18N_RP.getString("client.address") + ":");
        this.siteLabel = new JLabel(Common.I18N_RP.getString("client.site") + ":");
        this.nameField = new JTextField(30);
        this.addressField = new JTextField(30);
        this.siteField = new JTextField(30);
        jPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.siteLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.siteField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)this.addressLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.addressField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JPanel createContactsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.contactsTable = new JContactsTable();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.contactsTable));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createNotesTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(1, 1, 1, 1);
        this.notesLabel = new JLabel(Common.I18N_RP.getString("client.notes") + ":");
        this.notesArea = new JTextArea();
        this.notesArea.setLineWrap(true);
        this.notesArea.setWrapStyleWord(true);
        jPanel.add((Component)this.notesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
        jPanel.add((Component)new JScrollPane(this.notesArea, 20, 31), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        return jPanel;
    }

    private JComponent createContents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(Common.I18N_RP.getString("client.details"), this.createDetailsTab());
        this.tabbedPane.add(Common.I18N_RP.getString("client.contacts"), this.createContactsTab());
        this.tabbedPane.add(Common.I18N_RP.getString("client.notes"), this.createNotesTab());
        return this.tabbedPane;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listeners.remove(UndoableEditListener.class, undoableEditListener);
    }

    private void fireUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(UndoableEditListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((UndoableEditListener)eventListenerArray[i]).undoableEditHappened(undoableEditEvent);
        }
    }

    private void updateValues() {
        this.removeListeners();
        this.nameField.setText(this.client.getName());
        this.addressField.setText(this.client.getAddress());
        this.siteField.setText(this.client.getSite());
        try {
            this.notesArea.setText(this.client.getNotes());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.addListeners();
    }

    private class ClientHandler
    extends ClientAdapter {
        private ClientHandler() {
        }

        public void contactAdded(ClientEvent clientEvent) {
        }

        public void contactRemoved(ClientEvent clientEvent) {
        }

        public void dataChanged(ClientEvent clientEvent) {
            ClientDetailView.this.updateValues();
        }

        public void notesChanged(ClientEvent clientEvent) {
            ClientDetailView.this.updateValues();
        }
    }

    private class NotesHandler
    implements FocusListener {
        private String oldNotes = "";

        private NotesHandler() {
        }

        private void doIt() {
            String string = ClientDetailView.this.notesArea.getText();
            if (!string.equals(this.oldNotes)) {
                ClientNotesEdit clientNotesEdit = new ClientNotesEdit(ClientDetailView.this.client, this.oldNotes, string, "05/10/2009 19:04:00");
                ClientDetailView.this.client.setNotes(string);
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, clientNotesEdit);
                ClientDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.oldNotes = ClientDetailView.this.notesArea.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class AddressHandler
    implements FocusListener,
    ActionListener {
        private AddressHandler() {
        }

        private void doIt() {
            if (!ClientDetailView.this.addressField.getText().equals(ClientDetailView.this.client.getAddress())) {
                UndoableEditEvent undoableEditEvent;
                String string = ClientDetailView.this.addressField.getText();
                ClientAddressEdit clientAddressEdit = new ClientAddressEdit(ClientDetailView.this.client, ClientDetailView.this.client.getAddress(), string, "06/10/2009 13:27:00");
                boolean bl = ClientDetailView.this.client.isEmpty();
                ClientDetailView.this.client.setAddress(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    ClientNonEmptyEdit clientNonEmptyEdit = new ClientNonEmptyEdit(ClientDetailView.this.client, 11);
                    extendedCompoundEdit.addEdit(clientNonEmptyEdit);
                    extendedCompoundEdit.addEdit(clientAddressEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, clientAddressEdit);
                }
                ClientDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class SiteHandler
    implements FocusListener,
    ActionListener {
        private SiteHandler() {
        }

        private void doIt() {
            if (!ClientDetailView.this.siteField.getText().equals(ClientDetailView.this.client.getSite())) {
                UndoableEditEvent undoableEditEvent;
                String string = ClientDetailView.this.siteField.getText();
                ClientSiteEdit clientSiteEdit = new ClientSiteEdit(ClientDetailView.this.client, ClientDetailView.this.client.getSite(), string, "06/10/2009 15:02:00");
                boolean bl = ClientDetailView.this.client.isEmpty();
                ClientDetailView.this.client.setSite(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    ClientNonEmptyEdit clientNonEmptyEdit = new ClientNonEmptyEdit(ClientDetailView.this.client, 10);
                    extendedCompoundEdit.addEdit(clientNonEmptyEdit);
                    extendedCompoundEdit.addEdit(clientSiteEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, clientSiteEdit);
                }
                ClientDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }

    private class NameHandler
    implements FocusListener,
    ActionListener {
        private NameHandler() {
        }

        private void doIt() {
            if (!ClientDetailView.this.nameField.getText().equals(ClientDetailView.this.client.getName())) {
                UndoableEditEvent undoableEditEvent;
                String string = ClientDetailView.this.nameField.getText();
                ClientNameEdit clientNameEdit = new ClientNameEdit(ClientDetailView.this.client, ClientDetailView.this.client.getName(), string, "06/10/2009 13:28:00");
                boolean bl = ClientDetailView.this.client.isEmpty();
                ClientDetailView.this.client.setName(string);
                if (bl) {
                    ExtendedCompoundEdit extendedCompoundEdit = new ExtendedCompoundEdit();
                    ClientNonEmptyEdit clientNonEmptyEdit = new ClientNonEmptyEdit(ClientDetailView.this.client, 9);
                    extendedCompoundEdit.addEdit(clientNonEmptyEdit);
                    extendedCompoundEdit.addEdit(clientNameEdit);
                    extendedCompoundEdit.end();
                    undoableEditEvent = new UndoableEditEvent(this, extendedCompoundEdit);
                } else {
                    undoableEditEvent = new UndoableEditEvent(this, clientNameEdit);
                }
                ClientDetailView.this.fireUndoableEditHappened(undoableEditEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doIt();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.doIt();
        }
    }
}

