/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.MaterialResource;
import com.sbs.jpm.ui.action.CustomFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;

public class MaterialResourceSelection
extends StringSelection
implements Transferable {
    private static final DataFlavor[] flavors = new DataFlavor[]{CustomFlavor.materialResourceListFlavor, CustomFlavor.materialResourceFlavor, DataFlavor.stringFlavor};
    private static final int LIST = 0;
    private static final int RESOURCE = 1;
    private MaterialResource resource;
    private List list;

    public MaterialResourceSelection(MaterialResource materialResource) {
        super(materialResource.toString());
        this.resource = materialResource;
    }

    public MaterialResourceSelection(List list, String string) {
        super(string);
        this.list = list;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            throw new NullPointerException(Common.I18N_MESSAGES.getString("dataFlavour.null"));
        }
        if (dataFlavor.equals(flavors[0])) {
            return true;
        }
        if (dataFlavor.equals(flavors[1])) {
            return true;
        }
        return super.isDataFlavorSupported(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavors[0])) {
            return this.list;
        }
        if (dataFlavor.equals(flavors[1])) {
            return this.resource;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return super.getTransferData(dataFlavor);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

