/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.HumanResource;
import com.sbs.jpm.ui.action.CustomFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;

public class HumanResourceSelection
extends StringSelection
implements Transferable {
    private static final DataFlavor[] flavors = new DataFlavor[]{CustomFlavor.humanResourceFlavor, CustomFlavor.humanResourceListFlavor, DataFlavor.stringFlavor};
    private static final int LIST = 1;
    private static final int RESOURCE = 0;
    private HumanResource resource;
    private List list;

    public HumanResourceSelection(HumanResource humanResource) {
        super(humanResource.toString());
        this.resource = humanResource;
    }

    public HumanResourceSelection(List list, String string) {
        super(string);
        this.list = list;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            throw new NullPointerException(Common.I18N_MESSAGES.getString("dataFlavour.null"));
        }
        if (dataFlavor.equals(flavors[1])) {
            return true;
        }
        if (dataFlavor.equals(flavors[0])) {
            return true;
        }
        return super.isDataFlavorSupported(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavors[1])) {
            return this.list;
        }
        if (dataFlavor.equals(flavors[0])) {
            return this.resource;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return super.getTransferData(dataFlavor);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

