/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.core.Client;
import com.sbs.jpm.ui.action.CustomFlavor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSelection
extends StringSelection
implements Transferable {
    private static final DataFlavor[] flavors = new DataFlavor[]{CustomFlavor.clientFlavor, CustomFlavor.clientListFlavor, DataFlavor.stringFlavor};
    private static final int LIST = 1;
    private static final int CLIENT = 0;
    private Client client;
    private List<Client> list;

    public ClientSelection(Client client) {
        super(client.toString());
        this.client = client;
    }

    public ClientSelection(List<Client> list, String string) {
        super(string);
        this.list = list;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            throw new NullPointerException(Common.I18N_MESSAGES.getString("dataFlavour.null"));
        }
        if (dataFlavor.equals(flavors[1])) {
            return true;
        }
        if (dataFlavor.equals(flavors[0])) {
            return true;
        }
        return super.isDataFlavorSupported(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(flavors[1])) {
            return this.list;
        }
        if (dataFlavor.equals(flavors[0])) {
            return this.client;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return super.getTransferData(dataFlavor);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

