/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.JProject;
import com.sbs.jpm.ui.action.ActionManager;
import com.sbs.jpm.ui.component.JAreaView;
import com.sbs.jpm.ui.core.Data;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class ActionViewTaskSheet
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionViewTaskSheet() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("view.taskSheet"));
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("view.taskSheet.tooltip"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JProject jProject = Common.getApplication().getWorkspace().getJProject();
        if (jProject.getEpsView().isVisible()) {
            jProject.toggleEPS();
        }
        jProject.getAreaView().setActiveView(JAreaView.TASK_SHEET);
        jProject.deselectViewButtons();
        jProject.getTaskSheetButton().setSelected(true);
        jProject.getGuidePanel().disableNavigation();
        Data data = ActionManager.getActionManager().getData(2);
        jProject.getGuidePanel().setData(data);
        jProject.getGuidePanel().getDetailsTitleLabel().setText(data.getName());
        jProject.getAreaView().grabFocus();
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document != null) {
                ActionViewTaskSheet.this.setEnabled(true);
            } else {
                ActionViewTaskSheet.this.setEnabled(false);
            }
        }
    }
}

