/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.component.JSaveBaselineDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class ActionToolsSaveBaseline
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionToolsSaveBaseline() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("baselines.save") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("baselines.save.tooltip"));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        Company company = ((CompanyDocument)companyDocumentManager.getSelectedDocument()).getData();
        JSaveBaselineDialog jSaveBaselineDialog = new JSaveBaselineDialog((Frame)Common.getApplication(), Common.I18N_ACTIONS.getString("baselines.save.tooltip"), company.getCurrentTask());
        jSaveBaselineDialog.setVisible(true);
        Common.getApplication().repaint();
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document != null) {
                ActionToolsSaveBaseline.this.setEnabled(true);
                ((CompanyDocument)document).getData().addCompanyListener(new CompanyAdapter(){

                    public void currentProjectChanged(CompanyEvent companyEvent) {
                        if (companyEvent.getProject().getParent() == null) {
                            ActionToolsSaveBaseline.this.setEnabled(false);
                        } else {
                            ActionToolsSaveBaseline.this.setEnabled(true);
                        }
                    }
                });
            } else {
                ActionToolsSaveBaseline.this.setEnabled(false);
            }
        }
    }
}

