/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.CompanyAdapter;
import com.sbs.jpm.core.event.CompanyEvent;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.component.JClearBaselineDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

class ActionToolsClearBaseline
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionToolsClearBaseline() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("baselines.clear") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("baselines.clear.tooltip"));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        Task task = ((CompanyDocument)companyDocumentManager.getSelectedDocument()).getData().getCurrentTask();
        if (task.getNonEmptyBaselinesNo() == 0) {
            JOptionPane.showMessageDialog(Common.getApplication(), Common.I18N_MESSAGES.getString("baseline.noSavedBaseline.message"), Common.I18N_MESSAGES.getString("baseline.noSavedBaseline.title"), 1);
        } else {
            JClearBaselineDialog jClearBaselineDialog = new JClearBaselineDialog((Frame)Common.getApplication(), Common.I18N_ACTIONS.getString("baselines.clear.tooltip"), task);
            jClearBaselineDialog.setVisible(true);
            Common.getApplication().repaint();
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document != null) {
                ActionToolsClearBaseline.this.setEnabled(true);
                ((CompanyDocument)document).getData().addCompanyListener(new CompanyAdapter(){

                    public void currentProjectChanged(CompanyEvent companyEvent) {
                        if (companyEvent.getProject().getParent() == null) {
                            ActionToolsClearBaseline.this.setEnabled(false);
                        } else {
                            ActionToolsClearBaseline.this.setEnabled(true);
                        }
                    }
                });
            } else {
                ActionToolsClearBaseline.this.setEnabled(false);
            }
        }
    }
}

