/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.component.JOptionsDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ActionSettingsOptions
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JOptionsDialog optionsDialog;

    public ActionSettingsOptions() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("settings.options"));
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("settings.options.tooltip"));
        this.putValue("MnemonicKey", new Integer(79));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.optionsDialog = this.getOptionsDialog();
        this.optionsDialog.setVisible(true);
    }

    public JOptionsDialog getOptionsDialog() {
        JApplication jApplication = Common.getApplication();
        Company company = ((CompanyDocument)Common.getProjectDocumentManager().getSelectedDocument()).getData();
        if (this.optionsDialog == null) {
            this.optionsDialog = new JOptionsDialog(jApplication, company);
        }
        this.optionsDialog.update();
        return this.optionsDialog;
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document != null) {
                if (ActionSettingsOptions.this.optionsDialog != null) {
                    Company company = ((CompanyDocument)document).getData();
                    ActionSettingsOptions.this.optionsDialog.setCompany(company);
                }
                ActionSettingsOptions.this.setEnabled(true);
            } else {
                ActionSettingsOptions.this.setEnabled(false);
            }
        }
    }
}

