/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentAdapter;
import com.sbs.jpm.document.event.DocumentEvent;
import com.sbs.jpm.document.event.DocumentListener;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.action.ActionEditRedo;
import com.sbs.jpm.ui.action.ActionEditUndo;
import com.sbs.jpm.ui.action.ActionID;
import com.sbs.jpm.ui.action.ActionManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

class ActionServerSave
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionServerSave() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("server.save"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        try {
            if (companyDocumentManager.getSelectedDocument().save()) {
                Company company = ((CompanyDocument)companyDocumentManager.getSelectedDocument()).getData();
                company.getUndoManager().discardAllEdits();
                ActionManager actionManager = ActionManager.getActionManager();
                ((ActionEditUndo)actionManager.getAction(ActionID.EDIT_UNDO)).update();
                ((ActionEditRedo)actionManager.getAction(ActionID.EDIT_REDO)).update();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    class DocumentHandler
    extends DocumentAdapter {
        DocumentHandler() {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            Document document = (Document)documentEvent.getSource();
            ActionServerSave.this.setEnabled(document.isChanged());
        }

        public void documentLocked(DocumentEvent documentEvent) {
            ActionServerSave.this.setEnabled(false);
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        private DocumentListener docHandler;

        DocumentManagerHandler() {
            this.docHandler = new DocumentHandler();
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getOldDocument();
            Document document2 = documentManagerEvent.getNewDocument();
            if (document != null) {
                document.removeDocumentListener(this.docHandler);
            }
            if (document2 != null && document2.isServer()) {
                document2.addDocumentListener(this.docHandler);
                ActionServerSave.this.setEnabled(document2.isChanged());
            }
        }

        public void documentClosed(DocumentManagerEvent documentManagerEvent) {
            ActionServerSave.this.setEnabled(false);
        }

        public void documentOpened(DocumentManagerEvent documentManagerEvent) {
            ActionServerSave.this.setEnabled(false);
        }

        public void documentCreated(DocumentManagerEvent documentManagerEvent) {
            ActionServerSave.this.setEnabled(false);
        }

        public void serverClosed(DocumentManagerEvent documentManagerEvent) {
            ActionServerSave.this.setEnabled(false);
        }

        public void serverOpened(DocumentManagerEvent documentManagerEvent) {
            ActionServerSave.this.setEnabled(false);
        }
    }
}

