/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.document.Document;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

class ActionProjectImportProjects
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionProjectImportProjects() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("project.importProject") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("project.importProject.tooltip"));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
            companyDocumentManager.importProject(false);
        }
        catch (DocumentException documentException) {
            Common.logException("Error:", documentException);
            documentException.printStackTrace();
            JOptionPane.showMessageDialog(null, documentException.getMessage(), Common.I18N_MESSAGES.getString("project.failedToImport"), 0);
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            Document document = documentManagerEvent.getNewDocument();
            if (document != null) {
                if (document.isServer()) {
                    ActionProjectImportProjects.this.setEnabled(false);
                } else {
                    ActionProjectImportProjects.this.setEnabled(true);
                }
            } else {
                ActionProjectImportProjects.this.setEnabled(false);
            }
        }
    }
}

