/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocument;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.core.Company;
import com.sbs.jpm.core.Task;
import com.sbs.jpm.core.event.TaskAdapter;
import com.sbs.jpm.core.event.TaskEvent;
import com.sbs.jpm.core.event.TaskListener;
import com.sbs.jpm.document.DocumentException;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.ui.component.JProjectListDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

class ActionProjectExportProjects
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionProjectExportProjects() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("project.exportProject") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("project.exportProject.tooltip"));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            try {
                CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
                Company company = ((CompanyDocument)companyDocumentManager.getSelectedDocument()).getData();
                Company company2 = (Company)company.clone();
                Task task = company.getCurrentTask();
                if (company.getRootTask().equals(task)) {
                    task = task.getProjectChildAt(0);
                }
                JProjectListDialog jProjectListDialog = new JProjectListDialog(task, Common.I18N_MESSAGES.getString("project.selectProjectToBeExported"));
                jProjectListDialog.pack();
                jProjectListDialog.setLocationRelativeTo(Common.getApplication());
                jProjectListDialog.setVisible(true);
                task = jProjectListDialog.getProject();
                if (task == null) break block5;
                try {
                    company2.setRootTask(task);
                }
                catch (Exception exception) {
                    Common.logException("Error:", exception);
                    exception.printStackTrace();
                }
                CompanyDocument companyDocument = new CompanyDocument(company2);
                company2.setMultiProject(1);
                companyDocument.exportProject(0);
                task.setCompany(company);
                company.computeTasksId();
            }
            catch (DocumentException documentException) {
                Common.logException("Error:", documentException);
                documentException.printStackTrace();
                JOptionPane.showMessageDialog(null, documentException.getMessage(), Common.I18N_MESSAGES.getString("project.failedToExport"), 0);
            }
        }
    }

    class TaskHandler
    extends TaskAdapter {
        TaskHandler() {
        }

        public void childAdded(TaskEvent taskEvent) {
            ActionProjectExportProjects.this.setEnabled(true);
        }

        public void childRemoved(TaskEvent taskEvent) {
            ActionProjectExportProjects.this.setEnabled(taskEvent.getTask().getCompany().getRootTask().getProjectChildNumber() != 0);
        }
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        private TaskListener taskHandler;

        DocumentManagerHandler() {
            this.taskHandler = new TaskHandler();
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            CompanyDocument companyDocument;
            CompanyDocument companyDocument2 = (CompanyDocument)documentManagerEvent.getOldDocument();
            if (companyDocument2 != null) {
                companyDocument2.getData().getRootTask().removeTaskListener(this.taskHandler);
            }
            if ((companyDocument = (CompanyDocument)documentManagerEvent.getNewDocument()) != null) {
                companyDocument.getData().getRootTask().addTaskListener(this.taskHandler);
                ActionProjectExportProjects.this.setEnabled(companyDocument.getData().getRootTask().getProjectChildNumber() != 0);
            }
        }
    }
}

