/*
 * Decompiled with CFR 0.152.
 */
package com.sbs.jpm.ui.action;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.sbs.jpm.Common;
import com.sbs.jpm.CompanyDocumentManager;
import com.sbs.jpm.PDFFileFilter;
import com.sbs.jpm.configuration.Configuration;
import com.sbs.jpm.configuration.ConfigurationSetting;
import com.sbs.jpm.document.DocumentManager;
import com.sbs.jpm.document.event.DocumentManagerAdapter;
import com.sbs.jpm.document.event.DocumentManagerEvent;
import com.sbs.jpm.print.CustomPageable;
import com.sbs.jpm.print.PrintManager;
import com.sbs.jpm.ui.JApplication;
import com.sbs.jpm.ui.component.JProjectView;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class ActionFilePrintTo
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JProjectView projectView;

    public ActionFilePrintTo() {
        this.putValue("Name", Common.I18N_ACTIONS.getString("file.printTo") + "...");
        this.putValue("ShortDescription", Common.I18N_ACTIONS.getString("file.printTo.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/com/sbs/jpm/ui/images/empty.png")));
    }

    public void registerAsDocumentManagerListener(DocumentManager documentManager) {
        documentManager.addDocumentManagerListener(new DocumentManagerHandler());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PrintManager.setStartInterval(this.projectView.getProject().getStartDate());
        PrintManager.setEndInterval(this.projectView.getProject().getEndDate());
        if (((CustomPageable)((Object)this.projectView)).getNumberOfPages() == 0) {
            JOptionPane.showMessageDialog(null, Common.I18N_MESSAGES.getString("print.noInfoToPrint"), Common.I18N_MESSAGES.getString("print.failedToPrint"), 1);
            return;
        }
        this.exportToPDF();
    }

    private void exportToPDF() {
        PageFormat pageFormat = Common.getApplication().getPageFormat();
        Rectangle rectangle = new Rectangle((float)pageFormat.getWidth(), (float)pageFormat.getHeight());
        File file = this.getSelectedFile();
        if (file != null) {
            Document document = new Document(rectangle);
            try {
                PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                document.open();
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                CustomPageable customPageable = (CustomPageable)((Object)this.projectView);
                int n = 0;
                for (int i = 0; i < customPageable.getVerticalNumberOfPages(); ++i) {
                    for (int j = 0; j < customPageable.getHorizontalNumberOfPages(); ++j) {
                        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(rectangle.getWidth(), rectangle.getHeight());
                        Graphics2D graphics2D = pdfTemplate.createGraphicsShapes(rectangle.getWidth(), rectangle.getHeight());
                        customPageable.getPrintable(n).print(graphics2D, pageFormat, n);
                        pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
                        document.newPage();
                        ++n;
                        graphics2D.dispose();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Common.logException("Error:", exception);
                System.err.println(exception.getMessage());
            }
            document.close();
        }
    }

    private void exportToPNG() {
        PageFormat pageFormat = Common.getApplication().getPageFormat();
        File file = this.getSelectedFile();
        if (file != null) {
            try {
                BufferedImage bufferedImage = new BufferedImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight(), 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                CustomPageable customPageable = (CustomPageable)((Object)this.projectView);
                boolean bl = false;
                for (int i = 0; i < customPageable.getVerticalNumberOfPages(); ++i) {
                    for (int j = 0; j < customPageable.getHorizontalNumberOfPages(); ++j) {
                    }
                }
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                graphics2D.dispose();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Common.logException("Error:", exception);
            }
        }
    }

    private File getSelectedFile() {
        Configuration configuration = Configuration.getInstance();
        String string = configuration.getValue(ConfigurationSetting.CURRENT_DIR).toString();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(Common.I18N_ACTIONS.getString("file.printTo.tooltip"));
        jFileChooser.setFileFilter(new PDFFileFilter());
        JApplication jApplication = Common.getApplication();
        int n = jFileChooser.showSaveDialog(jApplication);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            int n2 = file.getName().lastIndexOf(".");
            if (n2 != -1) {
                if (!file.getName().substring(n2).equals(".pdf")) {
                    return null;
                }
            } else {
                file = new File(file.getAbsolutePath() + ".pdf");
            }
            configuration.setValue(ConfigurationSetting.CURRENT_DIR, file.getParent());
            return file;
        }
        return null;
    }

    public void projectViewChanged(JProjectView jProjectView) {
        this.projectView = jProjectView;
        JApplication jApplication = Common.getApplication();
        CompanyDocumentManager companyDocumentManager = Common.getProjectDocumentManager();
        this.setEnabled(jProjectView instanceof Pageable && companyDocumentManager.getSelectedDocument() != null);
    }

    class DocumentManagerHandler
    extends DocumentManagerAdapter {
        DocumentManagerHandler() {
        }

        public void documentSelectionChanged(DocumentManagerEvent documentManagerEvent) {
            ActionFilePrintTo.this.setEnabled(ActionFilePrintTo.this.projectView instanceof Pageable && documentManagerEvent.getNewDocument() != null);
        }
    }
}

